/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.PrimaryExpr;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;

public class ParExpr
extends PrimaryExpr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ParExpr clone() throws CloneNotSupportedException {
        ParExpr node = (ParExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ParExpr copy() {
        try {
            ParExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ParExpr fullCopy() {
        ParExpr tree = this.copy();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ASTNode child = this.children[i];
                if (child != null) {
                    child = child.fullCopy();
                    tree.setChild(child, i);
                }
                ++i;
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("(");
        this.getExpr().toString(s);
        s.append(")");
    }

    @Override
    public void typeCheck() {
        if (this.getExpr().isTypeAccess()) {
            this.error(this.getExpr() + " is a type and may not be used in parenthesized expression");
        }
    }

    @Override
    public void emitEvalBranch(Body b) {
        this.getExpr().emitEvalBranch(b);
    }

    @Override
    public Value eval(Body b) {
        return this.getExpr().eval(b);
    }

    public ParExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public ParExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        return this.getExpr().constant();
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        return this.getExpr().isConstant();
    }

    @Override
    public Variable varDecl() {
        ASTNode$State state = this.state();
        return this.getExpr().varDecl();
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDAafterTrue(v) || this.isFalse();
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDAafterFalse(v) || this.isTrue();
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDUafterTrue(v);
    }

    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDUafterFalse(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDUafter(v);
    }

    @Override
    public boolean isSuperAccess() {
        ASTNode$State state = this.state();
        return this.getExpr().isSuperAccess();
    }

    @Override
    public boolean isThisAccess() {
        ASTNode$State state = this.state();
        return this.getExpr().isThisAccess();
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getExpr().isTypeAccess() ? this.unknownType() : this.getExpr().type();
    }

    @Override
    public boolean isVariable() {
        ASTNode$State state = this.state();
        return this.getExpr().isVariable();
    }

    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        return this.getExpr().staticContextQualifier();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        return this.getParent().definesLabel();
    }

    @Override
    public boolean canBeTrue() {
        ASTNode$State state = this.state();
        return this.getExpr().canBeTrue();
    }

    @Override
    public boolean canBeFalse() {
        ASTNode$State state = this.state();
        return this.getExpr().canBeFalse();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

