/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.JastAddJ.PathPart;

public class ZipFilePart
extends PathPart {
    private HashSet set = new HashSet();
    private ZipFile file;
    private String zipPath;

    @Override
    public boolean hasPackage(String name) {
        return this.set.contains(name);
    }

    public ZipFilePart(ZipFile file, String path) {
        this.zipPath = path;
        this.file = file;
        Enumeration<? extends ZipEntry> e = file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String pathName = new File(entry.getName()).getParent();
            if (pathName != null) {
                pathName = pathName.replace(File.separatorChar, '.');
            }
            if (!this.set.contains(pathName)) {
                int pos = 0;
                while (pathName != null && -1 != (pos = pathName.indexOf(46, pos + 1))) {
                    String n = pathName.substring(0, pos);
                    if (this.set.contains(n)) continue;
                    this.set.add(n);
                }
                this.set.add(pathName);
            }
            this.set.add(entry.getName());
        }
    }

    public ZipFilePart(ZipFile file) {
        this(file, file.getName());
    }

    @Override
    public boolean selectCompilationUnit(String canonicalName) throws IOException {
        ZipEntry zipEntry;
        String name = canonicalName.replace('.', '/');
        if (this.set.contains(name = String.valueOf(name) + this.fileSuffix()) && (zipEntry = this.file.getEntry(name)) != null && !zipEntry.isDirectory()) {
            this.is = this.file.getInputStream(zipEntry);
            this.age = zipEntry.getTime();
            this.pathName = this.zipPath;
            this.relativeName = String.valueOf(name) + this.fileSuffix();
            this.fullName = canonicalName;
            return true;
        }
        return false;
    }
}

