/*
 * Decompiled with CFR 0.152.
 */
package soot;

import android.content.res.AXmlResourceParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.AbstractSootFieldRef;
import soot.ArrayType;
import soot.Context;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.G;
import soot.Hierarchy;
import soot.Kind;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootMethodRefImpl;
import soot.SootResolver;
import soot.SourceLocator;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextSensitiveCallGraph;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.options.CGOptions;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.util.ArrayNumberer;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.MapNumberer;
import soot.util.Numberer;
import soot.util.StringNumberer;
import test.AXMLPrinter;

public class Scene {
    private final int defaultSdkVersion = 15;
    private final Map<String, Integer> maxAPIs = new HashMap<String, Integer>();
    Chain<SootClass> classes = new HashChain<SootClass>();
    Chain<SootClass> applicationClasses = new HashChain<SootClass>();
    Chain<SootClass> libraryClasses = new HashChain<SootClass>();
    Chain<SootClass> phantomClasses = new HashChain<SootClass>();
    private final Map<String, RefType> nameToClass = new HashMap<String, RefType>();
    ArrayNumberer<Kind> kindNumberer = new ArrayNumberer();
    ArrayNumberer<Type> typeNumberer = new ArrayNumberer();
    ArrayNumberer<SootMethod> methodNumberer = new ArrayNumberer();
    Numberer<Unit> unitNumberer = new MapNumberer<Unit>();
    Numberer<Context> contextNumberer = null;
    Numberer<SparkField> fieldNumberer = new ArrayNumberer<SparkField>();
    ArrayNumberer<SootClass> classNumberer = new ArrayNumberer();
    StringNumberer subSigNumberer = new StringNumberer();
    ArrayNumberer<Local> localNumberer = new ArrayNumberer();
    private Hierarchy activeHierarchy;
    private FastHierarchy activeFastHierarchy;
    private CallGraph activeCallGraph;
    private ReachableMethods reachableMethods;
    private PointsToAnalysis activePointsToAnalysis;
    private SideEffectAnalysis activeSideEffectAnalysis;
    private List<SootMethod> entryPoints;
    boolean allowsPhantomRefs = false;
    SootClass mainClass;
    String sootClassPath = null;
    private ThrowAnalysis defaultThrowAnalysis = null;
    Set<String> reservedNames = new HashSet<String>();
    private int stateCount;
    private ContextSensitiveCallGraph cscg = null;
    private final Set<String>[] basicclasses = new Set[4];
    private List<SootClass> dynamicClasses = null;
    List<String> pkgList;
    private boolean doneResolving = false;
    private boolean incrementalBuild;
    protected LinkedList<String> excludedPackages;

    public Scene(Singletons.Global g) {
        this.setReservedNames();
        String scp = System.getProperty("soot.class.path");
        if (scp != null) {
            this.setSootClassPath(scp);
        }
        this.kindNumberer.add(Kind.INVALID);
        this.kindNumberer.add(Kind.STATIC);
        this.kindNumberer.add(Kind.VIRTUAL);
        this.kindNumberer.add(Kind.INTERFACE);
        this.kindNumberer.add(Kind.SPECIAL);
        this.kindNumberer.add(Kind.CLINIT);
        this.kindNumberer.add(Kind.THREAD);
        this.kindNumberer.add(Kind.EXECUTOR);
        this.kindNumberer.add(Kind.ASYNCTASK);
        this.kindNumberer.add(Kind.FINALIZE);
        this.kindNumberer.add(Kind.INVOKE_FINALIZE);
        this.kindNumberer.add(Kind.PRIVILEGED);
        this.kindNumberer.add(Kind.NEWINSTANCE);
        this.addSootBasicClasses();
        this.determineExcludedPackages();
    }

    private void determineExcludedPackages() {
        this.excludedPackages = new LinkedList();
        if (Options.v().exclude() != null) {
            this.excludedPackages.addAll(Options.v().exclude());
        }
        if (!Options.v().include_all() && Options.v().output_format() != 10 && Options.v().output_format() != 11) {
            this.excludedPackages.add("java.*");
            this.excludedPackages.add("sun.*");
            this.excludedPackages.add("javax.*");
            this.excludedPackages.add("com.sun.*");
            this.excludedPackages.add("com.ibm.*");
            this.excludedPackages.add("org.xml.*");
            this.excludedPackages.add("org.w3c.*");
            this.excludedPackages.add("apple.awt.*");
            this.excludedPackages.add("com.apple.*");
        }
    }

    public static Scene v() {
        return G.v().soot_Scene();
    }

    public void setMainClass(SootClass m) {
        this.mainClass = m;
        if (!m.declaresMethod(this.getSubSigNumberer().findOrAdd("void main(java.lang.String[])"))) {
            throw new RuntimeException("Main-class has no main method!");
        }
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public String quotedNameOf(String s) {
        if (this.reservedNames.contains(s)) {
            return "'" + s + "'";
        }
        return s;
    }

    public boolean hasMainClass() {
        if (this.mainClass == null) {
            this.setMainClassFromOptions();
        }
        return this.mainClass != null;
    }

    public SootClass getMainClass() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        return this.mainClass;
    }

    public SootMethod getMainMethod() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        if (!this.mainClass.declaresMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return this.mainClass.getMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
    }

    public void setSootClassPath(String p) {
        this.sootClassPath = p;
        SourceLocator.v().invalidateClassPath();
    }

    public String getSootClassPath() {
        if (this.sootClassPath == null) {
            String optionscp = Options.v().soot_classpath();
            if (optionscp.length() > 0) {
                this.sootClassPath = optionscp;
            }
            if (this.sootClassPath == null) {
                this.sootClassPath = this.defaultClassPath();
            } else if (Options.v().prepend_classpath()) {
                this.sootClassPath = String.valueOf(this.sootClassPath) + File.pathSeparator + this.defaultClassPath();
            }
            List<String> process_dir = Options.v().process_dir();
            StringBuffer pds = new StringBuffer();
            for (String path : process_dir) {
                if (this.sootClassPath.contains(path)) continue;
                pds.append(path);
                pds.append(File.pathSeparator);
            }
            this.sootClassPath = pds + this.sootClassPath;
        }
        return this.sootClassPath;
    }

    private int getMaxAPIAvailable(String dir) {
        Integer mapi = this.maxAPIs.get(dir);
        if (mapi != null) {
            return mapi;
        }
        File d = new File(dir);
        if (!d.exists()) {
            throw new RuntimeException("The Android platform directory you havespecified (" + dir + ") does not exist. Please check.");
        }
        File[] files = d.listFiles();
        if (files == null) {
            return -1;
        }
        int maxApi = -1;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (f.isDirectory() && name.startsWith("android-")) {
                try {
                    int v = Integer.decode(name.split("android-")[1]);
                    if (v > maxApi) {
                        maxApi = v;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.maxAPIs.put(dir, maxApi);
        return maxApi;
    }

    public String getAndroidJarPath(String jars, String apk) {
        int APIVersion = this.getAndroidAPIVersion(jars, apk);
        String jarPath = String.valueOf(jars) + File.separator + "android-" + APIVersion + File.separator + "android.jar";
        File f = new File(jarPath);
        if (!f.isFile()) {
            throw new RuntimeException("error: target android.jar (" + jarPath + ") does not exist.");
        }
        return jarPath;
    }

    public int getAndroidAPIVersion(String jars, String apk) {
        int maxAPI;
        File jarsF = new File(jars);
        File apkF = new File(apk);
        if (!jarsF.exists()) {
            throw new RuntimeException("file '" + jars + "' does not exist!");
        }
        if (!apkF.exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        int APIVersion = 15;
        if (apk.toLowerCase().endsWith(".apk")) {
            APIVersion = this.getTargetSDKVersion(apk, jars);
        }
        if (APIVersion > (maxAPI = this.getMaxAPIAvailable(jars))) {
            APIVersion = maxAPI;
        }
        return APIVersion;
    }

    private int getTargetSDKVersion(String apkFile, String platformJARs) {
        InputStream manifestIS = null;
        ZipFile archive = null;
        try {
            int minSdkVersion;
            int sdkTargetVersion;
            int maxAPI;
            block36: {
                try {
                    archive = new ZipFile(apkFile);
                    Enumeration<? extends ZipEntry> entries = archive.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.equals("AndroidManifest.xml")) continue;
                        manifestIS = archive.getInputStream(entry);
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error when looking for manifest in apk: " + e);
                }
                if (manifestIS == null) {
                    G.v().out.println("Could not find sdk version in Android manifest! Using default: 15");
                    return 15;
                }
                maxAPI = this.getMaxAPIAvailable(platformJARs);
                sdkTargetVersion = -1;
                minSdkVersion = -1;
                try {
                    AXmlResourceParser parser2 = new AXmlResourceParser();
                    parser2.open(manifestIS);
                    int depth = 0;
                    block21: while (true) {
                        int type = parser2.next();
                        switch (type) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                break block36;
                            }
                            case 2: {
                                String tagName = parser2.getName();
                                if (++depth != 2 || !tagName.equals("uses-sdk")) continue block21;
                                int i = 0;
                                while (true) {
                                    if (i == parser2.getAttributeCount()) continue block21;
                                    String attributeName = parser2.getAttributeName(i);
                                    String attributeValue = AXMLPrinter.getAttributeValue(parser2, i);
                                    if (attributeName.equals("targetSdkVersion")) {
                                        sdkTargetVersion = Integer.parseInt(attributeValue);
                                    } else if (attributeName.equals("minSdkVersion")) {
                                        minSdkVersion = Integer.parseInt(attributeValue);
                                    }
                                    ++i;
                                }
                            }
                            case 3: {
                                --depth;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int APIVersion = -1;
            if (sdkTargetVersion != -1) {
                if (sdkTargetVersion > maxAPI && minSdkVersion != -1 && minSdkVersion <= maxAPI) {
                    G.v().out.println("warning: Android API version '" + sdkTargetVersion + "' not available, using minApkVersion '" + minSdkVersion + "' instead");
                    APIVersion = minSdkVersion;
                } else {
                    APIVersion = sdkTargetVersion;
                }
            } else if (minSdkVersion != -1) {
                APIVersion = minSdkVersion;
            } else {
                G.v().out.println("Could not find sdk version in Android manifest! Using default: 15");
                APIVersion = 15;
            }
            if (APIVersion <= 2) {
                APIVersion = 3;
            }
            int n = APIVersion;
            return n;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error when looking for manifest in apk: " + e);
                }
            }
        }
    }

    public String defaultClassPath() {
        if (Options.v().src_prec() == 5) {
            return this.defaultAndroidClassPath();
        }
        return this.defaultJavaClassPath();
    }

    private String defaultAndroidClassPath() {
        String androidJars = Options.v().android_jars();
        String forceAndroidJar = Options.v().force_android_jar();
        if ((androidJars == null || androidJars.equals("")) && (forceAndroidJar == null || forceAndroidJar.equals(""))) {
            throw new RuntimeException("You are analyzing an Android application but did not define android.jar. Options -android-jars or -force-android-jar should be used.");
        }
        String jarPath = "";
        if (forceAndroidJar != null && !forceAndroidJar.isEmpty()) {
            jarPath = forceAndroidJar;
        } else if (androidJars != null && !androidJars.isEmpty()) {
            LinkedList<String> classPathEntries = new LinkedList<String>(Arrays.asList(Options.v().soot_classpath().split(File.pathSeparator)));
            classPathEntries.addAll(Options.v().process_dir());
            HashSet<String> targetApks = new HashSet<String>();
            for (String entry : classPathEntries) {
                if (!entry.toLowerCase().endsWith(".apk") && !entry.toLowerCase().endsWith(".dex")) continue;
                targetApks.add(entry);
            }
            if (targetApks.size() == 0) {
                throw new RuntimeException("no apk file given");
            }
            if (targetApks.size() > 1) {
                throw new RuntimeException("only one Android application can be analyzed when using option -android-jars.");
            }
            jarPath = this.getAndroidJarPath(androidJars, (String)targetApks.toArray()[0]);
        }
        if (jarPath.equals("")) {
            throw new RuntimeException("android.jar not found.");
        }
        File f = new File(jarPath);
        if (!f.exists()) {
            throw new RuntimeException("file '" + jarPath + "' does not exist!");
        }
        G.v().out.println("Using '" + jarPath + "' as android.jar");
        return jarPath;
    }

    private String defaultJavaClassPath() {
        StringBuilder sb = new StringBuilder();
        if (System.getProperty("os.name").equals("Mac OS X")) {
            sb.append(System.getProperty("java.home"));
            sb.append(File.separator);
            sb.append("..");
            sb.append(File.separator);
            sb.append("Classes");
            sb.append(File.separator);
            sb.append("classes.jar");
            sb.append(File.pathSeparator);
            sb.append(System.getProperty("java.home"));
            sb.append(File.separator);
            sb.append("..");
            sb.append(File.separator);
            sb.append("Classes");
            sb.append(File.separator);
            sb.append("ui.jar");
            sb.append(File.pathSeparator);
        }
        sb.append(System.getProperty("java.home"));
        sb.append(File.separator);
        sb.append("lib");
        sb.append(File.separator);
        sb.append("rt.jar");
        if (Options.v().whole_program() || Options.v().output_format() == 15) {
            sb.append(String.valueOf(File.pathSeparator) + System.getProperty("java.home") + File.separator + "lib" + File.separator + "jce.jar");
        }
        return sb.toString();
    }

    public int getState() {
        return this.stateCount;
    }

    private void modifyHierarchy() {
        ++this.stateCount;
        this.activeHierarchy = null;
        this.activeFastHierarchy = null;
        this.activeSideEffectAnalysis = null;
        this.activePointsToAnalysis = null;
    }

    public void addClass(SootClass c) {
        if (c.isInScene()) {
            throw new RuntimeException("already managed: " + c.getName());
        }
        if (this.containsClass(c.getName())) {
            throw new RuntimeException("duplicate class: " + c.getName());
        }
        this.classes.add(c);
        c.setLibraryClass();
        this.nameToClass.put(c.getName(), c.getType());
        c.getType().setSootClass(c);
        c.setInScene(true);
        this.modifyHierarchy();
    }

    public void removeClass(SootClass c) {
        if (!c.isInScene()) {
            throw new RuntimeException();
        }
        this.classes.remove(c);
        if (c.isLibraryClass()) {
            this.libraryClasses.remove(c);
        } else if (c.isPhantomClass()) {
            this.phantomClasses.remove(c);
        } else if (c.isApplicationClass()) {
            this.applicationClasses.remove(c);
        }
        c.getType().setSootClass(null);
        c.setInScene(false);
        this.modifyHierarchy();
    }

    public boolean containsClass(String className) {
        RefType type = this.nameToClass.get(className);
        if (type == null) {
            return false;
        }
        if (!type.hasSootClass()) {
            return false;
        }
        SootClass c = type.getSootClass();
        return c.isInScene();
    }

    public boolean containsType(String className) {
        return this.nameToClass.containsKey(className);
    }

    public String signatureToClass(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(1, index);
    }

    public String signatureToSubsignature(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(index + 2, sig.length() - 1);
    }

    public SootField grabField(String fieldSignature) {
        String cname = this.signatureToClass(fieldSignature);
        String fname = this.signatureToSubsignature(fieldSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        return c.getFieldUnsafe(fname);
    }

    public boolean containsField(String fieldSignature) {
        return this.grabField(fieldSignature) != null;
    }

    public SootMethod grabMethod(String methodSignature) {
        String cname = this.signatureToClass(methodSignature);
        String mname = this.signatureToSubsignature(methodSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        if (!c.declaresMethod(mname)) {
            return null;
        }
        return c.getMethod(mname);
    }

    public boolean containsMethod(String methodSignature) {
        return this.grabMethod(methodSignature) != null;
    }

    public SootField getField(String fieldSignature) {
        SootField f = this.grabField(fieldSignature);
        if (f != null) {
            return f;
        }
        throw new RuntimeException("tried to get nonexistent field " + fieldSignature);
    }

    public SootMethod getMethod(String methodSignature) {
        SootMethod m = this.grabMethod(methodSignature);
        if (m != null) {
            return m;
        }
        throw new RuntimeException("tried to get nonexistent method " + methodSignature);
    }

    public SootClass tryLoadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        if (!this.getPhantomRefs() && SourceLocator.v().getClassSource(className) == null) {
            this.setPhantomRefs(false);
            return null;
        }
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public SootClass loadClassAndSupport(String className) {
        SootClass ret = this.loadClass(className, 2);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3);
        }
        return ret;
    }

    public SootClass loadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public RefType getRefType(String className) {
        RefType refType = this.getRefTypeUnsafe(className);
        if (refType == null) {
            throw new IllegalStateException("RefType " + className + " not loaded. " + "If you tried to get the RefType of a library class, did you call loadNecessaryClasses()? " + "Otherwise please check Soot's classpath.");
        }
        return refType;
    }

    public RefType getRefTypeUnsafe(String className) {
        RefType refType = this.nameToClass.get(className);
        return refType;
    }

    public RefType getObjectType() {
        return this.getRefType("java.lang.Object");
    }

    public void addRefType(RefType type) {
        this.nameToClass.put(type.getClassName(), type);
    }

    public SootClass getSootClassUnsafe(String className) {
        SootClass tsc;
        RefType type = this.nameToClass.get(className);
        if (type != null && (tsc = type.getSootClass()) != null) {
            return tsc;
        }
        if (this.allowsPhantomRefs() || className.equals("soot.dummy.InvokeDynamic")) {
            SootClass c = new SootClass(className);
            this.addClass(c);
            c.setPhantom(true);
            return c;
        }
        return null;
    }

    public SootClass getSootClass(String className) {
        SootClass sc = this.getSootClassUnsafe(className);
        if (sc != null) {
            return sc;
        }
        throw new RuntimeException(String.valueOf(System.getProperty("line.separator")) + "Aborting: can't find classfile " + className);
    }

    public Chain<SootClass> getClasses() {
        return this.classes;
    }

    public Chain<SootClass> getApplicationClasses() {
        return this.applicationClasses;
    }

    public Chain<SootClass> getLibraryClasses() {
        return this.libraryClasses;
    }

    public Chain<SootClass> getPhantomClasses() {
        return this.phantomClasses;
    }

    Chain<SootClass> getContainingChain(SootClass c) {
        if (c.isApplicationClass()) {
            return this.getApplicationClasses();
        }
        if (c.isLibraryClass()) {
            return this.getLibraryClasses();
        }
        if (c.isPhantomClass()) {
            return this.getPhantomClasses();
        }
        return null;
    }

    public SideEffectAnalysis getSideEffectAnalysis() {
        if (!this.hasSideEffectAnalysis()) {
            this.setSideEffectAnalysis(new SideEffectAnalysis(this.getPointsToAnalysis(), this.getCallGraph()));
        }
        return this.activeSideEffectAnalysis;
    }

    public void setSideEffectAnalysis(SideEffectAnalysis sea) {
        this.activeSideEffectAnalysis = sea;
    }

    public boolean hasSideEffectAnalysis() {
        return this.activeSideEffectAnalysis != null;
    }

    public void releaseSideEffectAnalysis() {
        this.activeSideEffectAnalysis = null;
    }

    public PointsToAnalysis getPointsToAnalysis() {
        if (!this.hasPointsToAnalysis()) {
            return DumbPointerAnalysis.v();
        }
        return this.activePointsToAnalysis;
    }

    public void setPointsToAnalysis(PointsToAnalysis pa) {
        this.activePointsToAnalysis = pa;
    }

    public boolean hasPointsToAnalysis() {
        return this.activePointsToAnalysis != null;
    }

    public void releasePointsToAnalysis() {
        this.activePointsToAnalysis = null;
    }

    public FastHierarchy getOrMakeFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            this.setFastHierarchy(new FastHierarchy());
        }
        return this.getFastHierarchy();
    }

    public FastHierarchy getFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            throw new RuntimeException("no active FastHierarchy present for scene");
        }
        return this.activeFastHierarchy;
    }

    public void setFastHierarchy(FastHierarchy hierarchy) {
        this.activeFastHierarchy = hierarchy;
    }

    public boolean hasFastHierarchy() {
        return this.activeFastHierarchy != null;
    }

    public void releaseFastHierarchy() {
        this.activeFastHierarchy = null;
    }

    public Hierarchy getActiveHierarchy() {
        if (!this.hasActiveHierarchy()) {
            this.setActiveHierarchy(new Hierarchy());
        }
        return this.activeHierarchy;
    }

    public void setActiveHierarchy(Hierarchy hierarchy) {
        this.activeHierarchy = hierarchy;
    }

    public boolean hasActiveHierarchy() {
        return this.activeHierarchy != null;
    }

    public void releaseActiveHierarchy() {
        this.activeHierarchy = null;
    }

    public boolean hasCustomEntryPoints() {
        return this.entryPoints != null;
    }

    public List<SootMethod> getEntryPoints() {
        if (this.entryPoints == null) {
            this.entryPoints = EntryPoints.v().all();
        }
        return this.entryPoints;
    }

    public void setEntryPoints(List<SootMethod> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public ContextSensitiveCallGraph getContextSensitiveCallGraph() {
        if (this.cscg == null) {
            throw new RuntimeException("No context-sensitive call graph present in Scene. You can bulid one with Paddle.");
        }
        return this.cscg;
    }

    public void setContextSensitiveCallGraph(ContextSensitiveCallGraph cscg) {
        this.cscg = cscg;
    }

    public CallGraph getCallGraph() {
        if (!this.hasCallGraph()) {
            throw new RuntimeException("No call graph present in Scene. Maybe you want Whole Program mode (-w).");
        }
        return this.activeCallGraph;
    }

    public void setCallGraph(CallGraph cg) {
        this.reachableMethods = null;
        this.activeCallGraph = cg;
    }

    public boolean hasCallGraph() {
        return this.activeCallGraph != null;
    }

    public void releaseCallGraph() {
        this.activeCallGraph = null;
        this.reachableMethods = null;
    }

    public ReachableMethods getReachableMethods() {
        if (this.reachableMethods == null) {
            this.reachableMethods = new ReachableMethods(this.getCallGraph(), new ArrayList<MethodOrMethodContext>(this.getEntryPoints()));
        }
        this.reachableMethods.update();
        return this.reachableMethods;
    }

    public void setReachableMethods(ReachableMethods rm) {
        this.reachableMethods = rm;
    }

    public boolean hasReachableMethods() {
        return this.reachableMethods != null;
    }

    public void releaseReachableMethods() {
        this.reachableMethods = null;
    }

    public boolean getPhantomRefs() {
        return Options.v().allow_phantom_refs();
    }

    public void setPhantomRefs(boolean value) {
        this.allowsPhantomRefs = value;
    }

    public boolean allowsPhantomRefs() {
        return this.getPhantomRefs();
    }

    public Numberer<Kind> kindNumberer() {
        return this.kindNumberer;
    }

    public ArrayNumberer<Type> getTypeNumberer() {
        return this.typeNumberer;
    }

    public ArrayNumberer<SootMethod> getMethodNumberer() {
        return this.methodNumberer;
    }

    public Numberer<Context> getContextNumberer() {
        return this.contextNumberer;
    }

    public Numberer<Unit> getUnitNumberer() {
        return this.unitNumberer;
    }

    public Numberer<SparkField> getFieldNumberer() {
        return this.fieldNumberer;
    }

    public ArrayNumberer<SootClass> getClassNumberer() {
        return this.classNumberer;
    }

    public StringNumberer getSubSigNumberer() {
        return this.subSigNumberer;
    }

    public ArrayNumberer<Local> getLocalNumberer() {
        return this.localNumberer;
    }

    public void setContextNumberer(Numberer<Context> n) {
        if (this.contextNumberer != null) {
            throw new RuntimeException("Attempt to set context numberer when it is already set.");
        }
        this.contextNumberer = n;
    }

    public ThrowAnalysis getDefaultThrowAnalysis() {
        if (this.defaultThrowAnalysis == null) {
            int optionsThrowAnalysis = Options.v().throw_analysis();
            switch (optionsThrowAnalysis) {
                case 1: {
                    this.defaultThrowAnalysis = PedanticThrowAnalysis.v();
                    break;
                }
                case 2: {
                    this.defaultThrowAnalysis = UnitThrowAnalysis.v();
                    break;
                }
                default: {
                    throw new IllegalStateException("Options.v().throw_analysi() == " + Options.v().throw_analysis());
                }
            }
        }
        return this.defaultThrowAnalysis;
    }

    public void setDefaultThrowAnalysis(ThrowAnalysis ta) {
        this.defaultThrowAnalysis = ta;
    }

    private void setReservedNames() {
        Set<String> rn = this.getReservedNames();
        rn.add("newarray");
        rn.add("newmultiarray");
        rn.add("nop");
        rn.add("ret");
        rn.add("specialinvoke");
        rn.add("staticinvoke");
        rn.add("tableswitch");
        rn.add("virtualinvoke");
        rn.add("null_type");
        rn.add("unknown");
        rn.add("cmp");
        rn.add("cmpg");
        rn.add("cmpl");
        rn.add("entermonitor");
        rn.add("exitmonitor");
        rn.add("interfaceinvoke");
        rn.add("lengthof");
        rn.add("lookupswitch");
        rn.add("neg");
        rn.add("if");
        rn.add("abstract");
        rn.add("annotation");
        rn.add("boolean");
        rn.add("break");
        rn.add("byte");
        rn.add("case");
        rn.add("catch");
        rn.add("char");
        rn.add("class");
        rn.add("enum");
        rn.add("final");
        rn.add("native");
        rn.add("public");
        rn.add("protected");
        rn.add("private");
        rn.add("static");
        rn.add("synchronized");
        rn.add("transient");
        rn.add("volatile");
        rn.add("interface");
        rn.add("void");
        rn.add("short");
        rn.add("int");
        rn.add("long");
        rn.add("float");
        rn.add("double");
        rn.add("extends");
        rn.add("implements");
        rn.add("breakpoint");
        rn.add("default");
        rn.add("goto");
        rn.add("instanceof");
        rn.add("new");
        rn.add("return");
        rn.add("throw");
        rn.add("throws");
        rn.add("null");
        rn.add("from");
        rn.add("to");
        rn.add("with");
    }

    private void addSootBasicClasses() {
        this.basicclasses[1] = new HashSet<String>();
        this.basicclasses[2] = new HashSet<String>();
        this.basicclasses[3] = new HashSet<String>();
        this.addBasicClass("java.lang.Object");
        this.addBasicClass("java.lang.Class", 2);
        this.addBasicClass("java.lang.Void", 2);
        this.addBasicClass("java.lang.Boolean", 2);
        this.addBasicClass("java.lang.Byte", 2);
        this.addBasicClass("java.lang.Character", 2);
        this.addBasicClass("java.lang.Short", 2);
        this.addBasicClass("java.lang.Integer", 2);
        this.addBasicClass("java.lang.Long", 2);
        this.addBasicClass("java.lang.Float", 2);
        this.addBasicClass("java.lang.Double", 2);
        this.addBasicClass("java.lang.String");
        this.addBasicClass("java.lang.StringBuffer", 2);
        this.addBasicClass("java.lang.Error");
        this.addBasicClass("java.lang.AssertionError", 2);
        this.addBasicClass("java.lang.Throwable", 2);
        this.addBasicClass("java.lang.NoClassDefFoundError", 2);
        this.addBasicClass("java.lang.ExceptionInInitializerError");
        this.addBasicClass("java.lang.RuntimeException");
        this.addBasicClass("java.lang.ClassNotFoundException");
        this.addBasicClass("java.lang.ArithmeticException");
        this.addBasicClass("java.lang.ArrayStoreException");
        this.addBasicClass("java.lang.ClassCastException");
        this.addBasicClass("java.lang.IllegalMonitorStateException");
        this.addBasicClass("java.lang.IndexOutOfBoundsException");
        this.addBasicClass("java.lang.ArrayIndexOutOfBoundsException");
        this.addBasicClass("java.lang.NegativeArraySizeException");
        this.addBasicClass("java.lang.NullPointerException");
        this.addBasicClass("java.lang.InstantiationError");
        this.addBasicClass("java.lang.InternalError");
        this.addBasicClass("java.lang.OutOfMemoryError");
        this.addBasicClass("java.lang.StackOverflowError");
        this.addBasicClass("java.lang.UnknownError");
        this.addBasicClass("java.lang.ThreadDeath");
        this.addBasicClass("java.lang.ClassCircularityError");
        this.addBasicClass("java.lang.ClassFormatError");
        this.addBasicClass("java.lang.IllegalAccessError");
        this.addBasicClass("java.lang.IncompatibleClassChangeError");
        this.addBasicClass("java.lang.LinkageError");
        this.addBasicClass("java.lang.VerifyError");
        this.addBasicClass("java.lang.NoSuchFieldError");
        this.addBasicClass("java.lang.AbstractMethodError");
        this.addBasicClass("java.lang.NoSuchMethodError");
        this.addBasicClass("java.lang.UnsatisfiedLinkError");
        this.addBasicClass("java.lang.Thread");
        this.addBasicClass("java.lang.Runnable");
        this.addBasicClass("java.lang.Cloneable");
        this.addBasicClass("java.io.Serializable");
        this.addBasicClass("java.lang.ref.Finalizer");
        this.addBasicClass("java.lang.invoke.LambdaMetafactory");
    }

    public void addBasicClass(String name) {
        this.addBasicClass(name, 1);
    }

    public void addBasicClass(String name, int level) {
        this.basicclasses[level].add(name);
    }

    public void loadBasicClasses() {
        this.addReflectionTraceClasses();
        int i = 3;
        while (i >= 1) {
            for (String name : this.basicclasses[i]) {
                this.tryLoadClass(name, i);
            }
            --i;
        }
    }

    public Set<String> getBasicClasses() {
        HashSet<String> all = new HashSet<String>();
        int i = 0;
        while (i < this.basicclasses.length) {
            Set<String> classes = this.basicclasses[i];
            if (classes != null) {
                all.addAll(classes);
            }
            ++i;
        }
        return all;
    }

    private void addReflectionTraceClasses() {
        CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        String log = options.reflection_log();
        HashSet<String> classNames = new HashSet<String>();
        if (log != null && log.length() > 0) {
            BufferedReader reader = null;
            String line = "";
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(log)));
                    while ((line = reader.readLine()) != null) {
                        if (line.length() == 0) continue;
                        String[] portions = line.split(";", -1);
                        String kind = portions[0];
                        String target = portions[1];
                        String source = portions[2];
                        String sourceClassName = source.substring(0, source.lastIndexOf("."));
                        classNames.add(sourceClassName);
                        if (kind.equals("Class.forName")) {
                            classNames.add(target);
                            continue;
                        }
                        if (kind.equals("Class.newInstance")) {
                            classNames.add(target);
                            continue;
                        }
                        if (kind.equals("Method.invoke") || kind.equals("Constructor.newInstance")) {
                            classNames.add(this.signatureToClass(target));
                            continue;
                        }
                        if (kind.equals("Field.set*") || kind.equals("Field.get*")) {
                            classNames.add(this.signatureToClass(target));
                            continue;
                        }
                        throw new RuntimeException("Unknown entry kind: " + kind);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Line: '" + line + "'", e);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        for (String c : classNames) {
            this.addBasicClass(c, 3);
        }
    }

    public Collection<SootClass> dynamicClasses() {
        if (this.dynamicClasses == null) {
            throw new IllegalStateException("Have to call loadDynamicClasses() first!");
        }
        return this.dynamicClasses;
    }

    private void loadNecessaryClass(String name) {
        SootClass c = this.loadClassAndSupport(name);
        c.setApplicationClass();
    }

    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        for (String name : Options.v().classes()) {
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        if (Options.v().oaat()) {
            if (Options.v().process_dir().isEmpty()) {
                throw new IllegalArgumentException("If switch -oaat is used, then also -process-dir must be given.");
            }
        } else {
            for (String path : Options.v().process_dir()) {
                for (String cl : SourceLocator.v().getClassesUnder(path)) {
                    SootClass theClass = this.loadClassAndSupport(cl);
                    theClass.setApplicationClass();
                }
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    public void loadDynamicClasses() {
        this.dynamicClasses = new ArrayList<SootClass>();
        HashSet<String> dynClasses = new HashSet<String>();
        dynClasses.addAll(Options.v().dynamic_class());
        for (String string : Options.v().dynamic_dir()) {
            dynClasses.addAll(SourceLocator.v().getClassesUnder(string));
        }
        for (String string : Options.v().dynamic_package()) {
            dynClasses.addAll(SourceLocator.v().classesInDynamicPackage(string));
        }
        for (String className : dynClasses) {
            this.dynamicClasses.add(this.loadClassAndSupport(className));
        }
        Iterator<SootClass> iterator = this.dynamicClasses.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = iterator.next();
            if (sootClass.isConcrete()) continue;
            if (Options.v().verbose()) {
                G.v().out.println("Warning: dynamic class " + sootClass.getName() + " is abstract or an interface, and it will not be considered.");
            }
            iterator.remove();
        }
    }

    private void prepareClasses() {
        HashChain<SootClass> processedClasses = new HashChain<SootClass>();
        block0: while (true) {
            HashChain<SootClass> unprocessedClasses = new HashChain<SootClass>(this.getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator iterator = unprocessedClasses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SootClass s = (SootClass)iterator.next();
                if (s.isPhantom()) continue;
                if (Options.v().app()) {
                    s.setApplicationClass();
                }
                if (Options.v().classes().contains(s.getName())) {
                    s.setApplicationClass();
                    continue;
                }
                if (s.isApplicationClass() && this.isExcluded(s)) {
                    s.setLibraryClass();
                }
                if (this.isIncluded(s)) {
                    s.setApplicationClass();
                }
                if (!s.isApplicationClass()) continue;
                this.loadClassAndSupport(s.getName());
            }
            break;
        }
    }

    public boolean isExcluded(SootClass sc) {
        String name = sc.getName();
        for (String pkg : this.excludedPackages) {
            if (!name.equals(pkg) && (!pkg.endsWith(".*") && !pkg.endsWith("$*") || !name.startsWith(pkg.substring(0, pkg.length() - 1)))) continue;
            return !this.isIncluded(sc);
        }
        return false;
    }

    public boolean isIncluded(SootClass sc) {
        String name = sc.getName();
        for (String inc : Options.v().include()) {
            if (!name.equals(inc) && (!inc.endsWith(".*") && !inc.endsWith("$*") || !name.startsWith(inc.substring(0, inc.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    public void setPkgList(List<String> list) {
        this.pkgList = list;
    }

    public List<String> getPkgList() {
        return this.pkgList;
    }

    public SootMethodRef makeMethodRef(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        return new SootMethodRefImpl(declaringClass, name, parameterTypes, returnType, isStatic);
    }

    public SootMethodRef makeConstructorRef(SootClass declaringClass, List<Type> parameterTypes) {
        return this.makeMethodRef(declaringClass, "<init>", parameterTypes, VoidType.v(), false);
    }

    public SootFieldRef makeFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        return new AbstractSootFieldRef(declaringClass, name, type, isStatic);
    }

    public List<SootClass> getClasses(int desiredLevel) {
        ArrayList<SootClass> ret = new ArrayList<SootClass>();
        for (SootClass cl : this.getClasses()) {
            if (cl.resolvingLevel() < desiredLevel) continue;
            ret.add(cl);
        }
        return ret;
    }

    public boolean doneResolving() {
        return this.doneResolving;
    }

    public void setDoneResolving() {
        this.doneResolving = true;
    }

    public void setMainClassFromOptions() {
        if (this.mainClass != null) {
            return;
        }
        if (Options.v().main_class() != null && Options.v().main_class().length() > 0) {
            this.setMainClass(this.getSootClass(Options.v().main_class()));
        } else {
            Iterator<Object> classIter = Options.v().classes().iterator();
            while (classIter.hasNext()) {
                SootClass c = this.getSootClass((String)classIter.next());
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
            for (SootClass c : this.getApplicationClasses()) {
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
        }
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public void initiateIncrementalBuild() {
        this.incrementalBuild = true;
    }

    public void incrementalBuildFinished() {
        this.incrementalBuild = false;
    }

    public SootClass forceResolve(String className, int level) {
        SootClass c;
        boolean tmp = this.doneResolving;
        this.doneResolving = false;
        try {
            c = SootResolver.v().resolveClass(className, level);
        }
        finally {
            this.doneResolving = tmp;
        }
        return c;
    }
}

