/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;

abstract class AnnotationElemBuilder
extends AnnotationVisitor {
    protected final ArrayList<AnnotationElem> elems;

    AnnotationElemBuilder(int expected) {
        super(327680);
        this.elems = new ArrayList(expected);
    }

    AnnotationElemBuilder() {
        this(4);
    }

    public AnnotationElem getAnnotationElement(String name, Object value) {
        AnnotationElem elem;
        if (value instanceof Byte) {
            elem = new AnnotationIntElem(((Byte)value).byteValue(), 'B', name);
        } else if (value instanceof Boolean) {
            elem = new AnnotationIntElem((Boolean)value != false ? 1 : 0, 'Z', name);
        } else if (value instanceof Character) {
            elem = new AnnotationIntElem(((Character)value).charValue(), 'C', name);
        } else if (value instanceof Short) {
            elem = new AnnotationIntElem(((Short)value).shortValue(), 'S', name);
        } else if (value instanceof Integer) {
            elem = new AnnotationIntElem((Integer)value, 'I', name);
        } else if (value instanceof Long) {
            elem = new AnnotationLongElem((Long)value, 'J', name);
        } else if (value instanceof Float) {
            elem = new AnnotationFloatElem(((Float)value).floatValue(), 'F', name);
        } else if (value instanceof Double) {
            elem = new AnnotationDoubleElem((Double)value, 'D', name);
        } else if (value instanceof String) {
            elem = new AnnotationStringElem(value.toString(), 's', name);
        } else if (value instanceof Type) {
            Type t = (Type)value;
            elem = new AnnotationClassElem(t.getDescriptor(), 'c', name);
        } else if (value.getClass().isArray()) {
            ArrayList<AnnotationElem> annotationArray = new ArrayList<AnnotationElem>();
            if (value instanceof byte[]) {
                byte[] byArray = (byte[])value;
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Byte element = byArray[n2];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n2;
                }
            } else if (value instanceof boolean[]) {
                boolean[] blArray = (boolean[])value;
                int n = blArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Boolean element = blArray[n3];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n3;
                }
            } else if (value instanceof char[]) {
                char[] cArray = (char[])value;
                int n = cArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Character element = Character.valueOf(cArray[n4]);
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n4;
                }
            } else if (value instanceof short[]) {
                short[] sArray = (short[])value;
                int n = sArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Short element = sArray[n5];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n5;
                }
            } else if (value instanceof int[]) {
                int[] nArray = (int[])value;
                int n = nArray.length;
                int n6 = 0;
                while (n6 < n) {
                    Integer element = nArray[n6];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n6;
                }
            } else if (value instanceof long[]) {
                long[] lArray = (long[])value;
                int n = lArray.length;
                int n7 = 0;
                while (n7 < n) {
                    Long element = lArray[n7];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n7;
                }
            } else if (value instanceof float[]) {
                float[] fArray = (float[])value;
                int n = fArray.length;
                int n8 = 0;
                while (n8 < n) {
                    Float element = Float.valueOf(fArray[n8]);
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n8;
                }
            } else if (value instanceof double[]) {
                double[] dArray = (double[])value;
                int n = dArray.length;
                int n9 = 0;
                while (n9 < n) {
                    Double element = dArray[n9];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n9;
                }
            } else if (value instanceof String[]) {
                String[] stringArray = (String[])value;
                int n = stringArray.length;
                int n10 = 0;
                while (n10 < n) {
                    String element = stringArray[n10];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n10;
                }
            } else if (value instanceof Type[]) {
                Type[] typeArray = (Type[])value;
                int n = typeArray.length;
                int n11 = 0;
                while (n11 < n) {
                    Type element = typeArray[n11];
                    annotationArray.add(this.getAnnotationElement(name, element));
                    ++n11;
                }
            } else {
                throw new UnsupportedOperationException("Unsupported array value type: " + value.getClass());
            }
            elem = new AnnotationArrayElem(annotationArray, '[', name);
        } else {
            throw new UnsupportedOperationException("Unsupported value type: " + value.getClass());
        }
        return elem;
    }

    @Override
    public void visit(String name, Object value) {
        AnnotationElem elem = this.getAnnotationElement(name, value);
        this.elems.add(elem);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.elems.add(new AnnotationEnumElem(desc, value, 'e', name));
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                String ename = name;
                if (ename == null) {
                    ename = "default";
                }
                AnnotationElemBuilder.this.elems.add(new AnnotationArrayElem(this.elems, '[', ename));
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(final String name, final String desc) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag tag = new AnnotationTag(desc, this.elems);
                AnnotationElemBuilder.this.elems.add(new AnnotationAnnotationElem(tag, '@', name));
            }
        };
    }

    @Override
    public abstract void visitEnd();
}

