/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import java.util.List;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.RefLikeType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.Type;
import soot.VoidType;

class AsmUtil {
    public static boolean isDWord(Type type) {
        return type instanceof LongType || type instanceof DoubleType;
    }

    public static Type toBaseType(String internal) {
        if (internal.charAt(0) == '[') {
            internal = internal.substring(internal.lastIndexOf(91) + 1, internal.length());
        }
        if (internal.charAt(internal.length() - 1) == ';') {
            if ((internal = internal.substring(0, internal.length() - 1)).charAt(0) == 'L') {
                internal = internal.substring(1, internal.length());
            }
            internal = AsmUtil.toQualifiedName(internal);
            return RefType.v(internal);
        }
        switch (internal.charAt(0)) {
            case 'Z': {
                return BooleanType.v();
            }
            case 'B': {
                return ByteType.v();
            }
            case 'C': {
                return CharType.v();
            }
            case 'S': {
                return ShortType.v();
            }
            case 'I': {
                return IntType.v();
            }
            case 'F': {
                return FloatType.v();
            }
            case 'J': {
                return LongType.v();
            }
            case 'D': {
                return DoubleType.v();
            }
        }
        internal = AsmUtil.toQualifiedName(internal);
        return RefType.v(internal);
    }

    public static String toQualifiedName(String internal) {
        return internal.replace('/', '.');
    }

    public static String toInternalName(String qual) {
        return qual.replace('.', '/');
    }

    public static String toInternalName(SootClass cls) {
        return AsmUtil.toInternalName(cls.getName());
    }

    public static Type toJimpleRefType(String desc) {
        return desc.charAt(0) == '[' ? AsmUtil.toJimpleType(desc) : RefType.v(AsmUtil.toQualifiedName(desc));
    }

    public static Type toJimpleType(String desc) {
        Type baseType;
        int idx = desc.lastIndexOf(91);
        int nrDims = idx + 1;
        if (nrDims > 0) {
            if (desc.charAt(0) != '[') {
                throw new AssertionError((Object)("Invalid array descriptor: " + desc));
            }
            desc = desc.substring(idx + 1);
        }
        switch (desc.charAt(0)) {
            case 'Z': {
                baseType = BooleanType.v();
                break;
            }
            case 'B': {
                baseType = ByteType.v();
                break;
            }
            case 'C': {
                baseType = CharType.v();
                break;
            }
            case 'S': {
                baseType = ShortType.v();
                break;
            }
            case 'I': {
                baseType = IntType.v();
                break;
            }
            case 'F': {
                baseType = FloatType.v();
                break;
            }
            case 'J': {
                baseType = LongType.v();
                break;
            }
            case 'D': {
                baseType = DoubleType.v();
                break;
            }
            case 'L': {
                if (desc.charAt(desc.length() - 1) != ';') {
                    throw new AssertionError((Object)("Invalid reference descriptor: " + desc));
                }
                String name = desc.substring(1, desc.length() - 1);
                name = AsmUtil.toQualifiedName(name);
                baseType = RefType.v(name);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown descriptor: " + desc));
            }
        }
        if (!(baseType instanceof RefLikeType) && desc.length() > 1) {
            throw new AssertionError((Object)("Invalid primitive type descriptor: " + desc));
        }
        return nrDims > 0 ? ArrayType.v(baseType, nrDims) : baseType;
    }

    public static List<Type> toJimpleDesc(String desc) {
        ArrayList<Type> types = new ArrayList<Type>(2);
        int len = desc.length();
        int idx = 0;
        block14: while (idx != len) {
            int nrDims = 0;
            Type baseType = null;
            block15: while (idx != len) {
                char c = desc.charAt(idx++);
                switch (c) {
                    case '(': 
                    case ')': {
                        continue block14;
                    }
                    case '[': {
                        ++nrDims;
                        break;
                    }
                    case 'Z': {
                        baseType = BooleanType.v();
                        break block15;
                    }
                    case 'B': {
                        baseType = ByteType.v();
                        break block15;
                    }
                    case 'C': {
                        baseType = CharType.v();
                        break block15;
                    }
                    case 'S': {
                        baseType = ShortType.v();
                        break block15;
                    }
                    case 'I': {
                        baseType = IntType.v();
                        break block15;
                    }
                    case 'F': {
                        baseType = FloatType.v();
                        break block15;
                    }
                    case 'J': {
                        baseType = LongType.v();
                        break block15;
                    }
                    case 'D': {
                        baseType = DoubleType.v();
                        break block15;
                    }
                    case 'V': {
                        baseType = VoidType.v();
                        break block15;
                    }
                    case 'L': {
                        int begin = idx;
                        while (desc.charAt(++idx) != ';') {
                        }
                        String cls = desc.substring(begin, idx++);
                        baseType = RefType.v(AsmUtil.toQualifiedName(cls));
                        break block15;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type: " + c));
                    }
                }
            }
            if (baseType != null && nrDims > 0) {
                types.add(ArrayType.v(baseType, nrDims));
                continue;
            }
            types.add(baseType);
        }
        return types;
    }

    public static String baseTypeName(String s) {
        int index = s.indexOf("[");
        if (index < 0) {
            return s;
        }
        return s.substring(0, index);
    }

    private AsmUtil() {
    }
}

