/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import soot.ArrayType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.asm.AnnotationElemBuilder;
import soot.asm.AsmMethodSource;
import soot.asm.AsmUtil;
import soot.asm.SootClassBuilder;
import soot.asm.TagBuilder;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

class MethodBuilder
extends JSRInlinerAdapter {
    private TagBuilder tb;
    private VisibilityAnnotationTag[] visibleParamAnnotations;
    private VisibilityAnnotationTag[] invisibleParamAnnotations;
    private final SootMethod method;
    private final SootClassBuilder scb;

    MethodBuilder(SootMethod method, SootClassBuilder scb, String desc, String[] ex) {
        super(327680, null, method.getModifiers(), method.getName(), desc, null, ex);
        this.method = method;
        this.scb = scb;
    }

    private TagBuilder getTagBuilder() {
        TagBuilder t = this.tb;
        if (t == null) {
            t = this.tb = new TagBuilder(this.method, this.scb);
        }
        return t;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.getTagBuilder().visitAnnotation(desc, visible);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationElemBuilder(1){

            @Override
            public void visitEnd() {
                MethodBuilder.this.method.addTag(new AnnotationDefaultTag((AnnotationElem)this.elems.get(0)));
            }
        };
    }

    @Override
    public void visitAttribute(Attribute attr2) {
        this.getTagBuilder().visitAttribute(attr2);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, final String desc, boolean visible) {
        VisibilityAnnotationTag vat;
        if (visible) {
            VisibilityAnnotationTag[] vats = this.visibleParamAnnotations;
            if (vats == null) {
                this.visibleParamAnnotations = vats = new VisibilityAnnotationTag[this.method.getParameterCount()];
            }
            if ((vat = vats[parameter]) == null) {
                vats[parameter] = vat = new VisibilityAnnotationTag(0);
            }
        } else {
            VisibilityAnnotationTag[] vats = this.invisibleParamAnnotations;
            if (vats == null) {
                this.invisibleParamAnnotations = vats = new VisibilityAnnotationTag[this.method.getParameterCount()];
            }
            if ((vat = vats[parameter]) == null) {
                vats[parameter] = vat = new VisibilityAnnotationTag(1);
            }
        }
        final VisibilityAnnotationTag _vat = vat;
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag annotTag = new AnnotationTag(desc, this.elems);
                _vat.addAnnotation(annotTag);
            }
        };
    }

    @Override
    public void visitTypeInsn(int op, String t) {
        super.visitTypeInsn(op, t);
        Type rt = AsmUtil.toJimpleRefType(t);
        if (rt instanceof ArrayType) {
            this.scb.addDep(((ArrayType)rt).baseType);
        } else {
            this.scb.addDep(rt);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        for (Type t : AsmUtil.toJimpleDesc(desc)) {
            if (!(t instanceof RefType)) continue;
            this.scb.addDep(t);
        }
        this.scb.addDep(AsmUtil.toQualifiedName(owner));
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterf) {
        super.visitMethodInsn(opcode, owner, name, desc, isInterf);
        for (Type t : AsmUtil.toJimpleDesc(desc)) {
            if (!(t instanceof RefType)) continue;
            this.scb.addDep(t);
        }
        this.scb.addDep(AsmUtil.toBaseType(owner));
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        if (type != null) {
            this.scb.addDep(AsmUtil.toQualifiedName(type));
        }
    }

    @Override
    public void visitEnd() {
        VisibilityAnnotationTag vat;
        int n;
        int n2;
        VisibilityAnnotationTag[] visibilityAnnotationTagArray;
        VisibilityParameterAnnotationTag tag;
        super.visitEnd();
        if (this.visibleParamAnnotations != null) {
            tag = new VisibilityParameterAnnotationTag(this.visibleParamAnnotations.length, 0);
            visibilityAnnotationTagArray = this.visibleParamAnnotations;
            n2 = this.visibleParamAnnotations.length;
            n = 0;
            while (n < n2) {
                vat = visibilityAnnotationTagArray[n];
                tag.addVisibilityAnnotation(vat);
                ++n;
            }
            this.method.addTag(tag);
        }
        if (this.invisibleParamAnnotations != null) {
            tag = new VisibilityParameterAnnotationTag(this.invisibleParamAnnotations.length, 1);
            visibilityAnnotationTagArray = this.invisibleParamAnnotations;
            n2 = this.invisibleParamAnnotations.length;
            n = 0;
            while (n < n2) {
                vat = visibilityAnnotationTagArray[n];
                tag.addVisibilityAnnotation(vat);
                ++n;
            }
            this.method.addTag(tag);
        }
        if (this.method.isConcrete()) {
            this.method.setSource(new AsmMethodSource(this.maxLocals, this.instructions, this.localVariables, this.tryCatchBlocks));
        }
    }
}

