/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import soot.Local;
import soot.ValueBox;
import soot.asm.AsmMethodSource;
import soot.asm.Operand;
import soot.asm.UnitContainer;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;

final class StackFrame {
    private Operand[] out;
    private Local[] inStackLocals;
    private ValueBox[] boxes;
    private ArrayList<Operand[]> in;
    private final AsmMethodSource src;

    StackFrame(AsmMethodSource src) {
        this.src = src;
    }

    Operand[] out() {
        return this.out;
    }

    void in(Operand ... oprs) {
        ArrayList<Object> in = this.in;
        if (in == null) {
            in = this.in = new ArrayList(1);
        } else {
            in.clear();
        }
        in.add(oprs);
        this.inStackLocals = new Local[oprs.length];
    }

    void boxes(ValueBox ... boxes) {
        this.boxes = boxes;
    }

    void out(Operand ... oprs) {
        this.out = oprs;
    }

    void mergeIn(Operand ... oprs) {
        ArrayList<Operand[]> in = this.in;
        if (in.get(0).length != oprs.length) {
            throw new IllegalArgumentException("Invalid in operands length!");
        }
        int nrIn = in.size();
        boolean diff = false;
        int i = 0;
        while (i != oprs.length) {
            block25: {
                Operand newOp = oprs[i];
                int j = 0;
                while (j != nrIn) {
                    if (!in.get(j)[i].equivTo(newOp)) {
                        ++j;
                        continue;
                    }
                    break block25;
                }
                diff = true;
                Local stack = this.inStackLocals[i];
                if (stack != null) {
                    AssignStmt as;
                    if (newOp.stack == null) {
                        newOp.stack = stack;
                        as = Jimple.v().newAssignStmt(stack, newOp.value);
                        this.src.setUnit(newOp.insn, as);
                        newOp.updateBoxes();
                    } else {
                        as = Jimple.v().newAssignStmt(stack, newOp.stackOrValue());
                        this.src.mergeUnits(newOp.insn, as);
                        newOp.addBox(as.getRightOpBox());
                    }
                } else {
                    int j2 = 0;
                    while (j2 != nrIn) {
                        stack = in.get((int)j2)[i].stack;
                        if (stack != null) break;
                        ++j2;
                    }
                    if (stack == null && (stack = newOp.stack) == null) {
                        stack = this.src.newStackLocal();
                    }
                    ValueBox box = this.boxes == null ? null : this.boxes[i];
                    int j3 = 0;
                    while (j3 != nrIn) {
                        Operand prevOp = in.get(j3)[i];
                        if (prevOp.stack != stack) {
                            prevOp.removeBox(box);
                            if (prevOp.stack == null) {
                                prevOp.stack = stack;
                                AssignStmt as = Jimple.v().newAssignStmt(stack, prevOp.value);
                                this.src.setUnit(prevOp.insn, as);
                            } else {
                                AssignStmt as;
                                Object u = this.src.getUnit(prevOp.insn);
                                if (u instanceof UnitContainer) {
                                    UnitContainer uc = (UnitContainer)u;
                                    as = (AssignStmt)uc.units[0];
                                } else {
                                    as = (AssignStmt)u;
                                }
                                ValueBox lvb = as.getLeftOpBox();
                                assert (lvb.getValue() == prevOp.stack) : "Invalid stack local!";
                                lvb.setValue(stack);
                                prevOp.stack = stack;
                            }
                            prevOp.updateBoxes();
                        }
                        ++j3;
                    }
                    if (newOp.stack != stack) {
                        if (newOp.stack == null) {
                            newOp.stack = stack;
                            AssignStmt as = Jimple.v().newAssignStmt(stack, newOp.value);
                            this.src.setUnit(newOp.insn, as);
                        } else {
                            AssignStmt as;
                            Object u = this.src.getUnit(newOp.insn);
                            if (u instanceof UnitContainer) {
                                UnitContainer uc = (UnitContainer)u;
                                as = (AssignStmt)uc.units[0];
                            } else {
                                as = (AssignStmt)u;
                            }
                            ValueBox lvb = as.getLeftOpBox();
                            assert (lvb.getValue() == newOp.stack) : "Invalid stack local!";
                            lvb.setValue(stack);
                            newOp.stack = stack;
                        }
                        newOp.updateBoxes();
                    }
                    if (box != null) {
                        box.setValue(stack);
                    }
                    this.inStackLocals[i] = stack;
                }
            }
            ++i;
        }
        if (diff) {
            in.add(oprs);
        }
    }
}

