/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import soot.AbstractASMBackend;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityRef;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MethodHandle;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.tagkit.LineNumberTag;
import soot.util.backend.ASMBackendUtils;

public class BafASMBackend
extends AbstractASMBackend {
    protected final Map<Unit, Label> branchTargetLabels = new HashMap<Unit, Label>();
    protected final Map<Local, Integer> localToSlot = new HashMap<Local, Integer>();

    protected Label getBranchTargetLabel(Unit target) {
        return this.branchTargetLabels.get(target);
    }

    public BafASMBackend(SootClass sc, int javaVersion) {
        super(sc, javaVersion);
    }

    @Override
    protected int getMinJavaVersion(SootMethod method) {
        BafBody body = this.getBafBody(method);
        int minVersion = 2;
        for (Unit u : body.getUnits()) {
            if (u instanceof DynamicInvokeInst) {
                return 8;
            }
            if (!(u instanceof PushInst) || !(((PushInst)u).getConstant() instanceof ClassConstant)) continue;
            minVersion = 6;
        }
        return minVersion;
    }

    @Override
    protected void generateMethodBody(MethodVisitor mv, SootMethod method) {
        BafBody body = this.getBafBody(method);
        PatchingChain<Unit> instructions = body.getUnits();
        for (UnitBox box : body.getUnitBoxes(true)) {
            Unit u = box.getUnit();
            if (this.branchTargetLabels.containsKey(u)) continue;
            this.branchTargetLabels.put(u, new Label());
        }
        for (Trap trap : body.getTraps()) {
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            Label start = this.branchTargetLabels.get(trap.getBeginUnit());
            Label end = this.branchTargetLabels.get(trap.getEndUnit());
            Label handler = this.branchTargetLabels.get(trap.getHandlerUnit());
            String type = ASMBackendUtils.slashify(trap.getException().getName());
            mv.visitTryCatchBlock(start, end, handler, type);
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        HashSet<Local> assignedLocals = new HashSet<Local>();
        if (!method.isStatic()) {
            ++localCount;
        }
        int i = 0;
        while (i < method.getParameterCount()) {
            paramSlots[i] = localCount;
            localCount += ASMBackendUtils.sizeOfType(method.getParameterType(i));
            ++i;
        }
        for (Unit u : instructions) {
            if (!(u instanceof IdentityInst) || !(((IdentityInst)u).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityInst)u).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityInst)u).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            this.localToSlot.put(l, slot);
            assignedLocals.add(l);
        }
        for (Local local : body.getLocals()) {
            if (!assignedLocals.add(local)) continue;
            this.localToSlot.put(local, localCount);
            localCount += ASMBackendUtils.sizeOfType(local.getType());
        }
        for (Unit u : instructions) {
            if (this.branchTargetLabels.containsKey(u)) {
                mv.visitLabel(this.branchTargetLabels.get(u));
            }
            if (u.hasTag("LineNumberTag")) {
                Label l;
                LineNumberTag lnt = (LineNumberTag)u.getTag("LineNumberTag");
                if (this.branchTargetLabels.containsKey(u)) {
                    l = this.branchTargetLabels.get(u);
                } else {
                    l = new Label();
                    mv.visitLabel(l);
                }
                mv.visitLineNumber(lnt.getLineNumber(), l);
            }
            this.generateInstruction(mv, (Inst)u);
        }
    }

    protected void generateInstruction(final MethodVisitor mv, Inst inst) {
        inst.apply(new InstSwitch(){

            @Override
            public void caseReturnVoidInst(ReturnVoidInst i) {
                mv.visitInsn(177);
            }

            @Override
            public void caseReturnInst(ReturnInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitInsn(176);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(172);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(172);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(172);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(175);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(174);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(172);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(173);
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitInsn(176);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(172);
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitInsn(176);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid return type " + t.toString());
                    }
                });
            }

            @Override
            public void caseNopInst(NopInst i) {
                mv.visitInsn(0);
            }

            @Override
            public void caseJSRInst(JSRInst i) {
                mv.visitJumpInsn(168, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void casePushInst(PushInst i) {
                Constant c = i.getConstant();
                if (c instanceof IntConstant) {
                    int v = ((IntConstant)c).value;
                    switch (v) {
                        case -1: {
                            mv.visitInsn(2);
                            break;
                        }
                        case 0: {
                            mv.visitInsn(3);
                            break;
                        }
                        case 1: {
                            mv.visitInsn(4);
                            break;
                        }
                        case 2: {
                            mv.visitInsn(5);
                            break;
                        }
                        case 3: {
                            mv.visitInsn(6);
                            break;
                        }
                        case 4: {
                            mv.visitInsn(7);
                            break;
                        }
                        case 5: {
                            mv.visitInsn(8);
                            break;
                        }
                        default: {
                            if (v >= -128 && v <= 127) {
                                mv.visitIntInsn(16, v);
                                break;
                            }
                            if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                                mv.visitIntInsn(17, v);
                                break;
                            }
                            mv.visitLdcInsn(v);
                            break;
                        }
                    }
                } else if (c instanceof StringConstant) {
                    mv.visitLdcInsn(((StringConstant)c).value);
                } else if (c instanceof ClassConstant) {
                    mv.visitLdcInsn(org.objectweb.asm.Type.getObjectType(((ClassConstant)c).getValue()));
                } else if (c instanceof DoubleConstant) {
                    double v = ((DoubleConstant)c).value;
                    if (new Double(v).equals(0.0)) {
                        mv.visitInsn(14);
                    } else if (v == 1.0) {
                        mv.visitInsn(15);
                    } else {
                        mv.visitLdcInsn(v);
                    }
                } else if (c instanceof FloatConstant) {
                    float v = ((FloatConstant)c).value;
                    if (new Float(v).equals(Float.valueOf(0.0f))) {
                        mv.visitInsn(11);
                    } else if (v == 1.0f) {
                        mv.visitInsn(12);
                    } else if (v == 2.0f) {
                        mv.visitInsn(13);
                    } else {
                        mv.visitLdcInsn(Float.valueOf(v));
                    }
                } else if (c instanceof LongConstant) {
                    long v = ((LongConstant)c).value;
                    if (v == 0L) {
                        mv.visitInsn(9);
                    } else if (v == 1L) {
                        mv.visitInsn(10);
                    } else {
                        mv.visitLdcInsn(v);
                    }
                } else if (c instanceof NullConstant) {
                    mv.visitInsn(1);
                } else {
                    throw new RuntimeException("unsupported opcode");
                }
            }

            @Override
            public void casePopInst(PopInst i) {
                if (i.getWordCount() == 2) {
                    mv.visitInsn(88);
                } else {
                    mv.visitInsn(87);
                }
            }

            @Override
            public void caseIdentityInst(IdentityInst i) {
                Value l = i.getLeftOp();
                Value r = i.getRightOp();
                if (r instanceof CaughtExceptionRef && l instanceof Local) {
                    mv.visitVarInsn(58, BafASMBackend.this.localToSlot.get(l));
                }
            }

            @Override
            public void caseStoreInst(StoreInst i) {
                final int slot = BafASMBackend.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitVarInsn(58, slot);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitVarInsn(54, slot);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitVarInsn(54, slot);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitVarInsn(54, slot);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitVarInsn(57, slot);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitVarInsn(56, slot);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitVarInsn(54, slot);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitVarInsn(55, slot);
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitVarInsn(58, slot);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitVarInsn(54, slot);
                    }

                    @Override
                    public void caseStmtAddressType(StmtAddressType t) {
                        throw new RuntimeException("JSR not supported, use recent Java compiler!");
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitVarInsn(58, slot);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type: " + t);
                    }
                });
            }

            @Override
            public void caseGotoInst(GotoInst i) {
                mv.visitJumpInsn(167, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseLoadInst(LoadInst i) {
                final int slot = BafASMBackend.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitVarInsn(25, slot);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitVarInsn(21, slot);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitVarInsn(21, slot);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitVarInsn(21, slot);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitVarInsn(24, slot);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitVarInsn(23, slot);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitVarInsn(21, slot);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitVarInsn(22, slot);
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitVarInsn(25, slot);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitVarInsn(21, slot);
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitVarInsn(25, slot);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type: " + t);
                    }
                });
            }

            @Override
            public void caseArrayWriteInst(ArrayWriteInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitInsn(83);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(84);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(84);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(85);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(82);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(81);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(79);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(80);
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitInsn(83);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(86);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            @Override
            public void caseArrayReadInst(ArrayReadInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitInsn(50);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(51);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(51);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(52);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(49);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(48);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(46);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(47);
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitInsn(50);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(53);
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitInsn(50);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            @Override
            public void caseIfNullInst(IfNullInst i) {
                mv.visitJumpInsn(198, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfNonNullInst(IfNonNullInst i) {
                mv.visitJumpInsn(199, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfEqInst(IfEqInst i) {
                mv.visitJumpInsn(153, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfNeInst(IfNeInst i) {
                mv.visitJumpInsn(154, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfGtInst(IfGtInst i) {
                mv.visitJumpInsn(157, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfGeInst(IfGeInst i) {
                mv.visitJumpInsn(156, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfLtInst(IfLtInst i) {
                mv.visitJumpInsn(155, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfLeInst(IfLeInst i) {
                mv.visitJumpInsn(158, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
            }

            @Override
            public void caseIfCmpEqInst(final IfCmpEqInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitJumpInsn(165, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(159, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(159, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(159, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(153, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(153, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(159, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(153, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitJumpInsn(165, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(159, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitJumpInsn(165, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpNeInst(final IfCmpNeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        mv.visitJumpInsn(166, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(160, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(160, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(160, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(154, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(154, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(160, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(154, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        mv.visitJumpInsn(166, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(160, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        mv.visitJumpInsn(166, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpGtInst(final IfCmpGtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(163, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(163, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(163, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(157, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(157, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(163, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(157, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(163, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpGeInst(final IfCmpGeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(162, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(162, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(162, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(156, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(156, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(162, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(156, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(162, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpLtInst(final IfCmpLtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(161, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(161, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(161, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(155, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(155, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(161, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(155, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(161, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpLeInst(final IfCmpLeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitJumpInsn(164, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitJumpInsn(164, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitJumpInsn(164, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(152);
                        mv.visitJumpInsn(158, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(150);
                        mv.visitJumpInsn(158, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitJumpInsn(164, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(148);
                        mv.visitJumpInsn(158, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitJumpInsn(164, BafASMBackend.this.getBranchTargetLabel(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseStaticGetInst(StaticGetInst i) {
                SootFieldRef field = i.getFieldRef();
                mv.visitFieldInsn(178, ASMBackendUtils.slashify(field.declaringClass().getName()), field.name(), ASMBackendUtils.toTypeDesc(field.type()));
            }

            @Override
            public void caseStaticPutInst(StaticPutInst i) {
                SootFieldRef field = i.getFieldRef();
                mv.visitFieldInsn(179, ASMBackendUtils.slashify(field.declaringClass().getName()), field.name(), ASMBackendUtils.toTypeDesc(field.type()));
            }

            @Override
            public void caseFieldGetInst(FieldGetInst i) {
                SootFieldRef field = i.getFieldRef();
                mv.visitFieldInsn(180, ASMBackendUtils.slashify(field.declaringClass().getName()), field.name(), ASMBackendUtils.toTypeDesc(field.type()));
            }

            @Override
            public void caseFieldPutInst(FieldPutInst i) {
                SootFieldRef field = i.getFieldRef();
                mv.visitFieldInsn(181, ASMBackendUtils.slashify(field.declaringClass().getName()), field.name(), ASMBackendUtils.toTypeDesc(field.type()));
            }

            @Override
            public void caseInstanceCastInst(InstanceCastInst i) {
                Type castType = i.getCastType();
                if (castType instanceof RefType) {
                    mv.visitTypeInsn(192, ASMBackendUtils.slashify(castType.toString()));
                } else if (castType instanceof ArrayType) {
                    mv.visitTypeInsn(192, ASMBackendUtils.toTypeDesc(castType));
                }
            }

            @Override
            public void caseInstanceOfInst(InstanceOfInst i) {
                Type checkType = i.getCheckType();
                if (checkType instanceof RefType) {
                    mv.visitTypeInsn(193, ASMBackendUtils.slashify(checkType.toString()));
                } else if (checkType instanceof ArrayType) {
                    mv.visitTypeInsn(193, ASMBackendUtils.toTypeDesc(checkType));
                }
            }

            @Override
            public void casePrimitiveCastInst(PrimitiveCastInst i) {
                Type from = i.getFromType();
                final Type to = i.getToType();
                from.apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        this.emitIntToTypeCast();
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        this.emitIntToTypeCast();
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        this.emitIntToTypeCast();
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        if (to.equals(IntType.v())) {
                            mv.visitInsn(142);
                        } else if (to.equals(LongType.v())) {
                            mv.visitInsn(143);
                        } else if (to.equals(FloatType.v())) {
                            mv.visitInsn(144);
                        } else {
                            throw new RuntimeException("invalid to-type from double");
                        }
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        if (to.equals(IntType.v())) {
                            mv.visitInsn(139);
                        } else if (to.equals(LongType.v())) {
                            mv.visitInsn(140);
                        } else if (to.equals(DoubleType.v())) {
                            mv.visitInsn(141);
                        } else {
                            throw new RuntimeException("invalid to-type from float");
                        }
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        this.emitIntToTypeCast();
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        if (to.equals(IntType.v())) {
                            mv.visitInsn(136);
                        } else if (to.equals(FloatType.v())) {
                            mv.visitInsn(137);
                        } else if (to.equals(DoubleType.v())) {
                            mv.visitInsn(138);
                        } else {
                            throw new RuntimeException("invalid to-type from long");
                        }
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        this.emitIntToTypeCast();
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid from-type");
                    }

                    private void emitIntToTypeCast() {
                        if (to.equals(ByteType.v())) {
                            mv.visitInsn(145);
                        } else if (to.equals(CharType.v())) {
                            mv.visitInsn(146);
                        } else if (to.equals(ShortType.v())) {
                            mv.visitInsn(147);
                        } else if (to.equals(FloatType.v())) {
                            mv.visitInsn(134);
                        } else if (to.equals(LongType.v())) {
                            mv.visitInsn(133);
                        } else if (to.equals(DoubleType.v())) {
                            mv.visitInsn(135);
                        } else if (!to.equals(IntType.v()) && !to.equals(BooleanType.v())) {
                            throw new RuntimeException("invalid to-type from int");
                        }
                    }
                });
            }

            @Override
            public void caseDynamicInvokeInst(DynamicInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                SootMethodRef bsm = i.getBootstrapMethodRef();
                List<Value> args = i.getBootstrapArgs();
                final Object[] argsArray = new Object[args.size()];
                int index = 0;
                for (Value v : args) {
                    final int j = index++;
                    v.apply(new ConstantSwitch(){

                        @Override
                        public void defaultCase(Object object) {
                            throw new RuntimeException("Unexpected constant type!");
                        }

                        @Override
                        public void caseStringConstant(StringConstant v) {
                            argsArray[j] = v.value;
                        }

                        @Override
                        public void caseNullConstant(NullConstant v) {
                            throw new RuntimeException("Unexpected NullType as argument-type in invokedynamic!");
                        }

                        @Override
                        public void caseMethodHandle(MethodHandle handle) {
                            SootMethodRef methodRef = handle.getMethodRef();
                            argsArray[j] = new Handle(handle.tag, ASMBackendUtils.slashify(methodRef.declaringClass().getName()), methodRef.name(), ASMBackendUtils.toTypeDesc(methodRef));
                        }

                        @Override
                        public void caseLongConstant(LongConstant v) {
                            argsArray[j] = v.value;
                        }

                        @Override
                        public void caseIntConstant(IntConstant v) {
                            argsArray[j] = v.value;
                        }

                        @Override
                        public void caseFloatConstant(FloatConstant v) {
                            argsArray[j] = Float.valueOf(v.value);
                        }

                        @Override
                        public void caseDoubleConstant(DoubleConstant v) {
                            argsArray[j] = v.value;
                        }

                        @Override
                        public void caseClassConstant(ClassConstant v) {
                            argsArray[j] = org.objectweb.asm.Type.getType(v.getValue());
                        }
                    });
                }
                mv.visitInvokeDynamicInsn(m.name(), ASMBackendUtils.toTypeDesc(m), new Handle(i.getHandleTag(), ASMBackendUtils.slashify(bsm.declaringClass().getName()), bsm.name(), ASMBackendUtils.toTypeDesc(bsm)), argsArray);
            }

            @Override
            public void caseStaticInvokeInst(StaticInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                mv.visitMethodInsn(184, ASMBackendUtils.slashify(m.declaringClass().getName()), m.name(), ASMBackendUtils.toTypeDesc(m), m.declaringClass().isInterface());
            }

            @Override
            public void caseVirtualInvokeInst(VirtualInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                mv.visitMethodInsn(182, ASMBackendUtils.slashify(m.declaringClass().getName()), m.name(), ASMBackendUtils.toTypeDesc(m), m.declaringClass().isInterface());
            }

            @Override
            public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                SootClass declaration = m.declaringClass();
                boolean isInterface = true;
                if (!declaration.isPhantom() && !declaration.isInterface()) {
                    isInterface = false;
                }
                mv.visitMethodInsn(185, ASMBackendUtils.slashify(declaration.getName()), m.name(), ASMBackendUtils.toTypeDesc(m), isInterface);
            }

            @Override
            public void caseSpecialInvokeInst(SpecialInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                mv.visitMethodInsn(183, ASMBackendUtils.slashify(m.declaringClass().getName()), m.name(), ASMBackendUtils.toTypeDesc(m), m.declaringClass().isInterface());
            }

            @Override
            public void caseThrowInst(ThrowInst i) {
                mv.visitInsn(191);
            }

            @Override
            public void caseAddInst(AddInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(96);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(96);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(96);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(99);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(98);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(96);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(97);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(96);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseAndInst(AndInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(127);
                } else {
                    mv.visitInsn(126);
                }
            }

            @Override
            public void caseOrInst(OrInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(129);
                } else {
                    mv.visitInsn(128);
                }
            }

            @Override
            public void caseXorInst(XorInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(131);
                } else {
                    mv.visitInsn(130);
                }
            }

            @Override
            public void caseArrayLengthInst(ArrayLengthInst i) {
                mv.visitInsn(190);
            }

            @Override
            public void caseCmpInst(CmpInst i) {
                mv.visitInsn(148);
            }

            @Override
            public void caseCmpgInst(CmpgInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    mv.visitInsn(150);
                } else {
                    mv.visitInsn(152);
                }
            }

            @Override
            public void caseCmplInst(CmplInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    mv.visitInsn(149);
                } else {
                    mv.visitInsn(151);
                }
            }

            @Override
            public void caseDivInst(DivInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(108);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(108);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(108);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(111);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(110);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(108);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(109);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(108);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIncInst(IncInst i) {
                if (i.getUseBoxes().get(0).getValue() != i.getDefBoxes().get(0).getValue()) {
                    throw new RuntimeException("iinc def and use boxes don't match");
                }
                if (!(i.getConstant() instanceof IntConstant)) {
                    throw new RuntimeException("Wrong constant type for increment!");
                }
                mv.visitIincInsn(BafASMBackend.this.localToSlot.get(i.getLocal()), ((IntConstant)i.getConstant()).value);
            }

            @Override
            public void caseMulInst(MulInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(104);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(104);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(104);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(107);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(106);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(104);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(105);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(104);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseRemInst(RemInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(112);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(112);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(112);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(115);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(114);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(112);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(113);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(112);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseSubInst(SubInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(100);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(100);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(100);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(103);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(102);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(100);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(101);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(100);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseShlInst(ShlInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(121);
                } else {
                    mv.visitInsn(120);
                }
            }

            @Override
            public void caseShrInst(ShrInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(123);
                } else {
                    mv.visitInsn(122);
                }
            }

            @Override
            public void caseUshrInst(UshrInst i) {
                if (i.getOpType().equals(LongType.v())) {
                    mv.visitInsn(125);
                } else {
                    mv.visitInsn(124);
                }
            }

            @Override
            public void caseNewInst(NewInst i) {
                mv.visitTypeInsn(187, ASMBackendUtils.slashify(i.getBaseType().toString()));
            }

            @Override
            public void caseNegInst(NegInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        mv.visitInsn(116);
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        mv.visitInsn(116);
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        mv.visitInsn(116);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        mv.visitInsn(119);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        mv.visitInsn(118);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        mv.visitInsn(116);
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        mv.visitInsn(117);
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        mv.visitInsn(116);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseSwapInst(SwapInst i) {
                mv.visitInsn(95);
            }

            @Override
            public void caseDup1Inst(Dup1Inst i) {
                if (ASMBackendUtils.sizeOfType(i.getOp1Type()) == 2) {
                    mv.visitInsn(92);
                } else {
                    mv.visitInsn(89);
                }
            }

            @Override
            public void caseDup2Inst(Dup2Inst i) {
                Type firstOpType = i.getOp1Type();
                Type secondOpType = i.getOp2Type();
                if (ASMBackendUtils.sizeOfType(firstOpType) == 2) {
                    mv.visitInsn(92);
                    if (ASMBackendUtils.sizeOfType(secondOpType) == 2) {
                        mv.visitInsn(92);
                    } else {
                        mv.visitInsn(89);
                    }
                } else if (ASMBackendUtils.sizeOfType(secondOpType) == 2) {
                    mv.visitInsn(89);
                    mv.visitInsn(92);
                } else {
                    mv.visitInsn(92);
                }
            }

            @Override
            public void caseDup1_x1Inst(Dup1_x1Inst i) {
                Type opType = i.getOp1Type();
                Type underType = i.getUnder1Type();
                if (ASMBackendUtils.sizeOfType(opType) == 2) {
                    if (ASMBackendUtils.sizeOfType(underType) == 2) {
                        mv.visitInsn(94);
                    } else {
                        mv.visitInsn(93);
                    }
                } else if (ASMBackendUtils.sizeOfType(underType) == 2) {
                    mv.visitInsn(91);
                } else {
                    mv.visitInsn(90);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void caseDup1_x2Inst(Dup1_x2Inst i) {
                int toSkip = ASMBackendUtils.sizeOfType(i.getUnder1Type()) + ASMBackendUtils.sizeOfType(i.getUnder2Type());
                if (ASMBackendUtils.sizeOfType(i.getOp1Type()) == 2) {
                    if (toSkip != 2) throw new RuntimeException("magic not implemented yet");
                    mv.visitInsn(94);
                    return;
                } else {
                    if (toSkip != 2) throw new RuntimeException("magic not implemented yet");
                    mv.visitInsn(91);
                }
            }

            @Override
            public void caseDup2_x1Inst(Dup2_x1Inst i) {
                int toDup = ASMBackendUtils.sizeOfType(i.getOp1Type()) + ASMBackendUtils.sizeOfType(i.getOp2Type());
                if (toDup == 2) {
                    if (ASMBackendUtils.sizeOfType(i.getUnder1Type()) == 2) {
                        mv.visitInsn(94);
                    } else {
                        mv.visitInsn(93);
                    }
                } else {
                    throw new RuntimeException("magic not implemented yet");
                }
            }

            @Override
            public void caseDup2_x2Inst(Dup2_x2Inst i) {
                int toDup = ASMBackendUtils.sizeOfType(i.getOp1Type()) + ASMBackendUtils.sizeOfType(i.getOp2Type());
                int toSkip = ASMBackendUtils.sizeOfType(i.getUnder1Type()) + ASMBackendUtils.sizeOfType(i.getUnder2Type());
                if (toDup > 2 || toSkip > 2) {
                    throw new RuntimeException("magic not implemented yet");
                }
                if (toDup != 2 || toSkip != 2) {
                    throw new RuntimeException("VoidType not allowed in Dup2_x2 Instruction");
                }
                mv.visitInsn(94);
            }

            @Override
            public void caseNewArrayInst(NewArrayInst i) {
                Type t = i.getBaseType();
                if (t instanceof RefType) {
                    mv.visitTypeInsn(189, ASMBackendUtils.slashify(t.toString()));
                } else if (t instanceof ArrayType) {
                    mv.visitTypeInsn(189, ASMBackendUtils.toTypeDesc(t));
                } else {
                    int type;
                    if (t.equals(BooleanType.v())) {
                        type = 4;
                    } else if (t.equals(CharType.v())) {
                        type = 5;
                    } else if (t.equals(FloatType.v())) {
                        type = 6;
                    } else if (t.equals(DoubleType.v())) {
                        type = 7;
                    } else if (t.equals(ByteType.v())) {
                        type = 8;
                    } else if (t.equals(ShortType.v())) {
                        type = 9;
                    } else if (t.equals(IntType.v())) {
                        type = 10;
                    } else if (t.equals(LongType.v())) {
                        type = 11;
                    } else {
                        throw new RuntimeException("invalid type");
                    }
                    mv.visitIntInsn(188, type);
                }
            }

            @Override
            public void caseNewMultiArrayInst(NewMultiArrayInst i) {
                mv.visitMultiANewArrayInsn(ASMBackendUtils.toTypeDesc(i.getBaseType()), i.getDimensionCount());
            }

            @Override
            public void caseLookupSwitchInst(LookupSwitchInst i) {
                List<IntConstant> values = i.getLookupValues();
                List<Unit> targets = i.getTargets();
                int[] keys = new int[values.size()];
                Label[] labels = new Label[values.size()];
                int j = 0;
                while (j < values.size()) {
                    keys[j] = values.get((int)j).value;
                    labels[j] = BafASMBackend.this.branchTargetLabels.get(targets.get(j));
                    ++j;
                }
                mv.visitLookupSwitchInsn(BafASMBackend.this.branchTargetLabels.get(i.getDefaultTarget()), keys, labels);
            }

            @Override
            public void caseTableSwitchInst(TableSwitchInst i) {
                List<Unit> targets = i.getTargets();
                Label[] labels = new Label[targets.size()];
                int j = 0;
                while (j < targets.size()) {
                    labels[j] = BafASMBackend.this.branchTargetLabels.get(targets.get(j));
                    ++j;
                }
                mv.visitTableSwitchInsn(i.getLowIndex(), i.getHighIndex(), BafASMBackend.this.branchTargetLabels.get(i.getDefaultTarget()), labels);
            }

            @Override
            public void caseEnterMonitorInst(EnterMonitorInst i) {
                mv.visitInsn(194);
            }

            @Override
            public void caseExitMonitorInst(ExitMonitorInst i) {
                mv.visitInsn(195);
            }
        });
    }
}

