/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.Iterator;
import soot.AbstractJasminClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPrinter;
import soot.VoidType;
import soot.baf.internal.AbstractInst;

abstract class AbstractInvokeInst
extends AbstractInst {
    SootMethodRef methodRef;

    AbstractInvokeInst() {
    }

    public SootMethodRef getMethodRef() {
        return this.methodRef;
    }

    public SootMethod getMethod() {
        return this.methodRef.resolve();
    }

    public Type getType() {
        return this.methodRef.returnType();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + this.getParameters();
    }

    @Override
    public abstract String getName();

    @Override
    String getParameters() {
        return " " + this.methodRef.getSignature();
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.methodRef(this.methodRef);
    }

    @Override
    public int getInCount() {
        return this.getMethodRef().parameterTypes().size();
    }

    @Override
    public int getOutCount() {
        if (this.getMethodRef().returnType() instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getInMachineCount() {
        int count = 0;
        Iterator<Type> it = this.getMethodRef().parameterTypes().iterator();
        while (it.hasNext()) {
            count += AbstractJasminClass.sizeOfType(it.next());
        }
        return count;
    }

    @Override
    public int getOutMachineCount() {
        if (this.getMethodRef().returnType() instanceof VoidType) {
            return 0;
        }
        return AbstractJasminClass.sizeOfType(this.getMethodRef().returnType());
    }

    @Override
    public boolean containsInvokeExpr() {
        return true;
    }
}

