/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.Value;
import soot.VoidType;
import soot.baf.DynamicInvokeInst;
import soot.baf.InstSwitch;
import soot.baf.internal.AbstractInvokeInst;
import soot.util.Switch;

public class BDynamicInvokeInst
extends AbstractInvokeInst
implements DynamicInvokeInst {
    protected final SootMethodRef bsmRef;
    private final List<Value> bsmArgs;
    protected int tag;

    public BDynamicInvokeInst(SootMethodRef bsmMethodRef, List<Value> bsmArgs, SootMethodRef methodRef, int tag) {
        this.bsmRef = bsmMethodRef;
        this.bsmArgs = bsmArgs;
        this.methodRef = methodRef;
        this.tag = tag;
    }

    @Override
    public int getInCount() {
        return this.methodRef.parameterTypes().size();
    }

    @Override
    public Object clone() {
        return new BDynamicInvokeInst(this.bsmRef, this.bsmArgs, this.methodRef, this.tag);
    }

    @Override
    public int getOutCount() {
        if (this.methodRef.returnType() instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        return this.bsmArgs;
    }

    @Override
    public String getName() {
        return "dynamicinvoke";
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseDynamicInvokeInst(this);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("dynamicinvoke");
        buffer.append(" \"");
        buffer.append(this.methodRef.name());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buffer.append(">");
        buffer.append(this.bsmRef.getSignature());
        buffer.append("(");
        int i = 0;
        while (i < this.bsmArgs.size()) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.bsmArgs.get(i).toString());
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("dynamicinvoke");
        up.literal(" \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + "> ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        int i = 0;
        while (i < this.bsmArgs.size()) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgs.get(i).toString(up);
            ++i;
        }
        up.literal(")");
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

