/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.InstSwitch;
import soot.baf.LookupSwitchInst;
import soot.baf.internal.AbstractInst;
import soot.jimple.Constant;
import soot.util.Switch;

public class BLookupSwitchInst
extends AbstractInst
implements LookupSwitchInst {
    UnitBox defaultTargetBox;
    List lookupValues;
    UnitBox[] targetBoxes;
    List unitBoxes;

    public BLookupSwitchInst(Unit defaultTarget, List lookupValues, List targets) {
        this.defaultTargetBox = Baf.v().newInstBox(defaultTarget);
        this.targetBoxes = new UnitBox[targets.size()];
        int i = 0;
        while (i < this.targetBoxes.length) {
            this.targetBoxes[i] = Baf.v().newInstBox((Unit)targets.get(i));
            ++i;
        }
        this.lookupValues = new ArrayList();
        this.lookupValues.addAll(lookupValues);
        this.unitBoxes = new ArrayList();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            this.unitBoxes.add(element);
            ++n2;
        }
        this.unitBoxes.add(this.defaultTargetBox);
        this.unitBoxes = Collections.unmodifiableList(this.unitBoxes);
    }

    @Override
    public Object clone() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            list.add(element.getUnit());
            ++n2;
        }
        return new BLookupSwitchInst(this.defaultTargetBox.getUnit(), this.lookupValues, list);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return 1;
    }

    @Override
    public int getOutCount() {
        return 0;
    }

    @Override
    public int getOutMachineCount() {
        return 0;
    }

    @Override
    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    public void setLookupValues(List lookupValues) {
        this.lookupValues = new ArrayList();
        this.lookupValues.addAll(lookupValues);
    }

    @Override
    public void setLookupValue(int index, int value) {
        this.lookupValues.set(index, new Integer(value));
    }

    @Override
    public int getLookupValue(int index) {
        return (Integer)this.lookupValues.get(index);
    }

    public List getLookupValues() {
        return Collections.unmodifiableList(this.lookupValues);
    }

    @Override
    public int getTargetCount() {
        return this.targetBoxes.length;
    }

    @Override
    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public void setTargets(List<Unit> targets) {
        int i = 0;
        while (i < targets.size()) {
            this.targetBoxes[i].setUnit(targets.get(i));
            ++i;
        }
    }

    @Override
    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    public List getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            targets.add(element.getUnit());
            ++n2;
        }
        return targets;
    }

    @Override
    public String getName() {
        return "lookupswitch";
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("lookupswitch" + endOfLine);
        buffer.append("{" + endOfLine);
        int i = 0;
        while (i < this.lookupValues.size()) {
            buffer.append("    case " + this.lookupValues.get(i) + ": goto " + this.getTarget(i) + ";" + endOfLine);
            ++i;
        }
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("lookupswitch");
        up.newline();
        up.literal("{");
        up.newline();
        int i = 0;
        while (i < this.lookupValues.size()) {
            up.literal("    case ");
            up.constant((Constant)this.lookupValues.get(i));
            up.literal(": goto ");
            this.targetBoxes[i].toString(up);
            up.literal(";");
            up.newline();
            ++i;
        }
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    public List getUnitBoxes() {
        return this.unitBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseLookupSwitchInst(this);
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

