/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.InstSwitch;
import soot.baf.TableSwitchInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BTableSwitchInst
extends AbstractInst
implements TableSwitchInst {
    UnitBox defaultTargetBox;
    int lowIndex;
    int highIndex;
    UnitBox[] targetBoxes;
    List unitBoxes;

    public BTableSwitchInst(Unit defaultTarget, int lowIndex, int highIndex, List targets) {
        this.defaultTargetBox = Baf.v().newInstBox(defaultTarget);
        this.targetBoxes = new UnitBox[targets.size()];
        int i = 0;
        while (i < this.targetBoxes.length) {
            this.targetBoxes[i] = Baf.v().newInstBox((Unit)targets.get(i));
            ++i;
        }
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
        this.unitBoxes = new ArrayList();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            this.unitBoxes.add(element);
            ++n2;
        }
        this.unitBoxes.add(this.defaultTargetBox);
        this.unitBoxes = Collections.unmodifiableList(this.unitBoxes);
    }

    @Override
    public Object clone() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            list.add(element.getUnit());
            ++n2;
        }
        return new BTableSwitchInst(this.defaultTargetBox.getUnit(), this.lowIndex, this.highIndex, list);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return 1;
    }

    @Override
    public int getOutCount() {
        return 0;
    }

    @Override
    public int getOutMachineCount() {
        return 0;
    }

    @Override
    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    @Override
    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    @Override
    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    @Override
    public int getLowIndex() {
        return this.lowIndex;
    }

    @Override
    public int getHighIndex() {
        return this.highIndex;
    }

    public int getTargetCount() {
        return this.targetBoxes.length;
    }

    @Override
    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public void setTargets(List<Unit> targets) {
        int i = 0;
        while (i < targets.size()) {
            this.targetBoxes[i].setUnit(targets.get(i));
            ++i;
        }
    }

    @Override
    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    public List getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            targets.add(element.getUnit());
            ++n2;
        }
        return targets;
    }

    @Override
    public String getName() {
        return "tableswitch";
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("tableswitch" + endOfLine);
        buffer.append("{" + endOfLine);
        int i = this.lowIndex;
        while (i < this.highIndex) {
            buffer.append("    case " + i + ": goto " + this.getTarget(i - this.lowIndex) + ";" + endOfLine);
            ++i;
        }
        buffer.append("    case " + this.highIndex + ": goto " + this.getTarget(this.highIndex - this.lowIndex) + ";" + endOfLine);
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("tableswitch");
        up.newline();
        up.literal("{");
        up.newline();
        int i = this.lowIndex;
        while (i < this.highIndex) {
            this.printCaseTarget(up, i);
            ++i;
        }
        this.printCaseTarget(up, this.highIndex);
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    private void printCaseTarget(UnitPrinter up, int targetIndex) {
        up.literal("    case ");
        up.literal(new Integer(targetIndex).toString());
        up.literal(": goto ");
        this.targetBoxes[targetIndex - this.lowIndex].toString(up);
        up.literal(";");
        up.newline();
    }

    public List getUnitBoxes() {
        return this.unitBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseTableSwitchInst(this);
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

