/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.Baf;
import soot.baf.Dup1Inst;
import soot.baf.DupInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldArgInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.IdentityInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.LoadInst;
import soot.baf.MethodArgInst;
import soot.baf.MulInst;
import soot.baf.NewInst;
import soot.baf.OrInst;
import soot.baf.PushInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.XorInst;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.ZonedBlockGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class LoadStoreOptimizer
extends BodyTransformer {
    boolean debug = false;
    private static final int FAILURE = 0;
    private static final int SUCCESS = 1;
    private static final int MAKE_DUP = 2;
    private static final int MAKE_DUP1_X1 = 3;
    private static final int SPECIAL_SUCCESS = 4;
    private static final int HAS_CHANGED = 5;
    private static final int SPECIAL_SUCCESS2 = 6;
    private static final int STORE_LOAD_ELIMINATION = 0;
    private static final int STORE_LOAD_LOAD_ELIMINATION = -1;
    private Map<String, String> gOptions;

    public LoadStoreOptimizer(Singletons.Global g) {
    }

    public static LoadStoreOptimizer v() {
        return G.v().soot_baf_toolkits_base_LoadStoreOptimizer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        this.gOptions = options;
        Instance instance = new Instance();
        instance.mBody = body;
        instance.mUnits = body.getUnits();
        this.debug = PhaseOptions.getBoolean(this.gOptions, "debug");
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Performing LoadStore optimizations...");
        }
        if (this.debug) {
            G.v().out.println("\n\nOptimizing Method: " + body.getMethod().getName());
        }
        instance.go();
    }

    class Instance {
        private Chain<Unit> mUnits;
        private Body mBody;
        private LocalDefs mLocalDefs;
        private LocalUses mLocalUses;
        private Map<Unit, Block> mUnitToBlockMap;
        private boolean mPass2 = false;

        Instance() {
        }

        void go() {
            if (!this.mUnits.isEmpty()) {
                this.buildUnitToBlockMap();
                this.computeLocalDefsAndLocalUsesInfo();
                if (LoadStoreOptimizer.this.debug) {
                    G.v().out.println("Calling optimizeLoadStore(1)\n");
                }
                this.optimizeLoadStores();
                if (PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "inter")) {
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("Calling doInterBlockOptimizations");
                    }
                    this.doInterBlockOptimizations();
                }
                if (PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sl2") || PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sll2")) {
                    this.mPass2 = true;
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("Calling optimizeLoadStore(2)");
                    }
                    this.optimizeLoadStores();
                }
            }
        }

        private void buildUnitToBlockMap() {
            ZonedBlockGraph blockGraph = new ZonedBlockGraph(this.mBody);
            if (LoadStoreOptimizer.this.debug) {
                G.v().out.println("Method " + this.mBody.getMethod().getName() + " Block Graph: ");
                G.v().out.println(blockGraph);
            }
            List<Block> blocks = blockGraph.getBlocks();
            this.mUnitToBlockMap = new HashMap<Unit, Block>();
            for (Block block : blocks) {
                for (Unit unit : block) {
                    this.mUnitToBlockMap.put(unit, block);
                }
            }
        }

        private List<Unit> buildStoreList() {
            ArrayList<Unit> storeList = new ArrayList<Unit>();
            for (Unit unit : this.mUnits) {
                if (!(unit instanceof StoreInst)) continue;
                storeList.add(unit);
            }
            return storeList;
        }

        private void computeLocalDefsAndLocalUsesInfo() {
            this.mLocalDefs = LocalDefs.Factory.newLocalDefs(this.mBody);
            this.mLocalUses = LocalUses.Factory.newLocalUses(this.mBody, this.mLocalDefs);
        }

        private void optimizeLoadStores() {
            List<Unit> storeList = this.buildStoreList();
            boolean hasChanged = true;
            boolean hasChangedFlag = false;
            while (hasChanged) {
                hasChanged = false;
                Iterator<Unit> unitIt = storeList.iterator();
                block6: while (unitIt.hasNext()) {
                    Unit unit = unitIt.next();
                    List<UnitValueBoxPair> uses = this.mLocalUses.getUsesOf(unit);
                    if (uses.size() >= 3) continue;
                    for (UnitValueBoxPair pair : uses) {
                        List<Unit> defs;
                        Unit loadUnit = pair.getUnit();
                        if (!(loadUnit instanceof LoadInst) || (defs = this.mLocalDefs.getDefsOfAt((Local)pair.getValueBox().getValue(), loadUnit)).size() > 1 || defs.get(0) != unit) continue block6;
                    }
                    Block storeBlock = this.mUnitToBlockMap.get(unit);
                    for (UnitValueBoxPair pair : uses) {
                        Block useBlock = this.mUnitToBlockMap.get(pair.getUnit());
                        if (useBlock != storeBlock) continue block6;
                    }
                    switch (uses.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            Block block;
                            Unit loadUnit;
                            int test;
                            if (!PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sl") || this.mPass2 && !PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sl2") || (test = this.stackIndependent(unit, loadUnit = uses.get(0).getUnit(), block = this.mUnitToBlockMap.get(unit), 0)) != 1 && test != 4) continue block6;
                            block.remove(unit);
                            block.remove(loadUnit);
                            unitIt.remove();
                            hasChanged = true;
                            hasChangedFlag = false;
                            if (!LoadStoreOptimizer.this.debug) break;
                            G.v().out.println("Store/Load elimination occurred case1.");
                            break;
                        }
                        case 2: {
                            int result;
                            if (!PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sll") || this.mPass2 && !PhaseOptions.getBoolean(LoadStoreOptimizer.this.gOptions, "sll2")) continue block6;
                            Unit firstLoad = uses.get(0).getUnit();
                            Unit secondLoad = uses.get(1).getUnit();
                            Block block = this.mUnitToBlockMap.get(unit);
                            if (this.mUnits.follows(firstLoad, secondLoad)) {
                                Unit temp = secondLoad;
                                secondLoad = firstLoad;
                                firstLoad = temp;
                            }
                            if ((result = this.stackIndependent(unit, firstLoad, block, 0)) == 1) {
                                block.remove(firstLoad);
                                block.insertAfter(firstLoad, unit);
                                int res = this.stackIndependent(unit, secondLoad, block, -1);
                                if (res != 2) break;
                                Dup1Inst dup = Baf.v().newDup1Inst(((LoadInst)secondLoad).getOpType());
                                dup.addAllTagsOf(unit);
                                this.replaceUnit(unit, dup);
                                unitIt.remove();
                                block.remove(firstLoad);
                                block.remove(secondLoad);
                                hasChanged = true;
                                hasChangedFlag = false;
                                break;
                            }
                            if (result != 4 && result != 5 && result != 6 || hasChangedFlag) continue block6;
                            hasChangedFlag = true;
                            hasChanged = true;
                        }
                    }
                }
            }
        }

        private boolean isRequiredByFollowingUnits(Unit from, Unit to) {
            Iterator<Unit> it = this.mUnits.iterator(from, to);
            int stackHeight = 0;
            boolean res = false;
            if (from != to) {
                it.next();
                while (it.hasNext()) {
                    Unit currentInst = it.next();
                    if (currentInst == to) break;
                    if ((stackHeight -= ((Inst)currentInst).getInCount()) < 0) {
                        res = true;
                        break;
                    }
                    stackHeight += ((Inst)currentInst).getOutCount();
                }
            }
            return res;
        }

        private int pushStoreToLoad(Unit from, Unit to, Block block) {
            Unit storePred = block.getPredOf(from);
            if (storePred != null && ((Inst)storePred).getOutCount() == 1) {
                HashSet<Unit> unitsToMove = new HashSet<Unit>();
                unitsToMove.add(storePred);
                unitsToMove.add(from);
                int h = ((Inst)storePred).getInCount();
                Unit currentUnit = storePred;
                if (h != 0) {
                    currentUnit = block.getPredOf(storePred);
                    while (currentUnit != null) {
                        if ((h -= ((Inst)currentUnit).getOutCount()) < 0) {
                            if (LoadStoreOptimizer.this.debug) {
                                G.v().out.println("xxx: negative");
                            }
                            return 0;
                        }
                        unitsToMove.add(currentUnit);
                        if ((h += ((Inst)currentUnit).getInCount()) == 0) break;
                        currentUnit = block.getPredOf(currentUnit);
                    }
                }
                if (currentUnit == null) {
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("xxx: null");
                    }
                    return 0;
                }
                Unit uu = from;
                while ((uu = block.getSuccOf(uu)) != to) {
                    for (Unit nu : unitsToMove) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxxspecial;success pushing forward stuff.");
                        }
                        if (!this.canMoveUnitOver(nu, uu)) {
                            if (LoadStoreOptimizer.this.debug) {
                                G.v().out.println("xxx: cant move over faillure" + nu);
                            }
                            return 0;
                        }
                        if (!LoadStoreOptimizer.this.debug) continue;
                        G.v().out.println("can move" + nu + " over " + uu);
                    }
                }
                Unit unitToMove = currentUnit;
                while (unitToMove != from) {
                    Unit succ = block.getSuccOf(unitToMove);
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("moving " + unitToMove);
                    }
                    block.remove(unitToMove);
                    block.insertBefore(unitToMove, to);
                    unitToMove = succ;
                }
                block.remove(from);
                block.insertBefore(from, to);
                if (LoadStoreOptimizer.this.debug) {
                    G.v().out.println("xxx1success pushing forward stuff.");
                }
                return 4;
            }
            return 0;
        }

        private int stackIndependent(Unit from, Unit to, Block block, int aContext) {
            if (LoadStoreOptimizer.this.debug) {
                G.v().out.println("Trying: " + from + "/" + to + " in block  " + block.getIndexInMethod() + ":");
                G.v().out.println("context:" + (aContext == 0 ? "STORE_LOAD_ELIMINATION" : "STORE_LOAD_LOAD_ELIMINATION"));
            }
            int minStackHeightAttained = 0;
            int stackHeight = 0;
            Iterator<Unit> it = this.mUnits.iterator(this.mUnits.getSuccOf(from));
            int res = 0;
            Unit currentInst = it.next();
            if (aContext == -1) {
                currentInst = it.next();
            }
            while (currentInst != to) {
                if ((stackHeight -= ((Inst)currentInst).getInCount()) < minStackHeightAttained) {
                    minStackHeightAttained = stackHeight;
                }
                stackHeight += ((Inst)currentInst).getOutCount();
                currentInst = it.next();
            }
            if (LoadStoreOptimizer.this.debug) {
                G.v().out.println("nshv = " + stackHeight);
                G.v().out.println("mshv = " + minStackHeightAttained);
            }
            boolean hasChanged = true;
            block1: while (hasChanged) {
                hasChanged = false;
                if (aContext == -1) {
                    if (stackHeight == 0 && minStackHeightAttained == 0) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxx: succ: -1, makedup ");
                        }
                        return 2;
                    }
                    if (stackHeight == -1 && minStackHeightAttained == -1) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxx: succ: -1, makedup , -1");
                        }
                        return 2;
                    }
                    if (stackHeight == -2 && minStackHeightAttained == -2) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxx: succ -1 , make dupx1 ");
                        }
                        return 3;
                    }
                    if (minStackHeightAttained < -2) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxx: failled due: minStackHeightAttained < -2 ");
                        }
                        return 0;
                    }
                }
                if (aContext == 0) {
                    if (stackHeight == 0 && minStackHeightAttained == 0) {
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("xxx: success due: 0, SUCCESS ");
                        }
                        return 1;
                    }
                    if (minStackHeightAttained < 0) {
                        return this.pushStoreToLoad(from, to, block);
                    }
                }
                it = this.mUnits.iterator(this.mUnits.getSuccOf(from), to);
                Unit unitToMove = null;
                Unit u = it.next();
                if (aContext == -1) {
                    u = it.next();
                }
                int currentH = 0;
                while (u != to) {
                    int flag;
                    if (((Inst)u).getNetCount() == 1) {
                        if (u instanceof LoadInst || u instanceof PushInst || u instanceof NewInst || u instanceof StaticGetInst || u instanceof Dup1Inst) {
                            if (!this.isRequiredByFollowingUnits(u, to)) {
                                unitToMove = u;
                            }
                        } else if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("1003:(LoadStoreOptimizer@stackIndependent): found unknown unit w/ getNetCount == 1" + u);
                        }
                    }
                    if (unitToMove != null && this.tryToMoveUnit(unitToMove, block, from, to, flag = 0)) {
                        if (stackHeight > -2 && minStackHeightAttained == -2) {
                            return 5;
                        }
                        if (--stackHeight < minStackHeightAttained) {
                            minStackHeightAttained = stackHeight;
                        }
                        hasChanged = true;
                        continue block1;
                    }
                    currentH += ((Inst)u).getNetCount();
                    unitToMove = null;
                    u = it.next();
                }
            }
            if (this.isCommutativeBinOp(block.getSuccOf(to))) {
                if (aContext == 0 && stackHeight == 1 && minStackHeightAttained == 0) {
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("xxx: commutative ");
                    }
                    return 4;
                }
                if (((Inst)to).getOutCount() == 1 && ((Inst)to).getInCount() == 0 && ((Inst)this.mUnits.getPredOf(to)).getOutCount() == 1 && ((Inst)this.mUnits.getPredOf(to)).getInCount() == 0) {
                    Unit toPred = this.mUnits.getPredOf(to);
                    block.remove(toPred);
                    block.insertAfter(toPred, to);
                    return 5;
                }
                return 0;
            }
            if (aContext == 0) {
                return this.pushStoreToLoad(from, to, block);
            }
            return res;
        }

        private boolean isNonLocalReadOrWrite(Unit aUnit) {
            return aUnit instanceof FieldArgInst || aUnit instanceof ArrayReadInst || aUnit instanceof ArrayWriteInst;
        }

        private boolean canMoveUnitOver(Unit aUnitToMove, Unit aUnitToGoOver) {
            if (aUnitToGoOver instanceof MethodArgInst && aUnitToMove instanceof MethodArgInst || aUnitToGoOver instanceof MethodArgInst && this.isNonLocalReadOrWrite(aUnitToMove) || this.isNonLocalReadOrWrite(aUnitToGoOver) && aUnitToMove instanceof MethodArgInst || aUnitToGoOver instanceof ArrayReadInst && aUnitToMove instanceof ArrayWriteInst || aUnitToGoOver instanceof ArrayWriteInst && aUnitToMove instanceof ArrayReadInst || aUnitToGoOver instanceof ArrayWriteInst && aUnitToMove instanceof ArrayWriteInst || aUnitToGoOver instanceof FieldPutInst && aUnitToMove instanceof FieldGetInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof FieldGetInst && aUnitToMove instanceof FieldPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof FieldPutInst && aUnitToMove instanceof FieldPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticPutInst && aUnitToMove instanceof StaticGetInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticGetInst && aUnitToMove instanceof StaticPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField() || aUnitToGoOver instanceof StaticPutInst && aUnitToMove instanceof StaticPutInst && ((FieldArgInst)aUnitToGoOver).getField() == ((FieldArgInst)aUnitToMove).getField()) {
                return false;
            }
            if (aUnitToGoOver instanceof EnterMonitorInst || aUnitToGoOver instanceof ExitMonitorInst) {
                return false;
            }
            if (aUnitToMove instanceof EnterMonitorInst || aUnitToGoOver instanceof ExitMonitorInst) {
                return false;
            }
            if (aUnitToGoOver instanceof IdentityInst || aUnitToMove instanceof IdentityInst) {
                return false;
            }
            if (aUnitToMove instanceof LoadInst && (aUnitToGoOver instanceof StoreInst ? ((StoreInst)aUnitToGoOver).getLocal() == ((LoadInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof IncInst && ((IncInst)aUnitToGoOver).getLocal() == ((LoadInst)aUnitToMove).getLocal())) {
                return false;
            }
            if (aUnitToMove instanceof StoreInst && (aUnitToGoOver instanceof LoadInst ? ((LoadInst)aUnitToGoOver).getLocal() == ((StoreInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof IncInst && ((IncInst)aUnitToGoOver).getLocal() == ((StoreInst)aUnitToMove).getLocal())) {
                return false;
            }
            return !(aUnitToMove instanceof IncInst) || !(aUnitToGoOver instanceof StoreInst ? ((StoreInst)aUnitToGoOver).getLocal() == ((IncInst)aUnitToMove).getLocal() : aUnitToGoOver instanceof LoadInst && ((LoadInst)aUnitToGoOver).getLocal() == ((IncInst)aUnitToMove).getLocal());
        }

        /*
         * Unable to fully structure code
         */
        private boolean tryToMoveUnit(Unit unitToMove, Block block, Unit from, Unit to, int flag) {
            h = 0;
            current = unitToMove;
            reachedStore = false;
            reorderingOccurred = false;
            if (LoadStoreOptimizer.this.debug) {
                G.v().out.println("[tryToMoveUnit]: trying to move:" + unitToMove);
            }
            if (unitToMove != null) ** GOTO lbl29
            return false;
lbl-1000:
            // 1 sources

            {
                if (!this.canMoveUnitOver(current = this.mUnits.getPredOf(current), unitToMove)) {
                    return false;
                }
                if (current == from) {
                    reachedStore = true;
                }
                if ((h -= ((Inst)current).getOutCount()) < 0) {
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("1006:(LoadStoreOptimizer@stackIndependent): Stack went negative while trying to reorder code.");
                    }
                    if (flag == 1 && current instanceof DupInst) {
                        block.remove(unitToMove);
                        block.insertAfter(unitToMove, current);
                    }
                    return false;
                }
                if ((h += ((Inst)current).getInCount()) != 0 || !reachedStore || this.isRequiredByFollowingUnits(unitToMove, to)) continue;
                if (LoadStoreOptimizer.this.debug) {
                    G.v().out.println("10077:(LoadStoreOptimizer@stackIndependent): reordering bytecode move: " + unitToMove + "before: " + current);
                }
                block.remove(unitToMove);
                block.insertBefore(unitToMove, current);
                reorderingOccurred = true;
                break;
lbl29:
                // 2 sources

                ** while (current != block.getHead())
            }
lbl30:
            // 2 sources

            if (reorderingOccurred) {
                if (LoadStoreOptimizer.this.debug) {
                    G.v().out.println("reordering occured");
                }
                return true;
            }
            if (LoadStoreOptimizer.this.debug) {
                G.v().out.println("1008:(LoadStoreOptimizer@stackIndependent):failled to find a new slot for unit to move");
            }
            return false;
        }

        private void replaceUnit(Unit aToReplace1, Unit aToReplace2, Unit aReplacement) {
            Block block = this.mUnitToBlockMap.get(aToReplace1);
            if (aToReplace2 != null) {
                block.insertAfter(aReplacement, aToReplace2);
                block.remove(aToReplace2);
            } else {
                block.insertAfter(aReplacement, aToReplace1);
            }
            block.remove(aToReplace1);
            this.mUnitToBlockMap.put(aReplacement, block);
        }

        private void replaceUnit(Unit aToReplace, Unit aReplacement) {
            this.replaceUnit(aToReplace, null, aReplacement);
        }

        private boolean isExceptionHandlerBlock(Block aBlock) {
            Unit blockHead = aBlock.getHead();
            for (Trap trap : this.mBody.getTraps()) {
                if (trap.getHandlerUnit() != blockHead) continue;
                return true;
            }
            return false;
        }

        private int getDeltaStackHeightFromTo(Unit aFrom, Unit aTo) {
            Iterator<Unit> it = this.mUnits.iterator(aFrom, aTo);
            int h = 0;
            while (it.hasNext()) {
                h += ((Inst)it.next()).getNetCount();
            }
            return h;
        }

        private void doInterBlockOptimizations() {
            boolean hasChanged = true;
            while (hasChanged) {
                hasChanged = false;
                ArrayList<Unit> tempList = new ArrayList<Unit>();
                tempList.addAll(this.mUnits);
                for (Unit u : tempList) {
                    if (!(u instanceof LoadInst)) continue;
                    if (LoadStoreOptimizer.this.debug) {
                        G.v().out.println("inter trying: " + u);
                    }
                    Block loadBlock = this.mUnitToBlockMap.get(u);
                    List<Unit> defs = this.mLocalDefs.getDefsOfAt(((LoadInst)u).getLocal(), u);
                    if (defs.size() == 1) {
                        List<UnitValueBoxPair> uses;
                        Unit storeUnit;
                        Block defBlock = this.mUnitToBlockMap.get(defs.get(0));
                        if (defBlock == loadBlock || this.isExceptionHandlerBlock(loadBlock) || !((storeUnit = defs.get(0)) instanceof StoreInst) || (uses = this.mLocalUses.getUsesOf(storeUnit)).size() != 1 || !this.allSuccesorsOfAreThePredecessorsOf(defBlock, loadBlock) || this.getDeltaStackHeightFromTo(defBlock.getSuccOf(storeUnit), defBlock.getTail()) != 0) continue;
                        Iterator<Block> it2 = defBlock.getSuccs().iterator();
                        boolean res = true;
                        while (it2.hasNext()) {
                            Block b = it2.next();
                            if (this.getDeltaStackHeightFromTo(b.getHead(), b.getTail()) != 0) {
                                res = false;
                                break;
                            }
                            if (b.getPreds().size() == 1 && b.getSuccs().size() == 1) continue;
                            res = false;
                            break;
                        }
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println(String.valueOf(defBlock.toString()) + loadBlock.toString());
                        }
                        if (!res) continue;
                        defBlock.remove(storeUnit);
                        this.mUnitToBlockMap.put(storeUnit, loadBlock);
                        loadBlock.insertBefore(storeUnit, loadBlock.getHead());
                        hasChanged = true;
                        if (LoadStoreOptimizer.this.debug) {
                            G.v().out.println("inter-block opti occurred " + storeUnit + " " + u);
                        }
                        if (!LoadStoreOptimizer.this.debug) continue;
                        G.v().out.println(String.valueOf(defBlock.toString()) + loadBlock.toString());
                        continue;
                    }
                    if (defs.size() != 2) continue;
                    Unit def0 = defs.get(0);
                    Unit def1 = defs.get(1);
                    Block defBlock0 = this.mUnitToBlockMap.get(def0);
                    Block defBlock1 = this.mUnitToBlockMap.get(def1);
                    if (defBlock0 != loadBlock && defBlock1 != loadBlock && defBlock0 != defBlock1 && !this.isExceptionHandlerBlock(loadBlock)) {
                        if (this.mLocalUses.getUsesOf(def0).size() == 1 && this.mLocalUses.getUsesOf(def1).size() == 1) {
                            List<Block> def0Succs = defBlock0.getSuccs();
                            List<Block> def1Succs = defBlock1.getSuccs();
                            if (def0Succs.size() == 1 && def1Succs.size() == 1) {
                                if (def0Succs.get(0) == loadBlock && def1Succs.get(0) == loadBlock) {
                                    if (loadBlock.getPreds().size() == 2) {
                                        if (!(def0 != defBlock0.getTail() && this.getDeltaStackHeightFromTo(defBlock0.getSuccOf(def0), defBlock0.getTail()) != 0 || def1 != defBlock1.getTail() && this.getDeltaStackHeightFromTo(defBlock1.getSuccOf(def1), defBlock1.getTail()) != 0)) {
                                            defBlock0.remove(def0);
                                            defBlock1.remove(def1);
                                            loadBlock.insertBefore(def0, loadBlock.getHead());
                                            this.mUnitToBlockMap.put(def0, loadBlock);
                                            hasChanged = true;
                                            if (!LoadStoreOptimizer.this.debug) continue;
                                            G.v().out.println("inter-block opti2 occurred " + def0);
                                            continue;
                                        }
                                        if (!LoadStoreOptimizer.this.debug) continue;
                                        G.v().out.println("failed: inter1");
                                        continue;
                                    }
                                    if (!LoadStoreOptimizer.this.debug) continue;
                                    G.v().out.println("failed: inter2");
                                    continue;
                                }
                                if (!LoadStoreOptimizer.this.debug) continue;
                                G.v().out.println("failed: inter3");
                                continue;
                            }
                            if (!LoadStoreOptimizer.this.debug) continue;
                            G.v().out.println("failed: inter4");
                            continue;
                        }
                        if (!LoadStoreOptimizer.this.debug) continue;
                        G.v().out.println("failed: inter5");
                        continue;
                    }
                    if (!LoadStoreOptimizer.this.debug) continue;
                    G.v().out.println("failed: inter6");
                }
            }
        }

        private boolean allSuccesorsOfAreThePredecessorsOf(Block aFirstBlock, Block aSecondBlock) {
            int size = aFirstBlock.getSuccs().size();
            Iterator<Block> it = aFirstBlock.getSuccs().iterator();
            List<Block> preds = aSecondBlock.getPreds();
            while (it.hasNext()) {
                if (preds.contains(it.next())) continue;
                return false;
            }
            return size == preds.size();
        }

        private boolean isCommutativeBinOp(Unit aUnit) {
            if (aUnit == null) {
                return false;
            }
            return aUnit instanceof AddInst || aUnit instanceof MulInst || aUnit instanceof AndInst || aUnit instanceof OrInst || aUnit instanceof XorInst;
        }

        void propagateBackwardsIndependentHunk() {
            ArrayList<Unit> tempList = new ArrayList<Unit>();
            tempList.addAll(this.mUnits);
            for (Unit u : tempList) {
                Block block;
                Unit succ;
                if (!(u instanceof NewInst) || !((succ = (block = this.mUnitToBlockMap.get(u)).getSuccOf(u)) instanceof StoreInst)) continue;
                Unit currentUnit = u;
                Unit candidate = null;
                while (currentUnit != block.getHead()) {
                    if (!this.canMoveUnitOver(currentUnit = block.getPredOf(currentUnit), succ)) break;
                    candidate = currentUnit;
                }
                if (candidate == null) continue;
                block.remove(u);
                block.remove(succ);
                block.insertBefore(u, candidate);
                block.insertBefore(succ, candidate);
            }
        }
    }
}

