/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import soot.G;
import soot.Timers;
import soot.coffi.AnnotationDefault_attribute;
import soot.coffi.BootstrapMethods_attribute;
import soot.coffi.ByteCode;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_InvokeDynamic_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_MethodHandle_info;
import soot.coffi.CONSTANT_Methodref_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_collector;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.Code_attribute;
import soot.coffi.ConstantValue_attribute;
import soot.coffi.Deprecated_attribute;
import soot.coffi.EnclosingMethod_attribute;
import soot.coffi.Exception_attribute;
import soot.coffi.Generic_attribute;
import soot.coffi.InnerClasses_attribute;
import soot.coffi.Instruction;
import soot.coffi.Instruction_Unknown;
import soot.coffi.LineNumberTable_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.LocalVariableTypeTable_attribute;
import soot.coffi.RuntimeInvisibleAnnotations_attribute;
import soot.coffi.RuntimeInvisibleParameterAnnotations_attribute;
import soot.coffi.RuntimeVisibleAnnotations_attribute;
import soot.coffi.RuntimeVisibleParameterAnnotations_attribute;
import soot.coffi.Signature_attribute;
import soot.coffi.SourceFile_attribute;
import soot.coffi.Synthetic_attribute;
import soot.coffi.annotation;
import soot.coffi.annotation_element_value;
import soot.coffi.array_element_value;
import soot.coffi.attribute_info;
import soot.coffi.class_element_value;
import soot.coffi.constant_element_value;
import soot.coffi.cp_info;
import soot.coffi.element_value;
import soot.coffi.enum_constant_element_value;
import soot.coffi.exception_table_entry;
import soot.coffi.field_info;
import soot.coffi.inner_class_entry;
import soot.coffi.line_number_table_entry;
import soot.coffi.local_variable_table_entry;
import soot.coffi.local_variable_type_table_entry;
import soot.coffi.method_info;
import soot.coffi.parameter_annotation;
import soot.options.Options;

public class ClassFile {
    static final long MAGIC = 3405691582L;
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_VOLATILE = 64;
    static final short ACC_TRANSIENT = 128;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    static final short ACC_STRICT = 2048;
    static final short ACC_ANNOTATION = 8192;
    static final short ACC_ENUM = 16384;
    static final short ACC_UNKNOWN = 28672;
    static final String DESC_BYTE = "B";
    static final String DESC_CHAR = "C";
    static final String DESC_DOUBLE = "D";
    static final String DESC_FLOAT = "F";
    static final String DESC_INT = "I";
    static final String DESC_LONG = "J";
    static final String DESC_OBJECT = "L";
    static final String DESC_SHORT = "S";
    static final String DESC_BOOLEAN = "Z";
    static final String DESC_VOID = "V";
    static final String DESC_ARRAY = "[";
    boolean debug;
    String fn;
    long magic;
    int minor_version;
    int major_version;
    public int constant_pool_count;
    public cp_info[] constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public int fields_count;
    public field_info[] fields;
    public int methods_count;
    public method_info[] methods;
    public int attributes_count;
    public attribute_info[] attributes;
    public BootstrapMethods_attribute bootstrap_methods_attribute;

    public ClassFile(String nfn) {
        this.fn = nfn;
    }

    public String toString() {
        return this.constant_pool[this.this_class].toString(this.constant_pool);
    }

    public boolean loadClassFile(InputStream is) {
        ByteArrayInputStream f = null;
        InputStream classFileStream = is;
        if (Options.v().time()) {
            Timers.v().readTimer.start();
        }
        try {
            DataInputStream classDataStream = new DataInputStream(classFileStream);
            byte[] data = new byte[classDataStream.available()];
            classDataStream.readFully(data);
            f = new ByteArrayInputStream(data);
        }
        catch (IOException classDataStream) {
            // empty catch block
        }
        if (Options.v().time()) {
            Timers.v().readTimer.end();
        }
        DataInputStream d = new DataInputStream(f);
        boolean b = this.readClass(d);
        try {
            classFileStream.close();
            d.close();
            if (f != null) {
                ((InputStream)f).close();
            }
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    boolean saveClassFile() {
        FileOutputStream f;
        try {
            f = new FileOutputStream(this.fn);
        }
        catch (FileNotFoundException e) {
            if (this.fn.indexOf(".class") >= 0) {
                G.v().out.println("Can't find " + this.fn);
                return false;
            }
            this.fn = String.valueOf(this.fn) + ".class";
            try {
                f = new FileOutputStream(this.fn);
            }
            catch (FileNotFoundException ee) {
                G.v().out.println("Can't find " + this.fn);
                return false;
            }
        }
        DataOutputStream d = new DataOutputStream(f);
        boolean b = this.writeClass(d);
        try {
            d.close();
            f.close();
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    static String access_string(int af, String separator) {
        boolean hasone = false;
        String s = "";
        if ((af & 1) != 0) {
            s = "public";
            hasone = true;
        }
        if ((af & 2) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "private";
        }
        if ((af & 4) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "protected";
        }
        if ((af & 8) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "static";
        }
        if ((af & 0x10) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "final";
        }
        if ((af & 0x20) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "super";
        }
        if ((af & 0x40) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "volatile";
        }
        if ((af & 0x80) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "transient";
        }
        if ((af & 0x200) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "interface";
        }
        if ((af & 0x400) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "abstract";
        }
        if ((af & 0x800) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "strict";
        }
        if ((af & 0x2000) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "annotation";
        }
        if ((af & 0x4000) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "enum";
        }
        if ((af & 0x7000) != 0) {
            if (hasone) {
                s = String.valueOf(s) + separator;
            } else {
                hasone = true;
            }
            s = String.valueOf(s) + "unknown";
        }
        return s;
    }

    public boolean readClass(DataInputStream d) {
        block14: {
            block13: {
                this.magic = (long)d.readInt() & 0xFFFFFFFFL;
                if (this.magic == 3405691582L) break block13;
                G.v().out.println("Wrong magic number in " + this.fn + ": " + this.magic);
                return false;
            }
            this.minor_version = d.readUnsignedShort();
            this.major_version = d.readUnsignedShort();
            this.constant_pool_count = d.readUnsignedShort();
            if (this.readConstantPool(d)) break block14;
            return false;
        }
        try {
            this.access_flags = d.readUnsignedShort();
            this.this_class = d.readUnsignedShort();
            this.super_class = d.readUnsignedShort();
            this.interfaces_count = d.readUnsignedShort();
            if (this.interfaces_count > 0) {
                this.interfaces = new int[this.interfaces_count];
                int j = 0;
                while (j < this.interfaces_count) {
                    this.interfaces[j] = d.readUnsignedShort();
                    ++j;
                }
            }
            if (Options.v().time()) {
                Timers.v().fieldTimer.start();
            }
            this.fields_count = d.readUnsignedShort();
            this.readFields(d);
            if (Options.v().time()) {
                Timers.v().fieldTimer.end();
            }
            if (Options.v().time()) {
                Timers.v().methodTimer.start();
            }
            this.methods_count = d.readUnsignedShort();
            this.readMethods(d);
            if (Options.v().time()) {
                Timers.v().methodTimer.end();
            }
            if (Options.v().time()) {
                Timers.v().attributeTimer.start();
            }
            this.attributes_count = d.readUnsignedShort();
            if (this.attributes_count > 0) {
                this.attributes = new attribute_info[this.attributes_count];
                this.readAttributes(d, this.attributes_count, this.attributes);
            }
            if (Options.v().time()) {
                Timers.v().attributeTimer.end();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException with " + this.fn + ": " + e.getMessage(), e);
        }
        return true;
    }

    protected boolean readConstantPool(DataInputStream d) throws IOException {
        this.constant_pool = new cp_info[this.constant_pool_count];
        boolean skipone = false;
        int i = 1;
        while (i < this.constant_pool_count) {
            if (skipone) {
                skipone = false;
            } else {
                cp_info cp;
                byte tag = (byte)d.readUnsignedByte();
                switch (tag) {
                    case 7: {
                        cp = new CONSTANT_Class_info();
                        ((CONSTANT_Class_info)cp).name_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Class");
                        break;
                    }
                    case 9: {
                        cp = new CONSTANT_Fieldref_info();
                        ((CONSTANT_Fieldref_info)cp).class_index = d.readUnsignedShort();
                        ((CONSTANT_Fieldref_info)cp).name_and_type_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Fieldref");
                        break;
                    }
                    case 10: {
                        cp = new CONSTANT_Methodref_info();
                        ((CONSTANT_Methodref_info)cp).class_index = d.readUnsignedShort();
                        ((CONSTANT_Methodref_info)cp).name_and_type_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Methodref");
                        break;
                    }
                    case 11: {
                        cp = new CONSTANT_InterfaceMethodref_info();
                        ((CONSTANT_InterfaceMethodref_info)cp).class_index = d.readUnsignedShort();
                        ((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: MethodHandle");
                        break;
                    }
                    case 8: {
                        cp = new CONSTANT_String_info();
                        ((CONSTANT_String_info)cp).string_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: String");
                        break;
                    }
                    case 3: {
                        cp = new CONSTANT_Integer_info();
                        ((CONSTANT_Integer_info)cp).bytes = d.readInt();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Integer = " + ((CONSTANT_Integer_info)cp).bytes);
                        break;
                    }
                    case 4: {
                        cp = new CONSTANT_Float_info();
                        ((CONSTANT_Float_info)cp).bytes = d.readInt();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Float = " + ((CONSTANT_Float_info)cp).convert());
                        break;
                    }
                    case 5: {
                        cp = new CONSTANT_Long_info();
                        ((CONSTANT_Long_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                        ((CONSTANT_Long_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                        if (this.debug) {
                            String temp = cp.toString(this.constant_pool);
                            G.v().out.println("Constant pool[" + i + "]: Long = " + temp);
                        }
                        skipone = true;
                        break;
                    }
                    case 6: {
                        cp = new CONSTANT_Double_info();
                        ((CONSTANT_Double_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                        ((CONSTANT_Double_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                        if (this.debug) {
                            G.v().out.println("Constant pool[" + i + "]: Double = " + ((CONSTANT_Double_info)cp).convert());
                        }
                        skipone = true;
                        break;
                    }
                    case 12: {
                        cp = new CONSTANT_NameAndType_info();
                        ((CONSTANT_NameAndType_info)cp).name_index = d.readUnsignedShort();
                        ((CONSTANT_NameAndType_info)cp).descriptor_index = d.readUnsignedShort();
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Name and Type");
                        break;
                    }
                    case 1: {
                        CONSTANT_Utf8_info cputf8 = new CONSTANT_Utf8_info(d);
                        cp = CONSTANT_Utf8_collector.v().add(cputf8);
                        if (!this.debug) break;
                        G.v().out.println("Constant pool[" + i + "]: Utf8 = \"" + cputf8.convert() + "\"");
                        break;
                    }
                    case 15: {
                        cp = new CONSTANT_MethodHandle_info();
                        ((CONSTANT_MethodHandle_info)cp).kind = d.readByte();
                        ((CONSTANT_MethodHandle_info)cp).target_index = d.readUnsignedShort();
                        break;
                    }
                    case 18: {
                        cp = new CONSTANT_InvokeDynamic_info();
                        ((CONSTANT_InvokeDynamic_info)cp).bootstrap_method_index = d.readUnsignedShort();
                        ((CONSTANT_InvokeDynamic_info)cp).name_and_type_index = d.readUnsignedShort();
                        break;
                    }
                    default: {
                        G.v().out.println("Unknown tag in constant pool: " + tag + " at entry " + i);
                        return false;
                    }
                }
                cp.tag = tag;
                this.constant_pool[i] = cp;
            }
            ++i;
        }
        return true;
    }

    private void readAllBytes(byte[] dest, DataInputStream d) throws IOException {
        int total_len = dest.length;
        int read_len = 0;
        while (read_len < total_len) {
            int to_read = total_len - read_len;
            int curr_read = d.read(dest, read_len, to_read);
            read_len += curr_read;
        }
    }

    protected boolean readAttributes(DataInputStream d, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        int i = 0;
        while (i < attributes_count) {
            int k;
            attribute_info ra;
            attribute_info da;
            attribute_info ia;
            attribute_info la;
            attribute_info ea;
            attribute_info ca;
            int j = d.readUnsignedShort();
            long len = (long)d.readInt() & 0xFFFFFFFFL;
            String s = ((CONSTANT_Utf8_info)this.constant_pool[j]).convert();
            if (s.compareTo("SourceFile") == 0) {
                SourceFile_attribute sa = new SourceFile_attribute();
                sa.sourcefile_index = d.readUnsignedShort();
                a = sa;
            } else if (s.compareTo("ConstantValue") == 0) {
                ca = new ConstantValue_attribute();
                ca.constantvalue_index = d.readUnsignedShort();
                a = ca;
            } else if (s.compareTo("Code") == 0) {
                ca = new Code_attribute();
                ((Code_attribute)ca).max_stack = d.readUnsignedShort();
                ((Code_attribute)ca).max_locals = d.readUnsignedShort();
                ((Code_attribute)ca).code_length = (long)d.readInt() & 0xFFFFFFFFL;
                ((Code_attribute)ca).code = new byte[(int)((Code_attribute)ca).code_length];
                this.readAllBytes(((Code_attribute)ca).code, d);
                ((Code_attribute)ca).exception_table_length = d.readUnsignedShort();
                ((Code_attribute)ca).exception_table = new exception_table_entry[((Code_attribute)ca).exception_table_length];
                int k2 = 0;
                while (k2 < ((Code_attribute)ca).exception_table_length) {
                    exception_table_entry e = new exception_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.end_pc = d.readUnsignedShort();
                    e.handler_pc = d.readUnsignedShort();
                    e.catch_type = d.readUnsignedShort();
                    ((Code_attribute)ca).exception_table[k2] = e;
                    ++k2;
                }
                ((Code_attribute)ca).attributes_count = d.readUnsignedShort();
                ((Code_attribute)ca).attributes = new attribute_info[((Code_attribute)ca).attributes_count];
                this.readAttributes(d, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                a = ca;
            } else if (s.compareTo("Exceptions") == 0) {
                ea = new Exception_attribute();
                ea.number_of_exceptions = d.readUnsignedShort();
                if (ea.number_of_exceptions > 0) {
                    ea.exception_index_table = new int[ea.number_of_exceptions];
                    int k3 = 0;
                    while (k3 < ea.number_of_exceptions) {
                        ea.exception_index_table[k3] = d.readUnsignedShort();
                        ++k3;
                    }
                }
                a = ea;
            } else if (s.compareTo("LineNumberTable") == 0) {
                la = new LineNumberTable_attribute();
                la.line_number_table_length = d.readUnsignedShort();
                la.line_number_table = new line_number_table_entry[la.line_number_table_length];
                int k4 = 0;
                while (k4 < la.line_number_table_length) {
                    line_number_table_entry e = new line_number_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.line_number = d.readUnsignedShort();
                    la.line_number_table[k4] = e;
                    ++k4;
                }
                a = la;
            } else if (s.compareTo("LocalVariableTable") == 0) {
                la = new LocalVariableTable_attribute();
                ((LocalVariableTable_attribute)la).local_variable_table_length = d.readUnsignedShort();
                ((LocalVariableTable_attribute)la).local_variable_table = new local_variable_table_entry[((LocalVariableTable_attribute)la).local_variable_table_length];
                int k5 = 0;
                while (k5 < ((LocalVariableTable_attribute)la).local_variable_table_length) {
                    local_variable_table_entry e = new local_variable_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.length = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.descriptor_index = d.readUnsignedShort();
                    e.index = d.readUnsignedShort();
                    ((LocalVariableTable_attribute)la).local_variable_table[k5] = e;
                    ++k5;
                }
                a = la;
            } else if (s.compareTo("LocalVariableTypeTable") == 0) {
                la = new LocalVariableTypeTable_attribute();
                ((LocalVariableTypeTable_attribute)la).local_variable_type_table_length = d.readUnsignedShort();
                ((LocalVariableTypeTable_attribute)la).local_variable_type_table = new local_variable_type_table_entry[((LocalVariableTypeTable_attribute)la).local_variable_type_table_length];
                int k6 = 0;
                while (k6 < ((LocalVariableTypeTable_attribute)la).local_variable_type_table_length) {
                    local_variable_type_table_entry e = new local_variable_type_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.length = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.signature_index = d.readUnsignedShort();
                    e.index = d.readUnsignedShort();
                    ((LocalVariableTypeTable_attribute)la).local_variable_type_table[k6] = e;
                    ++k6;
                }
                a = la;
            } else if (s.compareTo("Synthetic") == 0) {
                ia = new Synthetic_attribute();
                a = ia;
            } else if (s.compareTo("Signature") == 0) {
                ia = new Signature_attribute();
                ((Signature_attribute)ia).signature_index = d.readUnsignedShort();
                a = ia;
            } else if (s.compareTo("Deprecated") == 0) {
                da = new Deprecated_attribute();
                a = da;
            } else if (s.compareTo("EnclosingMethod") == 0) {
                ea = new EnclosingMethod_attribute();
                ((EnclosingMethod_attribute)ea).class_index = d.readUnsignedShort();
                ((EnclosingMethod_attribute)ea).method_index = d.readUnsignedShort();
                a = ea;
            } else if (s.compareTo("InnerClasses") == 0) {
                ia = new InnerClasses_attribute();
                ((InnerClasses_attribute)ia).inner_classes_length = d.readUnsignedShort();
                ((InnerClasses_attribute)ia).inner_classes = new inner_class_entry[((InnerClasses_attribute)ia).inner_classes_length];
                int k7 = 0;
                while (k7 < ((InnerClasses_attribute)ia).inner_classes_length) {
                    inner_class_entry e = new inner_class_entry();
                    e.inner_class_index = d.readUnsignedShort();
                    e.outer_class_index = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.access_flags = d.readUnsignedShort();
                    ((InnerClasses_attribute)ia).inner_classes[k7] = e;
                    ++k7;
                }
                a = ia;
            } else if (s.compareTo("RuntimeVisibleAnnotations") == 0) {
                ra = new RuntimeVisibleAnnotations_attribute();
                ra.number_of_annotations = d.readUnsignedShort();
                ra.annotations = new annotation[ra.number_of_annotations];
                int k8 = 0;
                while (k8 < ra.number_of_annotations) {
                    annotation annot = new annotation();
                    annot.type_index = d.readUnsignedShort();
                    annot.num_element_value_pairs = d.readUnsignedShort();
                    annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                    ra.annotations[k8] = annot;
                    ++k8;
                }
                a = ra;
            } else if (s.compareTo("RuntimeInvisibleAnnotations") == 0) {
                ra = new RuntimeInvisibleAnnotations_attribute();
                ((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations = d.readUnsignedShort();
                ((RuntimeInvisibleAnnotations_attribute)ra).annotations = new annotation[((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations];
                int k9 = 0;
                while (k9 < ((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations) {
                    annotation annot = new annotation();
                    annot.type_index = d.readUnsignedShort();
                    annot.num_element_value_pairs = d.readUnsignedShort();
                    annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                    ((RuntimeInvisibleAnnotations_attribute)ra).annotations[k9] = annot;
                    ++k9;
                }
                a = ra;
            } else if (s.compareTo("RuntimeVisibleParameterAnnotations") == 0) {
                ra = new RuntimeVisibleParameterAnnotations_attribute();
                ((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters = d.readUnsignedByte();
                ((RuntimeVisibleParameterAnnotations_attribute)ra).parameter_annotations = new parameter_annotation[((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters];
                int x = 0;
                while (x < ((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters) {
                    parameter_annotation pAnnot = new parameter_annotation();
                    pAnnot.num_annotations = d.readUnsignedShort();
                    pAnnot.annotations = new annotation[pAnnot.num_annotations];
                    k = 0;
                    while (k < pAnnot.num_annotations) {
                        annotation annot = new annotation();
                        annot.type_index = d.readUnsignedShort();
                        annot.num_element_value_pairs = d.readUnsignedShort();
                        annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                        pAnnot.annotations[k] = annot;
                        ++k;
                    }
                    ((RuntimeVisibleParameterAnnotations_attribute)ra).parameter_annotations[x] = pAnnot;
                    ++x;
                }
                a = ra;
            } else if (s.compareTo("RuntimeInvisibleParameterAnnotations") == 0) {
                ra = new RuntimeInvisibleParameterAnnotations_attribute();
                ((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters = d.readUnsignedByte();
                ((RuntimeInvisibleParameterAnnotations_attribute)ra).parameter_annotations = new parameter_annotation[((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters];
                int x = 0;
                while (x < ((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters) {
                    parameter_annotation pAnnot = new parameter_annotation();
                    pAnnot.num_annotations = d.readUnsignedShort();
                    pAnnot.annotations = new annotation[pAnnot.num_annotations];
                    k = 0;
                    while (k < pAnnot.num_annotations) {
                        annotation annot = new annotation();
                        annot.type_index = d.readUnsignedShort();
                        annot.num_element_value_pairs = d.readUnsignedShort();
                        annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                        pAnnot.annotations[k] = annot;
                        ++k;
                    }
                    ((RuntimeInvisibleParameterAnnotations_attribute)ra).parameter_annotations[x] = pAnnot;
                    ++x;
                }
                a = ra;
            } else if (s.compareTo("AnnotationDefault") == 0) {
                da = new AnnotationDefault_attribute();
                element_value[] result = this.readElementValues(1, d, false, 0);
                ((AnnotationDefault_attribute)da).default_value = result[0];
                a = da;
            } else if (s.equals("BootstrapMethods")) {
                BootstrapMethods_attribute bsma = new BootstrapMethods_attribute();
                int count = d.readUnsignedShort();
                bsma.method_handles = new short[count];
                bsma.arg_indices = new short[count][];
                int num = 0;
                while (num < count) {
                    short index;
                    bsma.method_handles[num] = index = (short)d.readUnsignedShort();
                    int argCount = d.readUnsignedShort();
                    bsma.arg_indices[num] = new short[argCount];
                    int numArg = 0;
                    while (numArg < argCount) {
                        short indexArg;
                        bsma.arg_indices[num][numArg] = indexArg = (short)d.readUnsignedShort();
                        ++numArg;
                    }
                    ++num;
                }
                assert (this.bootstrap_methods_attribute == null) : "More than one bootstrap methods attribute!";
                this.bootstrap_methods_attribute = bsma;
                a = this.bootstrap_methods_attribute;
            } else {
                Generic_attribute ga = new Generic_attribute();
                if (len > 0L) {
                    ga.info = new byte[(int)len];
                    this.readAllBytes(ga.info, d);
                }
                a = ga;
            }
            a.attribute_name = j;
            a.attribute_length = len;
            ai[i] = a;
            ++i;
        }
        return true;
    }

    private element_value[] readElementValues(int count, DataInputStream d, boolean needName, int name_index) throws IOException {
        element_value[] list = new element_value[count];
        int x = 0;
        while (x < count) {
            element_value elem;
            int tag;
            char kind;
            if (needName) {
                name_index = d.readUnsignedShort();
            }
            if ((kind = (char)(tag = d.readUnsignedByte())) == 'B' || kind == 'C' || kind == 'D' || kind == 'F' || kind == 'I' || kind == 'J' || kind == 'S' || kind == 'Z' || kind == 's') {
                elem = new constant_element_value();
                elem.name_index = name_index;
                elem.tag = kind;
                elem.constant_value_index = d.readUnsignedShort();
                list[x] = elem;
            } else if (kind == 'e') {
                elem = new enum_constant_element_value();
                ((enum_constant_element_value)elem).name_index = name_index;
                ((enum_constant_element_value)elem).tag = kind;
                ((enum_constant_element_value)elem).type_name_index = d.readUnsignedShort();
                ((enum_constant_element_value)elem).constant_name_index = d.readUnsignedShort();
                list[x] = elem;
            } else if (kind == 'c') {
                elem = new class_element_value();
                ((class_element_value)elem).name_index = name_index;
                ((class_element_value)elem).tag = kind;
                ((class_element_value)elem).class_info_index = d.readUnsignedShort();
                list[x] = elem;
            } else if (kind == '[') {
                elem = new array_element_value();
                ((array_element_value)elem).name_index = name_index;
                ((array_element_value)elem).tag = kind;
                ((array_element_value)elem).num_values = d.readUnsignedShort();
                ((array_element_value)elem).values = this.readElementValues(((array_element_value)elem).num_values, d, false, name_index);
                list[x] = elem;
            } else if (kind == '@') {
                elem = new annotation_element_value();
                ((annotation_element_value)elem).name_index = name_index;
                ((annotation_element_value)elem).tag = kind;
                annotation annot = new annotation();
                annot.type_index = d.readUnsignedShort();
                annot.num_element_value_pairs = d.readUnsignedShort();
                annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                ((annotation_element_value)elem).annotation_value = annot;
                list[x] = elem;
            } else {
                throw new RuntimeException("Unknown element value pair kind: " + kind);
            }
            ++x;
        }
        return list;
    }

    protected boolean readFields(DataInputStream d) throws IOException {
        this.fields = new field_info[this.fields_count];
        int i = 0;
        while (i < this.fields_count) {
            field_info fi = new field_info();
            fi.access_flags = d.readUnsignedShort();
            fi.name_index = d.readUnsignedShort();
            fi.descriptor_index = d.readUnsignedShort();
            fi.attributes_count = d.readUnsignedShort();
            if (fi.attributes_count > 0) {
                fi.attributes = new attribute_info[fi.attributes_count];
                this.readAttributes(d, fi.attributes_count, fi.attributes);
            }
            this.fields[i] = fi;
            ++i;
        }
        return true;
    }

    protected boolean readMethods(DataInputStream d) throws IOException {
        this.methods = new method_info[this.methods_count];
        int i = 0;
        while (i < this.methods_count) {
            method_info mi = new method_info();
            mi.access_flags = d.readUnsignedShort();
            mi.name_index = d.readUnsignedShort();
            mi.descriptor_index = d.readUnsignedShort();
            mi.attributes_count = d.readUnsignedShort();
            if (mi.attributes_count > 0) {
                mi.attributes = new attribute_info[mi.attributes_count];
                this.readAttributes(d, mi.attributes_count, mi.attributes);
                int j = 0;
                while (j < mi.attributes_count) {
                    if (mi.attributes[j] instanceof Code_attribute) {
                        mi.code_attr = (Code_attribute)mi.attributes[j];
                        break;
                    }
                    ++j;
                }
            }
            this.methods[i] = mi;
            ++i;
        }
        return true;
    }

    protected boolean writeConstantPool(DataOutputStream dd) throws IOException {
        boolean skipone = false;
        int i = 1;
        while (i < this.constant_pool_count) {
            if (skipone) {
                skipone = false;
            } else {
                cp_info cp = this.constant_pool[i];
                dd.writeByte(cp.tag);
                switch (cp.tag) {
                    case 7: {
                        dd.writeShort(((CONSTANT_Class_info)cp).name_index);
                        break;
                    }
                    case 9: {
                        dd.writeShort(((CONSTANT_Fieldref_info)cp).class_index);
                        dd.writeShort(((CONSTANT_Fieldref_info)cp).name_and_type_index);
                        break;
                    }
                    case 10: {
                        dd.writeShort(((CONSTANT_Methodref_info)cp).class_index);
                        dd.writeShort(((CONSTANT_Methodref_info)cp).name_and_type_index);
                        break;
                    }
                    case 11: {
                        dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).class_index);
                        dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index);
                        break;
                    }
                    case 8: {
                        dd.writeShort(((CONSTANT_String_info)cp).string_index);
                        break;
                    }
                    case 3: {
                        dd.writeInt((int)((CONSTANT_Integer_info)cp).bytes);
                        break;
                    }
                    case 4: {
                        dd.writeInt((int)((CONSTANT_Float_info)cp).bytes);
                        break;
                    }
                    case 5: {
                        dd.writeInt((int)((CONSTANT_Long_info)cp).high);
                        dd.writeInt((int)((CONSTANT_Long_info)cp).low);
                        skipone = true;
                        break;
                    }
                    case 6: {
                        dd.writeInt((int)((CONSTANT_Double_info)cp).high);
                        dd.writeInt((int)((CONSTANT_Double_info)cp).low);
                        skipone = true;
                        break;
                    }
                    case 12: {
                        dd.writeShort(((CONSTANT_NameAndType_info)cp).name_index);
                        dd.writeShort(((CONSTANT_NameAndType_info)cp).descriptor_index);
                        break;
                    }
                    case 1: {
                        ((CONSTANT_Utf8_info)cp).writeBytes(dd);
                        break;
                    }
                    default: {
                        G.v().out.println("Unknown tag in constant pool: " + cp.tag);
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean writeAttributes(DataOutputStream dd, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        int i = 0;
        while (i < attributes_count) {
            attribute_info la;
            Object e;
            int k;
            attribute_info ca;
            a = ai[i];
            dd.writeShort(a.attribute_name);
            dd.writeInt((int)a.attribute_length);
            if (a instanceof SourceFile_attribute) {
                SourceFile_attribute sa = (SourceFile_attribute)a;
                dd.writeShort(sa.sourcefile_index);
            } else if (a instanceof ConstantValue_attribute) {
                ca = (ConstantValue_attribute)a;
                dd.writeShort(ca.constantvalue_index);
            } else if (a instanceof Code_attribute) {
                ca = (Code_attribute)a;
                dd.writeShort(((Code_attribute)ca).max_stack);
                dd.writeShort(((Code_attribute)ca).max_locals);
                dd.writeInt((int)((Code_attribute)ca).code_length);
                dd.write(((Code_attribute)ca).code, 0, (int)((Code_attribute)ca).code_length);
                dd.writeShort(((Code_attribute)ca).exception_table_length);
                k = 0;
                while (k < ((Code_attribute)ca).exception_table_length) {
                    e = ((Code_attribute)ca).exception_table[k];
                    dd.writeShort(((exception_table_entry)e).start_pc);
                    dd.writeShort(((exception_table_entry)e).end_pc);
                    dd.writeShort(((exception_table_entry)e).handler_pc);
                    dd.writeShort(((exception_table_entry)e).catch_type);
                    ++k;
                }
                dd.writeShort(((Code_attribute)ca).attributes_count);
                if (((Code_attribute)ca).attributes_count > 0) {
                    this.writeAttributes(dd, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                }
            } else if (a instanceof Exception_attribute) {
                Exception_attribute ea = (Exception_attribute)a;
                dd.writeShort(ea.number_of_exceptions);
                if (ea.number_of_exceptions > 0) {
                    k = 0;
                    while (k < ea.number_of_exceptions) {
                        dd.writeShort(ea.exception_index_table[k]);
                        ++k;
                    }
                }
            } else if (a instanceof LineNumberTable_attribute) {
                la = (LineNumberTable_attribute)a;
                dd.writeShort(la.line_number_table_length);
                k = 0;
                while (k < la.line_number_table_length) {
                    e = la.line_number_table[k];
                    dd.writeShort(((line_number_table_entry)e).start_pc);
                    dd.writeShort(((line_number_table_entry)e).line_number);
                    ++k;
                }
            } else if (a instanceof LocalVariableTable_attribute) {
                la = (LocalVariableTable_attribute)a;
                dd.writeShort(((LocalVariableTable_attribute)la).local_variable_table_length);
                k = 0;
                while (k < ((LocalVariableTable_attribute)la).local_variable_table_length) {
                    e = ((LocalVariableTable_attribute)la).local_variable_table[k];
                    dd.writeShort(((local_variable_table_entry)e).start_pc);
                    dd.writeShort(((local_variable_table_entry)e).length);
                    dd.writeShort(((local_variable_table_entry)e).name_index);
                    dd.writeShort(((local_variable_table_entry)e).descriptor_index);
                    dd.writeShort(((local_variable_table_entry)e).index);
                    ++k;
                }
            } else {
                G.v().out.println("Generic/Unknown Attribute in output");
                Generic_attribute ga = (Generic_attribute)a;
                if (ga.attribute_length > 0L) {
                    dd.write(ga.info, 0, (int)ga.attribute_length);
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean writeFields(DataOutputStream dd) throws IOException {
        int i = 0;
        while (i < this.fields_count) {
            field_info fi = this.fields[i];
            dd.writeShort(fi.access_flags);
            dd.writeShort(fi.name_index);
            dd.writeShort(fi.descriptor_index);
            dd.writeShort(fi.attributes_count);
            if (fi.attributes_count > 0) {
                this.writeAttributes(dd, fi.attributes_count, fi.attributes);
            }
            ++i;
        }
        return true;
    }

    protected boolean writeMethods(DataOutputStream dd) throws IOException {
        int i = 0;
        while (i < this.methods_count) {
            method_info mi = this.methods[i];
            dd.writeShort(mi.access_flags);
            dd.writeShort(mi.name_index);
            dd.writeShort(mi.descriptor_index);
            dd.writeShort(mi.attributes_count);
            if (mi.attributes_count > 0) {
                this.writeAttributes(dd, mi.attributes_count, mi.attributes);
            }
            ++i;
        }
        return true;
    }

    boolean writeClass(DataOutputStream dd) {
        block6: {
            dd.writeInt((int)this.magic);
            dd.writeShort(this.minor_version);
            dd.writeShort(this.major_version);
            dd.writeShort(this.constant_pool_count);
            if (this.writeConstantPool(dd)) break block6;
            return false;
        }
        try {
            dd.writeShort(this.access_flags);
            dd.writeShort(this.this_class);
            dd.writeShort(this.super_class);
            dd.writeShort(this.interfaces_count);
            if (this.interfaces_count > 0) {
                int j = 0;
                while (j < this.interfaces_count) {
                    dd.writeShort(this.interfaces[j]);
                    ++j;
                }
            }
            dd.writeShort(this.fields_count);
            this.writeFields(dd);
            dd.writeShort(this.methods_count);
            this.writeMethods(dd);
            dd.writeShort(this.attributes_count);
            if (this.attributes_count > 0) {
                this.writeAttributes(dd, this.attributes_count, this.attributes);
            }
        }
        catch (IOException e) {
            G.v().out.println("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public Instruction parseMethod(method_info m) {
        Instruction head = null;
        Instruction tail = null;
        ByteCode bc = new ByteCode();
        Code_attribute ca = m.locate_code_attribute();
        if (ca == null) {
            return null;
        }
        int j = 0;
        while ((long)j < ca.code_length) {
            Instruction inst = bc.disassemble_bytecode(ca.code, j);
            inst.originalIndex = j;
            if (inst instanceof Instruction_Unknown) {
                G.v().out.println("Unknown instruction in \"" + m.toName(this.constant_pool) + "\" at offset " + j);
                G.v().out.println(" bytecode = " + (inst.code & 0xFF));
            }
            j = inst.nextOffset(j);
            if (head == null) {
                head = inst;
            } else {
                tail.next = inst;
                inst.prev = tail;
            }
            tail = inst;
        }
        bc.build(head);
        j = 0;
        while (j < ca.exception_table_length) {
            exception_table_entry e = ca.exception_table[j];
            e.start_inst = bc.locateInst(e.start_pc);
            e.end_inst = (long)e.end_pc == ca.code_length ? null : bc.locateInst(e.end_pc);
            e.handler_inst = bc.locateInst(e.handler_pc);
            if (e.handler_inst != null) {
                e.handler_inst.labelled = true;
            }
            ++j;
        }
        m.instructions = head;
        attribute_info[] attribute_infoArray = ca.attributes;
        int n = ca.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            attribute_info element = attribute_infoArray[n2];
            if (element instanceof LineNumberTable_attribute) {
                LineNumberTable_attribute lntattr = (LineNumberTable_attribute)element;
                line_number_table_entry[] line_number_table_entryArray = lntattr.line_number_table;
                int n3 = lntattr.line_number_table.length;
                int n4 = 0;
                while (n4 < n3) {
                    line_number_table_entry element0 = line_number_table_entryArray[n4];
                    element0.start_inst = bc.locateInst(element0.start_pc);
                    ++n4;
                }
            }
            ++n2;
        }
        return head;
    }

    public void parse() {
        int i = 0;
        while (i < this.methods_count) {
            method_info mi = this.methods[i];
            mi.instructions = this.parseMethod(mi);
            ++i;
        }
    }

    int relabel(Instruction i) {
        int index = 0;
        while (i != null) {
            i.label = index;
            index = i.nextOffset(index);
            i = i.next;
        }
        return index;
    }

    byte[] unparseMethod(method_info m) {
        m.cfg.reconstructInstructions();
        int codesize = this.relabel(m.instructions);
        byte[] bc = new byte[codesize];
        Instruction i = m.instructions;
        codesize = 0;
        while (i != null) {
            codesize = i.compile(bc, codesize);
            i = i.next;
        }
        if (codesize != bc.length) {
            G.v().out.println("Warning: code size doesn't match array length!");
        }
        return bc;
    }

    void unparse() {
        int i = 0;
        while (i < this.methods_count) {
            method_info mi = this.methods[i];
            Code_attribute ca = mi.locate_code_attribute();
            if (ca != null) {
                byte[] bc = this.unparseMethod(mi);
                if (bc == null) {
                    G.v().out.println("Recompile of " + mi.toName(this.constant_pool) + " failed!");
                } else {
                    ca.code_length = bc.length;
                    ca.code = bc;
                    int j = 0;
                    while (j < ca.exception_table_length) {
                        exception_table_entry e = ca.exception_table[j];
                        e.start_pc = e.start_inst.label;
                        e.end_pc = e.end_inst != null ? e.end_inst.label : (int)ca.code_length;
                        e.handler_pc = e.handler_inst.label;
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    static String parseMethodDesc_return(String s) {
        int j = s.lastIndexOf(41);
        if (j >= 0) {
            return ClassFile.parseDesc(s.substring(j + 1), ",");
        }
        return ClassFile.parseDesc(s, ",");
    }

    static String parseMethodDesc_params(String s) {
        int j;
        int i = s.indexOf(40);
        if (i >= 0 && (j = s.indexOf(41, i + 1)) >= 0) {
            return ClassFile.parseDesc(s.substring(i + 1, j), ",");
        }
        return "<parse error>";
    }

    /*
     * Unable to fully structure code
     */
    static String parseDesc(String desc, String sep) {
        params = "";
        arraylevel = 0;
        didone = false;
        len = desc.length();
        i = 0;
        while (i < len) {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                c = desc.charAt(i);
                                                if (c != "B".charAt(0)) break block10;
                                                param = "byte";
                                                ** GOTO lbl60
                                            }
                                            if (c != "C".charAt(0)) break block11;
                                            param = "char";
                                            ** GOTO lbl60
                                        }
                                        if (c != "D".charAt(0)) break block12;
                                        param = "double";
                                        ** GOTO lbl60
                                    }
                                    if (c != "F".charAt(0)) break block13;
                                    param = "float";
                                    ** GOTO lbl60
                                }
                                if (c != "I".charAt(0)) break block14;
                                param = "int";
                                ** GOTO lbl60
                            }
                            if (c != "J".charAt(0)) break block15;
                            param = "long";
                            ** GOTO lbl60
                        }
                        if (c != "S".charAt(0)) break block16;
                        param = "short";
                        ** GOTO lbl60
                    }
                    if (c != "Z".charAt(0)) break block17;
                    param = "boolean";
                    ** GOTO lbl60
                }
                if (c != "V".charAt(0)) break block18;
                param = "void";
                ** GOTO lbl60
            }
            if (c == "[".charAt(0)) {
                ++arraylevel;
            } else {
                if (c == "L".charAt(0)) {
                    j = desc.indexOf(59, i + 1);
                    if (j < 0) {
                        G.v().out.println("Warning: Parse error -- can't find a ; in " + desc.substring(i + 1));
                        param = "<error>";
                    } else {
                        if (j - i > 10 && desc.substring(i + 1, i + 11).compareTo("java/lang/") == 0) {
                            i += 10;
                        }
                        param = desc.substring(i + 1, j);
                        param = param.replace('/', '.');
                        i = j;
                    }
                } else {
                    param = "???";
                }
lbl60:
                // 12 sources

                if (didone) {
                    params = String.valueOf(params) + sep;
                }
                params = String.valueOf(params) + param;
                while (arraylevel > 0) {
                    params = String.valueOf(params) + "[]";
                    --arraylevel;
                }
                didone = true;
            }
            ++i;
        }
        return params;
    }

    method_info findMethod(String s) {
        int i = 0;
        while (i < this.methods_count) {
            method_info m = this.methods[i];
            if (s.equals(m.toName(this.constant_pool))) {
                return m;
            }
            ++i;
        }
        return null;
    }

    void listMethods() {
        int i = 0;
        while (i < this.methods_count) {
            G.v().out.println(this.methods[i].prototype(this.constant_pool));
            ++i;
        }
    }

    void listConstantPool() {
        int i = 1;
        while (i < this.constant_pool_count) {
            cp_info c = this.constant_pool[i];
            G.v().out.println(DESC_ARRAY + i + "] " + c.typeName() + "=" + c.toString(this.constant_pool));
            if (this.constant_pool[i].tag == 5 || this.constant_pool[i].tag == 6) {
                ++i;
            }
            ++i;
        }
    }

    void listFields() {
        int i = 0;
        while (i < this.fields_count) {
            field_info fi = this.fields[i];
            G.v().out.print(fi.prototype(this.constant_pool));
            int j = 0;
            while (j < fi.attributes_count) {
                CONSTANT_Utf8_info cm = (CONSTANT_Utf8_info)this.constant_pool[fi.attributes[j].attribute_name];
                if (cm.convert().compareTo("ConstantValue") == 0) {
                    ConstantValue_attribute cva = (ConstantValue_attribute)fi.attributes[j];
                    G.v().out.print(" = " + this.constant_pool[cva.constantvalue_index].toString(this.constant_pool));
                    break;
                }
                ++j;
            }
            G.v().out.println(";");
            ++i;
        }
    }

    void moveMethod(String m, int pos) {
        G.v().out.println("Moving " + m + " to position " + pos + " of " + this.methods_count);
        int i = 0;
        while (i < this.methods_count) {
            if (m.compareTo(this.methods[i].toName(this.constant_pool)) == 0) {
                method_info mthd = this.methods[i];
                if (i > pos) {
                    int j = i;
                    while (j > pos && j > 0) {
                        this.methods[j] = this.methods[j - 1];
                        --j;
                    }
                    this.methods[pos] = mthd;
                } else if (i < pos) {
                    int j = i;
                    while (j < pos && j < this.methods_count - 1) {
                        this.methods[j] = this.methods[j + 1];
                        ++j;
                    }
                    this.methods[pos] = mthd;
                }
                return;
            }
            ++i;
        }
    }

    boolean descendsFrom(ClassFile cf) {
        return this.descendsFrom(cf.toString());
    }

    boolean descendsFrom(String cname) {
        cp_info cf = this.constant_pool[this.super_class];
        if (cf.toString(this.constant_pool).compareTo(cname) == 0) {
            return true;
        }
        int i = 0;
        while (i < this.interfaces_count) {
            cf = this.constant_pool[this.interfaces[i]];
            if (cf.toString(this.constant_pool).compareTo(cname) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isSterile() {
        return (this.access_flags & 1) == 0 || (this.access_flags & 0x10) != 0;
    }

    boolean sameClass(String cfn) {
        String s = cfn;
        int i = s.lastIndexOf(".class");
        if (i > 0) {
            s = s.substring(0, i);
        }
        return s.compareTo(this.toString()) == 0;
    }

    String fieldName(int i) {
        return this.fields[i].toName(this.constant_pool);
    }
}

