/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import soot.coffi.ByteCode;
import soot.coffi.cp_info;

abstract class Instruction
implements Cloneable {
    public static final String argsep = " ";
    public static final String LOCALPREFIX = "local_";
    public byte code;
    public int label;
    public String name;
    public Instruction next;
    public Instruction prev;
    public boolean labelled;
    public boolean branches;
    public boolean calls;
    public boolean returns;
    public Instruction[] succs;
    int originalIndex;

    public Instruction(byte c) {
        this.code = c;
        this.next = null;
        this.branches = false;
        this.calls = false;
        this.returns = false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return String.valueOf(this.label) + ": " + this.name + "[" + this.originalIndex + "]";
    }

    public abstract int parse(byte[] var1, int var2);

    public abstract int compile(byte[] var1, int var2);

    public void offsetToPointer(ByteCode bc) {
    }

    public int nextOffset(int curr) {
        return curr + 1;
    }

    public Instruction[] branchpoints(Instruction next) {
        return null;
    }

    public void markCPRefs(boolean[] refs) {
    }

    public void redirectCPRefs(short[] redirect) {
    }

    public int hashCode() {
        return new Integer(this.label).hashCode();
    }

    public boolean equals(Instruction i) {
        return this == i;
    }

    public static short getShort(byte[] bc, int index) {
        byte bh = bc[index];
        byte bl = bc[index + 1];
        short s = (short)(bh << 8 & 0xFF00 | bl & 0xFF);
        return s;
    }

    public static int getUnsignedShort(byte[] bc, int index) {
        byte bh = bc[index];
        byte bl = bc[index + 1];
        int s = bh << 8 & 0xFF00 | bl & 0xFF;
        return s;
    }

    public static int getInt(byte[] bc, int index) {
        int bhh = bc[index] << 24 & 0xFF000000;
        int bhl = bc[index + 1] << 16 & 0xFF0000;
        int blh = bc[index + 2] << 8 & 0xFF00;
        int bll = bc[index + 3] & 0xFF;
        int i = bhh | bhl | blh | bll;
        return i;
    }

    public static int shortToBytes(short s, byte[] bc, int index) {
        bc[index++] = (byte)(s >> 8 & 0xFF);
        bc[index++] = (byte)(s & 0xFF);
        return index;
    }

    public static int intToBytes(int s, byte[] bc, int index) {
        bc[index++] = (byte)(s >> 24 & 0xFF);
        bc[index++] = (byte)(s >> 16 & 0xFF);
        bc[index++] = (byte)(s >> 8 & 0xFF);
        bc[index++] = (byte)(s & 0xFF);
        return index;
    }

    public String toString(cp_info[] constant_pool) {
        int i = this.code & 0xFF;
        if (this.name == null) {
            this.name = "null???=" + Integer.toString(i);
        }
        return this.name;
    }
}

