/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import soot.G;
import soot.coffi.ByteCode;
import soot.coffi.Instruction;
import soot.coffi.cp_info;

class Instruction_Lookupswitch
extends Instruction {
    public byte pad;
    public int default_offset;
    public int npairs;
    public int[] match_offsets;
    public Instruction default_inst;
    public Instruction[] match_insts;

    public Instruction_Lookupswitch() {
        super((byte)-85);
        this.name = "lookupswitch";
        this.branches = true;
    }

    @Override
    public String toString(cp_info[] constant_pool) {
        String args = String.valueOf(super.toString(constant_pool)) + " " + "(" + Integer.toString(this.pad) + ")";
        args = String.valueOf(args) + " " + Integer.toString(this.default_inst.label);
        args = String.valueOf(args) + " " + Integer.toString(this.npairs) + ": ";
        int i = 0;
        while (i < this.npairs) {
            args = String.valueOf(args) + "case " + Integer.toString(this.match_offsets[i * 2]) + ": label_" + Integer.toString(this.match_insts[i].label);
            ++i;
        }
        return args;
    }

    @Override
    public int parse(byte[] bc, int index) {
        int i = index % 4;
        this.pad = i != 0 ? (byte)(4 - i) : (byte)0;
        this.default_offset = Instruction_Lookupswitch.getInt(bc, index += this.pad);
        this.npairs = Instruction_Lookupswitch.getInt(bc, index += 4);
        index += 4;
        if (this.npairs > 0) {
            this.match_offsets = new int[this.npairs * 2];
            int j = 0;
            do {
                this.match_offsets[j] = Instruction_Lookupswitch.getInt(bc, index);
                this.match_offsets[++j] = Instruction_Lookupswitch.getInt(bc, index += 4);
                index += 4;
            } while (++j < this.npairs * 2);
        }
        return index;
    }

    @Override
    public int nextOffset(int curr) {
        int siz = 0;
        int i = (curr + 1) % 4;
        if (i != 0) {
            siz = 4 - i;
        }
        return curr + siz + 9 + this.npairs * 8;
    }

    @Override
    public int compile(byte[] bc, int index) {
        bc[index++] = this.code;
        int i = 0;
        while (i < this.pad) {
            bc[index++] = 0;
            ++i;
        }
        index = this.default_inst != null ? Instruction_Lookupswitch.intToBytes(this.default_inst.label - this.label, bc, index) : Instruction_Lookupswitch.intToBytes(this.default_offset, bc, index);
        index = Instruction_Lookupswitch.intToBytes(this.npairs, bc, index);
        i = 0;
        while (i < this.npairs) {
            index = Instruction_Lookupswitch.intToBytes(this.match_offsets[i * 2], bc, index);
            index = this.match_insts[i] != null ? Instruction_Lookupswitch.intToBytes(this.match_insts[i].label - this.label, bc, index) : Instruction_Lookupswitch.intToBytes(this.match_offsets[i * 2 + 1], bc, index);
            ++i;
        }
        return index;
    }

    @Override
    public void offsetToPointer(ByteCode bc) {
        this.default_inst = bc.locateInst(this.default_offset + this.label);
        if (this.default_inst == null) {
            G.v().out.println("Warning: can't locate target of instruction");
            G.v().out.println(" which should be at byte address " + (this.label + this.default_offset));
        } else {
            this.default_inst.labelled = true;
        }
        if (this.npairs > 0) {
            this.match_insts = new Instruction[this.npairs];
            int i = 0;
            while (i < this.npairs) {
                this.match_insts[i] = bc.locateInst(this.match_offsets[i * 2 + 1] + this.label);
                if (this.match_insts[i] == null) {
                    G.v().out.println("Warning: can't locate target of instruction");
                    G.v().out.println(" which should be at byte address " + (this.label + this.match_offsets[i * 2 + 1]));
                } else {
                    this.match_insts[i].labelled = true;
                }
                ++i;
            }
        }
    }

    @Override
    public Instruction[] branchpoints(Instruction next) {
        Instruction[] i = new Instruction[this.npairs + 1];
        i[0] = this.default_inst;
        int j = 1;
        while (j < this.npairs + 1) {
            i[j] = this.match_insts[j - 1];
            ++j;
        }
        return i;
    }
}

