/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import soot.G;
import soot.coffi.ByteCode;
import soot.coffi.Instruction;
import soot.coffi.cp_info;

class Instruction_Tableswitch
extends Instruction {
    public byte pad;
    public int default_offset;
    public int low;
    public int high;
    public int[] jump_offsets;
    public Instruction default_inst;
    public Instruction[] jump_insts;

    public Instruction_Tableswitch() {
        super((byte)-86);
        this.name = "tableswitch";
        this.branches = true;
    }

    @Override
    public String toString(cp_info[] constant_pool) {
        String args = String.valueOf(super.toString(constant_pool)) + " " + "(" + Integer.toString(this.pad) + ")";
        args = String.valueOf(args) + " " + "label_" + Integer.toString(this.default_inst.label);
        args = String.valueOf(args) + " " + Integer.toString(this.low);
        args = String.valueOf(args) + " " + Integer.toString(this.high) + ": ";
        int i = 0;
        while (i < this.high - this.low + 1) {
            args = String.valueOf(args) + " " + "label_" + Integer.toString(this.jump_insts[i].label);
            ++i;
        }
        return args;
    }

    @Override
    public int parse(byte[] bc, int index) {
        int i = index % 4;
        this.pad = i != 0 ? (byte)(4 - i) : (byte)0;
        this.default_offset = Instruction_Tableswitch.getInt(bc, index += this.pad);
        this.low = Instruction_Tableswitch.getInt(bc, index += 4);
        this.high = Instruction_Tableswitch.getInt(bc, index += 4);
        index += 4;
        i = this.high - this.low + 1;
        if (i > 0) {
            this.jump_offsets = new int[i];
            int j = 0;
            do {
                this.jump_offsets[j] = Instruction_Tableswitch.getInt(bc, index);
                index += 4;
            } while (++j < i);
        }
        return index;
    }

    @Override
    public int nextOffset(int curr) {
        int siz = 0;
        int i = (curr + 1) % 4;
        if (i != 0) {
            siz = 4 - i;
        }
        return curr + siz + 13 + (this.high - this.low + 1) * 4;
    }

    @Override
    public int compile(byte[] bc, int index) {
        bc[index++] = this.code;
        int i = 0;
        while (i < this.pad) {
            bc[index++] = 0;
            ++i;
        }
        index = this.default_inst != null ? Instruction_Tableswitch.intToBytes(this.default_inst.label - this.label, bc, index) : Instruction_Tableswitch.intToBytes(this.default_offset, bc, index);
        index = Instruction_Tableswitch.intToBytes(this.low, bc, index);
        index = Instruction_Tableswitch.intToBytes(this.high, bc, index);
        i = 0;
        while (i <= this.high - this.low) {
            index = this.jump_insts[i] != null ? Instruction_Tableswitch.intToBytes(this.jump_insts[i].label - this.label, bc, index) : Instruction_Tableswitch.intToBytes(this.jump_offsets[i], bc, index);
            ++i;
        }
        return index;
    }

    @Override
    public void offsetToPointer(ByteCode bc) {
        this.default_inst = bc.locateInst(this.default_offset + this.label);
        if (this.default_inst == null) {
            G.v().out.println("Warning: can't locate target of instruction");
            G.v().out.println(" which should be at byte address " + (this.label + this.default_offset));
        } else {
            this.default_inst.labelled = true;
        }
        if (this.high - this.low + 1 > 0) {
            this.jump_insts = new Instruction[this.high - this.low + 1];
            int i = 0;
            while (i < this.high - this.low + 1) {
                this.jump_insts[i] = bc.locateInst(this.jump_offsets[i] + this.label);
                if (this.jump_insts[i] == null) {
                    G.v().out.println("Warning: can't locate target of instruction");
                    G.v().out.println(" which should be at byte address " + (this.label + this.jump_offsets[i]));
                } else {
                    this.jump_insts[i].labelled = true;
                }
                ++i;
            }
        }
    }

    @Override
    public Instruction[] branchpoints(Instruction next) {
        Instruction[] i = new Instruction[this.high - this.low + 2];
        i[0] = this.default_inst;
        int j = 1;
        while (j < this.high - this.low + 2) {
            i[j] = this.jump_insts[j - 1];
            ++j;
        }
        return i;
    }
}

