/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.PrintStream;
import soot.ArrayType;
import soot.RefType;
import soot.Type;
import soot.coffi.UnusuableType;

class TypeArray {
    private Type[] types;

    private TypeArray() {
    }

    public static TypeArray v(int size) {
        TypeArray newArray = new TypeArray();
        newArray.types = new Type[size];
        int i = 0;
        while (i < size) {
            newArray.types[i] = UnusuableType.v();
            ++i;
        }
        return newArray;
    }

    public Type get(int index) {
        return this.types[index];
    }

    public TypeArray set(int index, Type type) {
        TypeArray newArray = new TypeArray();
        newArray.types = (Type[])this.types.clone();
        newArray.types[index] = type;
        return newArray;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeArray) {
            TypeArray other = (TypeArray)obj;
            if (this.types.length != other.types.length) {
                return false;
            }
            Type[] typeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                Type element = typeArray[n2];
                if (!element.equals(element)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public TypeArray merge(TypeArray otherArray) {
        TypeArray newArray = new TypeArray();
        if (this.types.length != otherArray.types.length) {
            throw new RuntimeException("Merging of type arrays failed; unequal array length");
        }
        newArray.types = new Type[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            newArray.types[i] = this.types[i].equals(otherArray.types[i]) ? this.types[i] : (!(!(this.types[i] instanceof ArrayType) && !(this.types[i] instanceof RefType) || !(otherArray.types[i] instanceof ArrayType) && !(otherArray.types[i] instanceof RefType)) ? RefType.v("java.lang.Object") : UnusuableType.v());
            ++i;
        }
        return newArray;
    }

    public void print(PrintStream out) {
        int i = 0;
        while (i < this.types.length) {
            out.println(String.valueOf(i) + ": " + this.types[i].toString());
            ++i;
        }
    }
}

