/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.dava.DavaStaticBlockCleaner;
import soot.dava.StaticDefinitionFinder;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledBlockNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.traversals.ASTParentNodeFinder;
import soot.grimp.internal.GNewInvokeExpr;
import soot.grimp.internal.GThrowStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class MethodCallFinder
extends DepthFirstAdapter {
    ASTMethodNode underAnalysis;
    DavaStaticBlockCleaner cleaner;

    public MethodCallFinder(DavaStaticBlockCleaner cleaner) {
        this.cleaner = cleaner;
        this.underAnalysis = null;
    }

    public MethodCallFinder(boolean verbose, DavaStaticBlockCleaner cleaner) {
        super(verbose);
        this.cleaner = cleaner;
        this.underAnalysis = null;
    }

    @Override
    public void inASTMethodNode(ASTMethodNode node) {
        this.underAnalysis = node;
    }

    @Override
    public void inInvokeStmt(InvokeStmt s) {
        InvokeExpr invokeExpr = s.getInvokeExpr();
        SootMethod maybeInline = invokeExpr.getMethod();
        ASTMethodNode toInlineASTMethod = this.cleaner.inline(maybeInline);
        if (toInlineASTMethod == null) {
            return;
        }
        List<Object> subBodies = toInlineASTMethod.get_SubBodies();
        if (subBodies.size() != 1) {
            throw new RuntimeException("Found ASTMEthod node with more than one subBodies");
        }
        List body = (List)subBodies.get(0);
        ASTParentNodeFinder finder = new ASTParentNodeFinder();
        this.underAnalysis.apply(finder);
        List<ASTStatementSequenceNode> newChangedBodyPart = this.createChangedBodyPart(s, body, finder);
        boolean replaced = this.replaceSubBody(s, newChangedBodyPart, finder);
        if (replaced) {
            SootClass runtime;
            StaticDefinitionFinder defFinder = new StaticDefinitionFinder(maybeInline);
            toInlineASTMethod.apply(defFinder);
            if (defFinder.anyFinalFieldDefined() && (runtime = Scene.v().loadClassAndSupport("java.lang.RuntimeException")).declaresMethod("void <init>(java.lang.String)")) {
                SootMethod sootMethod = runtime.getMethod("void <init>(java.lang.String)");
                SootMethodRef methodRef = sootMethod.makeRef();
                RefType myRefType = RefType.v(runtime);
                StringConstant tempString = StringConstant.v("This method used to have a definition of a final variable. Dava inlined the definition into the static initializer");
                ArrayList<StringConstant> list = new ArrayList<StringConstant>();
                list.add(tempString);
                GNewInvokeExpr newInvokeExpr = new GNewInvokeExpr(myRefType, methodRef, list);
                GThrowStmt throwStmt = new GThrowStmt(newInvokeExpr);
                AugmentedStmt augStmt = new AugmentedStmt(throwStmt);
                ArrayList<Object> sequence = new ArrayList<Object>();
                sequence.add(augStmt);
                ASTStatementSequenceNode seqNode = new ASTStatementSequenceNode(sequence);
                ArrayList<Object> subBody = new ArrayList<Object>();
                subBody.add(seqNode);
                toInlineASTMethod.replaceBody(subBody);
            }
        }
    }

    public List<Object> getSubBodyFromSingleSubBodyNode(ASTNode node) {
        List<Object> subBodies = node.get_SubBodies();
        if (subBodies.size() != 1) {
            throw new RuntimeException("Found a single subBody node with more than 1 subBodies");
        }
        return (List)subBodies.get(0);
    }

    public List<Object> createNewSubBody(List<Object> orignalBody, List<ASTStatementSequenceNode> partNewBody, Object stmtSeqNode) {
        ArrayList<Object> newBody = new ArrayList<Object>();
        Iterator<Object> it = orignalBody.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (temp == stmtSeqNode) break;
            newBody.add(temp);
        }
        newBody.addAll(partNewBody);
        while (it.hasNext()) {
            newBody.add(it.next());
        }
        return newBody;
    }

    public boolean replaceSubBody(InvokeStmt s, List<ASTStatementSequenceNode> newChangedBodyPart, ASTParentNodeFinder finder) {
        Object stmtSeqNode = finder.getParentOf(s);
        Object ParentOfStmtSeq = finder.getParentOf(stmtSeqNode);
        if (ParentOfStmtSeq == null) {
            throw new RuntimeException("MethodCall FInder: parent of stmt seq node not found");
        }
        ASTNode node = (ASTNode)ParentOfStmtSeq;
        if (node instanceof ASTMethodNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTMethodNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTSynchronizedBlockNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTSynchronizedBlockNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTLabeledBlockNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTLabeledBlockNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTUnconditionalLoopNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTUnconditionalLoopNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTIfNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTIfNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTWhileNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTWhileNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTDoWhileNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTDoWhileNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTForLoopNode) {
            List<Object> subBodyToReplace = this.getSubBodyFromSingleSubBodyNode(node);
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            ((ASTForLoopNode)node).replaceBody(newBody);
            return true;
        }
        if (node instanceof ASTIfElseNode) {
            List<Object> subBodies = node.get_SubBodies();
            if (subBodies.size() != 2) {
                throw new RuntimeException("Found an ifelse ASTNode which does not have two bodies");
            }
            List ifBody = (List)subBodies.get(0);
            List elseBody = (List)subBodies.get(1);
            int subBodyNumber = -1;
            for (Object temp : ifBody) {
                if (temp != stmtSeqNode) continue;
                subBodyNumber = 0;
                break;
            }
            if (subBodyNumber != 0) {
                for (Object temp : elseBody) {
                    if (temp != stmtSeqNode) continue;
                    subBodyNumber = 1;
                    break;
                }
            }
            List subBodyToReplace = null;
            if (subBodyNumber == 0) {
                subBodyToReplace = ifBody;
            } else if (subBodyNumber == 1) {
                subBodyToReplace = elseBody;
            } else {
                throw new RuntimeException("Could not find the related ASTNode in the method");
            }
            List<Object> newBody = this.createNewSubBody(subBodyToReplace, newChangedBodyPart, stmtSeqNode);
            if (subBodyNumber == 0) {
                ((ASTIfElseNode)node).replaceBody(newBody, elseBody);
                return true;
            }
            if (subBodyNumber == 1) {
                ((ASTIfElseNode)node).replaceBody(ifBody, newBody);
                return true;
            }
        } else {
            if (node instanceof ASTTryNode) {
                List<Object> tryBody = ((ASTTryNode)node).get_TryBody();
                Iterator<Object> it = tryBody.iterator();
                boolean inTryBody = false;
                while (it.hasNext()) {
                    ASTNode temp = (ASTNode)it.next();
                    if (temp != stmtSeqNode) continue;
                    inTryBody = true;
                    break;
                }
                if (!inTryBody) {
                    return false;
                }
                List<Object> newBody = this.createNewSubBody(tryBody, newChangedBodyPart, stmtSeqNode);
                ((ASTTryNode)node).replaceTryBody(newBody);
                return true;
            }
            if (node instanceof ASTSwitchNode) {
                List<Object> indexList = ((ASTSwitchNode)node).getIndexList();
                Map<Object, List<Object>> index2BodyList = ((ASTSwitchNode)node).getIndex2BodyList();
                for (Object currentIndex : indexList) {
                    List<Object> body = index2BodyList.get(currentIndex);
                    if (body == null) continue;
                    boolean found = false;
                    for (ASTNode aSTNode : body) {
                        if (aSTNode != stmtSeqNode) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    List<Object> list = this.createNewSubBody(body, newChangedBodyPart, stmtSeqNode);
                    index2BodyList.put(currentIndex, list);
                    ((ASTSwitchNode)node).replaceIndex2BodyList(index2BodyList);
                    return true;
                }
            }
        }
        return false;
    }

    public List<ASTStatementSequenceNode> createChangedBodyPart(InvokeStmt s, List body, ASTParentNodeFinder finder) {
        Object parent = finder.getParentOf(s);
        if (parent == null) {
            throw new RuntimeException("MethodCall FInder: parent of invoke stmt not found");
        }
        ASTNode parentNode = (ASTNode)parent;
        if (!(parentNode instanceof ASTStatementSequenceNode)) {
            throw new RuntimeException("MethodCall FInder: parent node not a stmt seq node");
        }
        ASTStatementSequenceNode orignal = (ASTStatementSequenceNode)parentNode;
        ArrayList<Object> newInitialNode = new ArrayList<Object>();
        Iterator<Object> it = orignal.getStatements().iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            Stmt tempStmt = as.get_Stmt();
            if (tempStmt == s) break;
            newInitialNode.add(as);
        }
        ArrayList<Object> newSecondNode = new ArrayList<Object>();
        while (it.hasNext()) {
            newSecondNode.add(it.next());
        }
        ArrayList<ASTStatementSequenceNode> toReturn = new ArrayList<ASTStatementSequenceNode>();
        if (newInitialNode.size() != 0) {
            toReturn.add(new ASTStatementSequenceNode(newInitialNode));
        }
        toReturn.addAll(body);
        if (newSecondNode.size() != 0) {
            toReturn.add(new ASTStatementSequenceNode(newSecondNode));
        }
        return toReturn;
    }
}

