/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.asg;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.dava.Dava;
import soot.dava.internal.asg.AugmentedStmt;
import soot.jimple.IfStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.TrapUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.IterableSet;

public class AugmentedStmtGraph
implements DirectedGraph<AugmentedStmt> {
    private HashMap<Stmt, AugmentedStmt> binding = new HashMap();
    private HashMap<AugmentedStmt, AugmentedStmt> original2clone = new HashMap();
    private IterableSet<AugmentedStmt> aug_list = new IterableSet();
    private IterableSet<Stmt> stmt_list = new IterableSet();
    private List<AugmentedStmt> bheads = new LinkedList<AugmentedStmt>();
    private List<AugmentedStmt> btails = new LinkedList<AugmentedStmt>();
    private List<AugmentedStmt> cheads = new LinkedList<AugmentedStmt>();
    private List<AugmentedStmt> ctails = new LinkedList<AugmentedStmt>();

    public AugmentedStmtGraph(AugmentedStmtGraph other) {
        this();
        HashMap<AugmentedStmt, AugmentedStmt> old2new = new HashMap<AugmentedStmt, AugmentedStmt>();
        for (AugmentedStmt oas : other.aug_list) {
            Stmt s = oas.get_Stmt();
            AugmentedStmt nas = new AugmentedStmt(s);
            this.aug_list.add(nas);
            this.stmt_list.add(s);
            this.binding.put(s, nas);
            old2new.put(oas, nas);
        }
        for (AugmentedStmt oas : other.aug_list) {
            AugmentedStmt nas = (AugmentedStmt)old2new.get(oas);
            for (AugmentedStmt aug : oas.bpreds) {
                nas.bpreds.add((AugmentedStmt)old2new.get(aug));
            }
            if (nas.bpreds.isEmpty()) {
                this.bheads.add(nas);
            }
            for (AugmentedStmt aug : oas.cpreds) {
                nas.cpreds.add((AugmentedStmt)old2new.get(aug));
            }
            if (nas.cpreds.isEmpty()) {
                this.cheads.add(nas);
            }
            for (AugmentedStmt aug : oas.bsuccs) {
                nas.bsuccs.add((AugmentedStmt)old2new.get(aug));
            }
            if (nas.bsuccs.isEmpty()) {
                this.btails.add(nas);
            }
            for (AugmentedStmt aug : oas.csuccs) {
                nas.csuccs.add((AugmentedStmt)old2new.get(aug));
            }
            if (!nas.csuccs.isEmpty()) continue;
            this.ctails.add(nas);
        }
        this.find_Dominators();
    }

    public AugmentedStmtGraph(BriefUnitGraph bug, TrapUnitGraph cug) {
        this();
        Dava.v().log("AugmentedStmtGraph::AugmentedStmtGraph() - cug.size() = " + cug.size());
        for (Unit u : cug) {
            Stmt s = (Stmt)u;
            this.add_StmtBinding(s, new AugmentedStmt(s));
        }
        List<Unit> cugList = new PseudoTopologicalOrderer<Unit>().newList(cug, false);
        for (Stmt stmt : cugList) {
            this.aug_list.add(this.get_AugStmt(stmt));
            this.stmt_list.add(stmt);
        }
        for (AugmentedStmt augmentedStmt : this.aug_list) {
            this.mirror_PredsSuccs(augmentedStmt, bug);
            this.mirror_PredsSuccs(augmentedStmt, cug);
        }
        this.find_Dominators();
    }

    public AugmentedStmtGraph() {
    }

    public void add_AugmentedStmt(AugmentedStmt as) {
        Stmt s = as.get_Stmt();
        this.aug_list.add(as);
        this.stmt_list.add(s);
        this.add_StmtBinding(s, as);
        if (as.bpreds.isEmpty()) {
            this.bheads.add(as);
        }
        if (as.cpreds.isEmpty()) {
            this.cheads.add(as);
        }
        if (as.bsuccs.isEmpty()) {
            this.btails.add(as);
        }
        if (as.csuccs.isEmpty()) {
            this.ctails.add(as);
        }
        this.check_List(as.bpreds, this.btails);
        this.check_List(as.bsuccs, this.bheads);
        this.check_List(as.cpreds, this.ctails);
        this.check_List(as.csuccs, this.cheads);
    }

    public boolean contains(Object o) {
        return this.aug_list.contains(o);
    }

    public AugmentedStmt get_CloneOf(AugmentedStmt as) {
        return this.original2clone.get(as);
    }

    @Override
    public int size() {
        return this.aug_list.size();
    }

    private <T> void check_List(List<T> psList, List<T> htList) {
        for (T t : psList) {
            if (!htList.contains(t)) continue;
            htList.remove(t);
        }
    }

    public void calculate_Reachability(AugmentedStmt source, HashSet<AugmentedStmt> blockers, AugmentedStmt dominator) {
        if (blockers == null) {
            throw new RuntimeException("Tried to call AugmentedStmtGraph:calculate_Reachability() with null blockers.");
        }
        if (source == null) {
            return;
        }
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
        worklist.addLast(source);
        touchSet.add(source);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            for (AugmentedStmt sas : as.csuccs) {
                if (touchSet.contains(sas) || !sas.get_Dominators().contains(dominator)) continue;
                touchSet.add(sas);
                IterableSet reachers = sas.get_Reachers();
                if (!reachers.contains(source)) {
                    reachers.add(source);
                }
                if (blockers.contains(sas)) continue;
                worklist.addLast(sas);
            }
        }
    }

    public void calculate_Reachability(Collection sources, HashSet blockers, AugmentedStmt dominator) {
        Iterator srcIt = sources.iterator();
        while (srcIt.hasNext()) {
            this.calculate_Reachability((AugmentedStmt)srcIt.next(), (HashSet<AugmentedStmt>)blockers, dominator);
        }
    }

    public void calculate_Reachability(AugmentedStmt source, AugmentedStmt blocker, AugmentedStmt dominator) {
        HashSet<AugmentedStmt> h = new HashSet<AugmentedStmt>();
        h.add(blocker);
        this.calculate_Reachability(source, h, dominator);
    }

    public void calculate_Reachability(Collection sources, AugmentedStmt blocker, AugmentedStmt dominator) {
        HashSet<AugmentedStmt> h = new HashSet<AugmentedStmt>();
        h.add(blocker);
        this.calculate_Reachability(sources, h, dominator);
    }

    public void calculate_Reachability(AugmentedStmt source, AugmentedStmt dominator) {
        this.calculate_Reachability(source, new HashSet<AugmentedStmt>(), dominator);
    }

    public void calculate_Reachability(Collection sources, AugmentedStmt dominator) {
        this.calculate_Reachability(sources, new HashSet(), dominator);
    }

    public void calculate_Reachability(AugmentedStmt source) {
        this.calculate_Reachability(source, null);
    }

    public void calculate_Reachability(Collection sources) {
        this.calculate_Reachability(sources, null);
    }

    public void add_StmtBinding(Stmt s, AugmentedStmt as) {
        this.binding.put(s, as);
    }

    public AugmentedStmt get_AugStmt(Stmt s) {
        AugmentedStmt as = this.binding.get(s);
        if (as == null) {
            throw new RuntimeException("Could not find augmented statement for: " + s.toString());
        }
        return as;
    }

    @Override
    public List<AugmentedStmt> getHeads() {
        return this.cheads;
    }

    @Override
    public List<AugmentedStmt> getTails() {
        return this.ctails;
    }

    @Override
    public Iterator<AugmentedStmt> iterator() {
        return this.aug_list.iterator();
    }

    @Override
    public List<AugmentedStmt> getPredsOf(AugmentedStmt s) {
        return s.cpreds;
    }

    @Override
    public List<AugmentedStmt> getPredsOf(Stmt s) {
        return this.get_AugStmt((Stmt)s).cpreds;
    }

    @Override
    public List<AugmentedStmt> getSuccsOf(AugmentedStmt s) {
        return s.csuccs;
    }

    @Override
    public List<AugmentedStmt> getSuccsOf(Stmt s) {
        return this.get_AugStmt((Stmt)s).csuccs;
    }

    public List<AugmentedStmt> get_BriefHeads() {
        return this.bheads;
    }

    public List<AugmentedStmt> get_BriefTails() {
        return this.btails;
    }

    public IterableSet<AugmentedStmt> get_ChainView() {
        return new IterableSet<AugmentedStmt>((Collection<AugmentedStmt>)this.aug_list);
    }

    public Object clone() {
        return new AugmentedStmtGraph(this);
    }

    public boolean remove_AugmentedStmt(AugmentedStmt toRemove) {
        if (!this.aug_list.contains(toRemove)) {
            return false;
        }
        for (AugmentedStmt pas : toRemove.bpreds) {
            if (!pas.bsuccs.contains(toRemove)) continue;
            pas.bsuccs.remove(toRemove);
        }
        for (AugmentedStmt pas : toRemove.cpreds) {
            if (!pas.csuccs.contains(toRemove)) continue;
            pas.csuccs.remove(toRemove);
        }
        for (AugmentedStmt sas : toRemove.bsuccs) {
            if (!sas.bpreds.contains(toRemove)) continue;
            sas.bpreds.remove(toRemove);
        }
        for (AugmentedStmt sas : toRemove.csuccs) {
            if (!sas.cpreds.contains(toRemove)) continue;
            sas.cpreds.remove(toRemove);
        }
        this.aug_list.remove(toRemove);
        this.stmt_list.remove(toRemove.get_Stmt());
        this.bheads.remove(toRemove);
        this.btails.remove(toRemove);
        this.cheads.remove(toRemove);
        this.ctails.remove(toRemove);
        this.binding.remove(toRemove.get_Stmt());
        return true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String cr = "\n";
        b.append("AugmentedStmtGraph (size: " + this.size() + " stmts)" + cr);
        for (AugmentedStmt as : this.aug_list) {
            b.append("| .---" + cr + "| | AugmentedStmt " + as.toString() + cr + "| |" + cr + "| |  preds:");
            for (AugmentedStmt pas : as.cpreds) {
                b.append(" " + pas.toString());
            }
            b.append(String.valueOf(cr) + "| |" + cr + "| |  succs:");
            for (AugmentedStmt sas : as.csuccs) {
                b.append(" " + sas.toString());
            }
            b.append(String.valueOf(cr) + "| |" + cr + "| |  doms:");
            for (AugmentedStmt das : as.get_Dominators()) {
                b.append(" " + das.toString());
            }
            b.append(String.valueOf(cr) + "| `---" + cr);
        }
        b.append("-" + cr);
        return b.toString();
    }

    private void mirror_PredsSuccs(AugmentedStmt as, UnitGraph ug) {
        Stmt s = as.get_Stmt();
        LinkedList<AugmentedStmt> preds = new LinkedList<AugmentedStmt>();
        LinkedList<AugmentedStmt> succs = new LinkedList<AugmentedStmt>();
        for (Unit u : ug.getPredsOf(s)) {
            AugmentedStmt po = this.get_AugStmt((Stmt)u);
            if (preds.contains(po)) continue;
            preds.add(po);
        }
        for (Unit u : ug.getSuccsOf(s)) {
            AugmentedStmt so = this.get_AugStmt((Stmt)u);
            if (succs.contains(so)) continue;
            succs.add(so);
        }
        if (ug instanceof BriefUnitGraph) {
            as.bpreds = preds;
            as.bsuccs = succs;
            if (preds.size() == 0) {
                this.bheads.add(as);
            }
            if (succs.size() == 0) {
                this.btails.add(as);
            }
        } else if (ug instanceof TrapUnitGraph) {
            as.cpreds = preds;
            as.csuccs = succs;
            if (preds.size() == 0) {
                this.cheads.add(as);
            }
            if (succs.size() == 0) {
                this.ctails.add(as);
            }
        } else {
            throw new RuntimeException("Unknown UnitGraph type: " + ug.getClass());
        }
    }

    public IterableSet clone_Body(IterableSet oldBody) {
        Stmt ns;
        HashMap<AugmentedStmt, AugmentedStmt> old2new = new HashMap<AugmentedStmt, AugmentedStmt>();
        HashMap<AugmentedStmt, AugmentedStmt> new2old = new HashMap<AugmentedStmt, AugmentedStmt>();
        IterableSet<AugmentedStmt> newBody = new IterableSet<AugmentedStmt>();
        for (AugmentedStmt as : oldBody) {
            AugmentedStmt clone = (AugmentedStmt)as.clone();
            this.original2clone.put(as, clone);
            old2new.put(as, clone);
            new2old.put(clone, as);
            newBody.add(clone);
        }
        for (AugmentedStmt newAs : newBody) {
            AugmentedStmt oldAs = (AugmentedStmt)new2old.get(newAs);
            this.mirror_PredsSuccs(oldAs, oldAs.bpreds, newAs.bpreds, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.cpreds, newAs.cpreds, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.bsuccs, newAs.bsuccs, old2new);
            this.mirror_PredsSuccs(oldAs, oldAs.csuccs, newAs.csuccs, old2new);
        }
        Iterator it = newBody.iterator();
        while (it.hasNext()) {
            this.add_AugmentedStmt((AugmentedStmt)it.next());
        }
        HashMap<Stmt, Stmt> so2n = new HashMap<Stmt, Stmt>();
        for (AugmentedStmt as : oldBody) {
            Stmt os = as.get_Stmt();
            ns = ((AugmentedStmt)old2new.get(as)).get_Stmt();
            so2n.put(os, ns);
        }
        for (AugmentedStmt nas : newBody) {
            Unit[] new_target_list;
            Unit newTgt;
            Unit target;
            AugmentedStmt oas = (AugmentedStmt)new2old.get(nas);
            ns = nas.get_Stmt();
            Stmt os = oas.get_Stmt();
            if (os instanceof IfStmt) {
                Stmt target2 = ((IfStmt)os).getTarget();
                Unit newTgt2 = null;
                newTgt2 = (Unit)so2n.get(target2);
                if (newTgt2 != null) {
                    ((IfStmt)ns).setTarget(newTgt2);
                    continue;
                }
                ((IfStmt)ns).setTarget(target2);
                continue;
            }
            if (os instanceof TableSwitchStmt) {
                TableSwitchStmt otss = (TableSwitchStmt)os;
                TableSwitchStmt ntss = (TableSwitchStmt)ns;
                target = otss.getDefaultTarget();
                newTgt = null;
                newTgt = (Unit)so2n.get(target);
                if (newTgt != null) {
                    ntss.setDefaultTarget(newTgt);
                } else {
                    ntss.setDefaultTarget(target);
                }
                new_target_list = new LinkedList();
                int target_count = otss.getHighIndex() - otss.getLowIndex() + 1;
                int i = 0;
                while (i < target_count) {
                    target = otss.getTarget(i);
                    newTgt = null;
                    newTgt = (Unit)so2n.get(target);
                    if (newTgt != null) {
                        new_target_list.add(newTgt);
                    } else {
                        new_target_list.add(target);
                    }
                    ++i;
                }
                ntss.setTargets((List<? extends Unit>)new_target_list);
                continue;
            }
            if (!(os instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt olss = (LookupSwitchStmt)os;
            LookupSwitchStmt nlss = (LookupSwitchStmt)ns;
            target = olss.getDefaultTarget();
            newTgt = null;
            newTgt = (Unit)so2n.get(target);
            if (newTgt != null) {
                nlss.setDefaultTarget(newTgt);
            } else {
                nlss.setDefaultTarget(target);
            }
            new_target_list = new Unit[olss.getTargetCount()];
            int i = 0;
            while (i < new_target_list.length) {
                target = olss.getTarget(i);
                newTgt = null;
                newTgt = (Unit)so2n.get(target);
                new_target_list[i] = newTgt != null ? newTgt : target;
                ++i;
            }
            nlss.setTargets(new_target_list);
            nlss.setLookupValues(olss.getLookupValues());
        }
        return newBody;
    }

    private void mirror_PredsSuccs(AugmentedStmt originalAs, List oldList, List newList, Map old2new) {
        for (AugmentedStmt oldAs : oldList) {
            AugmentedStmt newAs = (AugmentedStmt)old2new.get(oldAs);
            if (newAs != null) {
                newList.add(newAs);
                continue;
            }
            newList.add(oldAs);
            AugmentedStmt clonedAs = (AugmentedStmt)old2new.get(originalAs);
            if (oldList == originalAs.bpreds) {
                oldAs.bsuccs.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.cpreds) {
                oldAs.csuccs.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.bsuccs) {
                oldAs.bpreds.add(clonedAs);
                continue;
            }
            if (oldList == originalAs.csuccs) {
                oldAs.cpreds.add(clonedAs);
                continue;
            }
            throw new RuntimeException("Error mirroring preds and succs in Try block splitting.");
        }
    }

    public void find_Dominators() {
        for (AugmentedStmt as : this.aug_list) {
            if (as.cpreds.size() != 0) {
                if (!as.get_Dominators().isEmpty()) {
                    as.get_Dominators().clear();
                }
                as.get_Dominators().addAll(this.aug_list);
                continue;
            }
            as.get_Dominators().clear();
        }
        IterableSet<AugmentedStmt> worklist = new IterableSet<AugmentedStmt>();
        worklist.addAll(this.aug_list);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            IterableSet<AugmentedStmt> pred_intersection = new IterableSet<AugmentedStmt>();
            boolean first_pred = true;
            for (AugmentedStmt pas : as.cpreds) {
                if (first_pred) {
                    pred_intersection.addAll(pas.get_Dominators());
                    if (!pred_intersection.contains(pas)) {
                        pred_intersection.add(pas);
                    }
                    first_pred = false;
                    continue;
                }
                Iterator piit = pred_intersection.snapshotIterator();
                while (piit.hasNext()) {
                    AugmentedStmt pid = (AugmentedStmt)piit.next();
                    if (pas.get_Dominators().contains(pid) || pas == pid) continue;
                    pred_intersection.remove(pid);
                }
            }
            if (as.get_Dominators().equals(pred_intersection)) continue;
            for (AugmentedStmt o : as.csuccs) {
                if (worklist.contains(o)) continue;
                worklist.add(o);
            }
            as.get_Dominators().clear();
            as.get_Dominators().addAll(pred_intersection);
        }
    }
}

