/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.javaRep;

import java.util.ArrayList;
import java.util.List;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.util.Switch;

public class DArrayInitExpr
implements Value {
    ValueBox[] elements;
    Type type;

    public DArrayInitExpr(ValueBox[] elements, Type type) {
        this.elements = elements;
        this.type = type;
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        ValueBox[] valueBoxArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            list.addAll(element.getValue().getUseBoxes());
            list.add(element);
            ++n2;
        }
        return list;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("{");
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].toString(up);
            if (i + 1 < this.elements.length) {
                up.literal(" , ");
            }
            ++i;
        }
        up.literal("}");
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        int i = 0;
        while (i < this.elements.length) {
            b.append(this.elements[i].toString());
            if (i + 1 < this.elements.length) {
                b.append(" , ");
            }
            ++i;
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public boolean equivTo(Object o) {
        return false;
    }

    @Override
    public int equivHashCode() {
        int toReturn = 0;
        ValueBox[] valueBoxArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            toReturn += element.getValue().equivHashCode();
            ++n2;
        }
        return toReturn;
    }

    public ValueBox[] getElements() {
        return this.elements;
    }
}

