/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.javaRep;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.internal.AbstractNewMultiArrayExpr;

public class DNewMultiArrayExpr
extends AbstractNewMultiArrayExpr {
    public DNewMultiArrayExpr(ArrayType type, List sizes) {
        super(type, new ValueBox[sizes.size()]);
        int i = 0;
        while (i < sizes.size()) {
            this.sizeBoxes[i] = Grimp.v().newExprBox((Value)sizes.get(i));
            ++i;
        }
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedSizes = new ArrayList<Value>(this.getSizeCount());
        int i = 0;
        while (i < this.getSizeCount()) {
            clonedSizes.add(i, Grimp.cloneIfNecessary(this.getSize(i)));
            ++i;
        }
        return new DNewMultiArrayExpr(this.getBaseType(), clonedSizes);
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("new");
        up.literal(" ");
        up.type(this.getBaseType().baseType);
        ValueBox[] valueBoxArray = this.sizeBoxes;
        int n = this.sizeBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            up.literal("[");
            element.toString(up);
            up.literal("]");
            ++n2;
        }
        int i = this.getSizeCount();
        while (i < this.getBaseType().numDimensions) {
            up.literal("[]");
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new " + this.getBaseType().baseType);
        List<Value> sizes = this.getSizes();
        Iterator<Value> it = this.getSizes().iterator();
        while (it.hasNext()) {
            buffer.append("[" + it.next().toString() + "]");
        }
        int i = this.getSizeCount();
        while (i < this.getBaseType().numDimensions) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }
}

