/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.HashMap;
import soot.dava.DecompilationException;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPTuple;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPVariable;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.toolkits.scalar.FlowSet;

public class CPFlowSet
extends DavaFlowSet<CPTuple> {
    public CPFlowSet() {
    }

    public CPFlowSet(CPFlowSet other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = new CPTuple[((CPTuple[])other.elements).length];
        int i = 0;
        while (i < ((CPTuple[])other.elements).length) {
            ((CPTuple[])this.elements)[i] = ((CPTuple[])other.elements)[i] != null ? ((CPTuple[])other.elements)[i].clone() : null;
            ++i;
        }
        this.breakList = (HashMap)other.breakList.clone();
        this.continueList = (HashMap)other.continueList.clone();
        this.implicitBreaks = (HashMap)other.implicitBreaks.clone();
        this.implicitContinues = (HashMap)other.implicitContinues.clone();
    }

    public Object contains(String className, String localOrField) {
        int i = 0;
        while (i < this.numElements) {
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (current.getSootClassName().equals(className)) {
                if (current.containsField()) {
                    if (current.getVariable().getSootField().getName().equals(localOrField)) {
                        return current.getValue();
                    }
                } else if (current.containsLocal() && current.getVariable().getLocal().getName().equals(localOrField)) {
                    return current.getValue();
                }
            }
            ++i;
        }
        return null;
    }

    public void addIfNotPresent(CPTuple newTuple) {
        int i = 0;
        while (i < this.numElements) {
            CPVariable newTupleVar;
            CPVariable curVar;
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (current.getSootClassName().equals(newTuple.getSootClassName()) && (curVar = current.getVariable()).equals(newTupleVar = newTuple.getVariable())) {
                current.setValue(newTuple.getValue());
                return;
            }
            ++i;
        }
        this.add(newTuple);
    }

    public void addIfNotPresentButDontUpdate(CPTuple newTuple) {
        int i = 0;
        while (i < this.numElements) {
            CPVariable newTupleVar;
            CPVariable curVar;
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (current.getSootClassName().equals(newTuple.getSootClassName()) && (curVar = current.getVariable()).equals(newTupleVar = newTuple.getVariable())) {
                if (current.isTop()) {
                    current.setValue(newTuple.getValue());
                }
                return;
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        CPFlowSet workingSet;
        if (!(otherFlow instanceof CPFlowSet) || !(destFlow instanceof CPFlowSet)) {
            super.intersection(otherFlow, destFlow);
            return;
        }
        CPFlowSet dest = (CPFlowSet)destFlow;
        CPFlowSet other = (CPFlowSet)otherFlow;
        if (dest == other || dest == this) {
            workingSet = new CPFlowSet();
        } else {
            workingSet = dest;
            workingSet.clear();
        }
        int i = 0;
        while (i < this.numElements) {
            CPTuple thisTuple = ((CPTuple[])this.elements)[i];
            String className = thisTuple.getSootClassName();
            CPVariable thisVar = thisTuple.getVariable();
            CPTuple matchFound = null;
            CPTuple otherTuple = null;
            int j = 0;
            while (j < other.numElements) {
                otherTuple = ((CPTuple[])other.elements)[j];
                String tempClass = otherTuple.getSootClassName();
                if (tempClass.equals(className) && otherTuple.getVariable().equals(thisVar)) {
                    matchFound = otherTuple;
                    break;
                }
                ++j;
            }
            if (matchFound != null) {
                if (thisTuple.isTop()) {
                    workingSet.add(thisTuple.clone());
                } else if (matchFound.isTop()) {
                    workingSet.add(matchFound.clone());
                } else {
                    Object thisValue;
                    if (matchFound.isTop() || thisTuple.isTop()) throw new DecompilationException("Ran out of cases in CPVariable values...report bug to developer");
                    Object matchedValue = matchFound.getValue();
                    if (matchedValue.equals(thisValue = thisTuple.getValue())) {
                        workingSet.add(thisTuple.clone());
                    } else {
                        workingSet.add(new CPTuple(className, thisVar, true));
                    }
                }
            } else {
                workingSet.add(thisTuple.clone());
            }
            ++i;
        }
        i = 0;
        while (i < other.numElements) {
            CPTuple otherTuple = ((CPTuple[])other.elements)[i];
            String otherClassName = otherTuple.getSootClassName();
            CPVariable otherVar = otherTuple.getVariable();
            boolean inBoth = false;
            int j = 0;
            while (j < this.numElements) {
                CPTuple thisTuple = ((CPTuple[])this.elements)[j];
                String thisClassName = thisTuple.getSootClassName();
                CPVariable thisVar = thisTuple.getVariable();
                if (otherClassName.equals(thisClassName) && thisVar.equals(otherVar)) {
                    inBoth = true;
                    break;
                }
                ++j;
            }
            if (!inBoth) {
                workingSet.add(otherTuple.clone());
            }
            ++i;
        }
    }

    @Override
    public CPFlowSet clone() {
        return new CPFlowSet(this);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Printing CPFlowSet: ");
        int i = 0;
        while (i < this.numElements) {
            b.append("\n" + ((CPTuple[])this.elements)[i].toString());
            ++i;
        }
        b.append("\n");
        return b.toString();
    }
}

