/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Value;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledBlockNode;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.toolkits.scalar.FlowSet;

public abstract class StructuredAnalysis {
    public static boolean DEBUG = false;
    public static boolean DEBUG_IF = false;
    public static boolean DEBUG_WHILE = false;
    public static boolean DEBUG_STATEMENTS = false;
    public static boolean DEBUG_TRY = false;
    DavaFlowSet NOPATH = this.emptyFlowSet();
    public int MERGETYPE = 0;
    final int UNDEFINED = 0;
    final int UNION = 1;
    final int INTERSECTION = 2;
    HashMap<Object, DavaFlowSet> beforeSets = new HashMap();
    HashMap<Object, DavaFlowSet> afterSets = new HashMap();

    public StructuredAnalysis() {
        this.setMergeType();
        if (this.MERGETYPE == 0) {
            throw new RuntimeException("MERGETYPE UNDEFINED");
        }
    }

    public abstract void setMergeType();

    public abstract DavaFlowSet newInitialFlow();

    public abstract DavaFlowSet emptyFlowSet();

    public abstract DavaFlowSet cloneFlowSet(DavaFlowSet var1);

    public abstract DavaFlowSet processStatement(Stmt var1, DavaFlowSet var2);

    public abstract DavaFlowSet processUnaryBinaryCondition(ASTUnaryBinaryCondition var1, DavaFlowSet var2);

    public abstract DavaFlowSet processSynchronizedLocal(Local var1, DavaFlowSet var2);

    public abstract DavaFlowSet processSwitchKey(Value var1, DavaFlowSet var2);

    public void print(Object toPrint) {
        System.out.println(toPrint.toString());
    }

    public DavaFlowSet processCondition(ASTCondition cond, DavaFlowSet input) {
        if (cond instanceof ASTUnaryBinaryCondition) {
            return this.processUnaryBinaryCondition((ASTUnaryBinaryCondition)cond, input);
        }
        if (cond instanceof ASTAggregatedCondition) {
            ASTCondition left = ((ASTAggregatedCondition)cond).getLeftOp();
            DavaFlowSet output1 = this.processCondition(left, input);
            ASTCondition right = ((ASTAggregatedCondition)cond).getRightOp();
            DavaFlowSet output2 = this.processCondition(right, output1);
            return this.merge(output1, output2);
        }
        throw new RuntimeException("Unknown ASTCondition found in structred flow analysis");
    }

    public DavaFlowSet process(Object body, DavaFlowSet input) {
        if (body instanceof ASTNode) {
            this.beforeSets.put(body, input);
            DavaFlowSet temp = this.processASTNode((ASTNode)body, input);
            this.afterSets.put(body, temp);
            return temp;
        }
        if (body instanceof Stmt) {
            this.beforeSets.put(body, input);
            DavaFlowSet result = this.processAbruptStatements((Stmt)body, input);
            this.afterSets.put(body, result);
            return result;
        }
        if (body instanceof AugmentedStmt) {
            AugmentedStmt as = (AugmentedStmt)body;
            Stmt s = as.get_Stmt();
            this.beforeSets.put(s, input);
            DavaFlowSet result = this.processAbruptStatements(s, input);
            this.afterSets.put(s, result);
            return result;
        }
        if (body instanceof List) {
            Iterator it = ((List)body).iterator();
            DavaFlowSet result = input;
            while (it.hasNext()) {
                Object temp = it.next();
                if (!(temp instanceof ASTNode)) {
                    throw new RuntimeException("Body sent to be processed by StructuredAnalysis contains a list which does not have ASTNodes");
                }
                this.beforeSets.put(temp, result);
                result = this.processASTNode((ASTNode)temp, result);
                this.afterSets.put(temp, result);
            }
            return result;
        }
        throw new RuntimeException("Body sent to be processed by StructuredAnalysis is not a valid body");
    }

    public DavaFlowSet processASTNode(ASTNode node, DavaFlowSet input) {
        if (node instanceof ASTDoWhileNode) {
            return this.processASTDoWhileNode((ASTDoWhileNode)node, input);
        }
        if (node instanceof ASTForLoopNode) {
            return this.processASTForLoopNode((ASTForLoopNode)node, input);
        }
        if (node instanceof ASTIfElseNode) {
            return this.processASTIfElseNode((ASTIfElseNode)node, input);
        }
        if (node instanceof ASTIfNode) {
            return this.processASTIfNode((ASTIfNode)node, input);
        }
        if (node instanceof ASTLabeledBlockNode) {
            return this.processASTLabeledBlockNode((ASTLabeledBlockNode)node, input);
        }
        if (node instanceof ASTMethodNode) {
            return this.processASTMethodNode((ASTMethodNode)node, input);
        }
        if (node instanceof ASTStatementSequenceNode) {
            return this.processASTStatementSequenceNode((ASTStatementSequenceNode)node, input);
        }
        if (node instanceof ASTSwitchNode) {
            return this.processASTSwitchNode((ASTSwitchNode)node, input);
        }
        if (node instanceof ASTSynchronizedBlockNode) {
            return this.processASTSynchronizedBlockNode((ASTSynchronizedBlockNode)node, input);
        }
        if (node instanceof ASTTryNode) {
            return this.processASTTryNode((ASTTryNode)node, input);
        }
        if (node instanceof ASTWhileNode) {
            return this.processASTWhileNode((ASTWhileNode)node, input);
        }
        if (node instanceof ASTUnconditionalLoopNode) {
            return this.processASTUnconditionalLoopNode((ASTUnconditionalLoopNode)node, input);
        }
        throw new RuntimeException("processASTNode called using unknown node type");
    }

    public final DavaFlowSet processSingleSubBodyNode(ASTNode node, DavaFlowSet input) {
        List<Object> subBodies = node.get_SubBodies();
        if (subBodies.size() != 1) {
            throw new RuntimeException("processSingleSubBodyNode called with a node without one subBody");
        }
        List subBody = (List)subBodies.get(0);
        return this.process(subBody, input);
    }

    public String getLabel(ASTNode node) {
        SETNodeLabel temp;
        if (node instanceof ASTLabeledNode && (temp = ((ASTLabeledNode)node).get_Label()) != null) {
            return ((Object)temp).toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DavaFlowSet processAbruptStatements(Stmt s, DavaFlowSet input) {
        if (s instanceof ReturnStmt || s instanceof RetStmt || s instanceof ReturnVoidStmt) {
            return this.NOPATH;
        }
        if (!(s instanceof DAbruptStmt)) return this.processStatement(s, input);
        DAbruptStmt abStmt = (DAbruptStmt)s;
        if (!abStmt.is_Continue() && !abStmt.is_Break()) {
            throw new RuntimeException("Found a DAbruptStmt which is neither break nor continue!!");
        }
        DavaFlowSet temp = this.NOPATH;
        SETNodeLabel nodeLabel = abStmt.getLabel();
        if (nodeLabel != null && nodeLabel.toString() != null) {
            if (abStmt.is_Continue()) {
                temp.addToContinueList(nodeLabel.toString(), input);
                return temp;
            } else {
                if (!abStmt.is_Break()) throw new RuntimeException("Found abruptstmt which is neither break nor continue");
                temp.addToBreakList(nodeLabel.toString(), input);
            }
            return temp;
        } else if (abStmt.is_Continue()) {
            temp.addToImplicitContinues(abStmt, input);
            return temp;
        } else {
            if (!abStmt.is_Break()) throw new RuntimeException("Found abruptstmt which is neither break nor continue");
            temp.addToImplicitBreaks(abStmt, input);
        }
        return temp;
    }

    public DavaFlowSet processASTMethodNode(ASTMethodNode node, DavaFlowSet input) {
        DavaFlowSet temp = this.processSingleSubBodyNode(node, input);
        return temp;
    }

    public DavaFlowSet processASTStatementSequenceNode(ASTStatementSequenceNode node, DavaFlowSet input) {
        List<Object> statements = node.getStatements();
        Iterator<Object> it = statements.iterator();
        DavaFlowSet output = this.cloneFlowSet(input);
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            Stmt s = as.get_Stmt();
            output = this.process(s, output);
            if (!DEBUG_STATEMENTS) continue;
            System.out.println("After Processing statement " + s + output.toString());
        }
        return output;
    }

    public DavaFlowSet processASTLabeledBlockNode(ASTLabeledBlockNode node, DavaFlowSet input) {
        DavaFlowSet output1 = this.processSingleSubBodyNode(node, input);
        String label = this.getLabel(node);
        return this.handleBreak(label, output1, node);
    }

    public DavaFlowSet processASTSynchronizedBlockNode(ASTSynchronizedBlockNode node, DavaFlowSet input) {
        input = this.processSynchronizedLocal(node.getLocal(), input);
        DavaFlowSet output = this.processSingleSubBodyNode(node, input);
        String label = this.getLabel(node);
        return this.handleBreak(label, output, node);
    }

    public DavaFlowSet processASTIfNode(ASTIfNode node, DavaFlowSet input) {
        input = this.processCondition(node.get_Condition(), input);
        DavaFlowSet output1 = this.processSingleSubBodyNode(node, input);
        DavaFlowSet output2 = this.merge(input, output1);
        String label = this.getLabel(node);
        DavaFlowSet temp = this.handleBreak(label, output2, node);
        if (DEBUG_IF) {
            System.out.println("Exiting if node" + temp.toString());
        }
        return temp;
    }

    public DavaFlowSet processASTIfElseNode(ASTIfElseNode node, DavaFlowSet input) {
        List<Object> subBodies = node.get_SubBodies();
        if (subBodies.size() != 2) {
            throw new RuntimeException("processASTIfElseNode called with a node without two subBodies");
        }
        List subBodyOne = (List)subBodies.get(0);
        List subBodyTwo = (List)subBodies.get(1);
        input = this.processCondition(node.get_Condition(), input);
        DavaFlowSet clonedInput = this.cloneFlowSet(input);
        DavaFlowSet output1 = this.process(subBodyOne, clonedInput);
        clonedInput = this.cloneFlowSet(input);
        DavaFlowSet output2 = this.process(subBodyTwo, clonedInput);
        DavaFlowSet temp = this.merge(output1, output2);
        String label = this.getLabel(node);
        output1 = this.handleBreak(label, temp, node);
        return output1;
    }

    public DavaFlowSet processASTWhileNode(ASTWhileNode node, DavaFlowSet input) {
        DavaFlowSet lastin = null;
        DavaFlowSet initialInput = this.cloneFlowSet(input);
        String label = this.getLabel(node);
        DavaFlowSet output = null;
        input = this.processCondition(node.get_Condition(), input);
        if (DEBUG_WHILE) {
            System.out.println("Going int while (condition processed): " + input.toString());
        }
        do {
            lastin = this.cloneFlowSet(input);
            output = this.processSingleSubBodyNode(node, input);
            output = this.handleContinue(label, output, node);
            input = this.merge(initialInput, output);
        } while (this.isDifferent(lastin, input = this.processCondition(node.get_Condition(), input)));
        DavaFlowSet temp = this.handleBreak(label, input, node);
        if (DEBUG_WHILE) {
            System.out.println("Going out of while: " + temp.toString());
        }
        return temp;
    }

    public DavaFlowSet processASTDoWhileNode(ASTDoWhileNode node, DavaFlowSet input) {
        DavaFlowSet lastin = null;
        DavaFlowSet output = null;
        DavaFlowSet initialInput = this.cloneFlowSet(input);
        String label = this.getLabel(node);
        if (DEBUG_WHILE) {
            System.out.println("Going into do-while: " + initialInput.toString());
        }
        do {
            lastin = this.cloneFlowSet(input);
            output = this.processSingleSubBodyNode(node, input);
            output = this.handleContinue(label, output, node);
        } while (this.isDifferent(lastin, input = this.merge(initialInput, output = this.processCondition(node.get_Condition(), output))));
        DavaFlowSet temp = this.handleBreak(label, output, node);
        if (DEBUG_WHILE) {
            System.out.println("Going out of do-while: " + temp.toString());
        }
        return temp;
    }

    public DavaFlowSet processASTUnconditionalLoopNode(ASTUnconditionalLoopNode node, DavaFlowSet input) {
        DavaFlowSet initialInput = this.cloneFlowSet(input);
        DavaFlowSet lastin = null;
        if (DEBUG_WHILE) {
            System.out.println("Going into while(true): " + initialInput.toString());
        }
        String label = this.getLabel(node);
        DavaFlowSet output = null;
        do {
            lastin = this.cloneFlowSet(input);
            output = this.processSingleSubBodyNode(node, input);
        } while (this.isDifferent(lastin, input = this.merge(initialInput, output = this.handleContinue(label, output, node))));
        DavaFlowSet temp = this.getMergedBreakList(label, output, node);
        if (DEBUG_WHILE) {
            System.out.println("Going out of while(true): " + temp.toString());
        }
        return temp;
    }

    public DavaFlowSet processASTForLoopNode(ASTForLoopNode node, DavaFlowSet input) {
        List<Object> init = node.getInit();
        for (Object o : init) {
            AugmentedStmt as = (AugmentedStmt)o;
            Stmt s = as.get_Stmt();
            input = this.process(s, input);
        }
        DavaFlowSet initialInput = this.cloneFlowSet(input);
        input = this.processCondition(node.get_Condition(), input);
        DavaFlowSet lastin = null;
        String label = this.getLabel(node);
        DavaFlowSet output2 = null;
        do {
            lastin = this.cloneFlowSet(input);
            DavaFlowSet output1 = this.processSingleSubBodyNode(node, input);
            output1 = this.handleContinue(label, output1, node);
            output2 = this.cloneFlowSet(output1);
            List<Object> update = node.getUpdate();
            for (Object o : update) {
                AugmentedStmt as = (AugmentedStmt)o;
                Stmt s = as.get_Stmt();
                output2 = this.process(s, output2);
            }
            input = this.merge(initialInput, output2);
        } while (this.isDifferent(lastin, input = this.processCondition(node.get_Condition(), input)));
        return this.handleBreak(label, input, node);
    }

    public DavaFlowSet processASTSwitchNode(ASTSwitchNode node, DavaFlowSet input) {
        if (DEBUG) {
            System.out.println("Going into switch: " + input.toString());
        }
        List<Object> indexList = node.getIndexList();
        Map<Object, List<Object>> index2BodyList = node.getIndex2BodyList();
        Iterator<Object> it = indexList.iterator();
        input = this.processSwitchKey(node.get_Key(), input);
        DavaFlowSet initialIn = this.cloneFlowSet(input);
        DavaFlowSet out = null;
        DavaFlowSet defaultOut = null;
        ArrayList<DavaFlowSet> toMergeBreaks = new ArrayList<DavaFlowSet>();
        while (it.hasNext()) {
            Object currentIndex = it.next();
            List<Object> body = index2BodyList.get(currentIndex);
            if (body == null) continue;
            out = this.process(body, input);
            toMergeBreaks.add(this.cloneFlowSet(out));
            if (currentIndex instanceof String) {
                defaultOut = out;
            }
            input = this.merge(out, initialIn);
        }
        DavaFlowSet output = null;
        output = out != null ? (defaultOut != null ? this.merge(defaultOut, out) : this.merge(initialIn, out)) : initialIn;
        String label = this.getLabel(node);
        ArrayList<DavaFlowSet> outList = new ArrayList<DavaFlowSet>();
        for (DavaFlowSet mset : toMergeBreaks) {
            outList.add(this.handleBreak(label, mset, node));
        }
        DavaFlowSet finalOut = output;
        for (DavaFlowSet outIt : outList) {
            finalOut = this.merge(finalOut, outIt);
        }
        if (DEBUG) {
            System.out.println("Going out of switch: " + finalOut.toString());
        }
        return finalOut;
    }

    public DavaFlowSet processASTTryNode(ASTTryNode node, DavaFlowSet input) {
        if (DEBUG_TRY) {
            System.out.println("TRY START is:" + input);
        }
        List<Object> tryBody = node.get_TryBody();
        DavaFlowSet tryBodyOutput = this.process(tryBody, input);
        DavaFlowSet inputCatch = this.newInitialFlow();
        if (DEBUG_TRY) {
            System.out.println("TRY initialFLOW is:" + inputCatch);
        }
        List<Object> catchList = node.get_CatchList();
        Iterator<Object> it = catchList.iterator();
        ArrayList<DavaFlowSet> catchOutput = new ArrayList<DavaFlowSet>();
        while (it.hasNext()) {
            ASTTryNode.container catchBody = (ASTTryNode.container)it.next();
            List body = (List)catchBody.o;
            DavaFlowSet tempResult = this.process(body, this.cloneFlowSet(inputCatch));
            catchOutput.add(tempResult);
        }
        String label = this.getLabel(node);
        ArrayList<DavaFlowSet> outList = new ArrayList<DavaFlowSet>();
        outList.add(this.handleBreak(label, tryBodyOutput, node));
        for (DavaFlowSet co : catchOutput) {
            DavaFlowSet temp = this.handleBreak(label, co, node);
            if (DEBUG_TRY) {
                System.out.println("TRY handling breaks is:" + temp);
            }
            outList.add(temp);
        }
        DavaFlowSet out = tryBodyOutput;
        for (DavaFlowSet co : outList) {
            out = this.merge(out, co);
        }
        if (DEBUG_TRY) {
            System.out.println("TRY after merge outList is:" + out);
        }
        for (DavaFlowSet co : catchOutput) {
            out = this.merge(out, co);
        }
        if (DEBUG_TRY) {
            System.out.println("TRY END RESULT is:" + out);
        }
        return out;
    }

    public DavaFlowSet merge(DavaFlowSet in1, DavaFlowSet in2) {
        if (this.MERGETYPE == 0) {
            throw new RuntimeException("Use the setMergeType method to set the type of merge used in the analysis");
        }
        if (in1 == this.NOPATH && in2 != this.NOPATH) {
            FlowSet out = in2.clone();
            ((DavaFlowSet)out).copyInternalDataFrom(in1);
            return out;
        }
        if (in1 != this.NOPATH && in2 == this.NOPATH) {
            FlowSet out = in1.clone();
            ((DavaFlowSet)out).copyInternalDataFrom(in2);
            return out;
        }
        if (in1 == this.NOPATH && in2 == this.NOPATH) {
            FlowSet out = in1.clone();
            ((DavaFlowSet)out).copyInternalDataFrom(in2);
            return out;
        }
        DavaFlowSet out = this.emptyFlowSet();
        if (this.MERGETYPE == 1) {
            in1.union(in2, out);
        } else if (this.MERGETYPE == 2) {
            in1.intersection(in2, out);
        } else {
            throw new RuntimeException("Merge type value" + this.MERGETYPE + " not recognized");
        }
        out.copyInternalDataFrom(in1);
        out.copyInternalDataFrom(in2);
        return out;
    }

    public DavaFlowSet mergeExplicitAndImplicit(String label, DavaFlowSet output, List<DavaFlowSet> explicitSet, List<DavaFlowSet> implicitSet) {
        Iterator<DavaFlowSet> it;
        FlowSet toReturn = output.clone();
        if (label != null && explicitSet != null && explicitSet.size() != 0) {
            it = explicitSet.iterator();
            toReturn = this.merge(output, it.next());
            while (it.hasNext()) {
                toReturn = this.merge((DavaFlowSet)toReturn, it.next());
            }
        }
        if (implicitSet != null) {
            it = implicitSet.iterator();
            while (it.hasNext()) {
                toReturn = this.merge((DavaFlowSet)toReturn, it.next());
            }
        }
        return toReturn;
    }

    public DavaFlowSet handleBreak(String label, DavaFlowSet out, ASTNode node) {
        List<DavaFlowSet> explicitSet = out.getBreakSet(label);
        if (node == null) {
            throw new RuntimeException("ASTNode sent to handleBreak was null");
        }
        List<DavaFlowSet> implicitSet = out.getImplicitlyBrokenSets(node);
        return this.mergeExplicitAndImplicit(label, out, explicitSet, implicitSet);
    }

    public DavaFlowSet handleContinue(String label, Object output, ASTNode node) {
        if (!(output instanceof DavaFlowSet)) {
            throw new RuntimeException("handleContinue is only implemented for DavaFlowSet type");
        }
        DavaFlowSet out = (DavaFlowSet)output;
        List<DavaFlowSet> explicitSet = out.getContinueSet(label);
        if (node == null) {
            throw new RuntimeException("ASTNode sent to handleContinue was null");
        }
        List<DavaFlowSet> implicitSet = out.getImplicitlyContinuedSets(node);
        return this.mergeExplicitAndImplicit(label, out, explicitSet, implicitSet);
    }

    private DavaFlowSet getMergedBreakList(String label, DavaFlowSet output, ASTNode node) {
        List breakSet = output.getBreakSet(label);
        DavaFlowSet toReturn = null;
        if (breakSet == null) {
            toReturn = this.NOPATH;
        } else if (breakSet.size() == 0) {
            toReturn = this.NOPATH;
        } else {
            Iterator it = breakSet.iterator();
            toReturn = it.next();
            while (it.hasNext()) {
                toReturn = this.merge(toReturn, it.next());
            }
        }
        List implicitSet = output.getImplicitlyBrokenSets(node);
        if (implicitSet != null) {
            Iterator it = implicitSet.iterator();
            if (implicitSet.size() > 0) {
                toReturn = it.next();
            }
            while (it.hasNext()) {
                toReturn = this.merge(toReturn, it.next());
            }
        }
        return toReturn;
    }

    public boolean isDifferent(DavaFlowSet oldObj, DavaFlowSet newObj) {
        return !oldObj.equals(newObj) || !oldObj.internalDataMatchesTo(newObj);
    }

    public DavaFlowSet getBeforeSet(Object beforeThis) {
        return this.beforeSets.get(beforeThis);
    }

    public DavaFlowSet getAfterSet(Object afterThis) {
        return this.afterSets.get(afterThis);
    }

    public void debug(String methodName, String debug) {
        if (DEBUG) {
            System.out.println("Class: StructuredAnalysis MethodName: " + methodName + "    DEBUG: " + debug);
        }
    }

    public void debug(String debug) {
        if (DEBUG) {
            System.out.println("Class: StructuredAnalysis DEBUG: " + debug);
        }
    }
}

