/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledBlockNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.transformations.StrengthenByIf;
import soot.dava.toolkits.base.AST.transformations.StrengthenByIfElse;
import soot.dava.toolkits.base.AST.transformations.UselessLabelFinder;

public class LoopStrengthener
extends DepthFirstAdapter {
    public LoopStrengthener() {
    }

    public LoopStrengthener(boolean verbose) {
        super(verbose);
    }

    @Override
    public void caseASTStatementSequenceNode(ASTStatementSequenceNode node) {
    }

    @Override
    public void normalRetrieving(ASTNode node) {
        if (node instanceof ASTSwitchNode) {
            this.dealWithSwitchNode((ASTSwitchNode)node);
            return;
        }
        Iterator<Object> sbit = node.get_SubBodies().iterator();
        int subBodyNumber = 0;
        while (sbit.hasNext()) {
            Object subBody = sbit.next();
            Iterator it = ((List)subBody).iterator();
            int nodeNumber = 0;
            while (it.hasNext()) {
                ASTNode oneNode;
                ASTNode temp = (ASTNode)it.next();
                if ((temp instanceof ASTWhileNode || temp instanceof ASTUnconditionalLoopNode || temp instanceof ASTDoWhileNode) && (oneNode = this.getOnlySubNode(temp)) != null) {
                    List<ASTNode> newNode = null;
                    if (oneNode instanceof ASTIfNode) {
                        newNode = StrengthenByIf.getNewNode(temp, (ASTIfNode)oneNode);
                    } else if (oneNode instanceof ASTIfElseNode) {
                        newNode = StrengthenByIfElse.getNewNode(temp, (ASTIfElseNode)oneNode);
                    }
                    if (newNode != null) {
                        this.replaceNode(node, subBodyNumber, nodeNumber, temp, newNode);
                        UselessLabelFinder.v().findAndKill(node);
                    }
                }
                temp.apply(this);
                ++nodeNumber;
            }
            ++subBodyNumber;
        }
    }

    @Override
    public void caseASTTryNode(ASTTryNode node) {
        this.inASTTryNode(node);
        List<Object> tryBody = node.get_TryBody();
        Iterator<Object> it = tryBody.iterator();
        int nodeNumber = 0;
        while (it.hasNext()) {
            ASTNode oneNode;
            ASTNode temp = (ASTNode)it.next();
            if ((temp instanceof ASTWhileNode || temp instanceof ASTUnconditionalLoopNode || temp instanceof ASTDoWhileNode) && (oneNode = this.getOnlySubNode(temp)) != null) {
                List<ASTNode> newNode = null;
                if (oneNode instanceof ASTIfNode) {
                    newNode = StrengthenByIf.getNewNode(temp, (ASTIfNode)oneNode);
                } else if (oneNode instanceof ASTIfElseNode) {
                    newNode = StrengthenByIfElse.getNewNode(temp, (ASTIfElseNode)oneNode);
                }
                if (newNode != null) {
                    List<Object> newBody = LoopStrengthener.createNewSubBody(tryBody, nodeNumber, temp, newNode);
                    if (newBody != null) {
                        node.replaceTryBody(newBody);
                        G.v().ASTTransformations_modified = true;
                    }
                    UselessLabelFinder.v().findAndKill(node);
                }
            }
            temp.apply(this);
            ++nodeNumber;
        }
        Map<Object, Object> exceptionMap = node.get_ExceptionMap();
        Map<Object, Object> paramMap = node.get_ParamMap();
        List<Object> catchList = node.get_CatchList();
        Iterator itBody = null;
        for (ASTTryNode.container container2 : catchList) {
            SootClass sootClass = (SootClass)exceptionMap.get(container2);
            RefType type = sootClass.getType();
            this.caseType(type);
            Local local = (Local)paramMap.get(container2);
            this.decideCaseExprOrRef(local);
            List body = (List)container2.o;
            itBody = body.iterator();
            nodeNumber = 0;
            while (itBody.hasNext()) {
                ASTNode oneNode;
                ASTNode temp = (ASTNode)itBody.next();
                if ((temp instanceof ASTWhileNode || temp instanceof ASTUnconditionalLoopNode || temp instanceof ASTDoWhileNode) && (oneNode = this.getOnlySubNode(temp)) != null) {
                    List<ASTNode> newNode = null;
                    if (oneNode instanceof ASTIfNode) {
                        newNode = StrengthenByIf.getNewNode(temp, (ASTIfNode)oneNode);
                    } else if (oneNode instanceof ASTIfElseNode) {
                        newNode = StrengthenByIfElse.getNewNode(temp, (ASTIfElseNode)oneNode);
                    }
                    if (newNode != null) {
                        List<Object> newBody = LoopStrengthener.createNewSubBody(body, nodeNumber, temp, newNode);
                        if (newBody != null) {
                            container2.replaceBody(newBody);
                            G.v().ASTTransformations_modified = true;
                        }
                        UselessLabelFinder.v().findAndKill(node);
                    }
                }
                temp.apply(this);
                ++nodeNumber;
            }
        }
        this.outASTTryNode(node);
    }

    private void dealWithSwitchNode(ASTSwitchNode node) {
        List<Object> indexList = node.getIndexList();
        Map<Object, List<Object>> index2BodyList = node.getIndex2BodyList();
        for (Object currentIndex : indexList) {
            List<Object> body = index2BodyList.get(currentIndex);
            if (body == null) continue;
            Iterator<Object> itBody = body.iterator();
            int nodeNumber = 0;
            while (itBody.hasNext()) {
                ASTNode oneNode;
                ASTNode temp = (ASTNode)itBody.next();
                if ((temp instanceof ASTWhileNode || temp instanceof ASTUnconditionalLoopNode || temp instanceof ASTDoWhileNode) && (oneNode = this.getOnlySubNode(temp)) != null) {
                    List<ASTNode> newNode = null;
                    if (oneNode instanceof ASTIfNode) {
                        newNode = StrengthenByIf.getNewNode(temp, (ASTIfNode)oneNode);
                    } else if (oneNode instanceof ASTIfElseNode) {
                        newNode = StrengthenByIfElse.getNewNode(temp, (ASTIfElseNode)oneNode);
                    }
                    if (newNode != null) {
                        List<Object> newBody = LoopStrengthener.createNewSubBody(body, nodeNumber, temp, newNode);
                        if (newBody != null) {
                            index2BodyList.put(currentIndex, newBody);
                            node.replaceIndex2BodyList(index2BodyList);
                            G.v().ASTTransformations_modified = true;
                        }
                        UselessLabelFinder.v().findAndKill(node);
                    }
                }
                temp.apply(this);
                ++nodeNumber;
            }
        }
    }

    private ASTNode getOnlySubNode(ASTNode node) {
        if (!(node instanceof ASTWhileNode || node instanceof ASTDoWhileNode || node instanceof ASTUnconditionalLoopNode)) {
            return null;
        }
        List<Object> subBodies = node.get_SubBodies();
        if (subBodies.size() != 1) {
            return null;
        }
        List subBody = (List)subBodies.get(0);
        if (subBody.size() != 1) {
            return null;
        }
        return (ASTNode)subBody.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceNode(ASTNode node, int subBodyNumber, int nodeNumber, ASTNode loopNode, List<ASTNode> newNode) {
        if (!(node instanceof ASTIfElseNode)) {
            List<Object> subBodies = node.get_SubBodies();
            if (subBodies.size() != 1) {
                throw new RuntimeException("Please report this benchmark to the programmer");
            }
            List onlySubBody = (List)subBodies.get(0);
            List<Object> newBody = LoopStrengthener.createNewSubBody(onlySubBody, nodeNumber, loopNode, newNode);
            if (newBody == null) {
                return;
            }
            if (node instanceof ASTMethodNode) {
                ((ASTMethodNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else if (node instanceof ASTSynchronizedBlockNode) {
                ((ASTSynchronizedBlockNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else if (node instanceof ASTLabeledBlockNode) {
                ((ASTLabeledBlockNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else if (node instanceof ASTUnconditionalLoopNode) {
                ((ASTUnconditionalLoopNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else if (node instanceof ASTIfNode) {
                ((ASTIfNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else if (node instanceof ASTWhileNode) {
                ((ASTWhileNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            } else {
                if (!(node instanceof ASTDoWhileNode)) return;
                ((ASTDoWhileNode)node).replaceBody(newBody);
                G.v().ASTTransformations_modified = true;
            }
            return;
        } else {
            if (subBodyNumber != 0 && subBodyNumber != 1) {
                return;
            }
            List<Object> subBodies = node.get_SubBodies();
            if (subBodies.size() != 2) {
                throw new RuntimeException("Please report this benchmark to the programmer");
            }
            List toModifySubBody = (List)subBodies.get(subBodyNumber);
            List<Object> newBody = LoopStrengthener.createNewSubBody(toModifySubBody, nodeNumber, loopNode, newNode);
            if (newBody == null) {
                return;
            }
            if (subBodyNumber == 0) {
                G.v().ASTTransformations_modified = true;
                ((ASTIfElseNode)node).replaceBody(newBody, (List)subBodies.get(1));
                return;
            } else {
                if (subBodyNumber != 1) return;
                G.v().ASTTransformations_modified = true;
                ((ASTIfElseNode)node).replaceBody((List)subBodies.get(0), newBody);
            }
        }
    }

    public static List<Object> createNewSubBody(List<Object> oldSubBody, int nodeNumber, ASTNode oldNode, List<ASTNode> newNode) {
        ArrayList<Object> newSubBody = new ArrayList<Object>();
        Iterator<Object> it = oldSubBody.iterator();
        int index = 0;
        while (index != nodeNumber) {
            if (!it.hasNext()) {
                return null;
            }
            newSubBody.add(it.next());
            ++index;
        }
        ASTNode toRemove = (ASTNode)it.next();
        if (toRemove.toString().compareTo(oldNode.toString()) != 0) {
            System.out.println("The replace nodes dont match please report benchmark to developer");
            return null;
        }
        newSubBody.addAll(newNode);
        while (it.hasNext()) {
            newSubBody.add(it.next());
        }
        return newSubBody;
    }
}

