/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.renamer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import soot.BooleanType;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.renamer.heuristicSet;
import soot.grimp.NewInvokeExpr;
import soot.grimp.internal.GAssignStmt;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.EqExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInstanceFieldRef;

public class infoGatheringAnalysis
extends DepthFirstAdapter {
    public boolean DEBUG = false;
    public static final int CLASSNAME = 0;
    public static final int METHODNAME = 1;
    public static final int GETSET = 2;
    public static final int IF = 3;
    public static final int WHILE = 4;
    public static final int SWITCH = 5;
    public static final int ARRAYINDEX = 6;
    public static final int MAINARG = 7;
    public static final int FIELDASSIGN = 8;
    public static final int FORLOOPUPDATE = 9;
    public static final int CAST = 10;
    public static final int NUMBITS = 11;
    heuristicSet info = new heuristicSet();
    boolean inDefinitionStmt = false;
    Local definedLocal = null;
    boolean inIf = false;
    boolean inWhile = false;
    boolean inFor = false;

    public infoGatheringAnalysis(DavaBody davaBody) {
        ArrayList<Local> localList = new ArrayList<Local>();
        HashSet params = new HashSet();
        HashSet<Object> thisLocals = davaBody.get_ThisLocals();
        for (Local local : davaBody.getLocals()) {
            if (params.contains(local) || thisLocals.contains(local)) continue;
            localList.add(local);
        }
        for (Local local : localList) {
            this.info.add(local, 11);
            this.debug("infoGatheringAnalysis", "added " + local.getName() + " to the heuristicset");
        }
        SootMethod method = davaBody.getMethod();
        if (method.getSubSignature().compareTo("void main(java.lang.String[])") == 0) {
            Iterator<Object> it = davaBody.get_ParamMap().values().iterator();
            int num = 0;
            Local param = null;
            while (it.hasNext()) {
                ++num;
                param = (Local)it.next();
            }
            if (num > 1) {
                throw new DecompilationException("main method has greater than 1 args!!");
            }
            this.info.setHeuristic(param, 7);
        }
    }

    @Override
    public void inDefinitionStmt(DefinitionStmt s) {
        this.inDefinitionStmt = true;
        Value v = s.getLeftOp();
        if (v instanceof Local) {
            this.definedLocal = this.info.contains((Local)v) ? (Local)v : null;
        }
    }

    @Override
    public void outDefinitionStmt(DefinitionStmt s) {
        if (this.definedLocal != null && s.getRightOp() instanceof CastExpr) {
            Type castType = ((CastExpr)s.getRightOp()).getCastType();
            this.info.addCastString(this.definedLocal, castType.toString());
        }
        this.inDefinitionStmt = false;
        this.definedLocal = null;
    }

    @Override
    public void inStaticFieldRef(StaticFieldRef sfr) {
        if (this.inDefinitionStmt && this.definedLocal != null) {
            SootField field = sfr.getField();
            this.info.setFieldName(this.definedLocal, field.getName());
        }
    }

    @Override
    public void inInstanceFieldRef(InstanceFieldRef ifr) {
        if (ifr instanceof AbstractInstanceFieldRef && this.inDefinitionStmt && this.definedLocal != null) {
            SootField field = ((AbstractInstanceFieldRef)ifr).getField();
            this.info.setFieldName(this.definedLocal, field.getName());
        }
    }

    @Override
    public void outInvokeExpr(InvokeExpr ie) {
        if (this.inDefinitionStmt && this.definedLocal != null) {
            if (ie instanceof NewInvokeExpr) {
                RefType ref = ((NewInvokeExpr)ie).getBaseType();
                String className = ref.getClassName();
                this.debug("outInvokeExpr", "defined local is" + this.definedLocal);
                this.info.setObjectClassName(this.definedLocal, className);
            } else {
                SootMethodRef methodRef = ie.getMethodRef();
                String name = methodRef.name();
                this.info.setMethodName(this.definedLocal, name);
            }
        }
    }

    @Override
    public void inASTUnaryCondition(ASTUnaryCondition uc) {
        Value val = uc.getValue();
        if (val instanceof Local) {
            if (this.inIf) {
                this.info.setHeuristic((Local)val, 3);
            }
            if (this.inWhile) {
                this.info.setHeuristic((Local)val, 4);
            }
        }
    }

    @Override
    public void inASTBinaryCondition(ASTBinaryCondition bc) {
        ConditionExpr condition = bc.getConditionExpr();
        Local local = this.checkBooleanUse(condition);
        if (local != null) {
            if (this.inIf) {
                this.info.setHeuristic(local, 3);
            }
            if (this.inWhile) {
                this.info.setHeuristic(local, 4);
            }
        }
    }

    @Override
    public void inASTIfNode(ASTIfNode node) {
        this.inIf = true;
    }

    @Override
    public void outASTIfNode(ASTIfNode node) {
        this.inIf = false;
    }

    @Override
    public void inASTIfElseNode(ASTIfElseNode node) {
        this.inIf = true;
    }

    @Override
    public void outASTIfElseNode(ASTIfElseNode node) {
        this.inIf = false;
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        this.inWhile = true;
    }

    @Override
    public void outASTWhileNode(ASTWhileNode node) {
        this.inWhile = false;
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        this.inWhile = true;
    }

    @Override
    public void outASTDoWhileNode(ASTDoWhileNode node) {
        this.inWhile = false;
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        Value key = node.get_Key();
        if (key instanceof Local) {
            this.info.setHeuristic((Local)key, 5);
        }
    }

    @Override
    public void inArrayRef(ArrayRef ar) {
        Value index = ar.getIndex();
        if (index instanceof Local) {
            this.info.setHeuristic((Local)index, 6);
        }
    }

    @Override
    public void inASTTryNode(ASTTryNode node) {
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        this.inFor = true;
        for (AugmentedStmt augmentedStmt : node.getUpdate()) {
            Value leftOp;
            Stmt s = augmentedStmt.get_Stmt();
            if (!(s instanceof GAssignStmt) || !((leftOp = ((GAssignStmt)s).getLeftOp()) instanceof Local)) continue;
            this.info.setHeuristic((Local)leftOp, 9);
        }
    }

    @Override
    public void outASTForLoopNode(ASTForLoopNode node) {
        this.inFor = false;
    }

    @Override
    public void outASTMethodNode(ASTMethodNode node) {
        if (this.DEBUG) {
            System.out.println("SET START");
            this.info.print();
            System.out.println("SET END");
        }
    }

    private Local checkBooleanUse(ConditionExpr condition) {
        boolean booleanUse = false;
        if (condition instanceof NeExpr || condition instanceof EqExpr) {
            Type op2Type;
            Value op1 = condition.getOp1();
            Value op2 = condition.getOp2();
            if (op1 instanceof DIntConstant) {
                Type op1Type = ((DIntConstant)op1).type;
                if (op1Type instanceof BooleanType) {
                    booleanUse = true;
                }
            } else if (op2 instanceof DIntConstant && (op2Type = ((DIntConstant)op2).type) instanceof BooleanType) {
                booleanUse = true;
            }
            if (booleanUse) {
                if (op1 instanceof Local) {
                    return (Local)op1;
                }
                if (op2 instanceof Local) {
                    return (Local)op2;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public heuristicSet getHeuristicSet() {
        return this.info;
    }

    public void debug(String methodName, String debug) {
        if (this.DEBUG) {
            System.out.println(String.valueOf(methodName) + "    DEBUG: " + debug);
        }
    }
}

