/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.AnnotationVisibility;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.DeprecatedTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toDex.SootToDexUtils;

public class DexAnnotation {
    private final Type ARRAY_TYPE = RefType.v("Array");
    private final SootClass clazz;
    private final IInitialResolver.Dependencies deps;

    DexAnnotation(SootClass clazz, IInitialResolver.Dependencies deps) {
        this.clazz = clazz;
        this.deps = deps;
    }

    void handleClassAnnotation(ClassDef classDef) {
        Set<? extends Annotation> aSet = classDef.getAnnotations();
        if (aSet == null || aSet.isEmpty()) {
            return;
        }
        List<Tag> tags = this.handleAnnotation(aSet, classDef.getType());
        if (tags == null) {
            return;
        }
        InnerClassAttribute ica = null;
        for (Tag t : tags) {
            if (t == null) continue;
            if (t instanceof InnerClassTag) {
                if (ica == null && (ica = (InnerClassAttribute)this.clazz.getTag("InnerClassAttribute")) == null) {
                    ica = new InnerClassAttribute();
                    this.clazz.addTag(ica);
                }
                ica.add((InnerClassTag)t);
            } else if (t instanceof VisibilityAnnotationTag) {
                VisibilityAnnotationTag vt = (VisibilityAnnotationTag)t;
                for (AnnotationTag a : vt.getAnnotations()) {
                    if (!a.getType().equals("Ldalvik/annotation/AnnotationDefault;")) continue;
                    for (AnnotationElem ae : a.getElems()) {
                        if (!(ae instanceof AnnotationAnnotationElem)) continue;
                        AnnotationAnnotationElem aae = (AnnotationAnnotationElem)ae;
                        AnnotationTag at = aae.getValue();
                        HashMap<String, AnnotationElem> defaults = new HashMap<String, AnnotationElem>();
                        for (AnnotationElem annotationElem : at.getElems()) {
                            defaults.put(annotationElem.getName(), annotationElem);
                        }
                        for (SootMethod sootMethod : this.clazz.getMethods()) {
                            String methodName = sootMethod.getName();
                            if (!defaults.containsKey(methodName)) continue;
                            AnnotationElem e = (AnnotationElem)defaults.get(methodName);
                            Type annotationType = this.getSootType(e);
                            boolean isCorrectType = false;
                            if (annotationType == null) {
                                isCorrectType = true;
                            } else if (annotationType.equals(sootMethod.getReturnType())) {
                                isCorrectType = true;
                            } else if (annotationType.equals(this.ARRAY_TYPE) && sootMethod.getReturnType() instanceof ArrayType) {
                                isCorrectType = true;
                            }
                            if (!isCorrectType || sootMethod.getParameterCount() != 0) continue;
                            e.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(e);
                            sootMethod.addTag(d);
                            defaults.remove(sootMethod.getName());
                        }
                        for (Map.Entry entry : defaults.entrySet()) {
                            SootMethod found = this.clazz.getMethodByNameUnsafe((String)entry.getKey());
                            AnnotationElem element = (AnnotationElem)entry.getValue();
                            if (found == null) continue;
                            element.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(element);
                            found.addTag(d);
                        }
                    }
                }
                if (vt.getVisibility() != 1) {
                    this.clazz.addTag(vt);
                }
            } else {
                this.clazz.addTag(t);
            }
            Debug.printDbg("add class annotation: ", t, " type: ", t.getClass());
        }
    }

    private Type getSootType(AnnotationElem e) {
        Type annotationType;
        switch (e.getKind()) {
            case '[': {
                annotationType = this.ARRAY_TYPE;
                AnnotationArrayElem array = (AnnotationArrayElem)e;
                if (array.getNumValues() <= 0) break;
                AnnotationElem firstElement = array.getValueAt(0);
                Type type = this.getSootType(firstElement);
                if (type == null) {
                    return null;
                }
                if (type.equals(this.ARRAY_TYPE)) {
                    return this.ARRAY_TYPE;
                }
                return ArrayType.v(type, 1);
            }
            case 's': {
                annotationType = RefType.v("java.lang.String");
                break;
            }
            case 'c': {
                annotationType = RefType.v("java.lang.Class");
                break;
            }
            case 'e': {
                AnnotationEnumElem enumElem = (AnnotationEnumElem)e;
                annotationType = Util.getType(enumElem.getTypeName());
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'Z': {
                annotationType = Util.getType(String.valueOf(e.getKind()));
                break;
            }
            default: {
                annotationType = null;
            }
        }
        return annotationType;
    }

    void handleFieldAnnotation(Host h, Field f) {
        List<Tag> tags;
        Set<? extends Annotation> aSet = f.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags = this.handleAnnotation(aSet, null)) != null) {
            for (Tag t : tags) {
                if (t == null) continue;
                h.addTag(t);
                Debug.printDbg("add field annotation: ", t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleMethodAnnotation(Host h, Method method) {
        boolean bl;
        List<Tag> tags;
        Set<? extends Annotation> aSet = method.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags = this.handleAnnotation(aSet, null)) != null) {
            for (Tag t : tags) {
                if (t == null) continue;
                h.addTag(t);
                Debug.printDbg("add method annotation: ", t);
            }
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        boolean addParameterNames = false;
        for (MethodParameter methodParameter : method.getParameters()) {
            String string = methodParameter.getName();
            parameterNames.add(string);
            if (string == null) continue;
            addParameterNames = true;
        }
        if (addParameterNames) {
            h.addTag(new ParamNamesTag(parameterNames));
        }
        boolean bl2 = false;
        List<? extends MethodParameter> parameters = method.getParameters();
        for (MethodParameter methodParameter : parameters) {
            Debug.printDbg("parameter ", methodParameter, " annotations: ", methodParameter.getAnnotations());
            if (methodParameter.getAnnotations().size() <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) return;
        VisibilityParameterAnnotationTag visibilityParameterAnnotationTag = new VisibilityParameterAnnotationTag(parameters.size(), 0);
        for (MethodParameter methodParameter : parameters) {
            List<Tag> tags2 = this.handleAnnotation(methodParameter.getAnnotations(), null);
            if (tags2 == null) {
                visibilityParameterAnnotationTag.addVisibilityAnnotation(null);
                continue;
            }
            VisibilityAnnotationTag paramVat = new VisibilityAnnotationTag(0);
            visibilityParameterAnnotationTag.addVisibilityAnnotation(paramVat);
            for (Tag t : tags2) {
                if (t == null) continue;
                AnnotationTag vat = null;
                if (!(t instanceof VisibilityAnnotationTag)) {
                    if (t instanceof DeprecatedTag) {
                        vat = new AnnotationTag("Ljava/lang/Deprecated;");
                    } else {
                        if (!(t instanceof SignatureTag)) throw new RuntimeException("error: unhandled tag for parameter annotation in method " + h + " (" + t + ").");
                        SignatureTag sig = (SignatureTag)t;
                        ArrayList<AnnotationElem> sigElements = new ArrayList<AnnotationElem>();
                        for (String s : SootToDexUtils.splitSignature(sig.getSignature())) {
                            sigElements.add(new AnnotationStringElem(s, 's', "value"));
                        }
                        AnnotationArrayElem elem = new AnnotationArrayElem(sigElements, 's', "value");
                        vat = new AnnotationTag("Ldalvik/annotation/Signature;", Collections.singleton(elem));
                    }
                } else {
                    vat = ((VisibilityAnnotationTag)t).getAnnotations().get(0);
                }
                Debug.printDbg("add parameter annotation: ", t);
                paramVat.addAnnotation(vat);
            }
        }
        if (visibilityParameterAnnotationTag.getVisibilityAnnotations().size() <= 0) return;
        h.addTag(visibilityParameterAnnotationTag);
    }

    /*
     * Could not resolve type clashes
     */
    private List<Tag> handleAnnotation(Set<? extends Annotation> annotations, String classType) {
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        VisibilityAnnotationTag[] vatg = new VisibilityAnnotationTag[3];
        for (Annotation a : annotations) {
            AnnotationElem e;
            int v = this.getVisibility(a.getVisibility());
            Tag t = null;
            Type atype = DexType.toSoot(a.getType());
            String atypes = atype.toString();
            int eSize = a.getElements().size();
            Debug.printDbg("annotation type: ", atypes, " elements: ", eSize);
            if (atypes.equals("dalvik.annotation.AnnotationDefault")) {
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation Default. Got " + eSize + " instead.");
                }
                e = this.getElements(a.getElements()).get(0);
                AnnotationTag adt = new AnnotationTag(a.getType());
                adt.addElem(e);
                if (vatg[v] == null) {
                    vatg[v] = new VisibilityAnnotationTag(v);
                }
                vatg[v].addAnnotation(adt);
            } else {
                Object outerClass;
                if (atypes.equals("dalvik.annotation.EnclosingClass")) {
                    if (eSize != 1) {
                        throw new RuntimeException("error: expected 1 element for annotation EnclosingClass. Got " + eSize + " instead.");
                    }
                    for (AnnotationElement elem : a.getElements()) {
                        outerClass = ((TypeEncodedValue)elem.getValue()).getValue();
                        outerClass = Util.dottedClassName((String)outerClass);
                        this.deps.typesToSignature.add(RefType.v((String)outerClass));
                        this.clazz.setOuterClass(SootResolver.v().makeClassRef((String)outerClass));
                        assert (this.clazz.getOuterClass() != this.clazz);
                    }
                    continue;
                }
                if (atypes.equals("dalvik.annotation.EnclosingMethod")) {
                    if (eSize != 1) {
                        throw new RuntimeException("error: expected 1 element for annotation EnclosingMethod. Got " + eSize + " instead.");
                    }
                    e = (AnnotationStringElem)this.getElements(a.getElements()).get(0);
                    String[] split1 = ((AnnotationStringElem)e).getValue().split("\\ \\|");
                    String classString = split1[0];
                    String methodString = split1[1];
                    String parameters = split1[2];
                    String returnType = split1[3];
                    String methodSigString = "(" + parameters + ")" + returnType;
                    t = new EnclosingMethodTag(classString, methodString, methodSigString);
                    String outerClass2 = classString.replace("/", ".");
                    this.deps.typesToSignature.add(RefType.v(outerClass2));
                    this.clazz.setOuterClass(SootResolver.v().makeClassRef(outerClass2));
                    assert (this.clazz.getOuterClass() != this.clazz);
                } else {
                    if (atypes.equals("dalvik.annotation.InnerClass")) {
                        int accessFlags = -1;
                        String name = null;
                        for (AnnotationElem ele : this.getElements(a.getElements())) {
                            if (ele instanceof AnnotationIntElem && ele.getName().equals("accessFlags")) {
                                accessFlags = ((AnnotationIntElem)ele).getValue();
                                continue;
                            }
                            if (ele instanceof AnnotationStringElem && ele.getName().equals("name")) {
                                name = ((AnnotationStringElem)ele).getValue();
                                continue;
                            }
                            throw new RuntimeException("Unexpected inner class annotation element");
                        }
                        outerClass = name == null ? classType.replaceAll("\\$[0-9,a-z,A-Z]*;$", ";") : classType.replaceFirst("\\$" + name + ";$", ";");
                        if (((String)outerClass).equals(classType)) {
                            outerClass = null;
                        }
                        InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(classType), outerClass == null ? null : DexType.toSootICAT((String)outerClass), name, accessFlags);
                        tags.add(innerTag);
                        if (outerClass == null || this.clazz.hasOuterClass()) continue;
                        String sootOuterClass = Util.dottedClassName((String)outerClass);
                        this.deps.typesToSignature.add(RefType.v(sootOuterClass));
                        this.clazz.setOuterClass(SootResolver.v().makeClassRef(sootOuterClass));
                        assert (this.clazz.getOuterClass() != this.clazz);
                        continue;
                    }
                    if (atypes.equals("dalvik.annotation.MemberClasses")) {
                        AnnotationArrayElem e2 = (AnnotationArrayElem)this.getElements(a.getElements()).get(0);
                        for (AnnotationElem ae : e2.getValues()) {
                            AnnotationClassElem c = (AnnotationClassElem)ae;
                            String innerClass = c.getDesc();
                            String outerClass3 = innerClass.replaceAll("\\$[^\\$]*$", "");
                            String name = innerClass.replaceAll("^.*\\$", "").replaceAll(";$", "");
                            if (name.replaceAll("[0-9].*", "").equals("")) {
                                name = null;
                            }
                            int accessFlags = 0;
                            InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(innerClass), DexType.toSootICAT(outerClass3), name, accessFlags);
                            tags.add(innerTag);
                        }
                        continue;
                    }
                    if (atypes.equals("dalvik.annotation.Signature")) {
                        if (eSize != 1) {
                            throw new RuntimeException("error: expected 1 element for annotation Signature. Got " + eSize + " instead.");
                        }
                        e = (AnnotationArrayElem)this.getElements(a.getElements()).get(0);
                        String sig = "";
                        for (AnnotationElem ae : ((AnnotationArrayElem)e).getValues()) {
                            AnnotationStringElem s = (AnnotationStringElem)ae;
                            sig = String.valueOf(sig) + s.getValue();
                        }
                        t = new SignatureTag(sig);
                    } else {
                        if (atypes.equals("dalvik.annotation.Throws")) continue;
                        if (atypes.equals("java.lang.Deprecated")) {
                            if (eSize != 0) {
                                throw new RuntimeException("error: expected 1 element for annotation Deprecated. Got " + eSize + " instead.");
                            }
                            t = new DeprecatedTag();
                            AnnotationTag adt = new AnnotationTag("Ljava/lang/Deprecated;");
                            if (vatg[v] == null) {
                                vatg[v] = new VisibilityAnnotationTag(v);
                            }
                            vatg[v].addAnnotation(adt);
                        } else {
                            Debug.printDbg("read visibility tag: ", a.getType());
                            if (vatg[v] == null) {
                                vatg[v] = new VisibilityAnnotationTag(v);
                            }
                            AnnotationTag tag = new AnnotationTag(a.getType());
                            for (AnnotationElem e3 : this.getElements(a.getElements())) {
                                tag.addElem(e3);
                            }
                            vatg[v].addAnnotation(tag);
                        }
                    }
                }
            }
            tags.add(t);
        }
        VisibilityAnnotationTag[] visibilityAnnotationTagArray = vatg;
        int n = vatg.length;
        int n2 = 0;
        while (n2 < n) {
            VisibilityAnnotationTag vat = visibilityAnnotationTagArray[n2];
            if (vat != null) {
                tags.add(vat);
            }
            ++n2;
        }
        return tags;
    }

    private ArrayList<AnnotationElem> getElements(Set<? extends AnnotationElement> set) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (AnnotationElement annotationElement : set) {
            Debug.printDbg("   element type: ", annotationElement.getValue().getClass());
            ArrayList<AnnotationElem> eList = this.handleAnnotationElement(annotationElement, Collections.singletonList(annotationElement.getValue()));
            if (eList == null) continue;
            aelemList.addAll(eList);
        }
        return aelemList;
    }

    private ArrayList<AnnotationElem> handleAnnotationElement(AnnotationElement ae, List<? extends EncodedValue> evList) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (EncodedValue encodedValue : evList) {
            int type = encodedValue.getValueType();
            AnnotationElem elem = null;
            Debug.printDbg("encoded value type: ", type);
            switch (type) {
                case 0: {
                    EncodedValue v = (ByteEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'B', ae.getName());
                    break;
                }
                case 2: {
                    EncodedValue v = (ShortEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'S', ae.getName());
                    break;
                }
                case 3: {
                    EncodedValue v = (CharEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'C', ae.getName());
                    break;
                }
                case 4: {
                    EncodedValue v = (IntEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'I', ae.getName());
                    break;
                }
                case 6: {
                    EncodedValue v = (LongEncodedValue)encodedValue;
                    elem = new AnnotationLongElem(v.getValue(), 'J', ae.getName());
                    break;
                }
                case 16: {
                    EncodedValue v = (FloatEncodedValue)encodedValue;
                    elem = new AnnotationFloatElem(v.getValue(), 'F', ae.getName());
                    break;
                }
                case 17: {
                    EncodedValue v = (DoubleEncodedValue)encodedValue;
                    elem = new AnnotationDoubleElem(v.getValue(), 'D', ae.getName());
                    break;
                }
                case 23: {
                    EncodedValue v = (StringEncodedValue)encodedValue;
                    elem = new AnnotationStringElem(v.getValue(), 's', ae.getName());
                    Debug.printDbg("value for string: ", v.getValue());
                    break;
                }
                case 24: {
                    EncodedValue v = (TypeEncodedValue)encodedValue;
                    elem = new AnnotationClassElem(DexType.toSootAT(v.getValue()), 'c', ae.getName());
                    break;
                }
                case 25: {
                    EncodedValue v = (FieldEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    String string4 = "";
                    string4 = String.valueOf(string4) + DexType.toSootAT(fr.getDefiningClass()) + ": ";
                    string4 = String.valueOf(string4) + DexType.toSootAT(fr.getType()) + " ";
                    string4 = String.valueOf(string4) + fr.getName();
                    Debug.printDbg("FIELD: ", string4);
                    elem = new AnnotationStringElem(string4, 'f', ae.getName());
                    break;
                }
                case 26: {
                    EncodedValue v = (MethodEncodedValue)encodedValue;
                    MethodReference mr = v.getValue();
                    String string = DexType.toSootICAT(mr.getDefiningClass());
                    String returnType = DexType.toSootAT(mr.getReturnType());
                    String methodName = mr.getName();
                    String parameters = "";
                    for (CharSequence charSequence : mr.getParameterTypes()) {
                        parameters = String.valueOf(parameters) + DexType.toSootAT(charSequence.toString());
                    }
                    String string5 = String.valueOf(string) + " |" + methodName + " |" + parameters + " |" + returnType;
                    elem = new AnnotationStringElem(string5, 'M', ae.getName());
                    break;
                }
                case 27: {
                    EncodedValue v = (EnumEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    elem = new AnnotationEnumElem(DexType.toSootAT(fr.getType()).toString(), fr.getName(), 'e', ae.getName());
                    break;
                }
                case 28: {
                    EncodedValue v = (ArrayEncodedValue)encodedValue;
                    ArrayList<AnnotationElem> l = this.handleAnnotationElement(ae, v.getValue());
                    if (l == null) break;
                    elem = new AnnotationArrayElem(l, '[', ae.getName());
                    break;
                }
                case 29: {
                    EncodedValue v = (AnnotationEncodedValue)encodedValue;
                    AnnotationTag t = new AnnotationTag(DexType.toSootAT(v.getType()).toString());
                    for (AnnotationElement annotationElement : v.getElements()) {
                        ArrayList<EncodedValue> l = new ArrayList<EncodedValue>();
                        l.add(annotationElement.getValue());
                        ArrayList<AnnotationElem> aList = this.handleAnnotationElement(annotationElement, l);
                        if (aList == null) continue;
                        for (AnnotationElem annotationElem : aList) {
                            t.addElem(annotationElem);
                        }
                    }
                    elem = new AnnotationAnnotationElem(t, '@', ae.getName());
                    break;
                }
                case 30: {
                    elem = new AnnotationStringElem(null, 'N', ae.getName());
                    break;
                }
                case 31: {
                    EncodedValue v = (BooleanEncodedValue)encodedValue;
                    elem = new AnnotationBooleanElem(v.getValue(), 'Z', ae.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown annotation element 0x" + Integer.toHexString(type));
                }
            }
            if (elem == null) continue;
            aelemList.add(elem);
        }
        return aelemList;
    }

    private int getVisibility(int visibility) {
        if ("runtime".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 0;
        }
        if ("system".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 1;
        }
        if ("build".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 2;
        }
        throw new RuntimeException("error: unknown annotation visibility: '" + visibility + "'");
    }

    class MyAnnotations {
        List<AnnotationTag> annotationList = new ArrayList<AnnotationTag>();
        List<Integer> visibilityList = new ArrayList<Integer>();

        MyAnnotations() {
        }

        public void add(AnnotationTag a, int visibility) {
            this.annotationList.add(a);
            this.visibilityList.add(new Integer(visibility));
        }

        public List<AnnotationTag> getAnnotations() {
            return this.annotationList;
        }

        public List<Integer> getVisibilityList() {
            return this.visibilityList;
        }
    }
}

