/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.dexpler.AbstractNullTransformer;
import soot.dexpler.Debug;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DexNullTransformer
extends AbstractNullTransformer {
    private boolean usedAsObject;
    private boolean doBreak = false;
    private Local l = null;

    public static DexNullTransformer v() {
        return new DexNullTransformer();
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map<String, String> options) {
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(body);
        LocalUses localUses = LocalUses.Factory.newLocalUses(body, localDefs);
        for (Local loc : this.getNullCandidates(body)) {
            Debug.printDbg("\n[null candidate] ", loc);
            this.usedAsObject = false;
            List<Unit> defs = this.collectDefinitionsWithAliases(loc, localDefs, localUses, body);
            this.doBreak = false;
            for (Unit u : defs) {
                if (u instanceof DefinitionStmt) {
                    this.l = (Local)((DefinitionStmt)u).getLeftOp();
                } else if (u instanceof IfStmt) {
                    throw new RuntimeException("ERROR: def can not be something else than Assign or Identity statement! (def: " + u + " class: " + u.getClass());
                }
                Debug.printDbg("    target local: ", this.l, " (Unit: ", u, " )");
                u.apply(new AbstractStmtSwitch(){

                    @Override
                    public void caseAssignStmt(AssignStmt stmt) {
                        Value r = stmt.getRightOp();
                        if (r instanceof FieldRef) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((FieldRef)r).getFieldRef().type());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof ArrayRef) {
                            ArrayRef ar = (ArrayRef)r;
                            if (ar.getType() instanceof UnknownType) {
                                DexNullTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                            } else {
                                DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(ar.getType());
                            }
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof StringConstant || r instanceof NewExpr || r instanceof NewArrayExpr) {
                            DexNullTransformer.this.usedAsObject = true;
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof CastExpr) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((CastExpr)r).getCastType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof InvokeExpr) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((InvokeExpr)r).getType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof LengthExpr) {
                            DexNullTransformer.this.usedAsObject = false;
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        boolean cfr_ignored_0 = r instanceof Local;
                    }

                    @Override
                    public void caseIdentityStmt(IdentityStmt stmt) {
                        if (stmt.getLeftOp() == DexNullTransformer.this.l) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(stmt.getRightOp().getType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                    }
                });
                if (this.doBreak) break;
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    Unit use = pair.getUnit();
                    Debug.printDbg("    use: ", use);
                    use.apply(new AbstractStmtSwitch(){

                        private boolean examineInvokeExpr(InvokeExpr e) {
                            AbstractInstanceInvokeExpr aiiexpr;
                            Value b;
                            List<Value> args = e.getArgs();
                            List<Type> argTypes = e.getMethodRef().parameterTypes();
                            if (!$assertionsDisabled && args.size() != argTypes.size()) {
                                throw new AssertionError();
                            }
                            int i = 0;
                            while (i < args.size()) {
                                if (args.get(i) == DexNullTransformer.this.l && DexNullTransformer.this.isObject(argTypes.get(i))) {
                                    return true;
                                }
                                ++i;
                            }
                            SootMethodRef sm = e.getMethodRef();
                            return !sm.isStatic() && e instanceof AbstractInvokeExpr && (b = (aiiexpr = (AbstractInstanceInvokeExpr)e).getBase()) == DexNullTransformer.this.l;
                        }

                        @Override
                        public void caseInvokeStmt(InvokeStmt stmt) {
                            InvokeExpr e = stmt.getInvokeExpr();
                            DexNullTransformer.this.usedAsObject = this.examineInvokeExpr(e);
                            Debug.printDbg("use as object = ", DexNullTransformer.this.usedAsObject);
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseAssignStmt(AssignStmt stmt) {
                            InstanceFieldRef ifr;
                            ArrayRef ar;
                            Value left = stmt.getLeftOp();
                            Value r = stmt.getRightOp();
                            if (left instanceof ArrayRef) {
                                ar = (ArrayRef)left;
                                if (ar.getIndex() == DexNullTransformer.this.l) {
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                                if (ar.getBase() == DexNullTransformer.this.l) {
                                    DexNullTransformer.this.usedAsObject = true;
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                            }
                            if (left instanceof InstanceFieldRef && (ifr = (InstanceFieldRef)left).getBase() == DexNullTransformer.this.l) {
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (stmt.getRightOp() == DexNullTransformer.this.l) {
                                Value l = stmt.getLeftOp();
                                if (l instanceof StaticFieldRef && DexNullTransformer.this.isObject(((StaticFieldRef)l).getFieldRef().type())) {
                                    DexNullTransformer.this.usedAsObject = true;
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                                if (l instanceof InstanceFieldRef && DexNullTransformer.this.isObject(((InstanceFieldRef)l).getFieldRef().type())) {
                                    DexNullTransformer.this.usedAsObject = true;
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                                if (l instanceof ArrayRef) {
                                    Type aType = ((ArrayRef)l).getType();
                                    if (aType instanceof UnknownType) {
                                        DexNullTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                    } else {
                                        DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(aType);
                                    }
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                            }
                            if (r instanceof FieldRef) {
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof ArrayRef) {
                                ar = (ArrayRef)r;
                                if (ar.getBase() == DexNullTransformer.this.l) {
                                    DexNullTransformer.this.usedAsObject = true;
                                } else {
                                    DexNullTransformer.this.usedAsObject = false;
                                }
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof StringConstant || r instanceof NewExpr) {
                                throw new RuntimeException("NOT POSSIBLE StringConstant or NewExpr at " + stmt);
                            }
                            if (r instanceof NewArrayExpr) {
                                DexNullTransformer.this.usedAsObject = false;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof CastExpr) {
                                DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((CastExpr)r).getCastType());
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof InvokeExpr) {
                                DexNullTransformer.this.usedAsObject = this.examineInvokeExpr((InvokeExpr)stmt.getRightOp());
                                Debug.printDbg("use as object 2 = ", DexNullTransformer.this.usedAsObject);
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof LengthExpr) {
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof BinopExpr) {
                                DexNullTransformer.this.usedAsObject = false;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                        }

                        @Override
                        public void caseIdentityStmt(IdentityStmt stmt) {
                            if (stmt.getLeftOp() == DexNullTransformer.this.l) {
                                throw new RuntimeException("IMPOSSIBLE 0");
                            }
                        }

                        @Override
                        public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseReturnStmt(ReturnStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l && DexNullTransformer.this.isObject(body.getMethod().getReturnType());
                            Debug.printDbg(" [return stmt] ", stmt, " usedAsObject: ", DexNullTransformer.this.usedAsObject, ", return type: ", body.getMethod().getReturnType());
                            Debug.printDbg(" class: ", body.getMethod().getReturnType().getClass());
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseThrowStmt(ThrowStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }
                    });
                    if (this.doBreak) break;
                }
                if (this.doBreak) break;
            }
            if (!this.usedAsObject) continue;
            for (Unit u : defs) {
                this.replaceWithNull(u);
                HashSet<Value> defLocals = new HashSet<Value>();
                for (ValueBox vb : u.getDefBoxes()) {
                    defLocals.add(vb.getValue());
                }
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    Stmt use = (Stmt)pair.getUnit();
                    if (use.containsArrayRef() && defLocals.contains(use.getArrayRef().getBase())) continue;
                    this.replaceWithNull(use);
                }
            }
        }
        for (Unit u : body.getUnits()) {
            Stmt stmt;
            u.apply(new AbstractStmtSwitch(){

                @Override
                public void caseAssignStmt(AssignStmt stmt) {
                    ArrayRef ar;
                    CastExpr ce;
                    if (DexNullTransformer.this.isObject(stmt.getLeftOp().getType()) && this.isConstZero(stmt.getRightOp())) {
                        stmt.setRightOp(NullConstant.v());
                        return;
                    }
                    if (stmt.getRightOp() instanceof CastExpr && DexNullTransformer.this.isObject((ce = (CastExpr)stmt.getRightOp()).getCastType()) && this.isConstZero(ce.getOp())) {
                        stmt.setRightOp(NullConstant.v());
                    }
                    if (stmt.getLeftOp() instanceof ArrayRef && this.isConstZero(stmt.getRightOp()) && (DexNullTransformer.this.isObjectArray((ar = (ArrayRef)stmt.getLeftOp()).getBase(), body) || stmt.hasTag("ObjectOpTag"))) {
                        stmt.setRightOp(NullConstant.v());
                    }
                }

                private boolean isConstZero(Value rightOp) {
                    if (rightOp instanceof IntConstant && ((IntConstant)rightOp).value == 0) {
                        return true;
                    }
                    return rightOp instanceof LongConstant && ((LongConstant)rightOp).value == 0L;
                }

                @Override
                public void caseReturnStmt(ReturnStmt stmt) {
                    if (stmt.getOp() instanceof IntConstant && DexNullTransformer.this.isObject(body.getMethod().getReturnType())) {
                        IntConstant iconst = (IntConstant)stmt.getOp();
                        if (!$assertionsDisabled && iconst.value != 0) {
                            throw new AssertionError();
                        }
                        stmt.setOp(NullConstant.v());
                    }
                }
            });
            if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr()) continue;
            InvokeExpr invExpr = stmt.getInvokeExpr();
            int i = 0;
            while (i < invExpr.getArgCount()) {
                if (this.isObject(invExpr.getMethodRef().parameterType(i)) && invExpr.getArg(i) instanceof IntConstant) {
                    IntConstant iconst = (IntConstant)invExpr.getArg(i);
                    assert (iconst.value == 0);
                    invExpr.setArg(i, NullConstant.v());
                }
                ++i;
            }
        }
    }

    private boolean isObjectArray(Value v, Body body) {
        for (Unit u : body.getUnits()) {
            FieldRef fr;
            NewArrayExpr nea;
            AssignStmt assign;
            if (!(u instanceof AssignStmt) || (assign = (AssignStmt)u).getLeftOp() != v || !(assign.getRightOp() instanceof NewArrayExpr ? this.isObject((nea = (NewArrayExpr)assign.getRightOp()).getBaseType()) : assign.getRightOp() instanceof FieldRef && (fr = (FieldRef)assign.getRightOp()).getType() instanceof ArrayType && this.isObject(((ArrayType)fr.getType()).getArrayElementType()))) continue;
            return true;
        }
        return false;
    }

    private Set<Local> getNullCandidates(Body body) {
        HashSet<Local> candidates = null;
        for (Unit u : body.getUnits()) {
            ConditionExpr expr;
            if (u instanceof AssignStmt) {
                AssignStmt a = (AssignStmt)u;
                if (!(a.getLeftOp() instanceof Local)) continue;
                Local l = (Local)a.getLeftOp();
                Value r = a.getRightOp();
                if ((!(r instanceof IntConstant) || ((IntConstant)r).value != 0) && (!(r instanceof LongConstant) || ((LongConstant)r).value != 0L)) continue;
                if (candidates == null) {
                    candidates = new HashSet();
                }
                candidates.add(l);
                Debug.printDbg("[add null candidate: ", u);
                continue;
            }
            if (!(u instanceof IfStmt) || !this.isZeroComparison(expr = (ConditionExpr)((IfStmt)u).getCondition()) || !(expr.getOp1() instanceof Local)) continue;
            if (candidates == null) {
                candidates = new HashSet<Local>();
            }
            candidates.add((Local)expr.getOp1());
            Debug.printDbg("[add null candidate if: ", u);
        }
        return candidates == null ? Collections.emptySet() : candidates;
    }
}

