/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dexpler.Debug;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.Stmt;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public abstract class DexTransformer
extends BodyTransformer {
    protected List<Unit> collectDefinitionsWithAliases(Local l, LocalDefs localDefs, LocalUses localUses, Body body) {
        HashSet<Local> seenLocals = new HashSet<Local>();
        Stack<Local> newLocals = new Stack<Local>();
        LinkedList<Unit> defs = new LinkedList<Unit>();
        newLocals.push(l);
        while (!newLocals.empty()) {
            Local local = (Local)newLocals.pop();
            Debug.printDbg("[null local] ", local);
            if (!seenLocals.add(local)) continue;
            for (Unit u : this.collectDefinitions(local, localDefs, body)) {
                Value r;
                if (u instanceof AssignStmt && (r = ((AssignStmt)u).getRightOp()) instanceof Local && !seenLocals.contains((Local)r)) {
                    newLocals.push((Local)r);
                }
                defs.add(u);
                List<UnitValueBoxPair> usesOf = localUses.getUsesOf(u);
                for (UnitValueBoxPair pair : usesOf) {
                    Unit unit = pair.getUnit();
                    if (!(unit instanceof AssignStmt)) continue;
                    Value right = ((AssignStmt)unit).getRightOp();
                    Value left = ((AssignStmt)unit).getLeftOp();
                    if (right != local || !(left instanceof Local) || seenLocals.contains((Local)left)) continue;
                    newLocals.push((Local)left);
                }
            }
        }
        return defs;
    }

    private List<Unit> collectDefinitions(Local l, LocalDefs localDefs, Body body) {
        ArrayList<Unit> defs = new ArrayList<Unit>();
        for (Unit u : body.getUnits()) {
            List<Unit> defsOf = localDefs.getDefsOfAt(l, u);
            if (defsOf == null) continue;
            defs.addAll(defsOf);
        }
        for (Unit u : defs) {
            Debug.printDbg("[add def] ", u);
        }
        return defs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Type findArrayType(LocalDefs localDefs, LocalUses localUses, Stmt arrayStmt, int depth, Set<Unit> alreadyVisitedDefs) {
        ArrayRef aRef = null;
        if (arrayStmt.containsArrayRef()) {
            aRef = arrayStmt.getArrayRef();
        }
        Local aBase = null;
        if (aRef == null) {
            if (!(arrayStmt instanceof AssignStmt)) throw new RuntimeException("ERROR: not an assign statement: " + arrayStmt);
            AssignStmt stmt = (AssignStmt)arrayStmt;
            aBase = (Local)stmt.getRightOp();
        } else {
            aBase = (Local)aRef.getBase();
        }
        List<Unit> defsOfaBaseList = localDefs.getDefsOfAt(aBase, arrayStmt);
        if (defsOfaBaseList == null || defsOfaBaseList.isEmpty()) {
            throw new RuntimeException("ERROR: no def statement found for array base local " + arrayStmt);
        }
        Type aType = null;
        for (Unit baseDef : defsOfaBaseList) {
            Type t;
            DefinitionStmt stmt;
            Debug.printDbg("dextransformer: ", baseDef);
            if (alreadyVisitedDefs.contains(baseDef)) continue;
            HashSet<Unit> newVisitedDefs = new HashSet<Unit>(alreadyVisitedDefs);
            newVisitedDefs.add(baseDef);
            if (baseDef instanceof AssignStmt) {
                stmt = (AssignStmt)baseDef;
                Value r = stmt.getRightOp();
                if (r instanceof FieldRef) {
                    t = ((FieldRef)r).getFieldRef().type();
                    if (t instanceof ArrayType) {
                        ArrayType at = (ArrayType)t;
                        t = at.getArrayElementType();
                    }
                    Debug.printDbg("atype fieldref: ", t);
                    if (depth != 0) return t;
                    aType = t;
                    break;
                }
                if (r instanceof ArrayRef) {
                    ArrayRef ar = (ArrayRef)r;
                    if (ar.getType().equals(".unknown") || ar.getType().toString().equals("unknown")) {
                        System.out.println("second round from stmt: " + stmt);
                        Type t2 = this.findArrayType(localDefs, localUses, stmt, ++depth, newVisitedDefs);
                        if (t2 instanceof ArrayType) {
                            ArrayType at = (ArrayType)t2;
                            t2 = at.getArrayElementType();
                        }
                        if (depth != 0) return t2;
                        aType = t2;
                        break;
                    }
                    Debug.printDbg("atype arrayref: ", ar.getType().toString());
                    ArrayType at = (ArrayType)stmt.getRightOp().getType();
                    Type t3 = at.getArrayElementType();
                    if (depth != 0) return t3;
                    aType = t3;
                    break;
                }
                if (r instanceof NewArrayExpr) {
                    NewArrayExpr expr = (NewArrayExpr)r;
                    Type t4 = expr.getBaseType();
                    Debug.printDbg("atype newarrayexpr: ", t4);
                    if (depth != 0) return t4;
                    aType = t4;
                    break;
                }
                if (r instanceof CastExpr) {
                    t = ((CastExpr)r).getCastType();
                    Debug.printDbg("atype cast: ", t);
                    if (t instanceof ArrayType) {
                        ArrayType at = (ArrayType)t;
                        t = at.getArrayElementType();
                    }
                    if (depth != 0) return t;
                    aType = t;
                    break;
                }
                if (r instanceof InvokeExpr) {
                    t = ((InvokeExpr)r).getMethodRef().returnType();
                    Debug.printDbg("atype invoke: ", t);
                    if (t instanceof ArrayType) {
                        ArrayType at = (ArrayType)t;
                        t = at.getArrayElementType();
                    }
                    if (depth != 0) return t;
                    aType = t;
                    break;
                }
                if (r instanceof Local) {
                    Debug.printDbg("atype alias: ", stmt);
                    t = this.findArrayType(localDefs, localUses, stmt, ++depth, newVisitedDefs);
                    aType = depth == 0 ? t : t;
                } else if (!(r instanceof Constant)) {
                    throw new RuntimeException("ERROR: def statement not possible! " + stmt);
                }
            } else {
                if (!(baseDef instanceof IdentityStmt)) throw new RuntimeException("ERROR: base local def must be AssignStmt or IdentityStmt! " + baseDef);
                stmt = (IdentityStmt)baseDef;
                ArrayType at = (ArrayType)stmt.getRightOp().getType();
                t = at.getArrayElementType();
                if (depth != 0) return t;
                aType = t;
                break;
            }
            if (aType != null) break;
        }
        if (depth != 0 || aType != null) return aType;
        throw new RuntimeException("ERROR: could not find type of array from statement '" + arrayStmt + "'");
    }
}

