/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.NarrowLiteralInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;

public class ConstInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ConstInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        int dest = ((OneRegisterInstruction)this.instruction).getRegisterA();
        Constant cst = this.getConstant(dest, body);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), cst);
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    private Constant getConstant(int dest, DexBody body) {
        long literal = 0L;
        if (this.instruction instanceof WideLiteralInstruction) {
            literal = ((WideLiteralInstruction)this.instruction).getWideLiteral();
        } else if (this.instruction instanceof NarrowLiteralInstruction) {
            literal = ((NarrowLiteralInstruction)this.instruction).getNarrowLiteral();
        } else {
            throw new RuntimeException("literal error: expected narrow or wide literal.");
        }
        Opcode opcode = this.instruction.getOpcode();
        switch (opcode) {
            case CONST_4: 
            case CONST_16: 
            case CONST: {
                return IntConstant.v((int)literal);
            }
            case CONST_HIGH16: {
                return IntConstant.v((int)literal);
            }
            case CONST_WIDE_HIGH16: {
                return LongConstant.v(literal);
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: {
                return LongConstant.v(literal);
            }
        }
        throw new IllegalArgumentException("Expected a const or a const-wide instruction, got neither.");
    }

    @Override
    boolean overridesRegister(int register) {
        OneRegisterInstruction i = (OneRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register == dest;
    }
}

