/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.dexpler.Debug;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.typing.UntypedIntOrFloatConstant;
import soot.dexpler.typing.UntypedLongOrDoubleConstant;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.IfStmt;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;

public class DalvikTyper
implements IDalvikTyper {
    private static DalvikTyper dt = null;
    private Set<Constraint> constraints = new HashSet<Constraint>();
    private Map<ValueBox, Type> typed = new HashMap<ValueBox, Type>();
    private Map<Local, Type> localTyped = new HashMap<Local, Type>();
    private Set<Local> localTemp = new HashSet<Local>();
    private List<LocalObj> localObjList = new ArrayList<LocalObj>();

    private DalvikTyper() {
    }

    public static DalvikTyper v() {
        if (dt == null) {
            dt = new DalvikTyper();
        }
        return dt;
    }

    public void clear() {
        this.constraints.clear();
        this.typed.clear();
        this.localTyped.clear();
        this.localTemp.clear();
        this.localObjList.clear();
    }

    @Override
    public void setType(ValueBox vb, Type t, boolean isUse) {
        if (vb.getValue() instanceof Local) {
            this.localObjList.add(new LocalObj(vb, t, isUse));
        } else {
            Debug.printDbg(false, "not instance of local: vb: " + vb + " value: " + vb.getValue() + " class: " + vb.getValue().getClass(), new Object[0]);
        }
    }

    @Override
    public void addConstraint(ValueBox l, ValueBox r) {
        this.constraints.add(new Constraint(l, r));
    }

    @Override
    public void assignType(Body b) {
        Object l;
        Debug.printDbg(false, "list of constraints:", new Object[0]);
        List<ValueBox> vbList = b.getUseAndDefBoxes();
        ArrayList<Constraint> toRemove = new ArrayList<Constraint>();
        for (Constraint c : this.constraints) {
            if (!vbList.contains(c.l)) {
                Debug.printDbg(false, "warning: " + c.l + " not in locals! removing...", new Object[0]);
                toRemove.add(c);
                continue;
            }
            if (vbList.contains(c.r)) continue;
            Debug.printDbg(false, "warning: " + c.r + " not in locals! removing...", new Object[0]);
            toRemove.add(c);
        }
        for (Constraint c : toRemove) {
            this.constraints.remove(c);
        }
        for (LocalObj lo : this.localObjList) {
            if (!vbList.contains(lo.vb)) {
                Debug.printDbg(false, "removing vb: " + lo.vb + " with type " + lo.t, new Object[0]);
                continue;
            }
            l = lo.getLocal();
            Type t = lo.t;
            if (this.localTemp.contains(l) && lo.isUse) {
                Debug.printDbg(false, "def already added for local " + l + "! for vb: " + lo.vb, new Object[0]);
                continue;
            }
            Debug.printDbg(false, "add type " + t + " to local " + l + " for vb: " + lo.vb, new Object[0]);
            this.localTemp.add((Local)l);
            this.typed.put(lo.vb, t);
        }
        for (ValueBox vb : this.typed.keySet()) {
            if (!(vb.getValue() instanceof Local)) continue;
            l = (Local)vb.getValue();
            this.localTyped.put((Local)l, this.typed.get(vb));
        }
        for (Constraint c : this.constraints) {
            Debug.printDbg(false, "constraint: " + c, new Object[0]);
        }
        for (ValueBox vb : this.typed.keySet()) {
            Debug.printDbg(false, "typed: " + vb + " -> " + this.typed.get(vb), new Object[0]);
        }
        for (Local l2 : this.localTyped.keySet()) {
            Debug.printDbg(false, "localTyped: " + l2 + " -> " + this.localTyped.get(l2), new Object[0]);
        }
        while (!this.constraints.isEmpty()) {
            boolean update = false;
            for (Constraint c : this.constraints) {
                ArrayType at;
                Type elementType;
                Type t;
                Local base;
                ArrayRef ar;
                Local leftLocal;
                Debug.printDbg(false, "current constraint: " + c, new Object[0]);
                Value l3 = c.l.getValue();
                Value r = c.r.getValue();
                if (l3 instanceof Local && r instanceof Constant) {
                    UntypedLongOrDoubleConstant ud;
                    UntypedIntOrFloatConstant uf;
                    Constant cst = (Constant)r;
                    if (!this.localTyped.containsKey(l3)) continue;
                    Type lt = this.localTyped.get((Local)l3);
                    Debug.printDbg(false, "would like to set type " + lt + " to constant: " + c, new Object[0]);
                    Constant newValue = null;
                    if (lt instanceof IntType || lt instanceof BooleanType || lt instanceof ShortType || lt instanceof CharType || lt instanceof ByteType) {
                        uf = (UntypedIntOrFloatConstant)cst;
                        newValue = uf.toIntConstant();
                    } else if (lt instanceof FloatType) {
                        uf = (UntypedIntOrFloatConstant)cst;
                        newValue = uf.toFloatConstant();
                    } else if (lt instanceof DoubleType) {
                        ud = (UntypedLongOrDoubleConstant)cst;
                        newValue = ud.toDoubleConstant();
                    } else if (lt instanceof LongType) {
                        ud = (UntypedLongOrDoubleConstant)cst;
                        newValue = ud.toLongConstant();
                    } else if (cst instanceof UntypedIntOrFloatConstant && ((UntypedIntOrFloatConstant)cst).value == 0) {
                        newValue = NullConstant.v();
                        System.out.println("new null constant for constraint " + c + " with l type: " + this.localTyped.get(l3));
                    } else {
                        throw new RuntimeException("unknow type for constance: " + lt);
                    }
                    c.r.setValue(newValue);
                    Debug.printDbg(false, "remove constraint: " + c, new Object[0]);
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (l3 instanceof Local && r instanceof Local) {
                    leftLocal = (Local)l3;
                    Local rightLocal = (Local)r;
                    if (this.localTyped.containsKey(leftLocal)) {
                        Type leftLocalType = this.localTyped.get(leftLocal);
                        if (!this.localTyped.containsKey(rightLocal)) {
                            Debug.printDbg(false, "set type " + leftLocalType + " to local " + rightLocal, new Object[0]);
                            rightLocal.setType(leftLocalType);
                            this.setLocalTyped(rightLocal, leftLocalType);
                        }
                        Debug.printDbg(false, "remove constraint: " + c, new Object[0]);
                        this.constraints.remove(c);
                        update = true;
                        break;
                    }
                    if (!this.localTyped.containsKey(rightLocal)) continue;
                    Type rightLocalType = this.localTyped.get(rightLocal);
                    if (!this.localTyped.containsKey(leftLocal)) {
                        Debug.printDbg(false, "set type " + rightLocalType + " to local " + leftLocal, new Object[0]);
                        leftLocal.setType(rightLocalType);
                        this.setLocalTyped(leftLocal, rightLocalType);
                    }
                    Debug.printDbg(false, "remove constraint: " + c, new Object[0]);
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (l3 instanceof ArrayRef && r instanceof Local) {
                    Local rightLocal = (Local)r;
                    ar = (ArrayRef)l3;
                    base = (Local)ar.getBase();
                    Debug.printDbg(false, "base: " + base, new Object[0]);
                    Debug.printDbg(false, "index: " + ar.getIndex(), new Object[0]);
                    if (!this.localTyped.containsKey(base)) continue;
                    t = this.localTyped.get(base);
                    Debug.printDbg(false, "type of local1: " + t + " " + t.getClass(), new Object[0]);
                    elementType = null;
                    if (!(t instanceof ArrayType)) continue;
                    at = (ArrayType)t;
                    elementType = at.getArrayElementType();
                    if (!this.localTyped.containsKey(rightLocal)) {
                        Debug.printDbg(false, "set type " + elementType + " to local " + r, new Object[0]);
                        rightLocal.setType(elementType);
                        this.setLocalTyped(rightLocal, elementType);
                    }
                    Debug.printDbg(false, "remove constraint: " + c, new Object[0]);
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                if (l3 instanceof Local && r instanceof ArrayRef) {
                    leftLocal = (Local)l3;
                    ar = (ArrayRef)r;
                    base = (Local)ar.getBase();
                    if (!this.localTyped.containsKey(base)) continue;
                    t = this.localTyped.get(base);
                    Debug.printDbg(false, "type of local2: " + t + " " + t.getClass(), new Object[0]);
                    elementType = null;
                    if (!(t instanceof ArrayType)) continue;
                    at = (ArrayType)t;
                    elementType = at.getArrayElementType();
                    if (!this.localTyped.containsKey(leftLocal)) {
                        Debug.printDbg(false, "set type " + elementType + " to local " + l3, new Object[0]);
                        leftLocal.setType(elementType);
                        this.setLocalTyped(leftLocal, elementType);
                    }
                    Debug.printDbg(false, "remove constraint: " + c, new Object[0]);
                    this.constraints.remove(c);
                    update = true;
                    break;
                }
                throw new RuntimeException("error: do not handling this kind of constraint: " + c);
            }
            if (!update) break;
        }
        for (Constraint c : this.constraints) {
            Debug.printDbg(false, "current constraint: " + c, new Object[0]);
            l = c.l.getValue();
            Value r = c.r.getValue();
            if (!(l instanceof Local) || !(r instanceof Constant)) continue;
            if (r instanceof UntypedIntOrFloatConstant) {
                UntypedIntOrFloatConstant cst = (UntypedIntOrFloatConstant)r;
                Constant newValue = null;
                if (cst.value != 0) {
                    Debug.printDbg(false, "[untyped constaints] set type int to non zero constant: " + c + " = " + cst.value, new Object[0]);
                    newValue = cst.toIntConstant();
                } else {
                    for (Unit u : b.getUnits()) {
                        for (ValueBox vb1 : u.getUseBoxes()) {
                            Value v1 = vb1.getValue();
                            if (v1 != l) continue;
                            System.out.println("local used in " + u);
                            if (u instanceof AssignStmt) {
                                AssignStmt a = (AssignStmt)u;
                                Value right = a.getRightOp();
                                if (right instanceof CastExpr) {
                                    newValue = NullConstant.v();
                                    continue;
                                }
                                newValue = cst.toIntConstant();
                                continue;
                            }
                            if (!(u instanceof IfStmt)) continue;
                            newValue = cst.toIntConstant();
                        }
                    }
                }
                c.r.setValue(newValue);
                continue;
            }
            if (!(r instanceof UntypedLongOrDoubleConstant)) continue;
            Debug.printDbg(false, "[untyped constaints] set type long to constant: " + c, new Object[0]);
            LongConstant newValue = ((UntypedLongOrDoubleConstant)r).toLongConstant();
            c.r.setValue(newValue);
        }
    }

    private void setLocalTyped(Local l, Type t) {
        this.localTyped.put(l, t);
    }

    class Constraint {
        ValueBox l;
        ValueBox r;

        public Constraint(ValueBox l, ValueBox r) {
            this.l = l;
            this.r = r;
        }

        public String toString() {
            return this.l + " < " + this.r;
        }
    }

    class LocalObj {
        ValueBox vb;
        Type t;
        boolean isUse;

        public LocalObj(ValueBox vb, Type t, boolean isUse) {
            this.vb = vb;
            this.t = t;
            this.isUse = isUse;
        }

        public Local getLocal() {
            return (Local)this.vb.getValue();
        }
    }
}

