/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr {
    protected ValueBox[] bsmArgBoxes;
    private SootMethodRef bsmRef;
    protected int tag;

    public GDynamicInvokeExpr(SootMethodRef bootStrapMethodRef, List<Value> bootstrapArgs, SootMethodRef methodRef, int tag, List args) {
        super(methodRef, new ValueBox[args.size()]);
        this.bsmRef = bootStrapMethodRef;
        this.tag = tag;
        int i = 0;
        while (i < args.size()) {
            this.argBoxes[i] = Grimp.v().newExprBox((Value)args.get(i));
            ++i;
        }
        i = 0;
        while (i < bootstrapArgs.size()) {
            this.bsmArgBoxes[i] = Grimp.v().newExprBox(bootstrapArgs.get(i));
            ++i;
        }
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        int i = 0;
        while (i < this.getArgCount()) {
            clonedArgs.add(i, Grimp.cloneIfNecessary(this.getArg(i)));
            ++i;
        }
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.getBootstrapArgCount());
        int i2 = 0;
        while (i2 < this.getBootstrapArgCount()) {
            clonedBsmArgs.add(i2, this.getBootstrapArg(i2));
            ++i2;
        }
        return new GDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public Value getBootstrapArg(int i) {
        return this.bsmArgBoxes[i].getValue();
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GDynamicInvokeExpr) {
            GDynamicInvokeExpr ie = (GDynamicInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            ValueBox[] valueBoxArray = this.argBoxes;
            int n = this.argBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                ValueBox element = valueBoxArray[n2];
                if (!element.getValue().equivTo(element.getValue())) {
                    return false;
                }
                ++n2;
            }
            if (!this.methodRef.equals(ie.methodRef)) {
                return false;
            }
            return this.bsmRef.equals(ie.bsmRef);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        ValueBox[] valueBoxArray = this.bsmArgBoxes;
        int n = this.bsmArgBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            l.add(element.getValue());
            ++n2;
        }
        return l;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("dynamicinvoke");
        buffer.append(" \"");
        buffer.append(this.methodRef.name());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buffer.append(">(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(") ");
        buffer.append(this.bsmRef.getSignature());
        buffer.append("(");
        i = 0;
        while (i < this.bsmArgBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.bsmArgBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("dynamicinvoke");
        up.literal(" \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
            ++i;
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        i = 0;
        while (i < this.bsmArgBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
            ++i;
        }
        up.literal(")");
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

