/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import soot.RefType;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.grimp.GrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.grimp.Precedence;
import soot.grimp.internal.ExprBox;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GNewInvokeExpr
extends AbstractInvokeExpr
implements NewInvokeExpr,
Precedence {
    RefType type;

    public GNewInvokeExpr(RefType type, SootMethodRef methodRef, List args) {
        super(methodRef, new ExprBox[args.size()]);
        if (methodRef != null && methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.methodRef = methodRef;
        this.type = type;
        int i = 0;
        while (i < args.size()) {
            this.argBoxes[i] = Grimp.v().newExprBox((Value)args.get(i));
            ++i;
        }
    }

    @Override
    public RefType getBaseType() {
        return this.type;
    }

    @Override
    public void setBaseType(RefType type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getPrecedence() {
        return 850;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new " + this.type.toString() + "(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("new");
        up.literal(" ");
        up.type(this.type);
        up.literal("(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
            ++i;
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((GrimpValueSwitch)sw).caseNewInvokeExpr(this);
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        int i = 0;
        while (i < this.getArgCount()) {
            clonedArgs.add(i, Grimp.cloneIfNecessary(this.getArg(i)));
            ++i;
        }
        return new GNewInvokeExpr(this.getBaseType(), this.methodRef, clonedArgs);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GNewInvokeExpr) {
            GNewInvokeExpr ie = (GNewInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            ValueBox[] valueBoxArray = this.argBoxes;
            int n = this.argBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                ValueBox element = valueBoxArray[n2];
                if (!element.getValue().equivTo(element.getValue())) {
                    return false;
                }
                ++n2;
            }
            return this.type.equals(ie.type);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }
}

