/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import soot.Body;
import soot.BodyTransformer;
import soot.ByteType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.Inst;
import soot.baf.JSRInst;
import soot.baf.NopInst;
import soot.baf.TargetArgInst;
import soot.baf.ThrowInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jbco.util.ThrowSet;
import soot.jimple.IntConstant;
import soot.jimple.NullConstant;
import soot.util.Chain;

public class IndirectIfJumpsToCaughtGotos
extends BodyTransformer
implements IJbcoTransform {
    int count = 0;
    public static String[] dependancies = new String[]{"bb.jbco_iii", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_iii";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Indirected Ifs through Traps: " + this.count);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        PatchingChain<Unit> units = b.getUnits();
        Unit nonTrap = this.findNonTrappedUnit(units, b.getTraps());
        if (nonTrap == null) {
            Unit last = null;
            nonTrap = Baf.v().newNopInst();
            for (Unit u : units) {
                if (u instanceof IdentityInst && ((IdentityInst)u).getLeftOp() instanceof Local) {
                    last = u;
                    continue;
                }
                if (last != null) {
                    units.insertAfter(nonTrap, last);
                    break;
                }
                units.addFirst(nonTrap);
                break;
            }
        }
        Stack<Type> stack = StackTypeHeightCalculator.getAfterStack(b, nonTrap);
        ArrayList<GotoInst> addedUnits = new ArrayList<GotoInst>();
        Iterator<Unit> it = units.snapshotIterator();
        while (it.hasNext()) {
            Unit u = it.next();
            if (!this.isIf(u) || Rand.getInt(10) > weight) continue;
            TargetArgInst ifu = (TargetArgInst)u;
            GotoInst newTarg = Baf.v().newGotoInst(ifu.getTarget());
            units.add(newTarg);
            ifu.setTarget(newTarg);
            addedUnits.add(newTarg);
        }
        if (addedUnits.size() <= 0) {
            return;
        }
        NopInst nop = Baf.v().newNopInst();
        units.add(nop);
        ArrayList<Unit> toinsert = new ArrayList<Unit>();
        SootField field = null;
        try {
            field = FieldRenamer.getRandomOpaques()[Rand.getInt(2)];
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (field != null && Rand.getInt(3) > 0) {
            toinsert.add(Baf.v().newStaticGetInst(field.makeRef()));
            if (field.getType() instanceof IntegerType) {
                toinsert.add(Baf.v().newIfGeInst(units.getSuccOf(nonTrap)));
            } else {
                SootMethod boolInit = ((RefType)field.getType()).getSootClass().getMethod("boolean booleanValue()");
                toinsert.add(Baf.v().newVirtualInvokeInst(boolInit.makeRef()));
                toinsert.add(Baf.v().newIfGeInst(units.getSuccOf(nonTrap)));
            }
        } else {
            toinsert.add(Baf.v().newPushInst(IntConstant.v(BodyBuilder.getIntegerNine())));
            toinsert.add(Baf.v().newPrimitiveCastInst(IntType.v(), ByteType.v()));
            toinsert.add(Baf.v().newPushInst(IntConstant.v(Rand.getInt() % 2 == 0 ? 9 : 3)));
            toinsert.add(Baf.v().newRemInst(ByteType.v()));
            toinsert.add(Baf.v().newIfEqInst(units.getSuccOf(nonTrap)));
        }
        ArrayList<Inst> toinserttry = new ArrayList<Inst>();
        while (stack.size() > 0) {
            toinserttry.add(Baf.v().newPopInst(stack.pop()));
        }
        toinserttry.add(Baf.v().newPushInst(NullConstant.v()));
        ThrowInst handler = Baf.v().newThrowInst();
        int rand = Rand.getInt(toinserttry.size());
        while (rand++ < toinserttry.size()) {
            toinsert.add((Unit)toinserttry.get(0));
            toinserttry.remove(0);
        }
        if (toinserttry.size() > 0) {
            toinserttry.add(Baf.v().newGotoInst(handler));
            toinsert.add(Baf.v().newGotoInst((Unit)toinserttry.get(0)));
            units.insertBefore((Unit)((Object)toinserttry), (Unit)nop);
        }
        toinsert.add(handler);
        units.insertAfter(toinsert, nonTrap);
        b.getTraps().add(Baf.v().newTrap(ThrowSet.getRandomThrowable(), (Unit)addedUnits.get(0), nop, handler));
        this.count += addedUnits.size();
        if (addedUnits.size() > 0 && debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }

    private Unit findNonTrappedUnit(PatchingChain<Unit> units, Chain<Trap> traps) {
        int intrap = 0;
        ArrayList<Unit> untrapped = new ArrayList<Unit>();
        Iterator<Unit> it = units.snapshotIterator();
        while (it.hasNext()) {
            Unit u = it.next();
            for (Trap t : traps) {
                if (u == t.getBeginUnit()) {
                    ++intrap;
                }
                if (u != t.getEndUnit()) continue;
                --intrap;
            }
            if (intrap != 0) continue;
            untrapped.add(u);
        }
        Unit result = null;
        if (untrapped.size() > 0) {
            int count = 0;
            while (result == null && count < 10) {
                ++count;
                result = (Unit)untrapped.get(Rand.getInt(999999) % untrapped.size());
                if (result.fallsThrough() && units.getSuccOf(result) != null && !(units.getSuccOf(result) instanceof ThrowInst)) continue;
                result = null;
            }
        }
        return result;
    }

    private boolean isIf(Unit u) {
        return u instanceof TargetArgInst && !(u instanceof GotoInst) && !(u instanceof JSRInst);
    }
}

