/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.PrimType;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.baf.Baf;
import soot.baf.IdentityInst;
import soot.baf.IncInst;
import soot.baf.LoadInst;
import soot.baf.StoreInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.Rand;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.ParameterRef;
import soot.util.Chain;

public class LocalsToBitField
extends BodyTransformer
implements IJbcoTransform {
    int replaced = 0;
    int locals = 0;
    public static String[] dependancies = new String[]{"jtp.jbco_jl", "bb.jbco_plvb", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_plvb";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Local fields inserted into bitfield: " + this.replaced);
        out.println("Original number of locals: " + this.locals);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        Chain<Local> bLocals = b.getLocals();
        PatchingChain<Unit> u = b.getUnits();
        Unit first = null;
        ArrayList<Value> params = new ArrayList<Value>();
        for (Unit unit : u) {
            Value v;
            IdentityInst ii;
            if (!(unit instanceof IdentityInst) || !((ii = (IdentityInst)unit).getRightOpBox().getValue() instanceof ParameterRef) || !((v = ii.getLeftOp()) instanceof Local)) continue;
            params.add(v);
            first = unit;
        }
        HashMap<Local, Local> bafToJLocals = new HashMap<Local, Local>();
        block7: for (Local jl : Main.methods2JLocals.get(b.getMethod())) {
            for (Local bl : bLocals) {
                if (!bl.getName().equals(jl.getName())) continue;
                bafToJLocals.put(bl, jl);
                continue block7;
            }
        }
        ArrayList<Local> booleans = new ArrayList<Local>();
        ArrayList<Local> bytes = new ArrayList<Local>();
        ArrayList<Local> chars = new ArrayList<Local>();
        ArrayList<Local> ints = new ArrayList<Local>();
        HashMap<Local, Integer> sizes = new HashMap<Local, Integer>();
        for (Local bl : bLocals) {
            Type t;
            if (params.contains(bl)) continue;
            ++this.locals;
            Local jlocal = (Local)bafToJLocals.get(bl);
            if (jlocal == null || !((t = jlocal.getType()) instanceof PrimType) || t instanceof DoubleType || t instanceof LongType || Rand.getInt(10) > weight) continue;
            if (t instanceof BooleanType) {
                booleans.add(bl);
                sizes.put(bl, new Integer(1));
                continue;
            }
            if (t instanceof ByteType) {
                bytes.add(bl);
                sizes.put(bl, new Integer(8));
                continue;
            }
            if (t instanceof CharType) {
                chars.add(bl);
                sizes.put(bl, new Integer(16));
                continue;
            }
            if (!(t instanceof IntType)) continue;
            ints.add(bl);
            sizes.put(bl, new Integer(32));
        }
        int count = 0;
        HashMap<Local, Local> bafToNewLocs = new HashMap<Local, Local>();
        int total = booleans.size() + bytes.size() * 8 + chars.size() * 16 + ints.size() * 32;
        HashMap newLocs = new HashMap();
        while (total >= 32 && booleans.size() + bytes.size() + chars.size() + ints.size() > 2) {
            Local nloc = Baf.v().newLocal("newDumby" + count++, LongType.v());
            HashMap<Local, Integer> nlocMap = new HashMap<Local, Integer>();
            boolean done = false;
            int index = 0;
            while (index < 64 && !done) {
                int max = 64 - index;
                max = max > 31 ? 4 : (max > 15 ? 3 : (max > 7 ? 2 : 1));
                int rand = Rand.getInt(max);
                max = index;
                switch (rand) {
                    case 3: {
                        Local l;
                        if (ints.size() > 0) {
                            l = (Local)ints.remove(Rand.getInt(ints.size()));
                            nlocMap.put(l, new Integer(index));
                            index += 32;
                            bafToNewLocs.put(l, nloc);
                            index = this.getNewIndex(index, ints, chars, bytes, booleans);
                            break;
                        }
                    }
                    case 2: {
                        Local l;
                        if (chars.size() > 0) {
                            l = (Local)chars.remove(Rand.getInt(chars.size()));
                            nlocMap.put(l, new Integer(index));
                            index += 16;
                            bafToNewLocs.put(l, nloc);
                            index = this.getNewIndex(index, ints, chars, bytes, booleans);
                            break;
                        }
                    }
                    case 1: {
                        Local l;
                        if (bytes.size() > 0) {
                            l = (Local)bytes.remove(Rand.getInt(bytes.size()));
                            nlocMap.put(l, new Integer(index));
                            index += 8;
                            bafToNewLocs.put(l, nloc);
                            index = this.getNewIndex(index, ints, chars, bytes, booleans);
                            break;
                        }
                    }
                    case 0: {
                        if (booleans.size() <= 0) break;
                        Local l = (Local)booleans.remove(Rand.getInt(booleans.size()));
                        nlocMap.put(l, new Integer(index++));
                        bafToNewLocs.put(l, nloc);
                        index = this.getNewIndex(index, ints, chars, bytes, booleans);
                    }
                }
                if (max != index) continue;
                done = true;
            }
            newLocs.put(nloc, nlocMap);
            bLocals.add(nloc);
            if (first != null) {
                u.insertAfter(Baf.v().newStoreInst(LongType.v(), nloc), first);
                u.insertAfter(Baf.v().newPushInst(LongConstant.v(0L)), first);
            } else {
                u.addFirst(Baf.v().newStoreInst(LongType.v(), nloc));
                u.addFirst(Baf.v().newPushInst(LongConstant.v(0L)));
            }
            total = booleans.size() + bytes.size() * 8 + chars.size() * 16 + ints.size() * 32;
        }
        if (bafToNewLocs.size() == 0) {
            return;
        }
        Iterator<Unit> it = u.snapshotIterator();
        while (it.hasNext()) {
            IncInst ii;
            Local bafLoc;
            Local nloc;
            long longmask;
            int size;
            Unit unit = it.next();
            if (unit instanceof StoreInst) {
                StoreInst si = (StoreInst)unit;
                Local bafLoc2 = si.getLocal();
                Local nloc2 = (Local)bafToNewLocs.get(bafLoc2);
                if (nloc2 == null) continue;
                Local jloc = (Local)bafToJLocals.get(bafLoc2);
                int index = (Integer)((Map)newLocs.get(nloc2)).get(bafLoc2);
                size = (Integer)sizes.get(bafLoc2);
                longmask = 0xFFFFFFFFFFFFFFFFL ^ (size == 1 ? 1L : (size == 8 ? 255L : (size == 16 ? 65535L : 0xFFFFFFFFL))) << index;
                u.insertBefore(Baf.v().newPrimitiveCastInst(jloc.getType(), LongType.v()), unit);
                if (index > 0) {
                    u.insertBefore(Baf.v().newPushInst(IntConstant.v(index)), unit);
                    u.insertBefore(Baf.v().newShlInst(LongType.v()), unit);
                }
                u.insertBefore(Baf.v().newPushInst(LongConstant.v(longmask ^ 0xFFFFFFFFFFFFFFFFL)), unit);
                u.insertBefore(Baf.v().newAndInst(LongType.v()), unit);
                u.insertBefore(Baf.v().newLoadInst(LongType.v(), nloc2), unit);
                u.insertBefore(Baf.v().newPushInst(LongConstant.v(longmask)), unit);
                u.insertBefore(Baf.v().newAndInst(LongType.v()), unit);
                u.insertBefore(Baf.v().newXorInst(LongType.v()), unit);
                u.insertBefore(Baf.v().newStoreInst(LongType.v(), nloc2), unit);
                u.remove(unit);
                continue;
            }
            if (unit instanceof LoadInst) {
                LoadInst li = (LoadInst)unit;
                Local bafLoc3 = li.getLocal();
                Local nloc3 = (Local)bafToNewLocs.get(bafLoc3);
                if (nloc3 == null) continue;
                int index = (Integer)((Map)newLocs.get(nloc3)).get(bafLoc3);
                int size2 = (Integer)sizes.get(bafLoc3);
                long longmask2 = (size2 == 1 ? 1L : (size2 == 8 ? 255L : (size2 == 16 ? 65535L : 0xFFFFFFFFL))) << index;
                u.insertBefore(Baf.v().newLoadInst(LongType.v(), nloc3), unit);
                u.insertBefore(Baf.v().newPushInst(LongConstant.v(longmask2)), unit);
                u.insertBefore(Baf.v().newAndInst(LongType.v()), unit);
                if (index > 0) {
                    u.insertBefore(Baf.v().newPushInst(IntConstant.v(index)), unit);
                    u.insertBefore(Baf.v().newShrInst(LongType.v()), unit);
                }
                Type origType = ((Local)bafToJLocals.get(bafLoc3)).getType();
                Type t = this.getType(origType);
                u.insertBefore(Baf.v().newPrimitiveCastInst(LongType.v(), t), unit);
                if (!(origType instanceof IntType) && !(origType instanceof BooleanType)) {
                    u.insertBefore(Baf.v().newPrimitiveCastInst(t, origType), unit);
                }
                u.remove(unit);
                continue;
            }
            if (!(unit instanceof IncInst) || (nloc = (Local)bafToNewLocs.get(bafLoc = (ii = (IncInst)unit).getLocal())) == null) continue;
            Type jlocType = this.getType(((Local)bafToJLocals.get(bafLoc)).getType());
            int index = (Integer)((Map)newLocs.get(nloc)).get(bafLoc);
            size = (Integer)sizes.get(bafLoc);
            longmask = (size == 1 ? 1L : (size == 8 ? 255L : (size == 16 ? 65535L : 0xFFFFFFFFL))) << index;
            u.insertBefore(Baf.v().newPushInst(ii.getConstant()), unit);
            u.insertBefore(Baf.v().newLoadInst(LongType.v(), nloc), unit);
            u.insertBefore(Baf.v().newPushInst(LongConstant.v(longmask)), unit);
            u.insertBefore(Baf.v().newAndInst(LongType.v()), unit);
            if (index > 0) {
                u.insertBefore(Baf.v().newPushInst(IntConstant.v(index)), unit);
                u.insertBefore(Baf.v().newShrInst(LongType.v()), unit);
            }
            u.insertBefore(Baf.v().newPrimitiveCastInst(LongType.v(), ii.getConstant().getType()), unit);
            u.insertBefore(Baf.v().newAddInst(ii.getConstant().getType()), unit);
            u.insertBefore(Baf.v().newPrimitiveCastInst(jlocType, LongType.v()), unit);
            if (index > 0) {
                u.insertBefore(Baf.v().newPushInst(IntConstant.v(index)), unit);
                u.insertBefore(Baf.v().newShlInst(LongType.v()), unit);
            }
            longmask = 0xFFFFFFFFFFFFFFFFL ^ longmask;
            u.insertBefore(Baf.v().newLoadInst(LongType.v(), nloc), unit);
            u.insertBefore(Baf.v().newPushInst(LongConstant.v(longmask)), unit);
            u.insertBefore(Baf.v().newAndInst(LongType.v()), unit);
            u.insertBefore(Baf.v().newXorInst(LongType.v()), unit);
            u.insertBefore(Baf.v().newStoreInst(LongType.v(), nloc), unit);
            u.remove(unit);
        }
        for (Local l : bLocals) {
            if (!bafToNewLocs.containsKey(l)) continue;
            it.remove();
            ++this.replaced;
        }
    }

    private Type getType(Type t) {
        if (t instanceof BooleanType || t instanceof CharType || t instanceof ShortType || t instanceof ByteType) {
            return IntType.v();
        }
        return t;
    }

    private int getNewIndex(int index, List<Local> ints, List<Local> chars, List<Local> bytes, List<Local> booleans) {
        int max = 0;
        if (booleans.size() > 0 && index < 63) {
            max = 64;
        } else if (bytes.size() > 0 && index < 56) {
            max = 57;
        } else if (chars.size() > 0 && index < 48) {
            max = 49;
        } else if (ints.size() > 0 && index < 32) {
            max = 33;
        }
        if (max != 0) {
            int rand = Rand.getInt(4);
            if ((max -= index) > rand) {
                max = rand;
            } else if (max != 1) {
                max = Rand.getInt(max);
            }
            index += max;
        }
        return index;
    }
}

