/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.DoubleType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.DupInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.OpTypeArgInst;
import soot.baf.TargetArgInst;
import soot.baf.internal.BLoadInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.Rand;
import soot.toolkits.graph.BriefUnitGraph;

public class MoveLoadsAboveIfs
extends BodyTransformer
implements IJbcoTransform {
    int movedloads = 0;
    public static String[] dependancies = new String[]{"bb.jbco_rlaii", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_rlaii";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Moved Loads Above Ifs: " + this.movedloads);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        BriefUnitGraph bug = new BriefUnitGraph(b);
        ArrayList<Unit> candidates = new ArrayList<Unit>();
        ArrayList<Unit> visited = new ArrayList<Unit>();
        ArrayList<Unit> worklist = new ArrayList<Unit>();
        worklist.addAll(bug.getHeads());
        while (worklist.size() > 0) {
            Unit u = (Unit)worklist.remove(0);
            if (visited.contains(u)) continue;
            visited.add(u);
            List<Unit> succs = bug.getSuccsOf(u);
            if (u instanceof TargetArgInst && this.checkCandidate(succs, bug)) {
                candidates.add(u);
            }
            int i = 0;
            while (i < succs.size()) {
                Unit o = succs.get(i);
                if (!visited.contains(o)) {
                    worklist.add(o);
                }
                ++i;
            }
        }
        int orig = this.movedloads;
        boolean changed = false;
        PatchingChain<Unit> units = b.getUnits();
        int i = 0;
        while (i < candidates.size()) {
            block19: {
                List<Unit> succs;
                Unit u;
                block20: {
                    BLoadInst clone;
                    block21: {
                        block18: {
                            u = (Unit)candidates.get(i);
                            succs = bug.getSuccsOf(u);
                            clone = (BLoadInst)((BLoadInst)succs.get(0)).clone();
                            if (!(u instanceof IfNonNullInst) && !(u instanceof IfNullInst)) break block18;
                            if (this.category(clone.getOpType()) == 2 || Rand.getInt(10) > weight) break block19;
                            units.insertBefore(clone, u);
                            units.insertBefore(Baf.v().newSwapInst(RefType.v(), clone.getOpType()), u);
                            break block20;
                        }
                        if (!(u instanceof OpTypeArgInst)) break block21;
                        Type t = ((OpTypeArgInst)u).getOpType();
                        if (this.category(t) == 2 || Rand.getInt(10) > weight) break block19;
                        units.insertBefore(clone, u);
                        Type t2 = clone.getOpType();
                        DupInst dup = this.category(t2) == 2 ? Baf.v().newDup2_x2Inst(t2, null, t, t) : Baf.v().newDup1_x2Inst(t2, t, t);
                        units.insertBefore(dup, u);
                        units.insertBefore(Baf.v().newPopInst(t2), u);
                        break block20;
                    }
                    if (this.category(clone.getOpType()) == 2 || Rand.getInt(10) > weight) break block19;
                    units.insertBefore(clone, u);
                    units.insertBefore(Baf.v().newSwapInst(IntType.v(), clone.getOpType()), u);
                }
                ++this.movedloads;
                int j = 0;
                while (j < succs.size()) {
                    Unit suc = succs.get(j);
                    List<Unit> sucPreds = bug.getPredsOf(suc);
                    if (sucPreds.size() > 1) {
                        if (suc == ((TargetArgInst)u).getTarget()) {
                            ((TargetArgInst)u).setTarget(bug.getSuccsOf(suc).get(0));
                        } else {
                            units.insertAfter(Baf.v().newGotoInst(bug.getSuccsOf(suc).get(0)), u);
                        }
                    } else {
                        units.remove(suc);
                    }
                    ++j;
                }
                if (i < candidates.size() - 1) {
                    bug = new BriefUnitGraph(b);
                }
                changed = true;
            }
            ++i;
        }
        if (changed) {
            if (output) {
                out.println(String.valueOf(this.movedloads - orig) + " loads moved above ifs in " + b.getMethod().getSignature());
            }
            if (debug) {
                StackTypeHeightCalculator.calculateStackHeights(b);
            }
        }
    }

    private boolean checkCandidate(List<Unit> succs, BriefUnitGraph bug) {
        if (succs.size() < 2) {
            return false;
        }
        Unit o = succs.get(0);
        int i = 1;
        while (i < succs.size()) {
            if (succs.get(i).getClass() != o.getClass()) {
                return false;
            }
            ++i;
        }
        if (o instanceof BLoadInst) {
            BLoadInst bl = (BLoadInst)o;
            Local l = bl.getLocal();
            int i2 = 1;
            while (i2 < succs.size()) {
                BLoadInst bld = (BLoadInst)succs.get(i2);
                if (bld.getLocal() != l || bug.getPredsOf(bld).size() > 1) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    private int category(Type t) {
        return t instanceof LongType || t instanceof DoubleType ? 2 : 1;
    }
}

