/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.Hierarchy;
import soot.Local;
import soot.PatchingChain;
import soot.PrimType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.jimpleTransformations.ClassRenamer;
import soot.jbco.jimpleTransformations.MethodRenamer;
import soot.jbco.util.BodyBuilder;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.ThisRef;
import soot.util.Chain;

public class BuildIntermediateAppClasses
extends SceneTransformer
implements IJbcoTransform {
    static int newclasses = 0;
    static int newmethods = 0;
    public static String[] dependancies = new String[]{"wjtp.jbco_bapibm"};
    public static String name = "wjtp.jbco_bapibm";

    @Override
    public void outputSummary() {
        out.println("New buffer classes created: " + newclasses);
        out.println("New buffer class methods created: " + newmethods);
    }

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (output) {
            out.println("Building Intermediate Classes...");
        }
        BodyBuilder.retrieveAllBodies();
        Scene scene = G.v().soot_Scene();
        Iterator<SootClass> it = scene.getApplicationClasses().snapshotIterator();
        while (it.hasNext()) {
            Vector<SootMethod> initMethodsToRewrite = new Vector<SootMethod>();
            Hashtable<String, SootMethod> methodsToAdd = new Hashtable<String, SootMethod>();
            SootClass c = it.next();
            SootClass cOrigSuperclass = c.getSuperclass();
            if (output) {
                out.println("Processing " + c.getName() + " with super " + cOrigSuperclass.getName());
            }
            Iterator<SootMethod> mIt = c.methodIterator();
            block3: while (mIt.hasNext()) {
                SootMethod m;
                block21: {
                    m = mIt.next();
                    if (!m.isConcrete()) continue;
                    try {
                        m.getActiveBody();
                    }
                    catch (Exception exc) {
                        if (m.retrieveActiveBody() != null) break block21;
                        throw new RuntimeException(String.valueOf(m.getSignature()) + " has no body. This was not expected dude.");
                    }
                }
                String subSig = m.getSubSignature();
                if (subSig.equals("void main(java.lang.String[])") && m.isPublic() && m.isStatic()) continue;
                if (subSig.indexOf("init>(") > 0) {
                    if (!subSig.startsWith("void <init>(")) continue;
                    initMethodsToRewrite.add(m);
                    continue;
                }
                scene.releaseActiveHierarchy();
                Hierarchy hierarchy = scene.getActiveHierarchy();
                for (SootClass _c : hierarchy.getSuperclassesOfIncluding(cOrigSuperclass)) {
                    if (!_c.isLibraryClass() || !_c.declaresMethod(subSig) || !hierarchy.isVisible(c, _c.getMethod(subSig))) continue;
                    methodsToAdd.put(subSig, m);
                    continue block3;
                }
            }
            if (methodsToAdd.size() <= 0) continue;
            String newName = ClassRenamer.getNewName("");
            ClassRenamer.oldToNewClassNames.put(newName, newName);
            String fullName = String.valueOf(ClassRenamer.getNamePrefix(c.getName())) + newName;
            if (output) {
                out.println("\tBuilding " + fullName);
            }
            SootClass iC = new SootClass(fullName, c.getModifiers() & 0xFFEF);
            Main.IntermediateAppClasses.add(iC);
            iC.setSuperclass(cOrigSuperclass);
            Scene.v().addClass(iC);
            iC.setApplicationClass();
            iC.setInScene(true);
            ThisRef thisRef = new ThisRef(iC.getType());
            Enumeration keys = methodsToAdd.keys();
            while (keys.hasMoreElements()) {
                String sSig = (String)keys.nextElement();
                SootMethod oldM = (SootMethod)methodsToAdd.get(sSig);
                List<Type> paramTypes = oldM.getParameterTypes();
                Type rType = oldM.getReturnType();
                String newMName = MethodRenamer.getNewName();
                SootMethod newM = new SootMethod(newMName, paramTypes, rType, oldM.getModifiers(), oldM.getExceptions());
                iC.addMethod(newM);
                JimpleBody body = Jimple.v().newBody(newM);
                newM.setActiveBody(body);
                Chain<Local> locals = body.getLocals();
                PatchingChain<Unit> units = body.getUnits();
                BodyBuilder.buildParameterLocals(units, locals, paramTypes);
                BodyBuilder.buildThisLocal(units, thisRef, locals);
                if (rType instanceof VoidType) {
                    units.add(Jimple.v().newReturnVoidStmt());
                } else if (rType instanceof PrimType) {
                    units.add(Jimple.v().newReturnStmt(Jimple.v().newCastExpr(IntConstant.v(0), rType)));
                } else {
                    units.add(Jimple.v().newReturnStmt(NullConstant.v()));
                }
                ++newmethods;
                newM = new SootMethod(oldM.getName(), paramTypes, rType, oldM.getModifiers(), oldM.getExceptions());
                iC.addMethod(newM);
                JimpleBody body2 = Jimple.v().newBody(newM);
                newM.setActiveBody(body2);
                Chain<Local> locals2 = body2.getLocals();
                PatchingChain<Unit> units2 = body2.getUnits();
                List<Local> args = BodyBuilder.buildParameterLocals(units2, locals2, paramTypes);
                Local ths = BodyBuilder.buildThisLocal(units2, thisRef, locals2);
                if (rType instanceof VoidType) {
                    units2.add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(ths, newM.makeRef(), args)));
                    units2.add(Jimple.v().newReturnVoidStmt());
                } else {
                    Local loc = Jimple.v().newLocal("retValue", rType);
                    body2.getLocals().add(loc);
                    units2.add(Jimple.v().newAssignStmt(loc, Jimple.v().newVirtualInvokeExpr(ths, newM.makeRef(), args)));
                    units2.add(Jimple.v().newReturnStmt(loc));
                }
                ++newmethods;
            }
            c.setSuperclass(iC);
            int i = initMethodsToRewrite.size();
            while (i-- > 0) {
                SootMethod im = (SootMethod)initMethodsToRewrite.remove(i);
                Body b = im.getActiveBody();
                Local thisLocal = b.getThisLocal();
                Iterator<Unit> uIt = b.getUnits().snapshotIterator();
                while (uIt.hasNext()) {
                    Iterator<ValueBox> uUses = uIt.next().getUseBoxes().iterator();
                    while (uUses.hasNext()) {
                        Value v = uUses.next().getValue();
                        if (!(v instanceof SpecialInvokeExpr)) continue;
                        SpecialInvokeExpr sie = (SpecialInvokeExpr)v;
                        SootMethodRef smr = sie.getMethodRef();
                        if (!sie.getBase().equivTo(thisLocal) || !smr.declaringClass().getName().equals(cOrigSuperclass.getName()) || !smr.getSubSignature().getString().startsWith("void <init>")) continue;
                        SootMethod newSuperInit = null;
                        if (!iC.declaresMethod("<init>", smr.parameterTypes())) {
                            List<Type> paramTypes = smr.parameterTypes();
                            newSuperInit = new SootMethod("<init>", paramTypes, smr.returnType());
                            iC.addMethod(newSuperInit);
                            JimpleBody body = Jimple.v().newBody(newSuperInit);
                            newSuperInit.setActiveBody(body);
                            PatchingChain<Unit> initUnits = body.getUnits();
                            Chain<Local> locals = body.getLocals();
                            List<Local> args = BodyBuilder.buildParameterLocals(initUnits, locals, paramTypes);
                            Local ths = BodyBuilder.buildThisLocal(initUnits, thisRef, locals);
                            initUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(ths, smr, args)));
                            initUnits.add(Jimple.v().newReturnVoidStmt());
                        } else {
                            newSuperInit = iC.getMethod("<init>", smr.parameterTypes());
                        }
                        sie.setMethodRef(newSuperInit.makeRef());
                    }
                }
            }
        }
        newclasses = Main.IntermediateAppClasses.size();
        scene.releaseActiveHierarchy();
        scene.getActiveHierarchy();
        scene.setFastHierarchy(new FastHierarchy());
    }
}

