/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.BooleanType;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;

public class FieldRenamer
extends SceneTransformer
implements IJbcoTransform {
    public static String[] dependancies = new String[]{"wjtp.jbco_fr"};
    public static String name = "wjtp.jbco_fr";
    private static final char[][] stringChars = new char[][]{{'S', '5', '$'}, {'l', '1', 'I'}, {'_'}};
    public static Vector<String> namesToNotRename = new Vector();
    public static Hashtable<String, String> oldToNewFieldNames = new Hashtable();
    public static Hashtable<SootClass, SootField> opaquePreds1ByClass = new Hashtable();
    public static Hashtable<SootClass, SootField> opaquePreds2ByClass = new Hashtable();
    public static ArrayList<SootField> sootFieldsRenamed = new ArrayList();
    public static SootField[][] opaquePairs = null;
    public static int[] handedOutPairs = null;
    public static int[] handedOutRunPairs = null;
    public static boolean rename_fields = false;
    RefType boolRef;

    @Override
    public void outputSummary() {
    }

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        Scene scene = G.v().soot_Scene();
        this.boolRef = scene.getRefType("java.lang.Boolean");
        if (output) {
            if (rename_fields) {
                out.println("Transforming Field Names and Adding Opaque Predicates...");
            } else {
                out.println("Adding Opaques...");
            }
        }
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        for (SootClass c : scene.getApplicationClasses()) {
            String cName = c.getName();
            if (cName.indexOf(".") >= 0) {
                cName = cName.substring(cName.lastIndexOf(".") + 1, cName.length());
            }
            oldToNewFieldNames.put(cName, cName);
            if (rename_fields) {
                if (output) {
                    out.println("\tClassName: " + cName);
                }
                for (SootField f : c.getFields()) {
                    int weight = Main.getWeight(phaseName, f.getName());
                    if (weight <= 0) continue;
                    this.renameField(cName, f);
                }
            }
            if (c.isInterface()) continue;
            String bool = "opPred1";
            Type t = Rand.getInt() % 2 == 0 ? BooleanType.v() : this.boolRef;
            while (oldToNewFieldNames.containsKey(bool)) {
                bool = String.valueOf(bool) + "_";
            }
            SootField f = new SootField(bool, t, 9);
            this.renameField(cName, f);
            opaquePreds1ByClass.put(c, f);
            c.addField(f);
            this.setBooleanTo(c, f, true);
            bool = "opPred2";
            t = t == BooleanType.v() ? this.boolRef : BooleanType.v();
            while (oldToNewFieldNames.containsKey(bool)) {
                bool = String.valueOf(bool) + "_";
            }
            f = new SootField(bool, t, 9);
            this.renameField(cName, f);
            opaquePreds2ByClass.put(c, f);
            c.addField(f);
            if (t != this.boolRef) continue;
            this.setBooleanTo(c, f, false);
        }
        this.buildOpaquePairings();
        if (!rename_fields) {
            return;
        }
        if (output) {
            out.println("\r\tUpdating field references in bytecode");
        }
        for (SootClass c : scene.getApplicationClasses()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete()) continue;
                if (!m.hasActiveBody()) {
                    m.retrieveActiveBody();
                }
                for (Unit u : m.getActiveBody().getUnits()) {
                    for (ValueBox vb : u.getUseAndDefBoxes()) {
                        FieldRef fr;
                        SootFieldRef sfr;
                        Value v = vb.getValue();
                        if (!(v instanceof FieldRef) || (sfr = (fr = (FieldRef)v).getFieldRef()).declaringClass().isLibraryClass()) continue;
                        String oldName = sfr.name();
                        String fullName = String.valueOf(sfr.declaringClass().getName()) + '.' + oldName;
                        String newName = oldToNewFieldNames.get(oldName);
                        if (newName == null || namesToNotRename.contains(fullName)) continue;
                        if (newName.equals(oldName)) {
                            System.out.println("Strange.. Should not find a field with the same old and new name.");
                        }
                        sfr = scene.makeFieldRef(sfr.declaringClass(), newName, sfr.type(), sfr.isStatic());
                        fr.setFieldRef(sfr);
                        try {
                            sfr.resolve();
                        }
                        catch (Exception exc) {
                            System.out.println("********ERROR Updating " + sfr.name() + " to " + newName);
                            System.out.println("Fields of " + sfr.declaringClass().getName() + ": " + sfr.declaringClass().getFields());
                            System.out.println(exc);
                            throw new RuntimeException(exc);
                        }
                    }
                }
            }
        }
    }

    protected void setBooleanTo(SootClass c, SootField f, boolean value) {
        SootMethod m;
        if (!value && f.getType() instanceof IntegerType && Rand.getInt() % 2 > 0) {
            return;
        }
        Body b = null;
        boolean newInit = false;
        if (!c.declaresMethodByName("<clinit>")) {
            m = new SootMethod("<clinit>", Collections.<Type>emptyList(), VoidType.v());
            c.addMethod(m);
            b = Jimple.v().newBody(m);
            m.setActiveBody(b);
            newInit = true;
        } else {
            m = c.getMethodByName("<clinit>");
            b = m.getActiveBody();
        }
        PatchingChain<Unit> units = b.getUnits();
        if (f.getType() instanceof IntegerType) {
            units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(f.makeRef()), IntConstant.v(value ? 1 : 0)));
        } else {
            Local bool = Jimple.v().newLocal("boolLcl", this.boolRef);
            b.getLocals().add(bool);
            SootMethod boolInit = this.boolRef.getSootClass().getMethod("void <init>(boolean)");
            units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(f.makeRef()), bool));
            units.addFirst(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(bool, boolInit.makeRef(), (Value)IntConstant.v(value ? 1 : 0))));
            units.addFirst(Jimple.v().newAssignStmt(bool, Jimple.v().newNewExpr(this.boolRef)));
        }
        if (newInit) {
            units.addLast(Jimple.v().newReturnVoidStmt());
        }
    }

    protected void renameField(String cName, SootField f) {
        if (sootFieldsRenamed.contains(f)) {
            return;
        }
        String newName = oldToNewFieldNames.get(f.getName());
        if (newName == null) {
            newName = FieldRenamer.getNewName();
            oldToNewFieldNames.put(f.getName(), newName);
        }
        if (output) {
            G.v().out.println("\t\tChanged " + f.getName() + " to " + newName);
        }
        f.setName(newName);
        sootFieldsRenamed.add(f);
    }

    public static String getNewName() {
        int size = 3;
        int tries = 0;
        int index = Rand.getInt(stringChars.length);
        int length = stringChars[index].length;
        String result = null;
        char[] cNewName = new char[size];
        do {
            int i;
            if (tries == 10) {
                cNewName = new char[++size];
                index = Rand.getInt(stringChars.length);
                length = stringChars[index].length;
                tries = 0;
            }
            if (size < 12) {
                do {
                    int rand = Rand.getInt(length);
                    cNewName[0] = stringChars[index][rand];
                } while (!Character.isJavaIdentifierStart(cNewName[0]));
                i = 1;
                while (i < cNewName.length) {
                    int rand = Rand.getInt(length);
                    cNewName[i] = stringChars[index][rand];
                    ++i;
                }
                result = String.copyValueOf(cNewName);
            } else {
                cNewName = new char[size - 6];
                do {
                    i = 0;
                    while (i < cNewName.length) {
                        cNewName[i] = (char)Rand.getInt();
                        ++i;
                    }
                } while (!FieldRenamer.isJavaIdentifier(result = String.copyValueOf(cNewName)));
            }
            ++tries;
        } while (oldToNewFieldNames.containsValue(result) || BodyBuilder.nameList.contains(result));
        BodyBuilder.nameList.add(result);
        return result;
    }

    public static void addOldAndNewName(String oldn, String newn) {
        oldToNewFieldNames.put(oldn, newn);
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static SootField[] getRandomOpaques() {
        if (handedOutPairs == null) {
            handedOutPairs = new int[opaquePairs.length];
        }
        int lowValue = 99999;
        ArrayList<Integer> available = new ArrayList<Integer>();
        int[] nArray = handedOutPairs;
        int n = handedOutPairs.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (lowValue > element) {
                lowValue = element;
            }
            ++n2;
        }
        int i = 0;
        while (i < handedOutPairs.length) {
            if (handedOutPairs[i] == lowValue) {
                available.add(new Integer(i));
            }
            ++i;
        }
        Integer index = (Integer)available.get(Rand.getInt(available.size()));
        int n3 = index;
        handedOutPairs[n3] = handedOutPairs[n3] + 1;
        return opaquePairs[index];
    }

    public static int getRandomOpaquesForRunnable() {
        if (handedOutRunPairs == null) {
            handedOutRunPairs = new int[opaquePairs.length];
        }
        int lowValue = 99999;
        ArrayList<Integer> available = new ArrayList<Integer>();
        int[] nArray = handedOutRunPairs;
        int n = handedOutRunPairs.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (lowValue > element) {
                lowValue = element;
            }
            ++n2;
        }
        if (lowValue > 2) {
            return -1;
        }
        int i = 0;
        while (i < handedOutRunPairs.length) {
            if (handedOutRunPairs[i] == lowValue) {
                available.add(new Integer(i));
            }
            ++i;
        }
        Integer index = (Integer)available.get(Rand.getInt(available.size()));
        return index;
    }

    public static void updateOpaqueRunnableCount(int i) {
        int n = i;
        handedOutRunPairs[n] = handedOutRunPairs[n] + 1;
    }

    private void buildOpaquePairings() {
        int i;
        Object[] fields1 = opaquePreds1ByClass.values().toArray();
        Object[] fields2 = opaquePreds2ByClass.values().toArray();
        int leng = fields1.length;
        if (leng > 1) {
            i = leng * 2;
            while (i > 1) {
                int rand1 = Rand.getInt(leng);
                int rand2 = Rand.getInt(leng);
                int rand3 = Rand.getInt(leng);
                int rand4 = Rand.getInt(leng);
                while (rand1 == rand2) {
                    rand2 = Rand.getInt(leng);
                }
                while (rand3 == rand4) {
                    rand4 = Rand.getInt(leng);
                }
                Object value = fields1[rand1];
                fields1[rand1] = fields1[rand2];
                fields1[rand2] = value;
                value = fields2[rand3];
                fields2[rand3] = fields2[rand4];
                fields2[rand4] = value;
                --i;
            }
        }
        opaquePairs = new SootField[leng][2];
        i = 0;
        while (i < leng) {
            FieldRenamer.opaquePairs[i] = new SootField[]{(SootField)fields1[i], (SootField)fields2[i]};
            ++i;
        }
    }
}

