/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.Rand;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.util.Chain;

public class GotoInstrumenter
extends BodyTransformer
implements IJbcoTransform {
    private int trapsAdded = 0;
    private int gotosInstrumented = 0;
    public static String[] dependancies = new String[]{"jtp.jbco_gia"};
    public static String name = "jtp.jbco_gia";
    static boolean verbose = G.v().soot_options_Options().verbose();

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Gotos Instrumented " + this.gotosInstrumented);
        out.println("Traps Added " + this.trapsAdded);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (b.getMethod().getName().indexOf("<init>") >= 0) {
            return;
        }
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        PatchingChain<Unit> units = b.getUnits();
        int size = units.size();
        Object first = null;
        for (Unit o : units) {
            if (!(o instanceof IdentityStmt)) break;
            first = o;
            --size;
        }
        if (size < 8) {
            return;
        }
        if (first == null) {
            first = units.getFirst();
        }
        Chain<Trap> traps = b.getTraps();
        int i = 0;
        int rand = 0;
        while (i++ < 10) {
            rand = Rand.getInt(size);
            if (rand < 1) {
                rand = 1;
            } else if (rand == size - 1) {
                rand = size - 2;
            }
            if (!this.isExceptionCaughtAt(units, rand + (units.size() - size), traps.iterator())) break;
        }
        if (i >= 10) {
            return;
        }
        i = 0;
        if (output) {
            out.println("Applying Gotos to " + b.getMethod().getName());
        }
        Object u = first = units.getSuccOf((Unit)first);
        do {
            Object[] toU;
            Object[] objectArray = toU = u.getBoxesPointingToThis().toArray();
            int n = toU.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                u.removeBoxPointingToThis((UnitBox)element);
                ++n2;
            }
            Unit u2 = units.getSuccOf((Unit)u);
            units.remove(u);
            units.add((Unit)u);
            Object[] objectArray2 = toU;
            int n3 = toU.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray2[n];
                u.addBoxPointingToThis((UnitBox)element);
                ++n;
            }
            u = u2;
        } while (++i < rand);
        Object oldFirst = first;
        if (first instanceof GotoStmt) {
            oldFirst = ((GotoStmt)first).getTargetBox().getUnit();
            first = Jimple.v().newGotoStmt(((GotoStmt)first).getTargetBox().getUnit());
        } else {
            first = Jimple.v().newGotoStmt((Unit)first);
        }
        units.insertBeforeNoRedirect((Unit)first, (Unit)u);
        if (units.getLast().fallsThrough()) {
            GotoStmt gtS = null;
            gtS = u instanceof GotoStmt ? Jimple.v().newGotoStmt(((GotoStmt)u).getTargetBox().getUnit()) : Jimple.v().newGotoStmt((Unit)u);
            units.add(gtS);
        }
        RefType throwable = G.v().soot_Scene().getRefType("java.lang.Throwable");
        CaughtExceptionRef cexc = Jimple.v().newCaughtExceptionRef();
        Local excLocal = Jimple.v().newLocal("jbco_gi_caughtExceptionLocal", throwable);
        b.getLocals().add(excLocal);
        IdentityStmt handler = Jimple.v().newIdentityStmt(excLocal, cexc);
        units.add(handler);
        units.add(Jimple.v().newThrowStmt(excLocal));
        Unit trapEnd = units.getSuccOf((Unit)oldFirst);
        try {
            while (trapEnd instanceof IdentityStmt) {
                trapEnd = units.getSuccOf(trapEnd);
            }
            trapEnd = units.getSuccOf(trapEnd);
            b.getTraps().add(Jimple.v().newTrap(throwable.getSootClass(), units.getPredOf((Unit)oldFirst), trapEnd, handler));
            ++this.trapsAdded;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.gotosInstrumented;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isExceptionCaughtAt(Chain<Unit> units, int idx, Iterator<Trap> trapsIt) {
        u = null;
        it = units.iterator();
        while (it.hasNext()) {
            if (idx-- == 0) {
                u = it.next();
                break;
            }
            it.next();
        }
        if (u != null) ** GOTO lbl19
        return false;
lbl-1000:
        // 1 sources

        {
            t = trapsIt.next();
            it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                if (!u.equals(it.next())) continue;
                return true;
            }
            if (!t.getEndUnit().equals(u)) continue;
            return true;
lbl19:
            // 2 sources

            ** while (trapsIt.hasNext())
        }
lbl20:
        // 1 sources

        return false;
    }
}

