/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FastHierarchy;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Chain;

public class LibraryMethodWrappersBuilder
extends SceneTransformer
implements IJbcoTransform {
    public static String[] dependancies = new String[]{"wjtp.jbco_blbc"};
    public static String name = "wjtp.jbco_blbc";
    private static int newmethods = 0;
    private static int methodcalls = 0;
    private static final Map<SootClass, Map<SootMethod, SootMethodRef>> libClassesToMethods = new HashMap<SootClass, Map<SootMethod, SootMethodRef>>();
    private static final Scene scene = G.v().soot_Scene();
    public static ArrayList<SootMethod> builtByMe = new ArrayList();

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("New Methods Created: " + newmethods);
        out.println("Method Calls Replaced: " + methodcalls);
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (output) {
            out.println("Building Library Wrapper Methods...");
        }
        BodyBuilder.retrieveAllBodies();
        Iterator<SootClass> it = scene.getApplicationClasses().snapshotIterator();
        while (it.hasNext()) {
            SootClass c = it.next();
            if (output) {
                out.println("\r\tProcessing " + c.getName() + "\r");
            }
            List<SootMethod> mList = c.getMethods();
            int midx = 0;
            while (midx < mList.size()) {
                SootMethod m = mList.get(midx);
                if (m.isConcrete() && !builtByMe.contains(m)) {
                    Body body = null;
                    try {
                        body = m.getActiveBody();
                    }
                    catch (Exception exc) {
                        body = m.retrieveActiveBody();
                    }
                    if (body != null) {
                        Unit unit;
                        int localName = 0;
                        Chain<Local> locals = body.getLocals();
                        PatchingChain<Unit> units = body.getUnits();
                        Unit first = null;
                        Iterator<Unit> uIt = units.snapshotIterator();
                        while (uIt.hasNext()) {
                            unit = uIt.next();
                            if (unit instanceof IdentityStmt) continue;
                            first = unit;
                            break;
                        }
                        uIt = units.snapshotIterator();
                        while (uIt.hasNext()) {
                            unit = uIt.next();
                            List<ValueBox> uses = unit.getUseBoxes();
                            int i = 0;
                            while (i < uses.size()) {
                                ValueBox vb = uses.get(i);
                                Value v = vb.getValue();
                                if (v instanceof InvokeExpr) {
                                    InvokeExpr ie = (InvokeExpr)v;
                                    SootMethod sm = null;
                                    try {
                                        sm = ie.getMethod();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        // empty catch block
                                    }
                                    SootClass dc = sm.getDeclaringClass();
                                    if (!sm.getName().endsWith("init>") && dc.isLibraryClass()) {
                                        SootMethodRef smr;
                                        if (output) {
                                            out.print("\t\t\tChanging " + sm.getSignature());
                                        }
                                        if ((smr = this.getNewMethodRef(dc, sm)) == null) {
                                            try {
                                                smr = this.buildNewMethod(c, dc, sm, ie);
                                                this.setNewMethodRef(dc, sm, smr);
                                                ++newmethods;
                                            }
                                            catch (Exception exc) {
                                                smr = null;
                                            }
                                        }
                                        if (smr != null) {
                                            Local newLocal;
                                            Type pType;
                                            if (output) {
                                                out.println(" to " + smr.getSignature() + "\tUnit: " + unit);
                                            }
                                            List<Value> args = ie.getArgs();
                                            List<Type> parms = smr.parameterTypes();
                                            int argsCount = args.size();
                                            int paramCount = parms.size();
                                            if (ie instanceof StaticInvokeExpr) {
                                                while (argsCount < paramCount) {
                                                    pType = parms.get(argsCount);
                                                    newLocal = Jimple.v().newLocal("newLocal" + localName++, pType);
                                                    locals.add(newLocal);
                                                    units.insertBeforeNoRedirect(Jimple.v().newAssignStmt(newLocal, LibraryMethodWrappersBuilder.getConstantType(pType)), first);
                                                    args.add(newLocal);
                                                    ++argsCount;
                                                }
                                                vb.setValue(Jimple.v().newStaticInvokeExpr(smr, args));
                                            } else if (ie instanceof InstanceInvokeExpr) {
                                                ++argsCount;
                                                args.add(((InstanceInvokeExpr)ie).getBase());
                                                while (argsCount < paramCount) {
                                                    pType = parms.get(argsCount);
                                                    newLocal = Jimple.v().newLocal("newLocal" + localName++, pType);
                                                    locals.add(newLocal);
                                                    units.insertBeforeNoRedirect(Jimple.v().newAssignStmt(newLocal, LibraryMethodWrappersBuilder.getConstantType(pType)), first);
                                                    args.add(newLocal);
                                                    ++argsCount;
                                                }
                                                vb.setValue(Jimple.v().newStaticInvokeExpr(smr, args));
                                            }
                                            ++methodcalls;
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                ++midx;
            }
        }
        scene.releaseActiveHierarchy();
        scene.getActiveHierarchy();
        scene.setFastHierarchy(new FastHierarchy());
    }

    private SootMethodRef getNewMethodRef(SootClass libClass, SootMethod sm) {
        Map<SootMethod, SootMethodRef> methods = libClassesToMethods.get(libClass);
        if (methods == null) {
            libClassesToMethods.put(libClass, new HashMap());
            return null;
        }
        return methods.get(sm);
    }

    private void setNewMethodRef(SootClass libClass, SootMethod sm, SootMethodRef smr) {
        Map<SootMethod, SootMethodRef> methods = libClassesToMethods.get(libClass);
        if (methods == null) {
            methods = new HashMap<SootMethod, SootMethodRef>();
            libClassesToMethods.put(libClass, methods);
        }
        methods.put(sm, smr);
    }

    private SootMethodRef buildNewMethod(SootClass fromC, SootClass libClass, SootMethod sm, InvokeExpr origIE) {
        SootMethod similarM;
        int index;
        SootClass randClass;
        List<SootMethod> methods;
        SootMethod randMethod;
        String newName;
        Vector<SootClass> availClasses = new Vector<SootClass>();
        for (SootClass c : scene.getApplicationClasses()) {
            if (!c.isConcrete() || c.isInterface() || !c.isPublic()) continue;
            availClasses.add(c);
        }
        int classCount = availClasses.size();
        if (classCount == 0) {
            throw new RuntimeException("There appears to be no public non-interface Application classes!");
        }
        do {
            if ((randClass = (SootClass)availClasses.get(index = Rand.getInt(classCount))) != fromC || classCount <= 1) continue;
            index = Rand.getInt(classCount);
            randClass = (SootClass)availClasses.get(index);
        } while ((newName = (randMethod = (methods = randClass.getMethods()).get(index = Rand.getInt(methods.size()))).getName()).endsWith("init>"));
        List<Type> smParamTypes = sm.getParameterTypes();
        ArrayList<Type> tmp = new ArrayList<Type>();
        if (!sm.isStatic()) {
            int i = 0;
            while (i < smParamTypes.size()) {
                tmp.add(smParamTypes.get(i));
                ++i;
            }
            tmp.add(libClass.getType());
            smParamTypes = tmp;
        } else {
            tmp.addAll(smParamTypes);
            smParamTypes = tmp;
        }
        int extraParams = 0;
        do {
            similarM = null;
            try {
                similarM = randClass.getMethod(newName, smParamTypes);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (similarM == null) continue;
            int rtmp = Rand.getInt(classCount + 7);
            if (rtmp >= classCount) {
                smParamTypes.add(LibraryMethodWrappersBuilder.getPrimType(rtmp -= classCount));
            } else {
                smParamTypes.add(((SootClass)availClasses.get(rtmp)).getType());
            }
            ++extraParams;
        } while (similarM != null);
        int mods = (sm.getModifiers() | 8 | 1) & 0xFBFF & 0xFEFF & 0xFFDF;
        SootMethod newMethod = new SootMethod(newName, smParamTypes, sm.getReturnType(), mods);
        randClass.addMethod(newMethod);
        JimpleBody body = Jimple.v().newBody(newMethod);
        newMethod.setActiveBody(body);
        PatchingChain<Unit> units = body.getUnits();
        Chain<Local> locals = body.getLocals();
        InvokeExpr ie = null;
        List<Local> args = BodyBuilder.buildParameterLocals(units, locals, smParamTypes);
        while (extraParams-- > 0) {
            args.remove(args.size() - 1);
        }
        if (sm.isStatic()) {
            ie = Jimple.v().newStaticInvokeExpr(sm.makeRef(), args);
        } else {
            Local libObj = args.remove(args.size() - 1);
            if (origIE instanceof InterfaceInvokeExpr) {
                ie = Jimple.v().newInterfaceInvokeExpr(libObj, sm.makeRef(), args);
            } else if (origIE instanceof SpecialInvokeExpr) {
                ie = Jimple.v().newSpecialInvokeExpr(libObj, sm.makeRef(), args);
            } else if (origIE instanceof VirtualInvokeExpr) {
                ie = Jimple.v().newVirtualInvokeExpr(libObj, sm.makeRef(), args);
            }
        }
        if (sm.getReturnType() instanceof VoidType) {
            units.add(Jimple.v().newInvokeStmt(ie));
            units.add(Jimple.v().newReturnVoidStmt());
        } else {
            Local assign = Jimple.v().newLocal("returnValue", sm.getReturnType());
            locals.add(assign);
            units.add(Jimple.v().newAssignStmt(assign, ie));
            units.add(Jimple.v().newReturnStmt(assign));
        }
        if (output) {
            out.println("\r" + sm.getName() + " was replaced by \r\t" + newMethod.getName() + " which calls \r\t\t" + ie);
        }
        if (units.size() < 2) {
            out.println("\r\rTHERE AREN'T MANY UNITS IN THIS METHOD " + units);
        }
        builtByMe.add(newMethod);
        return newMethod.makeRef();
    }

    private static Type getPrimType(int idx) {
        switch (idx) {
            case 0: {
                return IntType.v();
            }
            case 1: {
                return CharType.v();
            }
            case 2: {
                return ByteType.v();
            }
            case 3: {
                return LongType.v();
            }
            case 4: {
                return BooleanType.v();
            }
            case 5: {
                return DoubleType.v();
            }
            case 6: {
                return FloatType.v();
            }
        }
        return IntType.v();
    }

    private static Value getConstantType(Type t) {
        if (t instanceof BooleanType) {
            return IntConstant.v(Rand.getInt(1));
        }
        if (t instanceof IntType) {
            return IntConstant.v(Rand.getInt());
        }
        if (t instanceof CharType) {
            return Jimple.v().newCastExpr(IntConstant.v(Rand.getInt()), CharType.v());
        }
        if (t instanceof ByteType) {
            return Jimple.v().newCastExpr(IntConstant.v(Rand.getInt()), ByteType.v());
        }
        if (t instanceof LongType) {
            return LongConstant.v(Rand.getLong());
        }
        if (t instanceof FloatType) {
            return FloatConstant.v(Rand.getFloat());
        }
        if (t instanceof DoubleType) {
            return DoubleConstant.v(Rand.getDouble());
        }
        return Jimple.v().newCastExpr(NullConstant.v(), t);
    }
}

