/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.Hierarchy;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.InvokeExpr;

public class MethodRenamer
extends SceneTransformer
implements IJbcoTransform {
    public static String[] dependancies = new String[]{"wjtp.jbco_mr"};
    public static String name = "wjtp.jbco_mr";
    private static final char[][] stringChars = new char[][]{{'S', '5', '$'}, {'l', '1', 'I'}, {'_'}};
    public static Vector<?> namesToNotRename = new Vector();
    public static HashMap<String, String> oldToNewMethodNames = new HashMap();
    private static Hierarchy hierarchy;

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (output) {
            out.println("Transforming Method Names...");
        }
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        Scene scene = G.v().soot_Scene();
        scene.releaseActiveHierarchy();
        hierarchy = scene.getActiveHierarchy();
        for (SootClass c : scene.getApplicationClasses()) {
            Vector<String> fields = new Vector<String>();
            Iterator<SootField> fIt = c.getFields().iterator();
            while (fIt.hasNext()) {
                fields.add(fIt.next().getName());
            }
            for (SootMethod m : c.getMethods()) {
                String subSig = m.getSubSignature();
                if (!MethodRenamer.allowsRename(c, m)) continue;
                boolean rename = true;
                for (SootClass _c : hierarchy.getSuperclassesOfIncluding(c.getSuperclass())) {
                    if (!_c.declaresMethod(subSig) || !hierarchy.isVisible(c, _c.getMethod(subSig)) || !_c.isLibraryClass()) continue;
                    if (output) {
                        out.println("\t" + _c.getName() + "'s method " + subSig + " is overridden in " + c.getName());
                    }
                    rename = false;
                    break;
                }
                if (!rename) continue;
                String newName = oldToNewMethodNames.get(m.getName());
                if (newName == null) {
                    if (fields.size() > 0) {
                        int rand = Rand.getInt(fields.size());
                        newName = (String)fields.remove(rand);
                        if (oldToNewMethodNames.containsValue(newName)) {
                            newName = MethodRenamer.getNewName();
                        }
                    } else {
                        newName = MethodRenamer.getNewName();
                    }
                }
                oldToNewMethodNames.put(m.getName(), newName);
                if (output) {
                    out.println("\tChanged " + m.getSignature() + " to " + newName);
                }
                m.setName(newName);
            }
        }
        for (SootClass c : scene.getApplicationClasses()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete() || m.getDeclaringClass().isLibraryClass()) continue;
                Body aBody = null;
                try {
                    aBody = m.getActiveBody();
                }
                catch (Exception exc) {
                    continue;
                }
                Iterator<Unit> uIt = aBody.getUnits().iterator();
                while (uIt.hasNext()) {
                    Iterator<ValueBox> ubIt = uIt.next().getUseBoxes().iterator();
                    while (ubIt.hasNext()) {
                        Value v = ubIt.next().getValue();
                        if (!(v instanceof InvokeExpr)) continue;
                        InvokeExpr ie = (InvokeExpr)v;
                        try {
                            ie.getMethod();
                        }
                        catch (Exception rand) {
                            SootMethodRef r = ie.getMethodRef();
                            String newName = oldToNewMethodNames.get(r.name());
                            if (newName == null) continue;
                            r = scene.makeMethodRef(r.declaringClass(), newName, r.parameterTypes(), r.returnType(), r.isStatic());
                            ie.setMethodRef(r);
                        }
                    }
                }
            }
        }
        scene.releaseActiveHierarchy();
        scene.getActiveHierarchy();
        scene.setFastHierarchy(new FastHierarchy());
    }

    public static String getNewName() {
        int size = 5;
        int tries = 0;
        int index = Rand.getInt(stringChars.length);
        int length = stringChars[index].length;
        String result = null;
        char[] cNewName = new char[size];
        do {
            if (tries == size) {
                cNewName = new char[++size];
                tries = 0;
            }
            do {
                cNewName[0] = stringChars[index][Rand.getInt(length)];
            } while (!Character.isJavaIdentifierStart(cNewName[0]));
            int i = 1;
            while (i < cNewName.length) {
                int rand = Rand.getInt(length);
                cNewName[i] = stringChars[index][rand];
                ++i;
            }
            result = String.copyValueOf(cNewName);
            ++tries;
        } while (oldToNewMethodNames.containsValue(result) || BodyBuilder.nameList.contains(result));
        BodyBuilder.nameList.add(result);
        return result;
    }

    private static boolean allowsRename(SootClass c, SootMethod m) {
        if (Main.getWeight(name, m.getName()) == 0) {
            return false;
        }
        String subSig = m.getSubSignature();
        if (subSig.equals("void main(java.lang.String[])") && m.isPublic() && m.isStatic()) {
            return false;
        }
        if (subSig.indexOf("void <init>(") >= 0 || subSig.equals("void <clinit>()")) {
            return false;
        }
        for (SootClass _c : hierarchy.getSuperclassesOfIncluding(c.getSuperclass())) {
            if (!_c.isLibraryClass() || !_c.declaresMethod(subSig) || !hierarchy.isVisible(c, _c.getMethod(subSig))) continue;
            return false;
        }
        do {
            if (!MethodRenamer.checkInterfacesForMethod(c, m)) continue;
            return false;
        } while (c.hasSuperclass() && (c = c.getSuperclass()) != null);
        return true;
    }

    private static boolean checkInterfacesForMethod(SootClass c, SootMethod m) {
        for (SootClass sc : c.getInterfaces()) {
            if (!sc.isLibraryClass() || !sc.declaresMethod(m.getName(), m.getParameterTypes(), m.getReturnType())) continue;
            return true;
        }
        return false;
    }
}

