/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.jimple.infoflow.BiDirICFGFactory;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.solver.IInfoflowCFG;
import soot.jimple.infoflow.solver.InfoflowCFG;
import soot.jimple.toolkits.ide.icfg.OnTheFlyJimpleBasedICFG;

public class DefaultBiDiICFGFactory
implements BiDirICFGFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public IInfoflowCFG buildBiDirICFG(IInfoflow.CallgraphAlgorithm callgraphAlgorithm) {
        if (callgraphAlgorithm == IInfoflow.CallgraphAlgorithm.OnDemand) {
            long beforeClassLoading = System.nanoTime();
            OnTheFlyJimpleBasedICFG.loadAllClassesOnClassPathToSignatures();
            this.logger.info("Class loading took {} seconds", (Object)((double)(System.nanoTime() - beforeClassLoading) / 1.0E9));
            long beforeHierarchy = System.nanoTime();
            Scene.v().getOrMakeFastHierarchy();
            assert (Scene.v().hasFastHierarchy());
            this.logger.info("Hierarchy building took {} seconds", (Object)((double)(System.nanoTime() - beforeHierarchy) / 1.0E9));
            long beforeCFG = System.nanoTime();
            InfoflowCFG cfg = new InfoflowCFG(new OnTheFlyJimpleBasedICFG(Scene.v().getEntryPoints()));
            this.logger.info("CFG generation took {} seconds", (Object)((double)(System.nanoTime() - beforeCFG) / 1.0E9));
            return cfg;
        }
        return new InfoflowCFG();
    }
}

