/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.util.ConcurrentHashSet;
import soot.jimple.infoflow.util.MyConcurrentHashMap;
import soot.tagkit.LineNumberTag;

public class InfoflowResults {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MyConcurrentHashMap<SinkInfo, Set<SourceInfo>> results = new MyConcurrentHashMap();

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public boolean containsSink(Value sink) {
        for (SinkInfo si : this.results.keySet()) {
            if (!si.getSink().equals(sink)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSinkMethod(String sinkSignature) {
        return !this.findSinkByMethodSignature(sinkSignature).isEmpty();
    }

    public void addResult(Value sink, Stmt sinkStmt, Value source, Stmt sourceStmt) {
        this.addResult(new SinkInfo(sink, sinkStmt), new SourceInfo(source, sourceStmt));
    }

    public void addResult(Value sink, Stmt sinkStmt, Value source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath) {
        this.addResult(new SinkInfo(sink, sinkStmt), new SourceInfo(source, sourceStmt, userData, propagationPath));
    }

    public void addResult(Value sink, Stmt sinkContext, Value source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath, Stmt stmt) {
        LinkedList<Stmt> newPropPath = new LinkedList<Stmt>(propagationPath);
        newPropPath.add(stmt);
        this.addResult(new SinkInfo(sink, sinkContext), new SourceInfo(source, sourceStmt, userData, newPropPath));
    }

    public void addResult(SinkInfo sink, SourceInfo source) {
        assert (sink != null);
        assert (source != null);
        Set sourceInfo = this.results.putIfAbsentElseGet(sink, new ConcurrentHashSet());
        sourceInfo.add(source);
    }

    public Map<SinkInfo, Set<SourceInfo>> getResults() {
        return this.results;
    }

    public boolean isPathBetween(Value sink, Value source) {
        Set sources = null;
        for (SinkInfo sI : this.results.keySet()) {
            if (!sI.getSink().equals(sink)) continue;
            sources = (Set)this.results.get(sI);
            break;
        }
        if (sources == null) {
            return false;
        }
        for (SourceInfo src : sources) {
            if (!src.source.equals(source)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathBetween(String sink, String source) {
        for (SinkInfo si : this.results.keySet()) {
            if (!si.getSink().toString().equals(sink)) continue;
            Set sources = (Set)this.results.get(si);
            for (SourceInfo src : sources) {
                if (!src.source.toString().equals(source)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathBetweenMethods(String sinkSignature, String sourceSignature) {
        List<SinkInfo> sinkVals = this.findSinkByMethodSignature(sinkSignature);
        for (SinkInfo si : sinkVals) {
            Set sources = (Set)this.results.get(si);
            if (sources == null) {
                return false;
            }
            for (SourceInfo src : sources) {
                InvokeExpr expr;
                if (!(src.source instanceof InvokeExpr) || !(expr = (InvokeExpr)src.source).getMethod().getSignature().equals(sourceSignature)) continue;
                return true;
            }
        }
        return false;
    }

    private List<SinkInfo> findSinkByMethodSignature(String sinkSignature) {
        ArrayList<SinkInfo> sinkVals = new ArrayList<SinkInfo>();
        for (SinkInfo si : this.results.keySet()) {
            InvokeExpr expr;
            if (!(si.getSink() instanceof InvokeExpr) || !(expr = (InvokeExpr)si.getSink()).getMethod().getSignature().equals(sinkSignature)) continue;
            sinkVals.add(si);
        }
        return sinkVals;
    }

    public void printResults() {
        for (SinkInfo sink : this.results.keySet()) {
            this.logger.info("Found a flow to sink {}, from the following sources:", (Object)sink);
            for (SourceInfo source : (Set)this.results.get(sink)) {
                this.logger.info("\t- {}", (Object)source.getSource());
                if (source.getPath() == null || source.getPath().isEmpty()) continue;
                this.logger.info("\t\ton Path {}", (Object)source.getPath());
            }
        }
    }

    public void printResults(Writer wr) throws IOException {
        for (SinkInfo sink : this.results.keySet()) {
            wr.write("Found a flow to sink " + sink + ", from the following sources:\n");
            for (SourceInfo source : (Set)this.results.get(sink)) {
                wr.write("\t- " + source.getSource() + "\n");
                if (source.getPath() == null || source.getPath().isEmpty()) continue;
                wr.write("\t\ton Path " + source.getPath() + "\n");
            }
        }
    }

    public void clear() {
        this.results.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SinkInfo sink : this.results.keySet()) {
            for (SourceInfo source : (Set)this.results.get(sink)) {
                sb.append(source);
                sb.append(" -> ");
                sb.append(sink);
            }
        }
        return sb.toString();
    }

    public class SinkInfo {
        private final Value sink;
        private final Stmt context;

        public SinkInfo(Value sink, Stmt context) {
            assert (sink != null);
            this.sink = sink;
            this.context = context;
        }

        public Value getSink() {
            return this.sink;
        }

        public Stmt getContext() {
            return this.context;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.context.toString());
            if (this.context.hasTag("LineNumberTag")) {
                sb.append(" on line ").append(((LineNumberTag)this.context.getTag("LineNumberTag")).getLineNumber());
            }
            return sb.toString();
        }

        public int hashCode() {
            return 31 * this.sink.hashCode() + 7 * this.context.hashCode();
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o == null || !(o instanceof SinkInfo)) {
                return false;
            }
            SinkInfo si = (SinkInfo)o;
            return this.sink.equals(si.sink) && this.context.equals(si.context);
        }
    }

    public class SourceInfo {
        private final Value source;
        private final Stmt context;
        private final Object userData;
        private final List<Stmt> path;

        public SourceInfo(Value source, Stmt context) {
            assert (source != null);
            this.source = source;
            this.context = context;
            this.userData = null;
            this.path = null;
        }

        public SourceInfo(Value source, Stmt context, Object userData, List<Stmt> path) {
            assert (source != null);
            this.source = source;
            this.context = context;
            this.userData = userData;
            this.path = path;
        }

        public Value getSource() {
            return this.source;
        }

        public Stmt getContext() {
            return this.context;
        }

        public Object getUserData() {
            return this.userData;
        }

        public List<Stmt> getPath() {
            return this.path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.context.toString());
            if (this.context.hasTag("LineNumberTag")) {
                sb.append(" on line ").append(((LineNumberTag)this.context.getTag("LineNumberTag")).getLineNumber());
            }
            return sb.toString();
        }

        public int hashCode() {
            return 31 * this.source.hashCode() + 7 * this.context.hashCode();
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o == null || !(o instanceof SourceInfo)) {
                return false;
            }
            SourceInfo si = (SourceInfo)o;
            return this.source.equals(si.source) && this.context.equals(si.context);
        }
    }
}

