/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import heros.InterproceduralCFG;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.source.MethodBasedSourceSinkManager;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.Tag;

public class AndroidSourceSinkManager
extends MethodBasedSourceSinkManager {
    private static final SourceInfo sourceInfo = new SourceInfo(true);
    private static final String Activity_FindViewById = "<android.app.Activity: android.view.View findViewById(int)>";
    private static final String View_FindViewById = "<android.app.View: android.view.View findViewById(int)>";
    private final Map<String, AndroidMethod> sourceMethods;
    private final Map<String, AndroidMethod> sinkMethods;
    private final Map<String, AndroidMethod> callbackMethods;
    private final LayoutMatchingMode layoutMatching;
    private final Map<Integer, LayoutControl> layoutControls;
    private List<ARSCFileParser.ResPackage> resourcePackages;
    private String appPackageName = "";
    private final Set<SootMethod> analyzedLayoutMethods = new HashSet<SootMethod>();

    public AndroidSourceSinkManager(Set<AndroidMethod> set, Set<AndroidMethod> set2) {
        this(set, set2, new HashSet<AndroidMethod>(), LayoutMatchingMode.NoMatch, null);
    }

    public AndroidSourceSinkManager(Set<AndroidMethod> set, Set<AndroidMethod> set2, Set<AndroidMethod> set3, LayoutMatchingMode layoutMatchingMode, Map<Integer, LayoutControl> map) {
        this.sourceMethods = new HashMap<String, AndroidMethod>();
        for (AndroidMethod androidMethod : set) {
            this.sourceMethods.put(androidMethod.getSignature(), androidMethod);
        }
        this.sinkMethods = new HashMap<String, AndroidMethod>();
        for (AndroidMethod androidMethod : set2) {
            this.sinkMethods.put(androidMethod.getSignature(), androidMethod);
        }
        this.callbackMethods = new HashMap<String, AndroidMethod>();
        for (AndroidMethod androidMethod : set3) {
            this.callbackMethods.put(androidMethod.getSignature(), androidMethod);
        }
        this.layoutMatching = layoutMatchingMode;
        this.layoutControls = map;
        System.out.println("Created a SourceSinkManager with " + this.sourceMethods.size() + " sources, " + this.sinkMethods.size() + " sinks, and " + this.callbackMethods.size() + " callback methods.");
    }

    @Override
    public SourceInfo getSourceMethodInfo(SootMethod sootMethod) {
        return this.sourceMethods.containsKey(sootMethod.getSignature()) ? sourceInfo : null;
    }

    @Override
    public boolean isSinkMethod(SootMethod sootMethod) {
        return this.sinkMethods.containsKey(sootMethod.getSignature());
    }

    @Override
    public SourceInfo getSourceInfo(Stmt stmt, InterproceduralCFG<Unit, SootMethod> interproceduralCFG) {
        return this.getSourceType(stmt, interproceduralCFG) != SourceType.NoSource ? sourceInfo : null;
    }

    public SourceType getSourceType(Stmt stmt, InterproceduralCFG<Unit, SootMethod> interproceduralCFG) {
        IdentityStmt identityStmt;
        assert (interproceduralCFG != null);
        assert (interproceduralCFG instanceof BiDiInterproceduralCFG);
        if (super.getSourceInfo(stmt, interproceduralCFG) != null) {
            return SourceType.MethodCall;
        }
        if (this.isUISource(stmt, interproceduralCFG)) {
            return SourceType.UISource;
        }
        String string = interproceduralCFG.getMethodOf(stmt).getSignature();
        if (stmt instanceof IdentityStmt && (identityStmt = (IdentityStmt)stmt).getRightOp() instanceof ParameterRef && this.callbackMethods.containsKey(string)) {
            return SourceType.Callback;
        }
        return SourceType.NoSource;
    }

    private boolean isUISource(Stmt stmt, InterproceduralCFG<Unit, SootMethod> interproceduralCFG) {
        InvokeExpr invokeExpr;
        if (this.layoutMatching != LayoutMatchingMode.NoMatch && stmt.containsInvokeExpr() && ((invokeExpr = stmt.getInvokeExpr()).getMethod().getSignature().equals(Activity_FindViewById) || invokeExpr.getMethod().getSignature().equals(View_FindViewById))) {
            Object object;
            SootMethod sootMethod = interproceduralCFG.getMethodOf(stmt);
            if (this.analyzedLayoutMethods.add(sootMethod)) {
                ConstantPropagatorAndFolder.v().transform(sootMethod.getActiveBody());
            }
            if (this.layoutMatching == LayoutMatchingMode.MatchAll) {
                return true;
            }
            if (this.layoutControls == null) {
                return false;
            }
            if (invokeExpr.getArgCount() != 1) {
                System.err.println("Framework method call with unexpected number of arguments");
                return false;
            }
            int n = 0;
            if (invokeExpr.getArg(0) instanceof IntConstant) {
                n = ((IntConstant)invokeExpr.getArg((int)0)).value;
            } else if (invokeExpr.getArg(0) instanceof Local) {
                object = this.findLastResIDAssignment(stmt, (Local)invokeExpr.getArg(0), (BiDiInterproceduralCFG)interproceduralCFG, new HashSet<Stmt>(interproceduralCFG.getMethodOf(stmt).getActiveBody().getUnits().size()));
                if (object == null) {
                    System.err.println("Could not find assignment to local " + ((Local)invokeExpr.getArg(0)).getName() + " in method " + interproceduralCFG.getMethodOf(stmt).getSignature());
                    return false;
                }
                n = (Integer)object;
            } else {
                System.err.println("Framework method call with unexpected parameter type: " + invokeExpr.toString() + ", " + "first parameter is of type " + invokeExpr.getArg(0).getClass());
                return false;
            }
            object = this.layoutControls.get(n);
            if (object == null) {
                System.err.println("Layout control with ID " + n + " not found");
                return false;
            }
            if (this.layoutMatching == LayoutMatchingMode.MatchSensitiveOnly && ((LayoutControl)object).isSensitive()) {
                return true;
            }
        }
        return false;
    }

    private Integer findLastResIDAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> biDiInterproceduralCFG, Set<Stmt> set) {
        Object object;
        Object object2;
        if (!set.add(stmt)) {
            return null;
        }
        if (stmt instanceof AssignStmt && (object2 = (AssignStmt)stmt).getLeftOp() == local) {
            InvokeExpr invokeExpr;
            Object object3;
            if (object2.getRightOp() instanceof IntConstant) {
                return ((IntConstant)object2.getRightOp()).value;
            }
            if (object2.getRightOp() instanceof FieldRef) {
                SootField object4 = ((FieldRef)object2.getRightOp()).getField();
                object = object4.getTags().iterator();
                while (object.hasNext()) {
                    object3 = (Tag)object.next();
                    if (object3 instanceof IntegerConstantValueTag) {
                        return ((IntegerConstantValueTag)object3).getIntValue();
                    }
                    System.err.println("Constant " + object4 + " was of unexpected type");
                }
            } else if (object2.getRightOp() instanceof InvokeExpr && (invokeExpr = (InvokeExpr)object2.getRightOp()).getMethod().getName().equals("getIdentifier") && invokeExpr.getMethod().getDeclaringClass().getName().equals("android.content.res.Resources") && this.resourcePackages != null) {
                if (invokeExpr.getArgCount() != 3) {
                    System.err.println("Invalid parameter count for call to getIdentifier");
                    return null;
                }
                object = "";
                object3 = "";
                String string = "";
                if (invokeExpr.getArg(0) instanceof StringConstant) {
                    object = ((StringConstant)invokeExpr.getArg((int)0)).value;
                }
                if (invokeExpr.getArg(1) instanceof StringConstant) {
                    object3 = ((StringConstant)invokeExpr.getArg((int)1)).value;
                }
                if (invokeExpr.getArg(2) instanceof StringConstant) {
                    string = ((StringConstant)invokeExpr.getArg((int)2)).value;
                } else if (invokeExpr.getArg(2) instanceof Local) {
                    string = this.findLastStringAssignment(stmt, (Local)invokeExpr.getArg(2), biDiInterproceduralCFG);
                } else {
                    System.err.println("Unknown parameter type in call to getIdentifier");
                    return null;
                }
                ARSCFileParser.AbstractResource abstractResource = this.findResource((String)object, (String)object3, string);
                if (abstractResource != null) {
                    return abstractResource.getResourceID();
                }
            }
        }
        for (Unit unit : biDiInterproceduralCFG.getPredsOf(stmt)) {
            if (!(unit instanceof Stmt) || (object = this.findLastResIDAssignment((Stmt)unit, local, biDiInterproceduralCFG, set)) == null) continue;
            return object;
        }
        return null;
    }

    private ARSCFileParser.AbstractResource findResource(String string, String string2, String string3) {
        for (ARSCFileParser.ResPackage resPackage : this.resourcePackages) {
            boolean bl;
            boolean bl2 = bl = (string3 == null || string3.isEmpty()) && resPackage.getPackageName().equals(this.appPackageName);
            if (!(bl |= resPackage.getPackageName().equals(string3))) continue;
            for (ARSCFileParser.ResType resType : resPackage.getDeclaredTypes()) {
                if (!resType.getTypeName().equals(string2)) continue;
                ARSCFileParser.AbstractResource abstractResource = resType.getFirstResource(string);
                return abstractResource;
            }
        }
        return null;
    }

    private String findLastStringAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> biDiInterproceduralCFG) {
        Object object;
        if (stmt instanceof AssignStmt && (object = (AssignStmt)stmt).getLeftOp() == local && object.getRightOp() instanceof StringConstant) {
            return ((StringConstant)object.getRightOp()).value;
        }
        for (Unit unit : biDiInterproceduralCFG.getPredsOf(stmt)) {
            String string;
            if (!(unit instanceof Stmt) || (string = this.findLastStringAssignment((Stmt)unit, local, biDiInterproceduralCFG)) == null) continue;
            return string;
        }
        return null;
    }

    public void addSink(Set<AndroidMethod> set) {
        for (AndroidMethod androidMethod : set) {
            this.sinkMethods.put(androidMethod.getSignature(), androidMethod);
        }
    }

    public void setResourcePackages(List<ARSCFileParser.ResPackage> list) {
        this.resourcePackages = list;
    }

    public void setAppPackageName(String string) {
        this.appPackageName = string;
    }

    public static enum SourceType {
        NoSource,
        MethodCall,
        Callback,
        UISource;

    }

    public static enum LayoutMatchingMode {
        NoMatch,
        MatchAll,
        MatchSensitiveOnly;

    }
}

