/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.TestApps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xmlpull.v1.XmlPullParserException;
import soot.SootMethod;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.taintWrappers.TaintWrapperSet;

public class Test {
    static String command;
    static boolean generate;
    private static int timeout;
    private static int sysTimeout;
    private static boolean stopAfterFirstFlow;
    private static boolean implicitFlows;
    private static boolean staticTracking;
    private static boolean enableCallbacks;
    private static boolean enableExceptions;
    private static int accessPathLength;
    private static AndroidSourceSinkManager.LayoutMatchingMode layoutMatchingMode;
    private static boolean flowSensitiveAliasing;
    private static boolean computeResultPaths;
    private static boolean aggressiveTaintWrapper;
    private static boolean librarySummaryTaintWrapper;
    private static String summaryPath;
    private static DefaultPathBuilderFactory.PathBuilder pathBuilder;
    private static IInfoflow.CallgraphAlgorithm callgraphAlgorithm;
    private static boolean DEBUG;
    private static IIPCManager ipcManager;

    public static void setIPCManager(IIPCManager ipcManager) {
        Test.ipcManager = ipcManager;
    }

    public static IIPCManager getIPCManager() {
        return ipcManager;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 2) {
            Test.printUsage();
            return;
        }
        File outputDir = new File("JimpleOutput");
        if (outputDir.isDirectory()) {
            boolean success = true;
            for (File f : outputDir.listFiles()) {
                success = success && f.delete();
            }
            if (!success) {
                System.err.println("Cleanup of output directory " + outputDir + " failed!");
            }
            outputDir.delete();
        }
        if (!Test.parseAdditionalOptions(args)) {
            return;
        }
        if (!Test.validateAdditionalOptions()) {
            return;
        }
        ArrayList<String> apkFiles = new ArrayList<String>();
        File apkFile = new File(args[0]);
        if (apkFile.isDirectory()) {
            String[] dirFiles;
            for (String s : dirFiles = apkFile.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".apk");
                }
            })) {
                apkFiles.add(s);
            }
        } else {
            String extension = apkFile.getName().substring(apkFile.getName().lastIndexOf("."));
            if (extension.equalsIgnoreCase(".txt")) {
                BufferedReader rdr = new BufferedReader(new FileReader(apkFile));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    apkFiles.add(line);
                }
                rdr.close();
            } else if (extension.equalsIgnoreCase(".apk")) {
                apkFiles.add(args[0]);
            } else {
                System.err.println("Invalid input file format: " + extension);
                return;
            }
        }
        for (String fileName : apkFiles) {
            String fullFilePath;
            if (apkFiles.size() > 1) {
                fullFilePath = apkFile.isDirectory() ? args[0] + File.separator + fileName : fileName;
                System.out.println("Analyzing file " + fullFilePath + "...");
                File flagFile = new File("_Run_" + new File(fileName).getName());
                if (flagFile.exists()) continue;
                flagFile.createNewFile();
            } else {
                fullFilePath = fileName;
            }
            if (timeout > 0) {
                Test.runAnalysisTimeout(fullFilePath, args[1]);
            } else if (sysTimeout > 0) {
                Test.runAnalysisSysTimeout(fullFilePath, args[1]);
            } else {
                Test.runAnalysis(fullFilePath, args[1]);
            }
            System.gc();
        }
    }

    private static boolean parseAdditionalOptions(String[] args) {
        int i = 2;
        while (i < args.length) {
            String algo;
            if (args[i].equalsIgnoreCase("--timeout")) {
                timeout = Integer.valueOf(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--systimeout")) {
                sysTimeout = Integer.valueOf(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--singleflow")) {
                stopAfterFirstFlow = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--implicit")) {
                implicitFlows = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nostatic")) {
                staticTracking = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aplength")) {
                accessPathLength = Integer.valueOf(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--cgalgo")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("AUTO")) {
                    callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.AutomaticSelection;
                } else if (algo.equalsIgnoreCase("CHA")) {
                    callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.CHA;
                } else if (algo.equalsIgnoreCase("VTA")) {
                    callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.VTA;
                } else if (algo.equalsIgnoreCase("RTA")) {
                    callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.RTA;
                } else if (algo.equalsIgnoreCase("SPARK")) {
                    callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.SPARK;
                } else {
                    System.err.println("Invalid callgraph algorithm");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nocallbacks")) {
                enableCallbacks = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--noexceptions")) {
                enableExceptions = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--layoutmode")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("NONE")) {
                    layoutMatchingMode = AndroidSourceSinkManager.LayoutMatchingMode.NoMatch;
                } else if (algo.equalsIgnoreCase("PWD")) {
                    layoutMatchingMode = AndroidSourceSinkManager.LayoutMatchingMode.MatchSensitiveOnly;
                } else if (algo.equalsIgnoreCase("ALL")) {
                    layoutMatchingMode = AndroidSourceSinkManager.LayoutMatchingMode.MatchAll;
                } else {
                    System.err.println("Invalid layout matching mode");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aliasflowins")) {
                flowSensitiveAliasing = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nopaths")) {
                computeResultPaths = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aggressivetw")) {
                aggressiveTaintWrapper = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--pathalgo")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("CONTEXTSENSITIVE")) {
                    pathBuilder = DefaultPathBuilderFactory.PathBuilder.ContextSensitive;
                } else if (algo.equalsIgnoreCase("CONTEXTINSENSITIVE")) {
                    pathBuilder = DefaultPathBuilderFactory.PathBuilder.ContextInsensitive;
                } else if (algo.equalsIgnoreCase("SOURCESONLY")) {
                    pathBuilder = DefaultPathBuilderFactory.PathBuilder.ContextInsensitiveSourceFinder;
                } else {
                    System.err.println("Invalid path reconstruction algorithm");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--libsumtw")) {
                librarySummaryTaintWrapper = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--summarypath")) {
                summaryPath = args[i + 1];
                i += 2;
                continue;
            }
            ++i;
        }
        return true;
    }

    private static boolean validateAdditionalOptions() {
        if (timeout > 0 && sysTimeout > 0) {
            return false;
        }
        if (!flowSensitiveAliasing && callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.OnDemand && callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.AutomaticSelection) {
            System.err.println("Flow-insensitive aliasing can only be configured for callgraph algorithms that support this choice.");
            return false;
        }
        if (librarySummaryTaintWrapper && summaryPath.isEmpty()) {
            System.err.println("Summary path must be specified when using library summaries");
            return false;
        }
        return true;
    }

    private static void runAnalysisTimeout(final String fileName, final String androidJar) {
        FutureTask<InfoflowResults> task = new FutureTask<InfoflowResults>(new Callable<InfoflowResults>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InfoflowResults call() throws Exception {
                try (BufferedWriter wr = new BufferedWriter(new FileWriter("_out_" + new File(fileName).getName() + ".txt"));){
                    long beforeRun = System.nanoTime();
                    wr.write("Running data flow analysis...\n");
                    InfoflowResults res = Test.runAnalysis(fileName, androidJar);
                    wr.write("Analysis has run for " + (double)(System.nanoTime() - beforeRun) / 1.0E9 + " seconds\n");
                    wr.flush();
                    InfoflowResults infoflowResults = res;
                    return infoflowResults;
                }
            }
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(task);
        try {
            System.out.println("Running infoflow task...");
            task.get(timeout, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            System.err.println("Infoflow computation failed: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            System.err.println("Infoflow computation timed out: " + e.getMessage());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.err.println("Infoflow computation interrupted: " + e.getMessage());
            e.printStackTrace();
        }
        executor.shutdown();
    }

    private static void runAnalysisSysTimeout(String fileName, String androidJar) {
        String classpath = System.getProperty("java.class.path");
        String javaHome = System.getProperty("java.home");
        String executable = "/usr/bin/timeout";
        String[] command = new String[]{executable, "-s", "KILL", sysTimeout + "m", javaHome + "/bin/java", "-cp", classpath, "soot.jimple.infoflow.android.TestApps.Test", fileName, androidJar, stopAfterFirstFlow ? "--singleflow" : "--nosingleflow", implicitFlows ? "--implicit" : "--noimplicit", staticTracking ? "--static" : "--nostatic", "--aplength", Integer.toString(accessPathLength), "--cgalgo", Test.callgraphAlgorithmToString(callgraphAlgorithm), enableCallbacks ? "--callbacks" : "--nocallbacks", enableExceptions ? "--exceptions" : "--noexceptions", "--layoutmode", Test.layoutMatchingModeToString(layoutMatchingMode), flowSensitiveAliasing ? "--aliasflowsens" : "--aliasflowins", computeResultPaths ? "--paths" : "--nopaths", aggressiveTaintWrapper ? "--aggressivetw" : "--nonaggressivetw", "--pathalgo", Test.pathAlgorithmToString(pathBuilder)};
        System.out.println("Running command: " + executable + " " + command);
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectOutput(new File("_out_" + new File(fileName).getName() + ".txt"));
            pb.redirectError(new File("err_" + new File(fileName).getName() + ".txt"));
            Process proc = pb.start();
            proc.waitFor();
        }
        catch (IOException ex) {
            System.err.println("Could not execute timeout command: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            System.err.println("Process was interrupted: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static String callgraphAlgorithmToString(IInfoflow.CallgraphAlgorithm algorihm) {
        switch (algorihm) {
            case AutomaticSelection: {
                return "AUTO";
            }
            case CHA: {
                return "CHA";
            }
            case VTA: {
                return "VTA";
            }
            case RTA: {
                return "RTA";
            }
            case SPARK: {
                return "SPARK";
            }
        }
        return "unknown";
    }

    private static String layoutMatchingModeToString(AndroidSourceSinkManager.LayoutMatchingMode mode) {
        switch (mode) {
            case NoMatch: {
                return "NONE";
            }
            case MatchSensitiveOnly: {
                return "PWD";
            }
            case MatchAll: {
                return "ALL";
            }
        }
        return "unknown";
    }

    private static String pathAlgorithmToString(DefaultPathBuilderFactory.PathBuilder pathBuilder) {
        switch (pathBuilder) {
            case ContextSensitive: {
                return "CONTEXTSENSITIVE";
            }
            case ContextInsensitive: {
                return "CONTEXTINSENSITIVE";
            }
            case ContextInsensitiveSourceFinder: {
                return "SOURCESONLY";
            }
        }
        return "UNKNOWN";
    }

    private static InfoflowResults runAnalysis(String fileName, String androidJar) {
        try {
            ITaintPropagationWrapper taintWrapper;
            long beforeRun = System.nanoTime();
            SetupApplication app = null == ipcManager ? new SetupApplication(androidJar, fileName) : new SetupApplication(androidJar, fileName, ipcManager);
            app.setStopAfterFirstFlow(stopAfterFirstFlow);
            app.setEnableImplicitFlows(implicitFlows);
            app.setEnableStaticFieldTracking(staticTracking);
            app.setEnableCallbacks(enableCallbacks);
            app.setEnableExceptionTracking(enableExceptions);
            app.setAccessPathLength(accessPathLength);
            app.setLayoutMatchingMode(layoutMatchingMode);
            app.setFlowSensitiveAliasing(flowSensitiveAliasing);
            app.setPathBuilder(pathBuilder);
            app.setComputeResultPaths(computeResultPaths);
            if (librarySummaryTaintWrapper) {
                taintWrapper = Test.createLibrarySummaryTW();
            } else {
                EasyTaintWrapper easyTaintWrapper = new File("../soot-infoflow/EasyTaintWrapperSource.txt").exists() ? new EasyTaintWrapper("../soot-infoflow/EasyTaintWrapperSource.txt") : new EasyTaintWrapper("EasyTaintWrapperSource.txt");
                easyTaintWrapper.setAggressiveMode(aggressiveTaintWrapper);
                taintWrapper = easyTaintWrapper;
            }
            app.setTaintWrapper(taintWrapper);
            app.calculateSourcesSinksEntrypoints("SourcesAndSinks.txt");
            if (DEBUG) {
                app.printEntrypoints();
                app.printSinks();
                app.printSources();
            }
            System.out.println("Running data flow analysis...");
            InfoflowResults res = app.runInfoflow(new MyResultsAvailableHandler());
            System.out.println("Analysis has run for " + (double)(System.nanoTime() - beforeRun) / 1.0E9 + " seconds");
            return res;
        }
        catch (IOException ex) {
            System.err.println("Could not read file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        catch (XmlPullParserException ex) {
            System.err.println("Could not read Android manifest file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private static ITaintPropagationWrapper createLibrarySummaryTW() throws IOException {
        try {
            Class<?> clzLazySummary = Class.forName("soot.jimple.infoflow.methodSummary.data.impl.LazySummary");
            Object lazySummary = clzLazySummary.getConstructor(File.class).newInstance(new File(summaryPath));
            ITaintPropagationWrapper summaryWrapper = (ITaintPropagationWrapper)Class.forName("soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper").getConstructor(clzLazySummary).newInstance(lazySummary);
            TaintWrapperSet taintWrapperSet = new TaintWrapperSet();
            taintWrapperSet.addWrapper(summaryWrapper);
            taintWrapperSet.addWrapper(new EasyTaintWrapper("EasyTaintWrapperConversion.txt"));
            return taintWrapperSet;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            System.err.println("Could not find library summary classes: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ex) {
            System.err.println("Could not initialize library summaries: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            System.err.println("Internal error in library summary initialization: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private static void printUsage() {
        System.out.println("FlowDroid (c) Secure Software Engineering Group @ EC SPRIDE");
        System.out.println();
        System.out.println("Incorrect arguments: [0] = apk-file, [1] = android-jar-directory");
        System.out.println("Optional further parameters:");
        System.out.println("\t--TIMEOUT n Time out after n seconds");
        System.out.println("\t--SYSTIMEOUT n Hard time out (kill process) after n seconds, Unix only");
        System.out.println("\t--SINGLEFLOW Stop after finding first leak");
        System.out.println("\t--IMPLICIT Enable implicit flows");
        System.out.println("\t--NOSTATIC Disable static field tracking");
        System.out.println("\t--NOEXCEPTIONS Disable exception tracking");
        System.out.println("\t--APLENGTH n Set access path length to n");
        System.out.println("\t--CGALGO x Use callgraph algorithm x");
        System.out.println("\t--NOCALLBACKS Disable callback analysis");
        System.out.println("\t--LAYOUTMODE x Set UI control analysis mode to x");
        System.out.println("\t--ALIASFLOWINS Use a flow insensitive alias search");
        System.out.println("\t--NOPATHS Do not compute result paths");
        System.out.println("\t--AGGRESSIVETW Use taint wrapper in aggressive mode");
        System.out.println("\t--PATHALGO Use path reconstruction algorithm x");
        System.out.println("\t--LIBSUMTW Use library summary taint wrapper");
        System.out.println("\t--SUMMARYPATH Path to library summaries");
        System.out.println();
        System.out.println("Supported callgraph algorithms: AUTO, CHA, RTA, VTA, SPARK");
        System.out.println("Supported layout mode algorithms: NONE, PWD, ALL");
        System.out.println("Supported path algorithms: CONTEXTSENSITIVE, CONTEXTINSENSITIVE, SOURCESONLY");
    }

    static {
        generate = false;
        timeout = -1;
        sysTimeout = -1;
        stopAfterFirstFlow = false;
        implicitFlows = false;
        staticTracking = true;
        enableCallbacks = true;
        enableExceptions = true;
        accessPathLength = 5;
        layoutMatchingMode = AndroidSourceSinkManager.LayoutMatchingMode.MatchSensitiveOnly;
        flowSensitiveAliasing = true;
        computeResultPaths = true;
        aggressiveTaintWrapper = false;
        librarySummaryTaintWrapper = false;
        summaryPath = "";
        pathBuilder = DefaultPathBuilderFactory.PathBuilder.ContextInsensitiveSourceFinder;
        callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.AutomaticSelection;
        DEBUG = false;
        ipcManager = null;
    }

    private static final class MyResultsAvailableHandler
    implements ResultsAvailableHandler {
        private final BufferedWriter wr;

        private MyResultsAvailableHandler() {
            this.wr = null;
        }

        private MyResultsAvailableHandler(BufferedWriter wr) {
            this.wr = wr;
        }

        @Override
        public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
            if (results == null) {
                this.print("No results found.");
            } else {
                for (ResultSinkInfo sink : results.getResults().keySet()) {
                    this.print("Found a flow to sink " + sink + ", from the following sources:");
                    for (ResultSourceInfo source : results.getResults().get(sink)) {
                        this.print("\t- " + source.getSource() + " (in " + ((SootMethod)cfg.getMethodOf(source.getSource())).getSignature() + ")");
                        if (source.getPath() == null || source.getPath().isEmpty()) continue;
                        this.print("\t\ton Path " + source.getPath());
                    }
                }
            }
        }

        private void print(String string) {
            try {
                System.out.println(string);
                if (this.wr != null) {
                    this.wr.write(string + "\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

