/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlElement;

public class AXmlNode
extends AXmlElement {
    protected String tag;
    protected AXmlNode parent = null;
    ArrayList<AXmlNode> children = null;
    Map<String, AXmlAttribute<?>> attributes = null;

    public AXmlNode(String tag, String ns, AXmlNode parent) {
        this(tag, ns, parent, true);
    }

    public AXmlNode(String tag, String ns, AXmlNode parent, boolean added) {
        super(ns, added);
        this.tag = tag;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public boolean addSiblingBefore(AXmlNode sibling) {
        if (this.parent != null) {
            this.parent.addChild(sibling, this.parent.getChildren().indexOf(this));
            return true;
        }
        return false;
    }

    public boolean addSiblingAfter(AXmlNode sibling) {
        if (this.parent != null) {
            this.parent.addChild(sibling, this.parent.getChildren().indexOf(this) + 1);
            return true;
        }
        return false;
    }

    public AXmlNode addChild(AXmlNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return this;
    }

    public AXmlNode addChild(AXmlNode child, int index) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(index, child);
        return this;
    }

    public List<AXmlNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AXmlNode>(this.children);
    }

    public List<AXmlNode> getChildrenWithTag(String tag) {
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<AXmlNode> children = new ArrayList<AXmlNode>();
        for (AXmlNode child : this.children) {
            if (!child.getTag().equals(tag)) continue;
            children.add(child);
        }
        return children;
    }

    public Map<String, AXmlAttribute<?>> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return new HashMap(this.attributes);
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    public AXmlAttribute<?> getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void addAttribute(AXmlAttribute<?> attr2) {
        if (attr2 == null) {
            throw new NullPointerException("AXmlAttribute is null");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attr2.getName(), attr2);
    }

    public AXmlNode getParent() {
        return this.parent;
    }

    public void setParent(AXmlNode parent) {
        this.parent = parent;
    }

    public String toString() {
        String attributes = "";
        if (this.attributes != null) {
            for (AXmlAttribute<?> attrNode : this.attributes.values()) {
                attributes = attributes + " " + attrNode;
            }
        }
        return "<" + this.tag + attributes + ">";
    }
}

