/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlHandler;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.ApkHandler;

public class ProcessManifest {
    protected ApkHandler apk = null;
    protected AXmlHandler axml;
    protected AXmlNode manifest;
    protected AXmlNode application;
    protected List<AXmlNode> providers = null;
    protected List<AXmlNode> services = null;
    protected List<AXmlNode> activities = null;
    protected List<AXmlNode> receivers = null;
    private String cache_PackageName = null;

    public ProcessManifest() {
    }

    public ProcessManifest(String apkPath) throws IOException, XmlPullParserException {
        this(new File(apkPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessManifest(File apkFile) throws IOException, XmlPullParserException {
        this.apk = new ApkHandler(apkFile);
        try (InputStream is = null;){
            is = this.apk.getInputStream("AndroidManifest.xml");
            this.handle(is);
        }
    }

    public ProcessManifest(InputStream manifestIS) throws IOException, XmlPullParserException {
        this.handle(manifestIS);
    }

    protected void handle(InputStream manifestIS) throws IOException, XmlPullParserException {
        this.axml = new AXmlHandler(manifestIS);
        List<AXmlNode> manifests = this.axml.getNodesWithTag("manifest");
        if (manifests.isEmpty()) {
            throw new RuntimeException("Manifest contains no manifest node");
        }
        if (manifests.size() > 1) {
            throw new RuntimeException("Manifest contains more than one manifest node");
        }
        this.manifest = manifests.get(0);
        List<AXmlNode> applications = this.manifest.getChildrenWithTag("application");
        if (applications.isEmpty()) {
            throw new RuntimeException("Manifest contains no application node");
        }
        if (applications.size() > 1) {
            throw new RuntimeException("Manifest contains more than one application node");
        }
        this.application = applications.get(0);
        this.providers = this.axml.getNodesWithTag("provider");
        this.services = this.axml.getNodesWithTag("service");
        this.activities = this.axml.getNodesWithTag("activity");
        this.receivers = this.axml.getNodesWithTag("receiver");
    }

    private String expandClassName(String className) {
        String packageName = this.getPackageName();
        if (className.startsWith(".")) {
            return packageName + className;
        }
        if (className.substring(0, 1).equals(className.substring(0, 1).toUpperCase())) {
            return packageName + "." + className;
        }
        return className;
    }

    public AXmlHandler getAXml() {
        return this.axml;
    }

    public ApkHandler getApk() {
        return this.apk;
    }

    public AXmlNode getManifest() {
        return this.manifest;
    }

    public AXmlNode getApplication() {
        return this.application;
    }

    public ArrayList<AXmlNode> getProviders() {
        return new ArrayList<AXmlNode>(this.providers);
    }

    public ArrayList<AXmlNode> getServices() {
        return new ArrayList<AXmlNode>(this.services);
    }

    public Set<String> getEntryPointClasses() {
        if (!this.isApplicationEnabled()) {
            return Collections.emptySet();
        }
        HashSet<String> entryPoints = new HashSet<String>();
        for (AXmlNode node : this.activities) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.providers) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.services) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.receivers) {
            this.checkAndAddComponent(entryPoints, node);
        }
        String appName = this.getApplicationName();
        if (appName != null && !appName.isEmpty()) {
            entryPoints.add(appName);
        }
        return entryPoints;
    }

    private void checkAndAddComponent(Set<String> entryPoints, AXmlNode node) {
        AXmlAttribute<?> attrEnabled = node.getAttribute("enabled");
        if (attrEnabled == null || !attrEnabled.getValue().equals(Boolean.FALSE)) {
            AXmlAttribute<?> attr2 = node.getAttribute("name");
            if (attr2 != null) {
                entryPoints.add(this.expandClassName((String)attr2.getValue()));
            } else {
                for (Map.Entry<String, AXmlAttribute<?>> a : node.getAttributes().entrySet()) {
                    String name;
                    if (!a.getValue().getName().isEmpty() || a.getValue().getType() != 3 || !this.isValidComponentName(name = (String)a.getValue().getValue())) continue;
                    entryPoints.add(this.expandClassName(name));
                }
            }
        }
    }

    private boolean isValidComponentName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (name.equals("true") || name.equals("false")) {
            return false;
        }
        if (Character.isDigit(name.charAt(0))) {
            return false;
        }
        return name.startsWith(".");
    }

    public ComponentType getComponentType(String className) {
        for (AXmlNode node : this.activities) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Activity;
        }
        for (AXmlNode node : this.services) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Service;
        }
        for (AXmlNode node : this.receivers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.BroadcastReceiver;
        }
        for (AXmlNode node : this.providers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.ContentProvider;
        }
        return null;
    }

    public ArrayList<AXmlNode> getActivities() {
        return new ArrayList<AXmlNode>(this.activities);
    }

    public ArrayList<AXmlNode> getReceivers() {
        return new ArrayList<AXmlNode>(this.receivers);
    }

    public AXmlNode getProvider(String name) {
        return this.getNodeWithName(this.providers, name);
    }

    public AXmlNode getService(String name) {
        return this.getNodeWithName(this.services, name);
    }

    public AXmlNode getActivity(String name) {
        return this.getNodeWithName(this.activities, name);
    }

    public AXmlNode getReceiver(String name) {
        return this.getNodeWithName(this.receivers, name);
    }

    protected AXmlNode getNodeWithName(List<AXmlNode> list, String name) {
        for (AXmlNode node : list) {
            AXmlAttribute<?> attr2 = node.getAttributes().get("name");
            if (attr2 == null || !((Object)attr2).equals(name)) continue;
            return node;
        }
        return null;
    }

    public byte[] getOutput() {
        return this.axml.toByteArray();
    }

    public String getPackageName() {
        AXmlAttribute<?> attr2;
        if (this.cache_PackageName == null && (attr2 = this.manifest.getAttribute("package")) != null) {
            this.cache_PackageName = (String)attr2.getValue();
        }
        return this.cache_PackageName;
    }

    public int getVersionCode() {
        AXmlAttribute<?> attr2 = this.manifest.getAttribute("versionCode");
        return attr2 == null ? -1 : Integer.getInteger((String)attr2.getValue());
    }

    public String getVersionName() {
        AXmlAttribute<?> attr2 = this.manifest.getAttribute("versionName");
        return attr2 == null ? null : (String)attr2.getValue();
    }

    public String getApplicationName() {
        AXmlAttribute<?> attr2 = this.application.getAttribute("name");
        return attr2 == null ? null : this.expandClassName((String)attr2.getValue());
    }

    public boolean isApplicationEnabled() {
        AXmlAttribute<?> attr2 = this.application.getAttribute("enabled");
        return attr2 == null || !attr2.getValue().equals(Boolean.FALSE);
    }

    public int getMinSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr2 = usesSdk.get(0).getAttribute("minSdkVersion");
        if (attr2 == null) {
            return -1;
        }
        if (attr2.getValue() instanceof Integer) {
            return (Integer)attr2.getValue();
        }
        return Integer.getInteger((String)attr2.getValue());
    }

    public int targetSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr2 = usesSdk.get(0).getAttribute("targetSdkVersion");
        if (attr2 == null) {
            return -1;
        }
        if (attr2.getValue() instanceof Integer) {
            return (Integer)attr2.getValue();
        }
        return Integer.getInteger((String)attr2.getValue());
    }

    public Set<String> getPermissions() {
        List<AXmlNode> usesPerms = this.manifest.getChildrenWithTag("uses-permission");
        HashSet<String> permissions = new HashSet<String>();
        for (AXmlNode perm : usesPerms) {
            AXmlAttribute<?> attr2 = perm.getAttribute("name");
            if (attr2 != null) {
                permissions.add((String)attr2.getValue());
                continue;
            }
            for (AXmlAttribute<?> a : perm.getAttributes().values()) {
                if (a.getType() != 3 || !a.getName().isEmpty()) continue;
                permissions.add((String)a.getValue());
            }
        }
        return permissions;
    }

    public void addPermission(String permissionName) {
        AXmlNode permission = new AXmlNode("uses-permission", null, this.manifest);
        AXmlAttribute<String> permissionNameAttr = new AXmlAttribute<String>("name", permissionName, "http://schemas.android.com/apk/res/android");
        permission.addAttribute(permissionNameAttr);
    }

    public void addProvider(AXmlNode node) {
        if (this.providers.isEmpty()) {
            this.providers = new ArrayList<AXmlNode>();
        }
        this.providers.add(node);
    }

    public void addReceiver(AXmlNode node) {
        if (this.receivers.isEmpty()) {
            this.receivers = new ArrayList<AXmlNode>();
        }
        this.receivers.add(node);
    }

    public void addActivity(AXmlNode node) {
        if (this.activities.isEmpty()) {
            this.activities = new ArrayList<AXmlNode>();
        }
        this.activities.add(node);
    }

    public void addService(AXmlNode node) {
        if (this.services.isEmpty()) {
            this.services = new ArrayList<AXmlNode>();
        }
        this.services.add(node);
    }

    public void close() {
        if (this.apk != null) {
            this.apk.close();
        }
    }

    public Set<AXmlNode> getLaunchableActivities() {
        HashSet<AXmlNode> allLaunchableActivities = new HashSet<AXmlNode>();
        for (AXmlNode activity : this.activities) {
            for (AXmlNode activityChildren : activity.getChildren()) {
                if (!activityChildren.getTag().equals("intent-filter")) continue;
                boolean actionFilter = false;
                boolean categoryFilter = false;
                for (AXmlNode intentFilter : activityChildren.getChildren()) {
                    if (intentFilter.toString().equals("<action name=\"android.intent.action.MAIN\">")) {
                        actionFilter = true;
                        continue;
                    }
                    if (!intentFilter.toString().equals("<category name=\"android.intent.category.LAUNCHER\">")) continue;
                    categoryFilter = true;
                }
                if (!actionFilter || !categoryFilter) continue;
                allLaunchableActivities.add(activity);
            }
        }
        return allLaunchableActivities;
    }

    public static enum ComponentType {
        Activity,
        Service,
        ContentProvider,
        BroadcastReceiver;

    }
}

