/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.android.source.data.AccessPathTuple;
import soot.jimple.infoflow.data.SootMethodAndClass;

public class SourceSinkDefinition {
    private final SootMethodAndClass method;
    private Set<AccessPathTuple> baseObjects;
    private Set<AccessPathTuple>[] parameters;
    private Set<AccessPathTuple> returnValues;

    public SourceSinkDefinition(SootMethodAndClass am) {
        this(am, null, null, null);
    }

    public SourceSinkDefinition(SootMethodAndClass am, Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues) {
        this.method = am;
        this.baseObjects = baseObjects == null || baseObjects.isEmpty() ? null : baseObjects;
        this.parameters = parameters;
        this.returnValues = returnValues == null || returnValues.isEmpty() ? null : returnValues;
    }

    public SootMethodAndClass getMethod() {
        return this.method;
    }

    public Set<AccessPathTuple> getBaseObjects() {
        return this.baseObjects;
    }

    public int getBaseObjectCount() {
        return this.baseObjects == null ? 0 : this.baseObjects.size();
    }

    public Set<AccessPathTuple>[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        if (this.parameters == null || this.parameters.length == 0) {
            return 0;
        }
        int cnt = 0;
        for (Set<AccessPathTuple> apt : this.parameters) {
            cnt += apt.size();
        }
        return cnt;
    }

    public Set<AccessPathTuple> getReturnValues() {
        return this.returnValues;
    }

    public int getReturnValueCount() {
        return this.returnValues == null ? 0 : this.returnValues.size();
    }

    public boolean isEmpty() {
        boolean parametersEmpty = true;
        if (this.parameters != null) {
            for (Set<AccessPathTuple> paramSet : this.parameters) {
                if (paramSet == null || paramSet.isEmpty()) continue;
                parametersEmpty = false;
                break;
            }
        }
        return !(this.baseObjects != null && !this.baseObjects.isEmpty() || !parametersEmpty || this.returnValues != null && !this.returnValues.isEmpty());
    }

    public String toString() {
        return this.method.getSignature();
    }

    public SourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> baseSources = null;
        if (this.baseObjects != null) {
            baseSources = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.isSource()) continue;
                baseSources.add(apt);
            }
        }
        Set[] paramSources = new Set[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            HashSet<AccessPathTuple> thisParam;
            Set<AccessPathTuple> aptSet = this.parameters[i];
            paramSources[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
            for (AccessPathTuple apt : aptSet) {
                if (!apt.isSource()) continue;
                thisParam.add(apt);
            }
        }
        HashSet<AccessPathTuple> returnSources = null;
        if (this.returnValues != null) {
            returnSources = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.isSource()) continue;
                returnSources.add(apt);
            }
        }
        return new SourceSinkDefinition(this.method, baseSources, paramSources, returnSources);
    }

    public SourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> baseSinks = null;
        if (this.baseObjects != null) {
            baseSinks = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.isSink()) continue;
                baseSinks.add(apt);
            }
        }
        Set[] paramSinks = new Set[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            HashSet<AccessPathTuple> thisParam;
            Set<AccessPathTuple> aptSet = this.parameters[i];
            paramSinks[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
            for (AccessPathTuple apt : aptSet) {
                if (!apt.isSink()) continue;
                thisParam.add(apt);
            }
        }
        HashSet<AccessPathTuple> returnSinks = null;
        if (this.returnValues != null) {
            returnSinks = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.isSink()) continue;
                returnSinks.add(apt);
            }
        }
        return new SourceSinkDefinition(this.method, baseSinks, paramSinks, returnSinks);
    }

    public void merge(SourceSinkDefinition other) {
        if (other.baseObjects != null && !other.baseObjects.isEmpty()) {
            if (this.baseObjects == null) {
                this.baseObjects = new HashSet<AccessPathTuple>();
            }
            for (AccessPathTuple apt : other.baseObjects) {
                this.baseObjects.add(apt);
            }
        }
        if (other.parameters != null && other.parameters.length > 0) {
            if (this.parameters == null) {
                this.parameters = new Set[this.method.getParameters().size()];
            }
            for (int i = 0; i < other.parameters.length; ++i) {
                this.parameters[i].addAll(other.parameters[i]);
            }
        }
        if (other.returnValues != null && !other.returnValues.isEmpty()) {
            if (this.returnValues == null) {
                this.returnValues = new HashSet<AccessPathTuple>();
            }
            for (AccessPathTuple apt : other.returnValues) {
                this.returnValues.add(apt);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseObjects == null ? 0 : this.baseObjects.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : Arrays.hashCode(this.parameters));
        result = 31 * result + (this.returnValues == null ? 0 : this.returnValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceSinkDefinition other = (SourceSinkDefinition)obj;
        if (this.baseObjects == null ? other.baseObjects != null : !this.baseObjects.equals(other.baseObjects)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !Arrays.equals(this.parameters, other.parameters)) {
            return false;
        }
        return !(this.returnValues == null ? other.returnValues != null : !this.returnValues.equals(other.returnValues));
    }
}

