/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source.parsers.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.source.data.AccessPathTuple;
import soot.jimple.infoflow.android.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.android.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.data.SootMethodAndClass;

public class XMLSourceSinkParser
extends DefaultHandler
implements ISourceSinkDefinitionProvider {
    private String methodSignature;
    private String methodCategory;
    private boolean isSource;
    private boolean isSink;
    private String[] pathElements;
    private String[] pathElementTypes;
    private int paramIndex;
    private List<String> paramTypes = new ArrayList<String>();
    private String accessPathParentElement = "";
    private Set<AccessPathTuple> baseAPs = new HashSet<AccessPathTuple>();
    private List<Set<AccessPathTuple>> paramAPs = new ArrayList<Set<AccessPathTuple>>();
    private Set<AccessPathTuple> returnAPs = new HashSet<AccessPathTuple>();
    private Map<SootMethodAndClass, SourceSinkDefinition> sourcesAndSinks;
    private Set<SourceSinkDefinition> sources = new HashSet<SourceSinkDefinition>();
    private Set<SourceSinkDefinition> sinks = new HashSet<SourceSinkDefinition>();
    private static final String XSD_FILE_PATH = "exchangeFormat.xsd";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static XMLSourceSinkParser fromFile(String fileName) throws IOException {
        if (!XMLSourceSinkParser.verifyXML(fileName)) {
            throw new RuntimeException("The XML-File isn't valid");
        }
        XMLSourceSinkParser pmp = new XMLSourceSinkParser(fileName);
        return pmp;
    }

    @Override
    public Set<SourceSinkDefinition> getSources() {
        return this.sources;
    }

    @Override
    public Set<SourceSinkDefinition> getSinks() {
        return this.sinks;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String qNameLower;
        switch (qNameLower = qName.toLowerCase()) {
            case "method": {
                if (attributes == null) break;
                this.methodSignature = attributes.getValue("signature").trim();
                this.methodCategory = attributes.getValue("category").trim();
                break;
            }
            case "accesspath": {
                if (attributes == null) break;
                String tempStr = attributes.getValue("isSource");
                if (tempStr != null && !tempStr.isEmpty()) {
                    this.isSource = tempStr.equalsIgnoreCase("true");
                }
                if ((tempStr = attributes.getValue("isSink")) != null && !tempStr.isEmpty()) {
                    this.isSink = tempStr.equalsIgnoreCase("true");
                }
                if ((tempStr = attributes.getValue("length")) == null || tempStr.isEmpty()) break;
                this.pathElements = new String[Integer.parseInt(tempStr)];
                this.pathElementTypes = new String[Integer.parseInt(tempStr)];
                break;
            }
            case "base": {
                this.accessPathParentElement = qNameLower;
                break;
            }
            case "return": {
                this.accessPathParentElement = qNameLower;
                break;
            }
            case "param": {
                if (this.methodSignature != null && attributes != null) {
                    String tempStr = attributes.getValue("index");
                    if (tempStr != null && !tempStr.isEmpty()) {
                        this.paramIndex = Integer.parseInt(tempStr);
                    }
                    if ((tempStr = attributes.getValue("type")) != null && !tempStr.isEmpty()) {
                        this.paramTypes.add(tempStr.trim());
                    }
                }
                this.accessPathParentElement = qNameLower;
                break;
            }
            case "pathelement": {
                if (this.methodSignature == null || attributes == null) break;
                int pathElementIdx = -1;
                String tempStr = attributes.getValue("index");
                if (tempStr == null || tempStr.isEmpty()) break;
                pathElementIdx = Integer.parseInt(tempStr.trim());
                tempStr = attributes.getValue("field");
                if (tempStr != null && !tempStr.isEmpty()) {
                    if (pathElementIdx >= this.pathElements.length) {
                        throw new RuntimeException("Path element index out of range");
                    }
                    this.pathElements[pathElementIdx] = tempStr;
                }
                if ((tempStr = attributes.getValue("type")) == null || tempStr.isEmpty()) break;
                if (pathElementIdx >= this.pathElementTypes.length) {
                    throw new RuntimeException("Path element type index out of range");
                }
                this.pathElementTypes[pathElementIdx] = tempStr;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String qNameLower;
        switch (qNameLower = qName.toLowerCase()) {
            case "method": {
                if (this.methodSignature == null) break;
                AndroidMethod tempMeth = AndroidMethod.createFromSignature(this.methodSignature);
                if (this.methodCategory != null) {
                    String methodCategoryUpper = this.methodCategory.toUpperCase().trim();
                    tempMeth.setCategory(AndroidMethod.CATEGORY.valueOf(methodCategoryUpper));
                }
                tempMeth.setSink(this.isSink);
                tempMeth.setSource(this.isSource);
                SourceSinkDefinition ssd = new SourceSinkDefinition(tempMeth, this.baseAPs, this.paramAPs.toArray(new Set[this.paramAPs.size()]), this.returnAPs);
                if (this.sourcesAndSinks.containsKey(tempMeth)) {
                    this.sourcesAndSinks.get(tempMeth).merge(ssd);
                } else {
                    this.sourcesAndSinks.put(tempMeth, ssd);
                }
                this.methodSignature = null;
                this.methodCategory = null;
                this.baseAPs = new HashSet<AccessPathTuple>();
                this.paramAPs = new ArrayList<Set<AccessPathTuple>>();
                this.returnAPs = new HashSet<AccessPathTuple>();
                break;
            }
            case "accesspath": {
                if (this.isSource || this.isSink) {
                    if (this.pathElements != null && this.pathElements.length == 0 && this.pathElementTypes != null && this.pathElementTypes.length == 0) {
                        this.pathElements = null;
                        this.pathElementTypes = null;
                    }
                    AccessPathTuple apt = AccessPathTuple.fromPathElements(this.pathElements, this.pathElementTypes, this.isSource, this.isSink);
                    switch (this.accessPathParentElement) {
                        case "base": {
                            this.baseAPs.add(apt);
                            break;
                        }
                        case "return": {
                            this.returnAPs.add(apt);
                            break;
                        }
                        case "param": {
                            while (this.paramAPs.size() <= this.paramIndex) {
                                this.paramAPs.add(new HashSet());
                            }
                            this.paramAPs.get(this.paramIndex).add(apt);
                        }
                    }
                }
                this.isSource = false;
                this.isSink = false;
                this.pathElements = null;
                this.pathElementTypes = null;
                break;
            }
            case "base": {
                this.accessPathParentElement = "";
                break;
            }
            case "return": {
                this.accessPathParentElement = "";
                break;
            }
            case "param": {
                this.accessPathParentElement = "";
                this.paramIndex = -1;
                this.paramTypes.clear();
                break;
            }
        }
    }

    private XMLSourceSinkParser(String fileName) {
        this.sourcesAndSinks = new HashMap<SootMethodAndClass, SourceSinkDefinition>();
        SAXParserFactory pf = SAXParserFactory.newInstance();
        try {
            SAXParser parser2 = pf.newSAXParser();
            parser2.parse(fileName, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (SourceSinkDefinition def : this.sourcesAndSinks.values()) {
            SourceSinkDefinition sinkDef;
            SourceSinkDefinition sourceDef = def.getSourceOnlyDefinition();
            if (!sourceDef.isEmpty()) {
                this.sources.add(sourceDef);
            }
            if ((sinkDef = def.getSinkOnlyDefinition()).isEmpty()) continue;
            this.sinks.add(sinkDef);
        }
    }

    private static boolean verifyXML(String fileName) {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource xsdFile = new StreamSource(new File(XSD_FILE_PATH));
        StreamSource xmlFile = new StreamSource(new File(fileName));
        boolean validXML = false;
        try {
            Schema schema = sf.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(xmlFile);
                validXML = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!validXML) {
                new IOException("File isn't  valid against the xsd");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return validXML;
    }

    @Override
    public Set<SourceSinkDefinition> getAllMethods() {
        HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(this.sources.size() + this.sinks.size());
        sourcesSinks.addAll(this.sources);
        sourcesSinks.addAll(this.sinks);
        return sourcesSinks;
    }
}

