/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import soot.jimple.infoflow.collect.IdentityWrapper;

public class ConcurrentIdentityHashMap<K, V>
implements Map<K, V> {
    private final Map<IdentityWrapper<K>, V> innerMap = new ConcurrentHashMap<IdentityWrapper<K>, V>();

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(new IdentityWrapper<Object>(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.innerMap.get(new IdentityWrapper<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        return this.innerMap.put(new IdentityWrapper<K>(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.innerMap.remove(new IdentityWrapper<Object>(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<K> keySet() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (IdentityWrapper<K> k : this.innerMap.keySet()) {
            set.add(k.getContents());
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<IdentityWrapper<K>, V> entry : this.innerMap.entrySet()) {
            set.add(new MapEntry(entry.getKey().getContents(), entry.getValue()));
        }
        return set;
    }

    public class MapEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            MapEntry me = (MapEntry)other;
            return this.key == me.key && this.value.equals(me.value);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) + this.value.hashCode();
        }
    }
}

